/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionTypes;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.BaseDefinitionRangeInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.storage.valueprovider.ValueProviderInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;

@SASScope
public class ExpressionUtil
implements ExpressionTypes {
    private static final Hashtable<Integer, Vector<Integer>> exprToJdbcTypeMappings = new Hashtable();
    private static final Hashtable<Integer, Integer> jdbcToExprTypeMappings = new Hashtable();

    public static Vector<Integer> getJdbcTypes(int expressionType) {
        Integer expressionTypeObj = expressionType;
        Vector<Integer> out = exprToJdbcTypeMappings.get(expressionTypeObj);
        if (out == null) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.FailedToMapExpTypeToJDBCType.fmt.txt", expressionTypeObj.toString());
            throw new IQueryServicesRuntimeException(errorMsg);
        }
        return out;
    }

    public static int getExprType(int jdbcType) {
        Integer jdbcTypeObj = jdbcType;
        Integer I = jdbcToExprTypeMappings.get(jdbcTypeObj);
        if (I == null) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.FailedToMapJDBCTypeToExpType.fmt.txt", jdbcTypeObj.toString());
            throw new IQueryServicesRuntimeException(errorMsg);
        }
        return I;
    }

    public static List<ExpressionInterface> getJoinTriplets(ConditionalExpression expression) {
        Preconditions.ensureNonNull(expression);
        ArrayList<ConditionalExpression> result = null;
        if (expression instanceof ConditionalExpressionAdapter) {
            if (ExpressionUtil.isValidJoinTriplet((ConditionalExpressionAdapter)expression)) {
                result = new ArrayList<ConditionalExpression>(Collections.singletonList(expression));
            }
        } else if (expression instanceof SimpleConditionalExpression_Comparison) {
            if (ExpressionUtil.isValidJoinTriplet((SimpleConditionalExpression_Comparison)expression)) {
                result = new ArrayList<ConditionalExpression>(Collections.singletonList(expression));
            }
        } else if (expression instanceof CompoundConditionalExpression) {
            result = new ArrayList();
            ExpressionUtil.parseCompoundJoinTripletExpression((CompoundConditionalExpression)expression, result);
        } else if (expression instanceof MultipleConditionalExpression) {
            result = new ArrayList();
            ExpressionUtil.parseMultipleJoinTripletExpression((MultipleConditionalExpression)expression, result);
        }
        if (result == null) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.InvalidJoinTripletExpr.fmt.txt", Utils.toString(expression));
            throw new IQueryServicesRuntimeException(errorMsg);
        }
        try {
            if (!ExpressionUtil.containsTwoTablesInACondition(result)) {
                MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.InvalidTooFewJoinTables.fmt.txt", Utils.toString(expression));
                throw new IQueryServicesRuntimeException(errorMsg);
            }
        }
        catch (MetadataException e) {
            throw new IQueryServicesRuntimeException(e);
        }
        return result;
    }

    public static boolean containsTwoTablesInACondition(List result) throws MetadataException {
        ConditionalExpression expr = ExpressionUtil.getEffectiveJoinCondition(null, null, result);
        return expr != null;
    }

    public static ConditionalExpression getEffectiveJoinCondition(Table table1, Table table2, List result) throws MetadataException {
        ConditionalExpression cond = null;
        boolean ok = false;
        List<Table> tables = null;
        for (Object obj : result) {
            if (obj instanceof ConditionalExpression) {
                cond = (ConditionalExpression)obj;
                if (obj instanceof ConditionalExpressionAdapter) {
                    ConditionalExpressionAdapter sceb = (ConditionalExpressionAdapter)obj;
                    tables = ExpressionUtil.getTables(sceb.getExpression());
                    ok = tables.size() > 1;
                } else if (obj instanceof SimpleConditionalExpression_Comparison) {
                    SimpleConditionalExpression_Comparison scec = (SimpleConditionalExpression_Comparison)obj;
                    List<Table> leftTables = ExpressionUtil.getTables(scec.getLeftExpression());
                    List<Table> rightTables = ExpressionUtil.getTables(scec.getRightExpression());
                    if (leftTables.size() > 0 && rightTables.size() > 0) {
                        tables = new ArrayList<Table>();
                        Utils.accumulate(tables, leftTables);
                        Utils.accumulate(tables, rightTables);
                        boolean bl = ok = tables.size() > 1;
                    }
                }
            }
            if (!ok) continue;
            if (table1 != null) {
                ok = tables.contains(table1);
            }
            if (ok && table2 != null) {
                ok = tables.contains(table2);
            }
            if (!ok) continue;
            break;
        }
        if (ok) {
            return cond;
        }
        return null;
    }

    @Nonnull
    public static List<Table> getTables(ExpressionInterface expr) throws MetadataException {
        List<Column> columns;
        LinkedHashSet<Table> tables = new LinkedHashSet<Table>();
        if (expr instanceof Column) {
            Column c = (Column)expr;
            columns = Arrays.asList(c);
        } else {
            columns = expr.getResources(Column.class, 65535);
        }
        for (Column c : columns) {
            Table table = c.getOwningTable();
            if (table == null) continue;
            tables.add(table);
        }
        return new ArrayList<Table>(tables);
    }

    public static boolean isMultiSelectionPrompt(Prompt iqPrompt) {
        SelectableDefinitionInterface selectableDefinition;
        int sType;
        PromptDefinitionInterface promptDefinition;
        boolean result = false;
        if (iqPrompt != null && (promptDefinition = iqPrompt.getPromptDefinition()) instanceof SelectableDefinitionInterface && ((sType = (selectableDefinition = (SelectableDefinitionInterface)promptDefinition).getSelectionType()) == 301 || sType == 302)) {
            result = true;
        }
        return result;
    }

    public static boolean isRangePrompt(Prompt iqPrompt) {
        PromptDefinitionInterface pDef;
        boolean result = false;
        if (iqPrompt != null && (pDef = iqPrompt.getPromptDefinition()) instanceof BaseDefinitionRangeInterface) {
            result = true;
        }
        return result;
    }

    public static boolean isSingleSelectionPrompt(Prompt iqPrompt) {
        SelectableDefinitionInterface selectableDefinition;
        int sType;
        PromptDefinitionInterface promptDefinition;
        boolean result = false;
        if (iqPrompt != null && (promptDefinition = iqPrompt.getPromptDefinition()) instanceof SelectableDefinitionInterface && (sType = (selectableDefinition = (SelectableDefinitionInterface)promptDefinition).getSelectionType()) == 300) {
            result = true;
        }
        return result;
    }

    private static boolean isValidJoinTriplet(ConditionalExpressionAdapter sceb) {
        ExpressionInterface expr = sceb.getExpression();
        int type = expr.getExpressionType();
        return type == 9 || type == 2;
    }

    private static boolean isValidJoinTriplet(SimpleConditionalExpression_Comparison triplet) {
        ExpressionInterface left = triplet.getLeftExpression();
        ExpressionInterface right = triplet.getRightExpression();
        return left instanceof Column && right instanceof Column;
    }

    private static void parseCompoundJoinTripletExpression(CompoundConditionalExpression triplet, List<? super ExpressionInterface> appendTo) {
        ConditionalRelationType relationType = triplet.getRelationType();
        if (relationType != ConditionalRelationType.AND) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.InvalidConditionalRelationType.fmt.txt", Utils.toString(triplet));
            throw new IQueryServicesRuntimeException(errorMsg);
        }
        ExpressionInterface leftExpr = triplet.getLeftExpression();
        ExpressionUtil.traverse(leftExpr, appendTo);
        ExpressionInterface rightExpr = triplet.getRightExpression();
        ExpressionUtil.traverse(rightExpr, appendTo);
    }

    private static void parseMultipleJoinTripletExpression(MultipleConditionalExpression triplet, List<? super ExpressionInterface> appendTo) {
        ConditionalRelationType relationType = triplet.getRelationType();
        if (relationType == ConditionalRelationType.AND) {
            for (int i = 0; i < triplet.getExpressionCount(); ++i) {
                ExpressionInterface expr = triplet.getExpression(i);
                ExpressionUtil.traverse(expr, appendTo);
            }
        } else {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.InvalidConditionalRelationType.fmt.txt", Utils.toString(triplet));
            throw new IQueryServicesRuntimeException(errorMsg);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void traverse(ExpressionInterface expr, List<? super ExpressionInterface> appendTo) {
        if (expr instanceof ConditionalExpressionAdapter) {
            if (ExpressionUtil.isValidJoinTriplet((ConditionalExpressionAdapter)expr)) {
                appendTo.add(expr);
                return;
            }
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.InvalidJoinTripletExpr.fmt.txt", Utils.toString(expr));
            throw new IQueryServicesRuntimeException(errorMsg);
        }
        if (expr instanceof SimpleConditionalExpression_Comparison) {
            if (ExpressionUtil.isValidJoinTriplet((SimpleConditionalExpression_Comparison)expr)) {
                appendTo.add(expr);
                return;
            }
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.InvalidJoinTripletExpr.fmt.txt", Utils.toString(expr));
            throw new IQueryServicesRuntimeException(errorMsg);
        }
        if (expr instanceof CompoundConditionalExpression) {
            ExpressionUtil.parseCompoundJoinTripletExpression((CompoundConditionalExpression)expr, appendTo);
            return;
        }
        if (expr instanceof MultipleConditionalExpression) {
            ExpressionUtil.parseMultipleJoinTripletExpression((MultipleConditionalExpression)expr, appendTo);
            return;
        }
        MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ExpressionUtil.InvalidJoinTripletExpr.fmt.txt", Utils.toString(expr));
        throw new IQueryServicesRuntimeException(errorMsg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean returnsSpecialValuesALL(ExpressionInterface expression, DataSelection dataSelection) throws GenerationException {
        boolean isSpecialValuesALL = false;
        if (expression instanceof Prompt) {
            PromptDefinitionInterface definition = ((Prompt)expression).getPromptDefinition();
            try {
                if (!(definition instanceof ValueProviderDefinitionInterface)) return isSpecialValuesALL;
                ValueProviderInterface valueProver = ((ValueProviderDefinitionInterface)definition).getValueProvider();
                if (!(valueProver instanceof DynamicValueProviderInterface)) return isSpecialValuesALL;
                PromptValuesInterface promptValues = dataSelection.getPromptValues();
                Object definitionValue = promptValues.getPromptValue(definition);
                return ExpressionUtil.containsSpecialValuesALL(definitionValue);
            }
            catch (PromptValueNotFoundException e) {
                Object[] msgArgs = new Object[]{definition.getPromptName(), definition, dataSelection};
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ErrRetrieve.fmt.txt", msgArgs);
                throw new GenerationException(msg, (Throwable)e);
            }
        }
        if (expression == null) return isSpecialValuesALL;
        List<Prompt> prompts = expression.getResources(Prompt.class, 65531);
        Iterator<Prompt> iter = prompts.iterator();
        while (!isSpecialValuesALL) {
            if (!iter.hasNext()) return isSpecialValuesALL;
            isSpecialValuesALL = ExpressionUtil.returnsSpecialValuesALL(iter.next(), dataSelection);
        }
        return isSpecialValuesALL;
    }

    public static boolean containsSpecialValuesALL(Object definitionValue) {
        boolean isSpecialValuesALL = false;
        if (definitionValue instanceof List) {
            List objList = (List)definitionValue;
            Iterator it = objList.iterator();
            while (it.hasNext() && !isSpecialValuesALL) {
                Object next = it.next();
                isSpecialValuesALL = next != null && next.equals(SpecialValues.ALL);
            }
        } else if (definitionValue instanceof Object[]) {
            Object[] arrayValues = (Object[])definitionValue;
            int length = arrayValues.length;
            for (int i = 0; i < length && !isSpecialValuesALL; ++i) {
                Object object = arrayValues[i];
                isSpecialValuesALL = object != null && object.equals(SpecialValues.ALL);
            }
        } else if (definitionValue != null) {
            isSpecialValuesALL = definitionValue.equals(SpecialValues.ALL);
        }
        return isSpecialValuesALL;
    }

    static {
        Integer BITSTRING = 1;
        Vector<Integer> bitstringValues = new Vector<Integer>();
        bitstringValues.add(-2);
        bitstringValues.add(-7);
        bitstringValues.add(2004);
        bitstringValues.add(-4);
        bitstringValues.add(-3);
        exprToJdbcTypeMappings.put(BITSTRING, bitstringValues);
        jdbcToExprTypeMappings.put(-2, BITSTRING);
        jdbcToExprTypeMappings.put(-7, BITSTRING);
        jdbcToExprTypeMappings.put(2004, BITSTRING);
        jdbcToExprTypeMappings.put(-4, BITSTRING);
        jdbcToExprTypeMappings.put(-3, BITSTRING);
        Integer BOOLEAN = 9;
        Vector<Integer> booleanValues = new Vector<Integer>();
        booleanValues.add(16);
        exprToJdbcTypeMappings.put(BOOLEAN, booleanValues);
        jdbcToExprTypeMappings.put(16, BOOLEAN);
        Integer NUM = 2;
        Vector<Integer> numericValues = new Vector<Integer>();
        numericValues.add(-5);
        numericValues.add(3);
        numericValues.add(6);
        numericValues.add(4);
        numericValues.add(2);
        numericValues.add(7);
        numericValues.add(5);
        numericValues.add(-6);
        numericValues.add(8);
        exprToJdbcTypeMappings.put(NUM, numericValues);
        jdbcToExprTypeMappings.put(-5, NUM);
        jdbcToExprTypeMappings.put(3, NUM);
        jdbcToExprTypeMappings.put(8, NUM);
        jdbcToExprTypeMappings.put(6, NUM);
        jdbcToExprTypeMappings.put(4, NUM);
        jdbcToExprTypeMappings.put(2, NUM);
        jdbcToExprTypeMappings.put(7, NUM);
        jdbcToExprTypeMappings.put(5, NUM);
        jdbcToExprTypeMappings.put(-6, NUM);
        Integer CHARACTER = 3;
        Vector<Integer> characterValues = new Vector<Integer>();
        characterValues.add(1);
        characterValues.add(2005);
        characterValues.add(-1);
        characterValues.add(12);
        exprToJdbcTypeMappings.put(CHARACTER, characterValues);
        jdbcToExprTypeMappings.put(1, CHARACTER);
        jdbcToExprTypeMappings.put(2005, CHARACTER);
        jdbcToExprTypeMappings.put(-1, CHARACTER);
        jdbcToExprTypeMappings.put(12, CHARACTER);
        Integer DATE = 4;
        Vector<Integer> dateValues = new Vector<Integer>();
        dateValues.add(91);
        exprToJdbcTypeMappings.put(DATE, dateValues);
        jdbcToExprTypeMappings.put(91, DATE);
        Integer TIME = 5;
        Vector<Integer> timeValues = new Vector<Integer>();
        timeValues.add(92);
        exprToJdbcTypeMappings.put(TIME, timeValues);
        jdbcToExprTypeMappings.put(92, TIME);
        Integer TIMESTAMP = 6;
        Vector<Integer> timestampValues = new Vector<Integer>();
        timestampValues.add(93);
        exprToJdbcTypeMappings.put(TIMESTAMP, timestampValues);
        jdbcToExprTypeMappings.put(93, TIMESTAMP);
    }
}

