/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

@SASScope(value="ALL")
@SubjectToChange
public final class DateValueExpression
extends AbstractTimeValueExpression {
    private static final String SAS_DATE9_PATTERN = "''ddMMMyyyy'''d'";
    private static final String SQL99_DATE_PATTERN = "'DATE '''yyyy-MM-dd''";

    public DateValueExpression() {
    }

    public DateValueExpression(java.sql.Date value) {
        this.setDateValue(value);
    }

    public DateValueExpression(Date dateValue) {
        this.setValue(dateValue);
    }

    public java.sql.Date getDateValue() {
        return (java.sql.Date)this.getValue();
    }

    public void setDateValue(java.sql.Date value) {
        this.setValue(value);
    }

    @Override
    @SASScope
    protected SimpleDateFormat getFormatter() {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateInstance(2, Locale.ENGLISH);
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        formatter.setTimeZone(gmtTimeZone);
        return formatter;
    }

    @Override
    @SASScope
    protected String getPattern(DataSelection dataSelection, ConnectionType connectionType) throws MetadataException {
        String pattern = connectionType == ConnectionType.IOM_TSSQL ? SQL99_DATE_PATTERN : SAS_DATE9_PATTERN;
        return pattern;
    }

    @Override
    @SASScope
    Date newCoreObject(long value) {
        return new java.sql.Date(value);
    }

    @Override
    public int getExpressionType() {
        return 4;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DateValue";
    }
}

