/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConstantExpressionInterface;
import com.sas.iquery.metadata.expr.QueryMissingValues;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class ConstantExpression
extends AbstractExpression
implements ConstantExpressionInterface {
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_EXPRESSION_TYPE_CHANGED = "Expression type changed";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_VALUE_CHANGED = "Value changed";
    private int _expressionType = 0;
    private String _value;

    @SASScope(value="ALL")
    @SubjectToChange
    public ConstantExpression() {
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ConstantExpression(String value, int type) {
        this.setValue(value);
        this.setExpressionType(type);
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public int getExpressionType() {
        return this._expressionType;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public void setExpressionType(int type) {
        this.changeableCheck();
        if (this._expressionType != type) {
            this._expressionType = type;
            this.fireChangeEvent(EVENT_EXPRESSION_TYPE_CHANGED);
        }
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getValue() {
        return this._value;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public void setValue(String value) {
        this.changeableCheck();
        if (!IQModelImplUtilities.same(this._value, value)) {
            this._value = value;
            this.fireChangeEvent(EVENT_VALUE_CHANGED);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isMissing() {
        return QueryMissingValues.isMissing(this._value);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @SASScope
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (!result && obj != null && obj instanceof ConstantExpression) {
            ConstantExpression rhs = (ConstantExpression)obj;
            ConstantExpression lhs = this;
            if (IQModelImplUtilities.same(lhs._value, rhs._value) && rhs._expressionType == lhs._expressionType) {
                result = true;
            }
        }
        return result;
    }

    @SASScope
    public int hashCode() {
        int result = 53;
        result = 7 * result + this._expressionType;
        result = 7 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    @Override
    @SASScope
    public String toString() {
        return this._value;
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._value == null) {
            reasons.add(new Reason((Object)this, 2, 33, "ConstantExpression.HasNullValue.txt", (Object[])null));
        }
        if (this._expressionType == 0) {
            reasons.add(new Reason((Object)this, 2, 34, "ConstantExpression.HasNoExpressionTypeSet.txt", (Object[])null));
        }
        if (this._value != null && this._expressionType == 2 && !this.isMissing()) {
            try {
                Double.parseDouble(this._value);
            }
            catch (NumberFormatException nfe) {
                reasons.add(new Reason((Object)this, 2, 73, "ConstantExpression.HasInvalidValue.fmt.txt", this._value));
            }
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "Constant";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        IQModelImplUtilities.setExpressionTypeAttr(thisElement, "exprType", this._expressionType);
        IQModelImplUtilities.setAttr(thisElement, "value", this._value);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._expressionType = attrsProvider.consumeExpressionTypeAttr("exprType");
        this._value = attrsProvider.consumeAttr("value");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._expressionType = IQModelImplUtilities.getIntAttr(thisElement, "exprType", 0);
        this._value = IQModelImplUtilities.getAttr(thisElement, "valTxt");
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }
}

