/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.DateValueExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.TimeValueExpression;
import com.sas.iquery.metadata.expr.TimestampValueExpression;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.util.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public abstract class AbstractTimeValueExpression
extends AbstractExpression
implements ExpressionInterface {
    public static final String EVENT_VALUE_CHANGED = "Value changed";
    @SASScope
    protected Date _chronoValue;
    @SASScope
    protected Double _explicitDoubleValue;

    @SASScope(value="ALL")
    @SubjectToChange
    protected AbstractTimeValueExpression() {
    }

    @SASScope(value="ALL")
    @SubjectToChange
    protected AbstractTimeValueExpression(Date value) {
        this._chronoValue = value == null ? null : (Date)value.clone();
    }

    public static AbstractTimeValueExpression newValue(Date value, int expressionType) {
        Preconditions.ensureNonNull(value);
        AbstractTimeValueExpression out = null;
        if (expressionType == 4) {
            out = new DateValueExpression(value);
        } else if (expressionType == 5) {
            out = new TimeValueExpression(value);
        } else if (expressionType == 6) {
            out = new TimestampValueExpression(value);
        }
        return out;
    }

    public Date getValue() {
        return this._chronoValue == null ? null : (Date)this._chronoValue.clone();
    }

    @SASScope
    protected void _trustedSetValue(Date date) {
        this._chronoValue = date;
    }

    public void setValue(Date value) {
        this._chronoValue = value == null ? null : this.newCoreObject(value.getTime());
        this.fireChangeEvent(EVENT_VALUE_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        AbstractTimeValueExpression clone = (AbstractTimeValueExpression)super.clone();
        if (this._chronoValue != null) {
            clone._chronoValue = (Date)this._chronoValue.clone();
        }
        return clone;
    }

    public Double getExplicitDoubleValue() {
        return this._explicitDoubleValue;
    }

    public void setExplicitDoubleValue(Double doubleValue) {
        this._explicitDoubleValue = doubleValue;
        this.fireChangeEvent(EVENT_VALUE_CHANGED);
    }

    public String generateQueryText(DataSelectionProcessorAbstract dataSelectionProcessor) throws MetadataException {
        String queryText = this.generateQueryText(dataSelectionProcessor.getDataSelection(), this.getConnectionType(dataSelectionProcessor));
        return queryText;
    }

    public String generateQueryText(@Nonnull DataSelection dataSelection, @Nonnull ConnectionType connectionType) throws MetadataException {
        String queryText;
        Preconditions.ensureNonNull(dataSelection);
        Preconditions.ensureNonNull(connectionType);
        if (this._explicitDoubleValue != null) {
            queryText = "" + this._explicitDoubleValue;
        } else {
            if (this._chronoValue == null) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractTimeValueExpression.IllDefined.txt", new Object[0]));
            }
            SimpleDateFormat formatter = this.getFormatter();
            String pattern = this.getPattern(dataSelection, connectionType);
            formatter.applyPattern(pattern);
            queryText = formatter.format(this._chronoValue);
        }
        return queryText;
    }

    @SASScope
    protected abstract String getPattern(DataSelection var1, ConnectionType var2) throws MetadataException;

    @SASScope
    protected abstract SimpleDateFormat getFormatter();

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        if (this._chronoValue != null) {
            String xmlTimestamp = writingContext.getXMLTimestampToMillisecond(this._chronoValue);
            IQModelImplUtilities.setAttr(thisElement, "timestamp", xmlTimestamp);
        }
        if (this._explicitDoubleValue != null) {
            IQModelImplUtilities.setDoubleAttr(thisElement, "explicitDoubleValue", this._explicitDoubleValue);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        Date timestamp = attrsProvider.consumeTimestampAttr("timestamp", null);
        this._chronoValue = timestamp != null ? this.newCoreObject(timestamp.getTime()) : null;
        this._explicitDoubleValue = attrsProvider.consumeDoubleAttr("explicitDoubleValue", null);
    }

    abstract Date newCoreObject(long var1);

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        Long longTimeObject = IQModelImplUtilities.getLongAttr(thisElement, "javaLongTimeValue");
        if (longTimeObject != null) {
            long longTimeValue = longTimeObject;
            this._chronoValue = this.newCoreObject(longTimeValue);
        }
        this._explicitDoubleValue = IQModelImplUtilities.getDoubleAttr(thisElement, "explicitDoubleValue");
    }

    public boolean equals(Object obj) {
        boolean out = false;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            AbstractTimeValueExpression objtv = (AbstractTimeValueExpression)obj;
            if (objtv._chronoValue == null && this._chronoValue == null || objtv._chronoValue != null && this._chronoValue != null && objtv._chronoValue.toString().equals(this._chronoValue.toString())) {
                out = true;
            }
        }
        return out;
    }

    @SASScope
    public int hashCode() {
        int hashCode = 113;
        if (this._chronoValue != null) {
            hashCode += this._chronoValue.hashCode();
        }
        return hashCode;
    }

    @SASScope
    public String toString() {
        String out = null;
        out = this._chronoValue == null ? "-" : this._chronoValue.toString();
        if (this._explicitDoubleValue != null) {
            out = out + "(";
            out = out + this._explicitDoubleValue.toString();
            out = out + ")";
        }
        return out;
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._chronoValue == null) {
            reasons.add(new Reason((Object)this, 2, 4, "AbstractTimeValueExpression.IllDefined.fmt.txt", this.getDefinitionElementName()));
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    @SASScope
    protected ConnectionType getConnectionType(DataSelectionProcessorAbstract dataSelectionProcessor) throws MetadataException {
        try {
            return dataSelectionProcessor.isTSSQL() ? ConnectionType.IOM_TSSQL : ConnectionType.IOM;
        }
        catch (GenerationException e) {
            throw new MetadataException(e);
        }
    }
}

