/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.AbstractTimeRangeFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class DataItemTimeRangeFilter
extends AbstractTimeRangeFilter {
    public static final String EVENT_START_DATE_MEMBER_CHANGED = "The Start Date attribute has changed";
    public static final String EVENT_END_DATE_MEMBER_CHANGED = "The End Date attribute has changed";
    @Nullable
    private ExpressionInterface _startMember = null;
    @Nullable
    private ExpressionInterface _endMember = null;
    private Locale _memberLocale = null;
    private static final Logger _logger = LogManager.getLogger(DataItemTimeRangeFilter.class);

    public DataItemTimeRangeFilter() {
    }

    @Deprecated
    public DataItemTimeRangeFilter(String startDateMember, String endDateMember) throws IllegalArgumentException {
        this.setStartDateMember(startDateMember);
        this.setEndDateMember(endDateMember);
    }

    public DataItemTimeRangeFilter(ExpressionInterface startDateMember, ExpressionInterface endDateMember) throws IllegalArgumentException {
        this.setStartMember(startDateMember);
        this.setEndMember(endDateMember);
    }

    @Deprecated
    public void setStartDateMember(@Nonnull String startDateMember) throws IllegalArgumentException {
        Preconditions.ensureNonNull(startDateMember, "startDateMember", _logger);
        ConstantExpression constant = new ConstantExpression();
        constant.setExpressionType(3);
        constant.setValue(startDateMember);
        this._startMember = constant;
        this._memberLocale = LocaleUtilities.getDefaultViewerLocale();
        this.fireChangeEvent(EVENT_START_DATE_MEMBER_CHANGED);
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    @Deprecated
    public void setEndDateMember(@Nonnull String endDateMember) throws IllegalArgumentException {
        Preconditions.ensureNonNull(endDateMember, "endDateMember", _logger);
        ConstantExpression constant = new ConstantExpression();
        constant.setExpressionType(3);
        constant.setValue(endDateMember);
        this._endMember = constant;
        this._memberLocale = LocaleUtilities.getDefaultViewerLocale();
        this.fireChangeEvent(EVENT_START_DATE_MEMBER_CHANGED);
    }

    public void setStartMember(@Nonnull ExpressionInterface startDateMember) throws IllegalArgumentException {
        Preconditions.ensureNonNull(startDateMember, "startDateMember", _logger);
        this._startMember = startDateMember;
        this._memberLocale = LocaleUtilities.getDefaultViewerLocale();
        this.fireChangeEvent(EVENT_START_DATE_MEMBER_CHANGED);
    }

    public void setEndMember(@Nonnull ExpressionInterface endDateMember) throws IllegalArgumentException {
        Preconditions.ensureNonNull(endDateMember, "endDateMember", _logger);
        this._endMember = endDateMember;
        this._memberLocale = LocaleUtilities.getDefaultViewerLocale();
        this.fireChangeEvent(EVENT_START_DATE_MEMBER_CHANGED);
    }

    @Deprecated
    public String getStartDateMember() {
        String startDateMember = null;
        if (this._startMember instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._startMember;
            startDateMember = constant.getValue();
        }
        return startDateMember;
    }

    @Deprecated
    public String getEndDateMember() {
        String endDateMember = null;
        if (this._endMember instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._endMember;
            endDateMember = constant.getValue();
        }
        return endDateMember;
    }

    public ExpressionInterface getStartMember() {
        return this._startMember;
    }

    public ExpressionInterface getEndMember() {
        return this._endMember;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DataItemTimeRangeFilter";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
        DataItemTimeRangeFilter.writeRelatedObject(this._startMember, thisElement, writingContext, "StartDateMember");
        DataItemTimeRangeFilter.writeRelatedObject(this._endMember, thisElement, writingContext, "EndDateMember");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        String endDateMember;
        super.consumeAttributes(attrsProvider);
        String startDateMember = attrsProvider.consumeAttr("startDateMember");
        if (startDateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(startDateMember);
            this._startMember = constant;
        }
        if ((endDateMember = attrsProvider.consumeAttr("endDateMember")) != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(endDateMember);
            this._endMember = constant;
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._startMember = (ExpressionInterface)((Object)riHolder.consumeObject("StartDateMember"));
        this._endMember = (ExpressionInterface)((Object)riHolder.consumeObject("EndDateMember"));
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        String endDateMember;
        super.readDefinitionV1(thisElement, readingContext);
        String startDateMember = IQModelImplUtilities.getAttr(thisElement, "startDateMember");
        if (startDateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(startDateMember);
            this._startMember = constant;
        }
        if ((endDateMember = IQModelImplUtilities.getAttr(thisElement, "endDateMember")) != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(endDateMember);
            this._endMember = constant;
        }
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._startMember instanceof AbstractModelItem) {
            intoList.add(this._startMember);
        }
        if (this._endMember instanceof AbstractModelItem) {
            intoList.add(this._endMember);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._startMember = (ExpressionInterface)DataItemTimeRangeFilter.replace(this._startMember, oldObject, newObject);
        this._endMember = (ExpressionInterface)DataItemTimeRangeFilter.replace(this._endMember, oldObject, newObject);
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved()) {
            Reason reason;
            Object[] reasonArgs;
            Vector<Integer> expTypes;
            int expType;
            if (this._endMember != null && (expType = this._endMember.getExpressionType()) != 3) {
                expTypes = ExpressionUtil.getJdbcTypes(expType);
                reasonArgs = new Object[]{this._endMember, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                reasons.add(reason);
            }
            if (this._startMember != null && (expType = this._startMember.getExpressionType()) != 3) {
                expTypes = ExpressionUtil.getJdbcTypes(expType);
                reasonArgs = new Object[]{this._startMember, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                reasons.add(reason);
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        this.validateForPrompt(this._startMember, reasons);
        this.validateForPrompt(this._endMember, reasons);
    }

    private void validateForPrompt(ExpressionInterface expression, List<Reason> reasons) {
        if (expression instanceof Prompt && !BaseFilterExpression.isValidOlapMemberPrompt((Prompt)expression)) {
            Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidSingleSelectOlapMemberPrompt.fmt.txt", this, expression);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        DataItemTimeRangeFilter clone = (DataItemTimeRangeFilter)super.clone();
        clone._startMember = DataItemTimeRangeFilter.cloneReferencedExpression(this._startMember);
        clone._endMember = DataItemTimeRangeFilter.cloneReferencedExpression(this._endMember);
        return clone;
    }

    @SASScope
    public String toString(Locale locale) {
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("DataItemTimeRangeFilter.toString.fmt.txt", this.actionTypeMessageFormatter(), this._level, this._startMember, this._endMember);
        return message.getMessage(locale);
    }
}

