/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class DataItemTimeNPeriodsFilter
extends DataItemTimeFilter {
    public static final String EVENT_DATE_CHANGED = "The date attribute has changed";
    private ExpressionInterface _dateMember = null;
    private Locale _memberLocale = null;
    private static final Logger _logger = LogManager.getLogger(DataItemTimeNPeriodsFilter.class);

    public DataItemTimeNPeriodsFilter() {
    }

    @Deprecated
    public DataItemTimeNPeriodsFilter(int nPeriods, String searchDirection, String date) throws IllegalArgumentException {
        this.setnPeriods(nPeriods);
        this.setSearchDirection(searchDirection);
        this.setDateMember(date);
    }

    public DataItemTimeNPeriodsFilter(ExpressionInterface periods, String searchDirection, ExpressionInterface dateMember) throws IllegalArgumentException {
        this.setPeriods(periods);
        this.setSearchDirection(searchDirection);
        this.setMember(dateMember);
    }

    public void setDateMember(String date) throws IllegalArgumentException {
        Preconditions.ensureNonNull(date, "date", _logger);
        ConstantExpression constant = new ConstantExpression();
        constant.setExpressionType(3);
        constant.setValue(date);
        this._dateMember = constant;
        this.fireChangeEvent(EVENT_DATE_CHANGED);
    }

    public void setMember(ExpressionInterface date, Locale locale) throws IllegalArgumentException {
        Preconditions.ensureNonNull(date, "date", _logger);
        this._dateMember = date;
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        this._memberLocale = locale;
        this.fireChangeEvent(EVENT_DATE_CHANGED);
    }

    public void setMember(ExpressionInterface date) throws IllegalArgumentException {
        this.setMember(date, null);
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    @Nonnull
    public String getDateMember() {
        String dataMember;
        if (this._dateMember instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._dateMember;
            dataMember = constant.getValue();
        } else {
            dataMember = "";
        }
        return dataMember;
    }

    public ExpressionInterface getMember() {
        return this._dateMember;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DataItemTimeNPeriodsFilter";
    }

    @Override
    @SASScope
    public void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        DataItemTimeNPeriodsFilter.writeRelatedObject(this._dateMember, thisElement, writingContext, "DateMember");
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        String dateMember = attrsProvider.consumeAttr("dateMember");
        if (dateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(dateMember);
            this._dateMember = constant;
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._dateMember = (ExpressionInterface)((Object)riHolder.consumeObject("DateMember"));
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        String dateMember = IQModelImplUtilities.getAttr(thisElement, "dateMember");
        if (dateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(dateMember);
            this._dateMember = constant;
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        int expType;
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved() && this._dateMember != null && (expType = this._dateMember.getExpressionType()) != 3) {
            Vector<Integer> expTypes = ExpressionUtil.getJdbcTypes(expType);
            Object[] reasonArgs = new Object[]{this._dateMember, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
            Reason reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        if (this._dateMember instanceof Prompt && !BaseFilterExpression.isValidOlapMemberPrompt((Prompt)this._dateMember)) {
            Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidSingleSelectOlapMemberPrompt.fmt.txt", this, this._dateMember);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._dateMember instanceof AbstractModelItem) {
            intoList.add(this._dateMember);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._dateMember = (ExpressionInterface)DataItemTimeNPeriodsFilter.replace(this._dateMember, oldObject, newObject);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        DataItemTimeNPeriodsFilter clone = (DataItemTimeNPeriodsFilter)super.clone();
        clone._dateMember = DataItemTimeNPeriodsFilter.cloneReferencedExpression(this._dateMember);
        return clone;
    }

    @SASScope
    public String toString(Locale locale) {
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("DataItemTimeNPeriodsFilter.toString.fmt.txt", this.actionTypeMessageFormatter(), this.getPeriods(), this.getSearchDirection(), this._dateMember);
        return message.getMessage(locale);
    }
}

