/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class DataItemTimeFilter
extends BaseFilter {
    public static final String EVENT_SEARCH_DIRECTION_CHANGED = "Search direction changed";
    public static final String EVENT_PERIODS_CHANGED = "Number of periods changed";
    @Deprecated
    public static final String EVENT_NPERIODS_CHANGED = "Number of periods changed";
    public static final String FORWARD = "FORWARD";
    public static final String BACKWARD = "BACKWARD";
    private String _searchDirection;
    private ExpressionInterface _periods;
    private static final Logger _logger = LogManager.getLogger(DataItemTimeFilter.class);

    public void setnPeriods(int nPeriods) {
        if (nPeriods < 0) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataItemTimeFilter.BadPeriods.txt", new Object[0]));
        }
        ConstantExpression constant = new ConstantExpression();
        constant.setExpressionType(2);
        constant.setValue(Integer.toString(nPeriods));
        this._periods = constant;
        this.fireChangeEvent("Number of periods changed");
    }

    @SASScope
    public void setPeriods(ExpressionInterface periods) {
        if (periods instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)periods;
            if (constant.getExpressionType() != 2) {
                throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataItemTimeFilter.InvalidPeriodExpressionType.txt", new Object[0]));
            }
            int nPeriods = Integer.parseInt(constant.getValue());
            if (nPeriods < 0) {
                throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataItemTimeFilter.BadPeriods.txt", new Object[0]));
            }
        }
        this._periods = periods;
        this.fireChangeEvent("Number of periods changed");
    }

    public void setSearchDirection(String searchDirection) throws IllegalArgumentException {
        if (!BACKWARD.equals(searchDirection) && !FORWARD.equals(searchDirection)) {
            MessageFormatter errmsg = IQModelImplUtilities.getMessageFormatter("DataItemTimeFilterBadSearchDirection.txt", new Object[0]);
            _logger.error((Object)errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this._searchDirection = searchDirection;
        this.fireChangeEvent(EVENT_SEARCH_DIRECTION_CHANGED);
    }

    public int getnPeriods() {
        int nPeriods = 0;
        if (this._periods instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._periods;
            try {
                nPeriods = Integer.valueOf(constant.getValue());
            }
            catch (NumberFormatException nfe) {
                _logger.debug("The _periods value was not a valid numeric", (Throwable)nfe);
            }
        }
        return nPeriods;
    }

    public ExpressionInterface getPeriods() {
        return this._periods;
    }

    public String getSearchDirection() {
        return this._searchDirection;
    }

    @Override
    @SASScope
    public void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "searchDirection", this._searchDirection);
        DataItemTimeFilter.writeRelatedObject(this._periods, thisElement, writingContext, "Periods");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._searchDirection = attrsProvider.consumeAttrAndInternResult("searchDirection");
        String periods = attrsProvider.consumeAttr("nPeriods");
        if (periods != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(2);
            constant.setValue(periods);
            this._periods = constant;
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._periods = (ExpressionInterface)((Object)riHolder.consumeObject("Periods"));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._searchDirection = IQModelImplUtilities.getAttr(thisElement, "searchDirection");
        String periods = IQModelImplUtilities.getAttr(thisElement, "nPeriods");
        if (periods != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(2);
            constant.setValue(periods);
            this._periods = constant;
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        int expType;
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._periods != null && (expType = this._periods.getExpressionType()) != 2) {
            Reason reason = new Reason((Object)this, 2, 226, "DataItemTimeFilter.InvalidPeriodExpressionType.txt", (Object[])null);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        if (this._periods instanceof Prompt && !ExpressionUtil.isSingleSelectionPrompt((Prompt)this._periods)) {
            Reason notSingleSelectionPrompt = new Reason((Object)this, 8, 225, "Expression.OnlySingleSelectionPromptsAreSupported.fmt.txt", this, this._periods);
            reasons.add(notSingleSelectionPrompt);
        }
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._periods instanceof AbstractModelItem) {
            intoList.add(this._periods);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._periods = (ExpressionInterface)DataItemTimeFilter.replace(this._periods, oldObject, newObject);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        DataItemTimeFilter clone = (DataItemTimeFilter)super.clone();
        clone._periods = DataItemTimeFilter.cloneReferencedExpression(this._periods);
        return clone;
    }
}

