/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MonotonicIntegerToStringMapping;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class DataItemRankFilter
extends BaseFilter {
    public static final String EVENT_BY_RANK_NAMES_CHANGED = "By rank names changed";
    public static final String EVENT_BY_RANK_ORDER_CHANGED = "By rank order changed";
    public static final String EVENT_BY_RANK_TYPE_CHANGED = "By rank type changed";
    public static final String EVENT_VALUE_CHANGED = "Value changed";
    private String[] _byRankNames;
    private List<ExpressionInterface> _byRankQualifiers = new ArrayList<ExpressionInterface>();
    private int _rankOrder = 0;
    private int _rankType = 0;
    private int _value = 0;
    private boolean _includeTies = false;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int COUNT = 0;
    public static final int PERCENT = 1;
    public static final int SUM = 2;
    private static final Logger _logger = LogManager.getLogger(DataItemRankFilter.class);
    private static final String[] RANK_ORDER_PERSISTENCE_VALUES = new String[]{"TOP", "BOTTOM"};
    private static final int[] RANK_ORDER_MODEL_INT_VALUES = new int[]{0, 1};
    private static final String[] RANK_TYPE_PERSISTENCE_VALUES = new String[]{"COUNT", "PERCENT", "SUM"};
    private static final int[] RANK_TYPE_MODEL_INT_VALUES = new int[]{0, 1, 2};
    private static final MonotonicIntegerToStringMapping rankOrderPersistor = new MonotonicIntegerToStringMapping(RANK_ORDER_PERSISTENCE_VALUES, RANK_ORDER_MODEL_INT_VALUES);
    private static final MonotonicIntegerToStringMapping rankTypePersistor = new MonotonicIntegerToStringMapping(RANK_TYPE_PERSISTENCE_VALUES, RANK_TYPE_MODEL_INT_VALUES);

    public DataItemRankFilter(int rankOrder, int value, String[] byRankNames, int rankType) {
        if (byRankNames != null) {
            this.setbyRankNames(byRankNames);
        }
        this.setRankType(rankType);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public DataItemRankFilter(int rankOrder, int value, List byRankQualifierNames, int rankType) {
        if (byRankQualifierNames != null) {
            this.setRankQualifiers(byRankQualifierNames);
        }
        this.setRankType(rankType);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public DataItemRankFilter() {
    }

    public DataItemRankFilter(int rankOrder, int value, String[] byRankNames, int rankType, boolean includeTies) {
        if (byRankNames != null) {
            this.setbyRankNames(byRankNames);
        }
        this.setRankType(rankType);
        this.setIncludeTies(includeTies);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public DataItemRankFilter(int rankOrder, int value, List byRankQualifierNames, int rankType, boolean includeTies) {
        if (byRankQualifierNames != null) {
            this.setRankQualifiers(byRankQualifierNames);
        }
        this.setRankType(rankType);
        this.setIncludeTies(includeTies);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public DataItemRankFilter(int rankOrder, int value) {
        this.setRankType(0);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public DataItemRankFilter(int rankOrder, int value, boolean includeTies) {
        this.setRankType(0);
        this.setIncludeTies(includeTies);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public void setbyRankName(String byRankName) {
        this.changeableCheck();
        if (byRankName != null) {
            this._byRankNames = new String[1];
            this._byRankNames[0] = byRankName;
        } else {
            this._byRankNames = null;
        }
        this._byRankQualifiers = null;
        this.fireChangeEvent(EVENT_BY_RANK_NAMES_CHANGED);
    }

    public void setIncludeTies(boolean includeTies) {
        if (this._rankType == 0) {
            this._includeTies = includeTies;
        } else if (includeTies) {
            String rankType;
            switch (this._rankType) {
                case 0: {
                    rankType = this._rankType + "(Count)";
                    break;
                }
                case 1: {
                    rankType = this._rankType + "(Percent)";
                    break;
                }
                case 2: {
                    rankType = this._rankType + "(Sum)";
                    break;
                }
                default: {
                    rankType = Integer.toString(this._rankType);
                }
            }
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("RankFilterIncludeTiesErrorWithRankType.fmt.txt", rankType));
        }
    }

    public String getbyRankName() {
        String out = null;
        if (this._byRankNames != null && this._byRankNames.length >= 1) {
            out = this._byRankNames[0];
        }
        return out;
    }

    public boolean isIncludeTies() {
        return this._includeTies;
    }

    public void setRankQualifiers(List byRankQualifiers) {
        this.changeableCheck();
        byRankQualifiers = ListUtils.newList(byRankQualifiers);
        IQModelImplUtilities.ensureProperArgumentTypes(byRankQualifiers, VALID_TYPES_ANY_EXPRESSION);
        this._byRankNames = null;
        this._byRankQualifiers = byRankQualifiers;
        this.fireChangeEvent(EVENT_BY_RANK_NAMES_CHANGED);
    }

    public void setbyRankNames(String[] byRankNames) {
        this.changeableCheck();
        if (byRankNames != null) {
            byRankNames = (String[])byRankNames.clone();
            for (int i = 0; i < byRankNames.length; ++i) {
                if (byRankNames[i] != null) continue;
                throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataItemRankFilter.NullArgAtIndexForByRankName.fmt.txt", new Object[0]));
            }
            this._byRankNames = byRankNames;
        } else {
            this._byRankNames = null;
        }
        this._byRankQualifiers = null;
        this.fireChangeEvent(EVENT_BY_RANK_NAMES_CHANGED);
    }

    public String[] getbyRankNames() {
        return this._byRankNames == null ? null : (String[])this._byRankNames.clone();
    }

    public List<ExpressionInterface> getRankQualifiers() {
        return this._byRankQualifiers;
    }

    public void setRankOrder(int rankOrder) {
        this.changeableCheck();
        if (rankOrder < 0 || rankOrder >= RANK_ORDER_PERSISTENCE_VALUES.length) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataItemRankBadRankOrder.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this._rankOrder = rankOrder;
        this.fireChangeEvent(EVENT_BY_RANK_ORDER_CHANGED);
    }

    public int getRankOrder() {
        return this._rankOrder;
    }

    public void setRankType(int rankType) {
        this.changeableCheck();
        if (rankType >= 0 && rankType < RANK_TYPE_PERSISTENCE_VALUES.length) {
            this._rankType = rankType;
            this.fireChangeEvent(EVENT_BY_RANK_TYPE_CHANGED);
        } else {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)IQModelImplUtilities.getMessageFormatter("DataItemRankFilterBadRankType.txt", new Object[0]));
            }
            this._rankType = 0;
        }
    }

    public int getRankType() {
        return this._rankType;
    }

    public void setValue(int value) {
        this.changeableCheck();
        if (this._value != value) {
            this._value = value;
            this.fireChangeEvent(EVENT_VALUE_CHANGED);
        }
    }

    public int getValue() {
        return this._value;
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        if (this._byRankQualifiers != null && this._byRankQualifiers.size() > 0) {
            for (int i = 0; i < this._byRankQualifiers.size(); ++i) {
                ExpressionInterface _obj = this._byRankQualifiers.get(i);
                if (!(_obj instanceof ExpressionInterface)) continue;
                ExpressionInterface expression = _obj;
                ExpressionInterface newExp = this.singleReplaceResources(expression, oldResource, newResource, model, recursive);
                this._byRankQualifiers.set(i, newExp);
            }
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DataItemOLAPRankFilter";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        IQModelImplUtilities.setAttr(thisElement, "rankOrder", rankOrderPersistor.stringValue(this._rankOrder));
        IQModelImplUtilities.setIntAttr(thisElement, "rankValue", this._value);
        IQModelImplUtilities.setAttr(thisElement, "rankType", rankTypePersistor.stringValue(this._rankType));
        IQModelImplUtilities.setBooleanAttr(thisElement, "includeTies", this._includeTies, false);
        this.writeByRankNames(thisElement);
        DataItemRankFilter.writeRelatedObjects(this._byRankQualifiers, thisElement, writingContext, "RankByQualifiers");
    }

    private void writeByRankNames(Element thisElement) throws MetadataException {
        if (this._byRankNames != null && this._byRankNames.length > 0) {
            IQModelImplUtilities.setCommaSeparatedStringAttr(thisElement, "rankBy", this._byRankNames);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._rankOrder = attrsProvider.consumeIntWrittenAsString("rankOrder", rankOrderPersistor, 0);
        this._rankType = attrsProvider.consumeIntWrittenAsString("rankType", rankTypePersistor, 0);
        this._value = attrsProvider.consumeIntAttr("rankValue", 0);
        this._includeTies = attrsProvider.consumeBooleanAttr("includeTies", false);
        this._byRankNames = attrsProvider.consumeCommaSeparatedString("rankBy");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._byRankQualifiers = riHolder.consumeObjects("RankByQualifiers", ExpressionInterface.class);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        String rankOrderStr = IQModelImplUtilities.getAttr(thisElement, "rankOrder");
        this._rankOrder = rankOrderPersistor.intValue(rankOrderStr, 0);
        String rankTypeStr = IQModelImplUtilities.getAttr(thisElement, "rankType");
        this._rankType = rankTypePersistor.intValue(rankTypeStr, 0);
        this._value = IQModelImplUtilities.getIntAttr(thisElement, "rankValue", 0);
        this._includeTies = IQModelImplUtilities.getBooleanAttr(thisElement, "rankIncludeTies", false);
        String rankByList = IQModelImplUtilities.getAttr(thisElement, "rankBy");
        if (rankByList != null && rankByList.length() > 0) {
            ArrayList<String> temp = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(rankByList, ",");
            while (st.hasMoreTokens()) {
                temp.add(st.nextToken());
            }
            if (temp.size() > 0) {
                this._byRankNames = temp.toArray(new String[temp.size()]);
            }
        }
        this._byRankQualifiers = DataItemRankFilter.v1_readItemListUnderSubelement(thisElement, readingContext, "rankQualBy", VALID_TYPES_ANY_EXPRESSION);
    }

    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._byRankQualifiers != null) {
            intoList.addAll(this._byRankQualifiers);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        DataItemRankFilter.replaceInList(this._byRankQualifiers, oldObject, newObject);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        DataItemRankFilter clone = (DataItemRankFilter)super.clone();
        if (this._byRankQualifiers != null) {
            clone.setRankQualifiers(DataItemRankFilter.cloneReferencedExpressionList(this._byRankQualifiers));
        }
        return clone;
    }

    @SASScope
    public String toString(Locale locale) {
        Object rankQualifier;
        int rankQualifierSize;
        if (this._byRankNames != null) {
            rankQualifierSize = this._byRankNames.length;
            rankQualifier = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, (Object[])this._byRankNames);
        } else if (this._byRankQualifiers == null) {
            rankQualifier = null;
            rankQualifierSize = 0;
        } else {
            rankQualifierSize = this._byRankQualifiers.size();
            rankQualifier = rankQualifierSize == 0 ? null : (this._byRankQualifiers.size() == 1 ? this._byRankQualifiers.get(0) : new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._byRankQualifiers.toArray()));
        }
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("DataItemRankFilterOlap.toString.fmt.txt", this.actionTypeMessageFormatter(), this._rankOrder, this._value, this._rankType, rankQualifierSize, rankQualifier, this._includeTies ? 1 : 0);
        return message.getMessage(locale);
    }
}

