/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MonotonicIntegerToStringMapping;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.util.LocaleUtilities;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class DataItemNavigationFilter
extends BaseFilter {
    public static final String EVENT_LEVEL_NAME_CHANGED = "Level name changed";
    public static final String EVENT_NAVIGATION_FILTER_TYPE_CHANGED = "Navigation filter type changed";
    public static final String EVENT_NAVIGATION_MEMBER_NAME_CHANGED = "Navigation member name changed";
    public static final int PARENT_NAVIGATION_FILTER_TYPE = 0;
    public static final int ANCESTORS_NAVIGATION_FILTER_TYPE = 1;
    public static final int DESCENDANTS_NAVIGATION_FILTER_TYPE = 2;
    public static final int SIBLINGS_NAVIGATION_FILTER_TYPE = 3;
    public static final int CHILDREN_NAVIGATION_FILTER_TYPE = 4;
    public static final int ROOTS_NAVIGATION_FILTER_TYPE = 5;
    public static final int LEAVES_NAVIGATION_FILTER_TYPE = 6;
    public static final int LEVEL_NAVIGATION_FILTER_TYPE = 7;
    public static final int PARENT_LEVEL_NAVIGATION_FILTER_TYPE = 8;
    private int _navigationFilterType;
    private String _navigationName;
    private String _levelName = null;
    private ExpressionInterface _level = null;
    private Locale _memberLocale = null;
    private static final Logger _logger = LogManager.getLogger(DataItemNavigationFilter.class);
    private static final String[] NAVIGATION_TYPE_PERSISTENCE_VALUES = new String[]{"PARENT", "ANCESTORS", "DESCENDANTS", "SIBLINGS", "CHILDREN", "ROOTS", "LEAVES", "LEVEL", "PARENT_LEVEL"};
    private static final int[] NAVIGATION_TYPE_MODEL_INT_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final MonotonicIntegerToStringMapping navigationTypePersistor = new MonotonicIntegerToStringMapping(NAVIGATION_TYPE_PERSISTENCE_VALUES, NAVIGATION_TYPE_MODEL_INT_VALUES);

    public DataItemNavigationFilter() {
    }

    public DataItemNavigationFilter(int navigationFilterType, String navigationName) {
        this.setNavigationMemberName(navigationName);
        this.setNavigationFilterType(navigationFilterType);
    }

    @Deprecated
    public DataItemNavigationFilter(int navigationFilterType, String navigationName, String levelName) {
        this.setNavigationMemberName(navigationName);
        this.setNavigationFilterType(navigationFilterType);
        this.setLevelName(levelName);
    }

    public DataItemNavigationFilter(int navigationFilterType, String navigationName, ExpressionInterface level) {
        this.setNavigationMemberName(navigationName);
        this.setNavigationFilterType(navigationFilterType);
        this.setLevel(level);
    }

    public void setNavigationFilterType(int type) {
        this.changeableCheck();
        if (type >= 0 && type < NAVIGATION_TYPE_PERSISTENCE_VALUES.length) {
            if (this._navigationFilterType != type) {
                this._navigationFilterType = type;
                this.fireChangeEvent(EVENT_NAVIGATION_FILTER_TYPE_CHANGED);
            }
        } else {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataItemNavigationFilter.HasInvalidFilterType.fmt.txt", type));
        }
    }

    public int getNavigationFilterType() {
        return this._navigationFilterType;
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    public void setNavigationMemberName(String navigationName) {
        this.setNavigationMemberName(navigationName, null);
    }

    public void setNavigationMemberName(String navigationName, Locale locale) {
        this.changeableCheck();
        if (!IQModelImplUtilities.same(this._navigationName, navigationName)) {
            if (locale == null) {
                locale = LocaleUtilities.getDefaultViewerLocale();
            }
            this._memberLocale = locale;
            this._navigationName = navigationName;
            this.fireChangeEvent(EVENT_NAVIGATION_MEMBER_NAME_CHANGED);
        }
    }

    public String getNavigationName() {
        return this._navigationName;
    }

    @Deprecated
    public void setLevelName(String levelName) {
        this.changeableCheck();
        if (!IQModelImplUtilities.same(this._levelName, levelName)) {
            if (levelName == null && (this._navigationFilterType == 1 || this._navigationFilterType == 2)) {
                throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataItemNavigationFilter.HasNullLevelName.txt", "" + levelName));
            }
            this._levelName = levelName;
            this.fireChangeEvent(EVENT_LEVEL_NAME_CHANGED);
        }
    }

    public void setLevel(ExpressionInterface level) {
        this.changeableCheck();
        if (!(level instanceof Level)) {
            throw new IllegalArgumentException();
        }
        this._level = level;
    }

    public ExpressionInterface getLevel() {
        return this._level;
    }

    public String getLevelName() {
        String returnValue = null;
        if (this._level != null) {
            if (this._level instanceof Level) {
                try {
                    returnValue = ((Level)this._level).getUniqueName();
                }
                catch (MetadataException e) {
                    if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                        _logger.error(e.getLocalizedMessage());
                    }
                }
            }
        } else if (this._navigationName != null && this._levelName != null) {
            returnValue = this._levelName;
        }
        return returnValue;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DataItemNavigationFilter";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this._navigationFilterType != 0) {
            IQModelImplUtilities.setAttr(thisElement, "navFilterType", navigationTypePersistor.stringValue(this._navigationFilterType));
        }
        IQModelImplUtilities.setAttr(thisElement, "navName", this._navigationName);
        if (this._level == null) {
            if (this._levelName != null) {
                IQModelImplUtilities.setAttr(thisElement, "levelName", this._levelName);
            }
        } else {
            this.setLevel(this._level);
        }
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._level = (ExpressionInterface)((Object)riHolder.consumeObject("Level"));
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._navigationFilterType = attrsProvider.consumeIntWrittenAsString("navFilterType", navigationTypePersistor, 0);
        this._navigationName = attrsProvider.consumeAttr("navName");
        this._levelName = attrsProvider.consumeAttr("levelName");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        String navigationFilterTypeStr = IQModelImplUtilities.getAttr(thisElement, "navFilterType");
        this._navigationFilterType = navigationTypePersistor.intValue(navigationFilterTypeStr, 0);
        this._navigationName = IQModelImplUtilities.getAttr(thisElement, "navName");
        this._levelName = IQModelImplUtilities.getAttr(thisElement, "levelName");
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if ((this._navigationFilterType == 1 || this._navigationFilterType == 2) && this._levelName == null && this._level == null) {
            reasons.add(new Reason((Object)this, 2, 64, "DataItemNavigationFilter.HasNullLevelName.txt", new Object[0]));
        }
        if (this._navigationName == null) {
            reasons.add(new Reason((Object)this, 2, 65, "DataItemNavigationFilter.HasNullNavigationName.txt", new Object[0]));
        }
        if (this._navigationFilterType < 0 || this._navigationFilterType >= NAVIGATION_TYPE_PERSISTENCE_VALUES.length) {
            reasons.add(new Reason((Object)this, 2, 66, "DataItemNavigationFilter.HasInvalidFilterType.fmt.txt", Integer.toString(this._navigationFilterType)));
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._level != null && this._level instanceof AbstractModelItem) {
            intoList.add(this._level);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        if (this._level != null) {
            this._level = (ExpressionInterface)DataItemNavigationFilter.replace(this._level, oldObject, newObject);
        }
    }

    @SASScope
    public String toString(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataItemNavigationFilter(").append(this.actionTypeMessageFormatter()).append(',').append(navigationTypePersistor.stringValue(this._navigationFilterType)).append(',').append(this._navigationName).append(',').append(this._levelName).append(')');
        return buffer.toString();
    }
}

