/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.business.step.olap.TupleFilterMemberQualifier;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.util.impl.AppliedFilter;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class BusinessQueryTupleFilter
extends BaseFilter {
    public static final String EVENT_TUPLES_CHANGED = "Tuples changed";
    public static final String EVENT_MEASURE_CHANGED = "Measure changed";
    private static final Logger _logger = LogManager.getLogger(BusinessQueryTupleFilter.class);
    private DataItem _measureQualifier = null;
    private List _memberQualifierList = null;

    public String getDisplayedText(MetadataInterface metadata, Role role, boolean applyPromptValues, Locale locale) {
        IQMetadataInterface iqMetadataInterface;
        BusinessModel businessModel;
        String returnValue = this.toString();
        if (metadata instanceof IQMetadataInterface && (businessModel = (iqMetadataInterface = (IQMetadataInterface)metadata).getRelatedBusinessModel()) instanceof DataSelection) {
            DataSelection ds = (DataSelection)businessModel;
            returnValue = AppliedFilter.getOLAPBusinessQueryStepFilterDescription(ds, role, this, iqMetadataInterface, applyPromptValues, locale);
        }
        return returnValue;
    }

    public static boolean isFilterSelectionValid(BusinessQuery model, TupleElementInterface[] tupleElements) {
        boolean returnValue = true;
        StructureOfData structure = model.getInputStructure();
        if (!structure.isOLAP()) {
            return false;
        }
        if (tupleElements != null && BusinessQueryTupleFilter.isTotalSelected(tupleElements)) {
            returnValue = false;
        }
        return returnValue;
    }

    private static boolean isTotalSelected(TupleElementInterface[] tupleElems) {
        boolean returnValue;
        block3: {
            returnValue = false;
            try {
                for (TupleElementInterface tuple : tupleElems) {
                    TupleElementType type = tuple.getType();
                    if (type != TupleElementType.TOTAL && type != TupleElementType.SUBTOTAL) continue;
                    returnValue = true;
                    break;
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(Level.ERROR)) break block3;
                _logger.error(e.getLocalizedMessage());
            }
        }
        return returnValue;
    }

    public DataItem getMeasuresQualifier() {
        return this._measureQualifier;
    }

    public List<TupleFilterMemberQualifier> getMemberQualifiers() {
        return ListUtils.newList(this._memberQualifierList);
    }

    public void setMeasureQualifier(DataItem measureQualifier) {
        this._measureQualifier = measureQualifier;
        this.fireChangeEvent(EVENT_MEASURE_CHANGED);
    }

    public void setMemberQualifiers(List tupleFilterMemberQualifiers) {
        this._memberQualifierList = tupleFilterMemberQualifiers = ListUtils.newList(tupleFilterMemberQualifiers);
        this.fireChangeEvent(EVENT_TUPLES_CHANGED);
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._memberQualifierList != null) {
            intoList.addAll(this._memberQualifierList);
        }
        if (this._measureQualifier != null) {
            intoList.add(this._measureQualifier);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        BusinessQueryTupleFilter clone = (BusinessQueryTupleFilter)super.clone();
        clone._measureQualifier = (DataItem)BusinessQueryTupleFilter.cloneReferencedExpression(this._measureQualifier);
        if (this._memberQualifierList != null) {
            clone._memberQualifierList = BusinessQueryTupleFilter.cloneReferencedExpressionList(this._memberQualifierList);
        }
        return clone;
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._measureQualifier = (DataItem)((Object)riHolder.consumeObject("TupleFilterMeasure"));
        this._memberQualifierList = riHolder.consumeObjects("TupleFilterMembers", Object.class);
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "BusinessQueryTupleFilter";
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        BusinessQueryTupleFilter.replaceInList(this._memberQualifierList, oldObject, newObject);
        this._measureQualifier = (DataItem)BusinessQueryTupleFilter.replace(this._measureQualifier, oldObject, newObject);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._measureQualifier = (DataItem)Utils.replaceResource(this._measureQualifier, oldResource, newResource, model, recursive);
        for (int i = 0; i < this._memberQualifierList.size(); ++i) {
            Object _obj = this._memberQualifierList.get(i);
            if (!(_obj instanceof TupleFilterMemberQualifier)) continue;
            TupleFilterMemberQualifier tupleMemberQ = (TupleFilterMemberQualifier)_obj;
            ExpressionInterface newExp = this.singleReplaceResources(tupleMemberQ.getMemberItem(), oldResource, newResource, model, recursive);
            tupleMemberQ.setMemberItem((DataItem)newExp);
            this._memberQualifierList.set(i, newExp);
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        BusinessQueryTupleFilter.writeRelatedObject(this._measureQualifier, thisElement, writingContext, "TupleFilterMeasure", ModelVersion.VERSION_92M3);
        BusinessQueryTupleFilter.writeRelatedObjects(this._memberQualifierList, thisElement, writingContext, "TupleFilterMembers", ModelVersion.VERSION_92M3);
    }

    @SASScope
    public String toString(Locale locale) {
        ArrayMessageFormatter memberQualifier;
        int memberQualifierSize = 0;
        if (this._memberQualifierList == null || this._memberQualifierList.isEmpty()) {
            memberQualifier = null;
        } else {
            Iterator ite = this._memberQualifierList.iterator();
            ArrayList<String> li = new ArrayList<String>();
            while (ite.hasNext()) {
                li.add(((TupleFilterMemberQualifier)ite.next()).toString());
                ++memberQualifierSize;
            }
            memberQualifier = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, li.toArray());
        }
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("BusinessQueryTupleFilter.toString.fmt.txt", this.actionTypeMessageFormatter(), memberQualifierSize, memberQualifier, this._measureQualifier);
        return message.getMessage(locale);
    }
}

