/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.AppliedFilter;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.MetadataInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class BusinessQueryRankFilter
extends BaseFilter {
    public static final String EVENT_BY_RANK_NAMES_CHANGED = "By rank names changed";
    public static final String EVENT_BY_RANK_ORDER_CHANGED = "By rank order changed";
    public static final String EVENT_BY_RANK_TYPE_CHANGED = "By rank type changed";
    public static final String EVENT_VALUE_CHANGED = "Value changed";
    private List _byRankQualifiers = new ArrayList();
    private String _rankOrder;
    private String _rankType;
    private int _value;
    private boolean _includeTies = false;
    private Locale _memberLocale = null;
    public static final String TOP = "Top";
    public static final String BOTTOM = "Bottom";
    public static final String COUNT = "Count";
    public static final String PERCENT = "Percent";
    public static final String SUM = "Sum";
    private static final Logger _logger = LogManager.getLogger(BusinessQueryRankFilter.class);

    public BusinessQueryRankFilter(String rankOrder, int value, List byRankQualifierNames, String rankType) {
        if (byRankQualifierNames != null) {
            this.setRankQualifiers(byRankQualifierNames);
        }
        this.setRankType(rankType);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public BusinessQueryRankFilter() {
    }

    public BusinessQueryRankFilter(String rankOrder, int value, List byRankQualifierNames, String rankType, boolean includeTies) {
        if (byRankQualifierNames != null) {
            this.setRankQualifiers(byRankQualifierNames);
        }
        this.setRankType(rankType);
        this.setIncludeTies(includeTies);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public BusinessQueryRankFilter(String rankOrder, int value) {
        this.setRankType(COUNT);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public BusinessQueryRankFilter(String rankOrder, int value, boolean includeTies) {
        this.setRankType(COUNT);
        this.setIncludeTies(includeTies);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public boolean isIncludeTies() {
        return this._includeTies;
    }

    public String getDisplayedText(MetadataInterface metadata, Role role, boolean applyPromptValues, Locale locale) {
        IQMetadataInterface iqMetadataInterface;
        BusinessModel businessModel;
        String returnValue = this.toString();
        if (metadata instanceof IQMetadataInterface && (businessModel = (iqMetadataInterface = (IQMetadataInterface)metadata).getRelatedBusinessModel()) instanceof DataSelection) {
            DataSelection ds = (DataSelection)businessModel;
            returnValue = AppliedFilter.getOLAPBusinessQueryStepFilterDescription(ds, role, this, iqMetadataInterface, applyPromptValues, locale);
        }
        return returnValue;
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    public void setRankQualifiers(List byRankQualifiers) {
        this.setRankQualifiers(byRankQualifiers, null);
    }

    public void setRankQualifiers(List byRankQualifiers, Locale locale) {
        byRankQualifiers = ListUtils.newList(byRankQualifiers);
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        this._memberLocale = locale;
        IQModelImplUtilities.ensureProperArgumentTypes(byRankQualifiers, VALID_TYPES_ANY_EXPRESSION);
        this._byRankQualifiers = byRankQualifiers;
        this.fireChangeEvent(EVENT_BY_RANK_NAMES_CHANGED);
    }

    public List getRankQualifiers() {
        return ListUtils.newList(this._byRankQualifiers);
    }

    public void setRankOrder(String rankOrder) {
        if (!rankOrder.equalsIgnoreCase(BOTTOM) && !rankOrder.equalsIgnoreCase(TOP)) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryBadRankOrder.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this._rankOrder = rankOrder;
        this.fireChangeEvent(EVENT_BY_RANK_ORDER_CHANGED);
    }

    public String getRankOrder() {
        return this._rankOrder;
    }

    public void setIncludeTies(boolean includeTies) {
        if (this._rankType.equalsIgnoreCase(COUNT)) {
            this._includeTies = includeTies;
        } else if (includeTies) {
            MessageFormatter msg = null;
            msg = this._rankType.trim().length() > 0 ? IQModelImplUtilities.getMessageFormatter("RankFilterIncludeTiesErrorWithRankType.fmt.txt", this._rankType) : IQModelImplUtilities.getMessageFormatter("RankFilterIncludeTiesError.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }

    public void setRankType(@Nonnull String rankType) {
        Preconditions.ensureNonNull(rankType, "rankType", _logger);
        if (!(rankType.equalsIgnoreCase(COUNT) || rankType.equalsIgnoreCase(PERCENT) || rankType.equalsIgnoreCase(SUM))) {
            rankType = COUNT;
        }
        this._rankType = rankType;
        this.fireChangeEvent(EVENT_BY_RANK_TYPE_CHANGED);
    }

    public String getRankType() {
        return this._rankType;
    }

    public void setValue(int value) {
        this._value = value;
        this.fireChangeEvent(EVENT_VALUE_CHANGED);
    }

    public int getValue() {
        return this._value;
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        for (int i = 0; i < this._byRankQualifiers.size(); ++i) {
            Object _obj = this._byRankQualifiers.get(i);
            if (!(_obj instanceof ExpressionInterface)) continue;
            ExpressionInterface expression = (ExpressionInterface)_obj;
            ExpressionInterface newExp = this.singleReplaceResources(expression, oldResource, newResource, model, recursive);
            this._byRankQualifiers.set(i, newExp);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "BusinessQueryRankFilter";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "rankOrder", this._rankOrder);
        IQModelImplUtilities.setAttr(thisElement, "rankType", this._rankType);
        IQModelImplUtilities.setIntAttr(thisElement, "rankValue", this._value, 0);
        IQModelImplUtilities.setBooleanAttr(thisElement, "rankIncludeTies", this._includeTies, false);
        BusinessQueryRankFilter.writeRelatedObjects(this._byRankQualifiers, thisElement, writingContext, "RankByQualifiers");
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._rankOrder = attrsProvider.consumeAttrAndInternResult("rankOrder");
        this._rankType = attrsProvider.consumeAttrAndInternResult("rankType");
        this._value = attrsProvider.consumeIntAttr("rankValue", 0);
        this._includeTies = attrsProvider.consumeBooleanAttr("rankIncludeTies", false);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._byRankQualifiers = riHolder.consumeObjects("RankByQualifiers", ExpressionInterface.class);
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._rankOrder = IQModelImplUtilities.getAttrAndInternResult(thisElement, "rankOrder");
        this._rankType = IQModelImplUtilities.getAttrAndInternResult(thisElement, "rankType");
        this._value = IQModelImplUtilities.getIntAttr(thisElement, "rankValue", 0);
        this._includeTies = IQModelImplUtilities.getBooleanAttr(thisElement, "rankIncludeTies", false);
        this._byRankQualifiers = BusinessQueryRankFilter.v1_readItemListUnderSubelement(thisElement, readingContext, "rankQualBy", VALID_TYPES_ANY_EXPRESSION);
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._byRankQualifiers != null) {
            intoList.addAll(this._byRankQualifiers);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        BusinessQueryRankFilter.replaceInList(this._byRankQualifiers, oldObject, newObject);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        BusinessQueryRankFilter clone = (BusinessQueryRankFilter)super.clone();
        if (this._byRankQualifiers != null) {
            clone._byRankQualifiers = BusinessQueryRankFilter.cloneReferencedExpressionList(this._byRankQualifiers);
        }
        return clone;
    }

    @SASScope
    public String toString(Locale locale) {
        int rankQualifierSize;
        ArrayMessageFormatter rankQualifier;
        if (this._byRankQualifiers == null) {
            rankQualifier = null;
            rankQualifierSize = 0;
        } else {
            rankQualifierSize = this._byRankQualifiers.size();
            rankQualifier = rankQualifierSize == 0 ? null : (this._byRankQualifiers.size() == 1 ? (ArrayMessageFormatter)this._byRankQualifiers.get(0) : new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._byRankQualifiers.toArray()));
        }
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("BusinessQueryRankFilter.toString.fmt.txt", this.actionTypeMessageFormatter(), this._rankOrder, this._value, this._rankType, rankQualifierSize, rankQualifier, this._includeTies ? 1 : 0);
        return message.getMessage(locale);
    }
}

