/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.AppliedFilter;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.MetadataInterface;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class BusinessQueryDataBasedFilter
extends BaseFilter {
    public static final String EVENT_LEFT_EXPRESSION_CHANGED = "Left expression changed";
    public static final String EVENT_RIGHT_EXPRESSION_CHANGED = "Right expression changed";
    public static final String EVENT_COMPARISON_OPERATOR_CHANGED = "Comparison operator changed";
    @NonNull
    private List<ExpressionInterface> _leftExpressionList = new ArrayList<ExpressionInterface>();
    private ComparisonOperator _operator;
    @NonNull
    private List<NonCalculatedValue> _rightExpressionList = new ArrayList<NonCalculatedValue>();
    private Locale _memberLocale = null;
    private static final Logger _logger = LogManager.getLogger(BusinessQueryDataBasedFilter.class);

    @SASScope
    public BusinessQueryDataBasedFilter() {
    }

    public BusinessQueryDataBasedFilter(@NonNull List<? extends ExpressionInterface> memberNames, @NonNull ComparisonOperator operator, @NonNull Object value) {
        this.setLeftExpression(memberNames);
        this.setOperator(operator);
        if (value != null) {
            StringExpression valueExpression = new StringExpression();
            valueExpression.setText(value.toString());
            valueExpression.setExpressionType(3);
            this.setRightExpression(Collections.singletonList(valueExpression));
        }
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    public String getDisplayedText(MetadataInterface metadata, Role role, boolean applyPromptValues, Locale locale) {
        IQMetadataInterface iqMetadataInterface;
        BusinessModel businessModel;
        String returnValue = this.toString();
        if (metadata instanceof IQMetadataInterface && (businessModel = (iqMetadataInterface = (IQMetadataInterface)metadata).getRelatedBusinessModel()) instanceof DataSelection) {
            DataSelection ds = (DataSelection)businessModel;
            returnValue = AppliedFilter.getOLAPBusinessQueryStepFilterDescription(ds, role, this, iqMetadataInterface, applyPromptValues, locale);
        }
        return returnValue;
    }

    public void setLeftExpression(@NonNull List<? extends ExpressionInterface> values, Locale locale) {
        if (values == null) {
            values = Collections.emptyList();
        }
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        this._memberLocale = locale;
        this._leftExpressionList.clear();
        this._leftExpressionList.addAll(values);
        Preconditions.ensureNonNullTypedElements(this._leftExpressionList, ExpressionInterface.class, "values", _logger);
        this.fireChangeEvent(EVENT_LEFT_EXPRESSION_CHANGED);
    }

    public void setLeftExpression(@NonNull List<? extends ExpressionInterface> values) {
        if (values == null) {
            values = Collections.emptyList();
        }
        this._leftExpressionList.clear();
        this._leftExpressionList.addAll(values);
        Preconditions.ensureNonNullTypedElements(this._leftExpressionList, ExpressionInterface.class, "values", _logger);
        this.fireChangeEvent(EVENT_LEFT_EXPRESSION_CHANGED);
    }

    public List<ExpressionInterface> getLeftExpression() {
        return new ArrayList<ExpressionInterface>(this._leftExpressionList);
    }

    public void setOperator(ComparisonOperator operator) {
        if (this._operator != operator) {
            Preconditions.ensureNonNull(operator, "operator");
            this._operator = operator;
            this.fireChangeEvent(EVENT_COMPARISON_OPERATOR_CHANGED);
        }
    }

    public ComparisonOperator getOperator() {
        return this._operator;
    }

    public void setRightExpression(List<? extends NonCalculatedValue> values) {
        if (values == null) {
            values = Collections.emptyList();
        }
        this._rightExpressionList.clear();
        this._rightExpressionList.addAll(values);
        Preconditions.ensureNonNullTypedElements(this._rightExpressionList, NonCalculatedValue.class);
        this.fireChangeEvent(EVENT_RIGHT_EXPRESSION_CHANGED);
    }

    public List<NonCalculatedValue> getRightExpression() {
        return new ArrayList<NonCalculatedValue>(this._rightExpressionList);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        ListIterator<ExpressionInterface> leftIterator = this._leftExpressionList.listIterator();
        while (leftIterator.hasNext()) {
            ExpressionInterface newExp = this.singleReplaceResources(leftIterator.next(), oldResource, newResource, model, recursive);
            leftIterator.set(newExp);
        }
        ListIterator<NonCalculatedValue> rightIterator = this._rightExpressionList.listIterator();
        while (rightIterator.hasNext()) {
            ExpressionInterface newExp = this.singleReplaceResources((ExpressionInterface)((Object)rightIterator.next()), oldResource, newResource, model, recursive);
            rightIterator.set((NonCalculatedValue)((Object)newExp));
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._operator == null) {
            // empty if block
        }
        if (this._leftExpressionList.isEmpty()) {
            reasons.add(new Reason((Object)this, 2, 74, "DataItemDataBasedFilterEmptyLeft.txt", new Object[0]));
        }
        if (this._rightExpressionList.isEmpty()) {
            reasons.add(new Reason((Object)this, 2, 75, "DataItemDataBasedFilterEmptyRight.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.addAll(this._leftExpressionList);
        intoList.addAll(this._rightExpressionList);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        BusinessQueryDataBasedFilter.replaceInList(this._leftExpressionList, oldObject, newObject);
        BusinessQueryDataBasedFilter.replaceInList(this._rightExpressionList, oldObject, newObject);
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "BusinessQueryDataBasedFilter";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setEnumAttr(thisElement, "operator", this._operator);
        BusinessQueryDataBasedFilter.writeRelatedObjects(this._leftExpressionList, thisElement, writingContext, "LeftExprs");
        BusinessQueryDataBasedFilter.writeRelatedObjects(this._rightExpressionList, thisElement, writingContext, "RightExprs");
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._operator = ComparisonOperator.fromPersistentForm(attrsProvider.consumeAttr("operator"));
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._leftExpressionList.clear();
        this._leftExpressionList.addAll(riHolder.consumeObjects("LeftExprs", ExpressionInterface.class));
        this._rightExpressionList.clear();
        this._rightExpressionList.addAll(riHolder.consumeObjects("RightExprs", NonCalculatedValue.class));
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._operator = ComparisonOperator.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "operator"));
        this._leftExpressionList.clear();
        this._leftExpressionList.addAll(BusinessQueryDataBasedFilter.v1_readItemListUnderSubelement(thisElement, readingContext, "leftFilterExprList", VALID_TYPES_ANY_EXPRESSION));
        this._rightExpressionList.clear();
        this._rightExpressionList.addAll(BusinessQueryDataBasedFilter.v1_readItemListUnderSubelement(thisElement, readingContext, "rightFitlerExprList", VALID_TYPES_NONCALCULATED_VALUE));
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        BusinessQueryDataBasedFilter clone = (BusinessQueryDataBasedFilter)super.clone();
        clone._leftExpressionList = new ArrayList<ExpressionInterface>(this._leftExpressionList.size());
        clone.setLeftExpression(BusinessQueryDataBasedFilter.cloneReferencedExpressionList(this._leftExpressionList));
        clone._rightExpressionList = new ArrayList<NonCalculatedValue>(this._rightExpressionList.size());
        clone.setRightExpression(BusinessQueryDataBasedFilter.cloneReferencedExpressionList(this._rightExpressionList));
        return clone;
    }

    @SASScope
    public String toString(Locale locale) {
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("BusinessQueryDataBasedFilter.toString.fmt.txt", this.actionTypeMessageFormatter(), new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._leftExpressionList == null ? null : this._leftExpressionList.toArray()), this._operator, new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._rightExpressionList == null ? null : this._rightExpressionList.toArray()));
        return message.getMessage(locale);
    }
}

