/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
abstract class AbstractTimeRangeFilter
extends BaseFilter {
    public static final String EVENT_TIME_LEVEL_NAME_CHANGED = "The level name attribute has changed";
    protected ExpressionInterface _level = null;
    private static final Logger _logger = LogManager.getLogger(AbstractTimeRangeFilter.class);

    public void setLevel(String level) throws IllegalArgumentException {
        Preconditions.ensureNonNull(level, "level", _logger);
        ConstantExpression constant = new ConstantExpression();
        constant.setExpressionType(3);
        constant.setValue(level);
        this._level = constant;
        this.fireChangeEvent(EVENT_TIME_LEVEL_NAME_CHANGED);
    }

    public void setLevelName(ExpressionInterface level) {
        Preconditions.ensureNonNull(level, "level", _logger);
        this._level = level;
        this.fireChangeEvent(EVENT_TIME_LEVEL_NAME_CHANGED);
    }

    public String getLevel() {
        String level;
        if (this._level instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._level;
            level = constant.getValue();
        } else {
            level = "";
        }
        return level;
    }

    public ExpressionInterface getLevelName() {
        return this._level;
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        AbstractTimeRangeFilter.writeRelatedObject(this._level, thisElement, writingContext, "Level");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        String level = attrsProvider.consumeAttr("levelName");
        if (level != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(level);
            this._level = constant;
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._level = (ExpressionInterface)((Object)riHolder.consumeObject("Level"));
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        String level = IQModelImplUtilities.getAttr(thisElement, "levelName");
        if (level != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(level);
            this._level = constant;
        }
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this._level != null) {
            intoList.add(this._level);
        }
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._level = (ExpressionInterface)AbstractTimeRangeFilter.replace(this._level, oldObject, newObject);
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        int expType;
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved() && this._level != null && (expType = this._level.getExpressionType()) != 3) {
            Vector<Integer> expTypes = ExpressionUtil.getJdbcTypes(expType);
            Object[] reasonArgs = new Object[]{this._level, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
            Reason reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
            reasons.add(reason);
        }
    }

    @Override
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        if (this._level instanceof Prompt && !ExpressionUtil.isSingleSelectionPrompt((Prompt)this._level)) {
            Reason notSingleSelectionPrompt = new Reason((Object)this, 8, 225, "Expression.OnlySingleSelectionPromptsAreSupported.fmt.txt", this, this._level);
            reasons.add(notSingleSelectionPrompt);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractTimeRangeFilter clone = (AbstractTimeRangeFilter)super.clone();
        clone._level = AbstractTimeRangeFilter.cloneReferencedExpression(this._level);
        return clone;
    }
}

