/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.LocalizableToStringInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class CompoundStep
extends AbstractModelItem
implements StepInterface,
Cloneable,
LocalizableToStringInterface {
    public static final String EVENT_NEGATION_CHANGED = "The negation attribute has changed";
    public static final String EVENT_STEPS_CHANGED = "The list of steps changed";
    public static final String EVENT_CONDITION_TYPE_CHANGED = "The condition type changed";
    public static final String AND_CONDITION = "AND";
    public static final String OR_CONDITION = "OR";
    private List<StepInterface> _steps = new ArrayList<StepInterface>();
    private List<String> _typeOfSteps = new ArrayList<String>();
    private boolean _negateThisExpression = false;
    private static final Logger _logger = LogManager.getLogger(CompoundStep.class);
    private static final char CONDITION_SEPARATOR = ',';

    public void addStep(StepInterface step) {
        this.changeableCheck();
        this._steps.add(Preconditions.ensureNonNull(step));
        step.addListener(this);
        this.fireChangeEvent(EVENT_STEPS_CHANGED);
    }

    public boolean isNegated() {
        return this._negateThisExpression;
    }

    public void setNegated(boolean isNegated) {
        this.changeableCheck();
        if (this._negateThisExpression != isNegated) {
            this._negateThisExpression = isNegated;
            this.fireChangeEvent(EVENT_NEGATION_CHANGED);
        }
    }

    public void setConditionType(String stepCondition) {
        this.changeableCheck();
        if (AND_CONDITION.equalsIgnoreCase(stepCondition)) {
            this._typeOfSteps.add(stepCondition);
        } else if (OR_CONDITION.equalsIgnoreCase(stepCondition)) {
            this._typeOfSteps.add(stepCondition);
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("CompoundStepNotANDOR.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this.fireChangeEvent(EVENT_CONDITION_TYPE_CHANGED);
    }

    public List<StepInterface> getSteps() {
        ArrayList<Object> out = this._steps == null ? new ArrayList(0) : new ArrayList<StepInterface>(this._steps);
        return out;
    }

    public List<String> getStepsConditions() {
        ArrayList<Object> out = this._typeOfSteps == null ? new ArrayList(0) : new ArrayList<String>(this._typeOfSteps);
        return out;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "CompoundStep";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setBooleanAttr(thisElement, "negate", this._negateThisExpression, false);
        CompoundStep.writeRelatedObjects(this._steps, thisElement, writingContext, "Steps");
        this.writeConditions(thisElement);
    }

    private void writeConditions(Element element) throws MetadataException {
        if (this._typeOfSteps != null) {
            int size = this._typeOfSteps.size();
            StringBuffer buf = new StringBuffer(size * 4);
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                String s = this._typeOfSteps.get(i);
                buf.append(s);
            }
            if (buf.length() > 0) {
                IQModelImplUtilities.setAttr(element, "conditions", buf.toString());
            }
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._negateThisExpression = attrsProvider.consumeBooleanAttr("negate", false);
        String conditions = attrsProvider.consumeAttr("conditions");
        this._typeOfSteps = new ArrayList<String>();
        if (conditions != null) {
            this.parseConditions(conditions);
        }
    }

    private void parseConditions(String conditionsAttr) throws SAXException {
        String oneCondition;
        int start = 0;
        int index = conditionsAttr.indexOf(44);
        while (index != -1) {
            oneCondition = conditionsAttr.substring(start, index);
            this.processOneCondition(oneCondition);
            start = index + 1;
            index = conditionsAttr.indexOf(44, start);
        }
        oneCondition = conditionsAttr.substring(start);
        this.processOneCondition(oneCondition);
    }

    private void processOneCondition(String oneCondition) throws SAXException {
        if ((oneCondition = oneCondition.intern()) != AND_CONDITION && oneCondition != OR_CONDITION) {
            throw new SAXException("Invalid condition value: " + oneCondition);
        }
        this._typeOfSteps.add(oneCondition);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._steps = riHolder.consumeObjects("Steps", StepInterface.class);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._negateThisExpression = IQModelImplUtilities.getBooleanAttr(thisElement, "NegativeCompoundStep", false);
        this._steps = CompoundStep.v1_readItemListDirectlyUnderElement(thisElement, readingContext, null, new Class[]{StepInterface.class});
        this._typeOfSteps = IQModelImplUtilities.getMultiValueAttr(thisElement, "CompoundStepConditions");
        for (int i = 0; i < this._typeOfSteps.size(); ++i) {
            String s = this._typeOfSteps.get(i);
            if (s == null) continue;
            this._typeOfSteps.set(i, s.intern());
        }
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this._steps != null) {
            intoList.addAll(this._steps);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        CompoundStep.replaceInList(this._steps, oldObject, newObject);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        CompoundStep clone = (CompoundStep)super.clone();
        clone._typeOfSteps = new ArrayList<String>(this._typeOfSteps);
        clone._steps = new ArrayList<StepInterface>();
        for (StepInterface step : this._steps) {
            if (step == null) continue;
            if (step instanceof AbstractModelItem) {
                step = (StepInterface)((AbstractModelItem)((Object)step)).clone();
                clone._steps.add(step);
                step.addListener(clone);
                continue;
            }
            throw new CloneNotSupportedException(IQModelImplUtilities.getMessage("StepFactory.CannotCloneStep.fmt.txt", this.getIdentityString()));
        }
        return clone;
    }

    @SASScope
    public String toString() {
        return this.toString(null);
    }

    @SASScope
    public String toString(Locale locale) {
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("CompoundStep.toString.fmt.txt", new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._typeOfSteps.toArray()), new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._steps.toArray()), this._negateThisExpression ? 1 : 0);
        return message.getMessage(locale);
    }
}

