/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.services.InitializationException;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.MetadataAttribute;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class SolutionsRemoteContext {
    private static final String SOLUTIONS_REMOTE_SERVICE_NAME = "Remote Services";
    private UserContextInterface _remoteUserContext = null;
    private SessionContextInterface _remoteSessionContext = null;
    private static final Logger _logger = LogManager.getLogger(SolutionsRemoteContext.class);
    RuntimeException destroyedAt = null;

    public SolutionsRemoteContext(DiscoveryServiceInterface disc, UserContextInterface userContext) throws ServiceException, RemoteException {
        SessionServiceInterface ss = this.findRemoteSessionService(disc);
        UserServiceInterface us = this.findRemoteUserService(disc);
        this._remoteUserContext = us.fromByteArray(userContext.toByteArray());
        if (_logger.isDebugEnabled()) {
            _logger.debug("remoteUserContext: " + this._remoteUserContext);
        }
        us.setUser(this._remoteUserContext);
        this._remoteSessionContext = ss.newSessionContext(this._remoteUserContext);
        if (this._remoteSessionContext == null) {
            throw new RuntimeException("Remote Session Context is null!");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("remoteSessionContext: " + this._remoteSessionContext);
        }
        this._remoteUserContext.setSessionContext(this._remoteSessionContext);
    }

    public String getRemoteEntityKey() throws RemoteException {
        if (this.destroyedAt != null) {
            throw new RuntimeException("Remote Session Context already destroyed", this.destroyedAt);
        }
        return this._remoteSessionContext.getEntityKey();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.destroyedAt = new RuntimeException("Destroyed at");
        if (this._remoteSessionContext != null) {
            block8: {
                try {
                    this._remoteSessionContext.destroy();
                }
                catch (ServiceException e1) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("ServiceException while cleaning up _remoteSessionContext=" + this._remoteSessionContext, (Throwable)e1);
                    }
                }
                catch (RemoteException e2) {
                    if (!_logger.isDebugEnabled()) break block8;
                    _logger.debug("RemoteException while cleaning up _remoteSessionContext=" + this._remoteSessionContext, (Throwable)e2);
                }
            }
            this._remoteSessionContext = null;
        }
        if (this._remoteUserContext != null) {
            block9: {
                try {
                    this._remoteUserContext.destroy();
                }
                catch (RemoteException e3) {
                    if (!_logger.isDebugEnabled()) break block9;
                    _logger.debug("RemoteException while cleaning up _remoteUserContext=" + this._remoteUserContext, (Throwable)e3);
                }
            }
            this._remoteUserContext = null;
        }
    }

    private SessionServiceInterface findRemoteSessionService(DiscoveryServiceInterface disc) throws InitializationException, RemoteException, ServiceException, ServiceNotAvailableException {
        ServiceAttributeInterface[] sessionAttrs = new ServiceAttributeInterface[]{new MetadataAttribute(null, SOLUTIONS_REMOTE_SERVICE_NAME, "SoftwareComponent", null)};
        Class[] sessionClasses = new Class[]{SessionServiceInterface.class};
        ServiceTemplate sessionTemplate = new ServiceTemplate(sessionClasses, sessionAttrs);
        SessionServiceInterface ss = (SessionServiceInterface)disc.findService(sessionTemplate);
        return ss;
    }

    private UserServiceInterface findRemoteUserService(DiscoveryServiceInterface disc) throws InitializationException, RemoteException, ServiceException, ServiceNotAvailableException {
        ServiceAttributeInterface[] userAttrs = new ServiceAttributeInterface[]{new MetadataAttribute(null, SOLUTIONS_REMOTE_SERVICE_NAME, "SoftwareComponent", null)};
        Class[] userClasses = new Class[]{UserServiceInterface.class};
        ServiceTemplate userTemplate = new ServiceTemplate(userClasses, userAttrs);
        UserServiceInterface us = (UserServiceInterface)disc.findService(userTemplate);
        return us;
    }
}

