/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.impl.security.AbstractEventBrokerImpl;
import com.sas.iquery.metadata.business.impl.security.EventBrokerCredentials;
import com.sas.iquery.metadata.business.impl.security.TableInfoServiceRequest;
import com.sas.iquery.metadata.business.impl.security.TableInfoServiceResponse;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Root;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.util.ServiceUrlResolver;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.webdav.WebDAVStatus;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class OMATableExtensionBroker
extends AbstractEventBrokerImpl {
    private static final Logger _logger = LogManager.getLogger(OMATableExtensionBroker.class);
    private static final String EXTENSION_NAME_SECURITY_ENDPOINT = "SecurityEndpoint";
    private static final String EXTENSION_NAME_SECURITY_ENDPOINT_2 = "Security Endpoint";

    OMATableExtensionBroker(SessionContextInterface session) throws MetadataException {
        super(session);
    }

    @Override
    protected boolean useEntityKeyForEvent() throws MetadataException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableInfoServiceResponse getTableInfo(EventBrokerCredentials credentials, TableInfoServiceRequest request, DiscoveryServiceInterface discoveryService, DataSourceTable dsTable) throws MetadataException {
        AccessPath accessPath = dsTable.getAccessPath();
        Server server = accessPath.getServer();
        Schema schema = accessPath.getSchema();
        Table table = dsTable.getTable();
        String serverSchemaTableName = (server == null ? "null" : "[" + server.getLabel() + "]") + "." + (schema == null ? "null" : "[" + schema.getLabel() + "]") + "." + (table == null ? "null" : "[" + table.getLabel() + "]");
        if (_logger.isDebugEnabled()) {
            _logger.debug("Values found for " + dsTable.getIdentityString() + ": " + serverSchemaTableName);
        }
        if (!(server instanceof SoftwareServer)) {
            throw new MetadataException(this.getErrorMessageNonSoftwareServer(dsTable, server, serverSchemaTableName));
        }
        SoftwareServer softwareServer = (SoftwareServer)server;
        LogicalServerInterface lsi = softwareServer.getLogicalServerInterface();
        if (_logger.isDebugEnabled()) {
            _logger.debug("    LSI = " + lsi);
        }
        if (lsi == null) {
            throw new MetadataException(this.getErrorMessageNoLogicalServer(dsTable, serverSchemaTableName, softwareServer));
        }
        RepositoryInterface repository = null;
        try {
            repository = lsi.getRepository();
        }
        catch (Throwable e) {
            throw new MetadataException(this.getErrorMessageFailedToRetrieveRepository(dsTable, serverSchemaTableName, lsi, e), e);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("    REP = " + repository);
        }
        if (repository == null) {
            throw new MetadataException(this.getErrorMessageNoRepository(dsTable, serverSchemaTableName, lsi));
        }
        if (!(table instanceof OMAWrapper)) {
            throw new MetadataException(this.getErrorMessageNotAnOMAWrapper(dsTable, serverSchemaTableName));
        }
        OMAWrapper oma = (OMAWrapper)((Object)table);
        if (_logger.isDebugEnabled()) {
            _logger.debug("    OMA = " + oma);
        }
        CMetadata cmd = oma.getOMAObject();
        if (_logger.isDebugEnabled()) {
            _logger.debug("    CMD = " + cmd);
        }
        if (cmd == null) {
            throw new MetadataException(this.getErrorMessageNoOMAObject(dsTable, serverSchemaTableName));
        }
        if (!(cmd instanceof Root)) {
            throw new MetadataException(this.getErrorMessageNotARootMetadataObject(dsTable, serverSchemaTableName, cmd));
        }
        Root omr = (Root)cmd;
        if (_logger.isDebugEnabled()) {
            _logger.debug("    OMR = " + omr);
        }
        String sep = null;
        try {
            List<Extension> extensions = AssociationListUtil.filteredSnapshot(omr.getExtensions(), Extension.class);
            for (Extension extension : extensions) {
                if (!extension.getName().equalsIgnoreCase(EXTENSION_NAME_SECURITY_ENDPOINT) && !extension.getName().equalsIgnoreCase(EXTENSION_NAME_SECURITY_ENDPOINT_2)) continue;
                sep = extension.getValue();
                break;
            }
        }
        catch (Throwable e) {
            throw new MetadataException(this.getErrorMessageFailRetrievingTableExtensions(dsTable, serverSchemaTableName, cmd, e), e);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("    SEP = " + sep);
        }
        if (sep == null || sep.trim().length() == 0) {
            throw new MetadataException(this.getErrorMessageNoSepTableExtensions(dsTable, serverSchemaTableName, cmd));
        }
        ServiceUrlResolver suResolver = new ServiceUrlResolver(repository);
        String restServicesUrl = null;
        try {
            restServicesUrl = suResolver.getUrl(sep);
        }
        catch (Throwable e) {
            throw new MetadataException(this.getErrorMessageFailRetrievingSepUrl(dsTable, serverSchemaTableName, cmd, sep, e), e);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("    URL = " + restServicesUrl);
        }
        if (restServicesUrl == null || restServicesUrl.trim().length() == 0) {
            throw new MetadataException(this.getErrorMessageNoSepUrl(dsTable, serverSchemaTableName, cmd, sep));
        }
        String sendText = request.toString();
        if (_logger.isDebugEnabled()) {
            _logger.debug("    Request = " + sendText);
        }
        String respString = null;
        HttpPost httpPost = null;
        try {
            InputStreamEntity requestEntity;
            AuthScope httpAuthScope = this.newHttpAuthScope(credentials);
            Credentials httpCredentials = this.newHttpCredentials(credentials);
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(httpAuthScope, httpCredentials);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
            RequestConfig requestConfig = RequestConfig.custom().setCircularRedirectsAllowed(true).build();
            httpPost = new HttpPost(restServicesUrl);
            httpPost.addHeader("content-type", "application/json");
            httpPost.setConfig(requestConfig);
            try {
                requestEntity = new InputStreamEntity((InputStream)new ByteArrayInputStream(sendText.getBytes()));
                requestEntity.setContentType("application/json");
            }
            catch (Throwable e) {
                throw new MetadataException(this.getErrorMessageFailCreatingXml(dsTable, serverSchemaTableName, cmd, sep, restServicesUrl, e), e);
            }
            httpPost.setEntity((HttpEntity)requestEntity);
            int rc = 200;
            CloseableHttpResponse httpResponse = null;
            try {
                httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                rc = httpResponse.getStatusLine().getStatusCode();
            }
            catch (Throwable e) {
                throw new MetadataException(this.getErrorMessageFailSendingToClient(dsTable, serverSchemaTableName, cmd, sep, restServicesUrl, httpResponse, e), e);
            }
            if (rc != 200 || httpResponse != null && httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new MetadataException(this.getErrorMessageNonStatusOkReturnCode(dsTable, serverSchemaTableName, cmd, sep, restServicesUrl, httpResponse));
            }
            try {
                HttpEntity entity = httpResponse.getEntity();
                respString = EntityUtils.toString((HttpEntity)entity);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("    Reply = " + respString);
                }
            }
            catch (Throwable e) {
                throw new MetadataException(this.getErrorMessageFailRetrievingResponse(dsTable, serverSchemaTableName, cmd, sep, restServicesUrl, e), e);
            }
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        TableInfoServiceResponse infoResponse = this.newTableInfoServiceResponse(respString);
        if (infoResponse == null) {
            throw new MetadataException(this.getErrorMessageResponseReturned(dsTable, serverSchemaTableName, cmd, sep, restServicesUrl));
        }
        if (infoResponse.isInError()) {
            throw new MetadataException(this.getErrorMessageResponseError(dsTable, serverSchemaTableName, cmd, sep, restServicesUrl, infoResponse));
        }
        return infoResponse;
    }

    private Credentials newHttpCredentials(EventBrokerCredentials credentials) {
        int domainIndex;
        String host = credentials.getHost();
        String domain = credentials.getDomain();
        String userid = credentials.getUserid();
        String password = credentials.getPassword();
        if ((domain == null || domain.trim().isEmpty()) && (domainIndex = userid.indexOf("\\")) > 0) {
            domain = userid.substring(0, domainIndex);
            if (userid.length() > domainIndex + 1) {
                userid = userid.substring(domainIndex + 1);
            }
        }
        Object httpCredentials = domain == null || domain.trim().isEmpty() ? new UsernamePasswordCredentials(userid, password) : new NTCredentials(userid, password, host, domain);
        return httpCredentials;
    }

    private AuthScope newHttpAuthScope(EventBrokerCredentials credentials) {
        String host = credentials.getHost();
        int port = Integer.parseInt(credentials.getPort());
        AuthScope authScope = new AuthScope(host, port, null);
        return authScope;
    }

    private MessageFormatter getErrorMessageResponseError(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, String sep, String restServicesUrl, TableInfoServiceResponse infoResponse) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageResponseError.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), restServicesUrl, infoResponse.getError(), sep, cmdName, cmd.getClass().getName());
    }

    private MessageFormatter getErrorMessageResponseReturned(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, String sep, String restServicesUrl) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageResponseReturned.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), restServicesUrl, sep, cmdName, cmd.getClass().getName());
    }

    private MessageFormatter getErrorMessageFailRetrievingResponse(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, String sep, String restServicesUrl, Throwable e) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageFailRetrievingResponse.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), restServicesUrl, sep, cmdName, cmd.getClass().getName(), e);
    }

    private MessageFormatter getErrorMessageNonStatusOkReturnCode(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, String sep, String restServicesUrl, CloseableHttpResponse httpResponse) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNonStatusOkReturnCode.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), restServicesUrl, sep, cmdName, cmd.getClass().getName(), httpResponse.getStatusLine().getStatusCode(), WebDAVStatus.getStatusText((int)httpResponse.getStatusLine().getStatusCode()));
    }

    private MessageFormatter getErrorMessageFailSendingToClient(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, String sep, String restServicesUrl, CloseableHttpResponse httpResponse, Throwable e) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageFailSendingToClient.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), restServicesUrl, sep, cmdName, cmd.getClass().getName(), httpResponse.getStatusLine().getStatusCode(), WebDAVStatus.getStatusText((int)httpResponse.getStatusLine().getStatusCode()), e);
    }

    private MessageFormatter getErrorMessageFailCreatingXml(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, String sep, String restServicesUrl, Throwable e) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageFailCreatingXml.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), restServicesUrl, sep, cmdName, cmd.getClass().getName(), e);
    }

    private MessageFormatter getErrorMessageNoSepUrl(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, String sep) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNoSepUrl.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), sep, cmdName, cmd.getClass().getName());
    }

    private MessageFormatter getErrorMessageFailRetrievingSepUrl(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, String sep, Throwable e) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageFailRetrievingSepUrl.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), sep, cmdName, cmd.getClass().getName(), e);
    }

    private MessageFormatter getErrorMessageNoSepTableExtensions(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNoSepTableExtensions.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), cmdName, cmd.getClass().getName());
    }

    private MessageFormatter getErrorMessageFailRetrievingTableExtensions(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd, Throwable e) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageFailRetrievingTableExtensions.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), cmdName, cmd.getClass().getName(), e);
    }

    private MessageFormatter getErrorMessageNotARootMetadataObject(DataSourceTable dsTable, String serverSchemaTableName, CMetadata cmd) {
        String cmdName;
        try {
            cmdName = cmd.getName();
        }
        catch (Throwable e2) {
            cmdName = cmd.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNotARootMetadataObject.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), cmdName, cmd.getClass().getName());
    }

    private MessageFormatter getErrorMessageNoOMAObject(DataSourceTable dsTable, String serverSchemaTableName) {
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNoOMAObject.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName());
    }

    private MessageFormatter getErrorMessageNotAnOMAWrapper(DataSourceTable dsTable, String serverSchemaTableName) {
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNotAnOMAWrapper.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName());
    }

    private MessageFormatter getErrorMessageNoRepository(DataSourceTable dsTable, String serverSchemaTableName, LogicalServerInterface lsi) {
        String lsiName;
        try {
            lsiName = lsi.getName();
        }
        catch (Throwable e2) {
            lsiName = lsi.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNoRepository.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), lsiName, lsi.getClass().getName());
    }

    private MessageFormatter getErrorMessageFailedToRetrieveRepository(DataSourceTable dsTable, String serverSchemaTableName, LogicalServerInterface lsi, Throwable e) {
        String lsiName;
        try {
            lsiName = lsi.getName();
        }
        catch (Throwable e2) {
            lsiName = lsi.toString();
        }
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageFailedToRetrieveRepository.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), lsiName, lsi.getClass().getName(), e);
    }

    private MessageFormatter getErrorMessageNoLogicalServer(DataSourceTable dsTable, String serverSchemaTableName, SoftwareServer softwareServer) {
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNoLogicalServer.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), softwareServer.getLabel(), softwareServer.getClass().getName());
    }

    private MessageFormatter getErrorMessageNonSoftwareServer(DataSourceTable dsTable, Server server, String serverSchemaTableName) {
        return IQMetadataResourceBundle.getMessageFormatter("OMATableExtensionBroker.ErrorMessageNonSoftwareServer.fmt.txt", serverSchemaTableName, dsTable, dsTable.getIntraModelID(), dsTable.getClass().getName(), server.getLabel(), server.getClass().getName());
    }
}

