/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.DataSecurityFactoryInterface;
import com.sas.iquery.metadata.business.impl.DataSecurityInterface;
import com.sas.iquery.metadata.business.impl.security.BrokerTypes;
import com.sas.iquery.metadata.impl.SessionContextDependentCache;
import com.sas.iquery.metadata.impl.SessionContextDependentCacheException;
import com.sas.services.session.SessionContextInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSecurityFactory
implements DataSecurityFactoryInterface {
    static DataSecurityFactoryInterface _instance = new DataSecurityFactory();
    private static final SessionContextDependentCache _cachedSessionObjects = SessionContextDependentCache.getNewInstance();
    private static final Logger _logger = LogManager.getLogger(DataSecurityFactory.class);

    public static DataSecurityFactoryInterface getInstance() {
        return _instance;
    }

    @Override
    public synchronized DataSecurityInterface newBroker(SessionContextInterface session) throws MetadataException {
        DataSecurityInterface cachedBroker = this.getCachedSecurityBroker(session);
        if (cachedBroker != null) {
            return cachedBroker;
        }
        _logger.debug("Minting new broker");
        DataSecurityInterface broker = null;
        boolean disableHcm = IQSystemProperties.isBooleanPropertyEnabled("IQ.DISABLEHCM");
        if (!disableHcm) {
            broker = BrokerTypes.HCM_SOLUTION_EVENT_BROKER.newDataSecurityBroker(session);
        }
        if (broker == null) {
            broker = BrokerTypes.OMA_TABLE_EXTENSION_BROKER.newDataSecurityBroker(session);
        }
        if (broker == null) {
            broker = BrokerTypes.ERROR_LOADING_BROKER_INFO.newDataSecurityBroker(session);
        }
        if (broker != null) {
            this.putCachedSecurityBroker(session, broker);
        }
        return broker;
    }

    private DataSecurityInterface getCachedSecurityBroker(SessionContextInterface session) {
        String cacheKey = DataSecurityInterface.class.getName();
        DataSecurityInterface cachedBroker = (DataSecurityInterface)_cachedSessionObjects.get(session, cacheKey);
        if (_logger.isDebugEnabled()) {
            _logger.debug("using session key=" + session);
            _logger.debug("    and cache key=" + cacheKey);
            _logger.debug("cached broker=" + cachedBroker);
        }
        return cachedBroker;
    }

    private synchronized void putCachedSecurityBroker(SessionContextInterface session, DataSecurityInterface broker) {
        String cacheKey = DataSecurityInterface.class.getName();
        if (_logger.isDebugEnabled()) {
            _logger.debug("In putCachedSecurityBroker() ");
            _logger.debug("using session key=" + session);
            _logger.debug("    and cache key=" + cacheKey);
            _logger.debug("caching broker=" + broker);
        }
        try {
            SessionContextDependentCache.SessionContextEndListener listener = new SessionContextDependentCache.SessionContextEndListener(){

                @Override
                public void sessionEnd(SessionContextInterface session) {
                    _logger.debug("In SessionContextEndListener sessionEnd ");
                    try {
                        _logger.debug("Removed the CachedSessionEndListener and its CachedValueObject.");
                        _cachedSessionObjects.removeSessionContextEndListener(session, this, true);
                    }
                    catch (IllegalStateException e) {
                        _logger.debug("Error while destroying session.getUserContext() ", (Throwable)e);
                    }
                }
            };
            _cachedSessionObjects.put(session, cacheKey, broker, listener);
        }
        catch (SessionContextDependentCacheException e) {
            _logger.debug("could not cache Security Broker", (Throwable)e);
        }
    }
}

