/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.util.XMLUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseEventMessage {
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String XML_PROCESS = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    public static final String ELEMENT_ROOT = "Root";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String CDATA_BEGIN = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String EMPTY_ELEMENT = "";
    private static final Logger _logger = LogManager.getLogger(BaseEventMessage.class);

    public BaseEventMessage() {
    }

    public BaseEventMessage(String message) throws MetadataException {
        DocumentFragment docfrag = this.getMessageAsDocumentFragment(message);
        this.create(docfrag);
    }

    public abstract String toString();

    protected abstract void create(DocumentFragment var1) throws MetadataException;

    public DocumentFragment getMessageAsDocumentFragment(Object message) throws MetadataException {
        DocumentFragment documentFragment = null;
        _logger.debug("Creating DocumentFragment from passed in message.");
        if (message instanceof DocumentFragment) {
            documentFragment = (DocumentFragment)message;
        } else if (message instanceof String) {
            String body = (String)message;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Initial body is: " + body);
            }
            Document doc = null;
            try {
                StringBuffer buffer = new StringBuffer();
                int index = body.indexOf("?>");
                if (index != -1) {
                    buffer.append(body.substring(0, index + 2));
                    buffer.append("<Root>");
                    buffer.append(body.substring(index + 2));
                    buffer.append("</Root>");
                } else {
                    buffer.append("<Root>");
                    buffer.append(body);
                    buffer.append("</Root>");
                }
                body = buffer.toString();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("2nd Body is " + body);
                }
                doc = XMLUtil.convertStringToDocument((String)body);
                documentFragment = doc.createDocumentFragment();
                Element root = doc.getDocumentElement();
                Node cloned = root.cloneNode(true);
                NodeList nodeList = root.getChildNodes();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("nodeList: " + nodeList);
                }
                int listLength = nodeList.getLength();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("listLength: " + listLength);
                }
                Vector<Node> nodes = new Vector<Node>();
                for (int i = 0; i < listLength; ++i) {
                    Node node = nodeList.item(i);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Node name: " + node.getNodeName());
                    }
                    if (node == null || node.getNodeType() != 1 && node.getNodeType() != 3) continue;
                    nodes.add(node);
                }
                while (cloned.hasChildNodes()) {
                    documentFragment.appendChild(cloned.removeChild(cloned.getFirstChild()));
                }
                for (Node node : nodes) {
                    documentFragment.appendChild(node.getFirstChild());
                }
            }
            catch (Throwable t) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("BaseEventMessage.cannot.parse.string.exception.fmt.txt", this.getClass().getName());
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(msg.toString(), t);
                }
                throw new MetadataException(msg, t);
            }
        }
        return documentFragment;
    }

    protected String encode(String itemToEncode) {
        if (itemToEncode == null) {
            return EMPTY_ELEMENT;
        }
        try {
            return URLEncoder.encode(itemToEncode, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn(uee.getLocalizedMessage(), (Throwable)uee);
            }
            return itemToEncode;
        }
    }

    protected String decode(String value) {
        block2: {
            try {
                value = URLDecoder.decode(value, UTF8_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                if (!_logger.isEnabled(Level.WARN)) break block2;
                _logger.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected String wrapCDATA(String item) {
        StringBuffer sb = new StringBuffer();
        sb.append(CDATA_BEGIN);
        sb.append(item);
        sb.append(CDATA_END);
        return sb.toString();
    }
}

