/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.IntegratedObjectHandlerAdapter;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.RelatedObjectList;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.UnsynchronizedStack;
import com.sas.iquery.metadata.business.impl.XMLV2PeepholeOptimizer;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLV2ModelHandler
extends DefaultHandler {
    private UnsynchronizedStack _elementLocationStack = new UnsynchronizedStack();
    private UnsynchronizedStack _relatedObjectHoldersStack = new UnsynchronizedStack();
    private UnsynchronizedStack _relatedObjectListsStack = new UnsynchronizedStack();
    private boolean _processingObjectOrObjectUseElement = false;
    private boolean _hasOutermostModelElementBeenRead = false;
    private AbstractModel _outermostModel;
    private AbstractBase _objectDoingConsumption = null;
    private boolean _parserIsInterningStrings = false;
    private boolean _insideExternalResourcesElement = false;
    private ReadingContextV2 _currentModelReadingContext;
    private ContentHandler _integratedObjectHandler;
    private IntegratedObjectHandlerAdapter _integratedObjectHandlerAdapter;
    private AttributesProvider _attributesProvider;
    private static final Logger _logger = LogManager.getLogger(XMLV2ModelHandler.class);
    private static final Logger _perfRFDLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.details");
    private UnsynchronizedStack _unusedRelatedObjectListsPool = new UnsynchronizedStack();
    private UnsynchronizedStack _unusedRelatedObjectsHoldersPool = new UnsynchronizedStack();

    public XMLV2ModelHandler(ReadingContextV2 readingContext) {
        this._currentModelReadingContext = readingContext;
        this._attributesProvider = new AttributesProvider(readingContext, 20);
        this._outermostModel = readingContext.getModelBeingRead();
    }

    private void pushModelContext(AbstractModel innerModel) {
        this._currentModelReadingContext = this._currentModelReadingContext.newInnerModelContext(innerModel);
        this._attributesProvider.resetContext(this._currentModelReadingContext);
    }

    private void popModelContext() {
        this._currentModelReadingContext = this._currentModelReadingContext.getOuterModelContext();
        this._attributesProvider.resetContext(this._currentModelReadingContext);
    }

    void setParserIsInterningStrings(boolean isInterningStrings) {
        this._parserIsInterningStrings = isInterningStrings;
        this._attributesProvider.setParserIsInterningStrings(isInterningStrings);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (_perfRFDLogger.isDebugEnabled()) {
            String attrsString = this.attrsDebugString(atts);
            ExtraLoggingContexts.debugLogReadFlowDetails(">> startElement(): qName=" + qName + ", uri=" + namespaceURI + ", localName=" + localName + ", attributes=" + attrsString);
        }
        String elementName = qName;
        this._elementLocationStack.push(elementName);
        if (this._integratedObjectHandler == null) {
            if (this._processingObjectOrObjectUseElement) {
                this.handleNewRelationshipElement(elementName, atts);
            } else {
                this._attributesProvider.reinitializeForConsumptionOfAttributes(atts);
                if (!this._hasOutermostModelElementBeenRead) {
                    this.handleOutermostModelElement();
                    this._hasOutermostModelElementBeenRead = true;
                } else {
                    AbstractBase obj = null;
                    boolean useElement = elementName.endsWith("Use");
                    obj = useElement ? this.handleNewObjectUseElement(elementName) : this.handleNewObjectElement(elementName);
                    if (obj != null) {
                        RelatedObjectList referencedItems = (RelatedObjectList)this._relatedObjectListsStack.peek();
                        referencedItems.add(obj);
                    } else {
                        boolean recognizedAsIntegratedObject = this.setupIntegratedObjectHandling(elementName);
                        if (!recognizedAsIntegratedObject) {
                            this.reportUnrecognizedXMLElementName(elementName);
                            if (useElement) {
                                this.handleUnrecognizedObjectUseElement(elementName);
                            } else {
                                this.handleUnrecognizedObjectElement(elementName);
                            }
                        }
                    }
                }
            }
        }
        if (this._integratedObjectHandler != null) {
            ExtraLoggingContexts.debugLogReadFlowDetails("      passing startElement info onto an integrated object handler.");
            this._integratedObjectHandler.startElement(namespaceURI, localName, qName, atts);
        } else {
            this._processingObjectOrObjectUseElement = !this._processingObjectOrObjectUseElement;
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<< startElement");
    }

    private boolean setupIntegratedObjectHandling(String elementName) throws SAXException {
        IntegratedObjectHandlerAdapter adapter = IntegratedObjectHandlerAdapter.newAdapterForElement(elementName, this._currentModelReadingContext);
        if (adapter != null) {
            RelatedObjectList relatedObjectsList = (RelatedObjectList)this._relatedObjectListsStack.peek();
            relatedObjectsList.add(adapter);
            this._integratedObjectHandler = adapter.getContentHandler();
            this._integratedObjectHandlerAdapter = adapter;
        }
        return adapter != null;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (_perfRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails(">> endElement(): qName=" + qName + ", uri=" + namespaceURI + ", localName=" + localName);
        }
        if (this._integratedObjectHandler != null) {
            ExtraLoggingContexts.debugLogReadFlowDetails("      passing endElement info onto foreign handler.");
            this._integratedObjectHandler.endElement(namespaceURI, localName, qName);
            if (this._integratedObjectHandlerAdapter.isDone()) {
                ExtraLoggingContexts.debugLogReadFlowDetails(">>    end using foreign XML handler.");
                this._integratedObjectHandler = null;
                this._integratedObjectHandlerAdapter = null;
            }
        } else {
            String elementName = qName;
            if (this._processingObjectOrObjectUseElement) {
                if (!elementName.endsWith("Use")) {
                    this.handleEndObjectElement();
                }
            } else {
                this.handleEndRelationshipElement(elementName);
            }
            this._processingObjectOrObjectUseElement = !this._processingObjectOrObjectUseElement;
        }
        this._elementLocationStack.removeTOS();
        ExtraLoggingContexts.debugLogReadFlowDetails("<< endElement");
    }

    private void handleNewRelationshipElement(String elementName, Attributes attrs) throws SAXException {
        if (_perfRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails(">>    handleNewRelationshipElement():  elementName=" + elementName);
        }
        RelatedObjectList acquired = this.acquireRelatedObjectList(elementName);
        this._relatedObjectListsStack.push(acquired);
        if (attrs.getLength() > 0) {
            String attrName = attrs.getQName(0);
            this.reportUnrecognizedXMLAttrName(attrName);
        }
        if (!this._insideExternalResourcesElement && this.elementNamesEqual(elementName, "ExternalResources")) {
            this._insideExternalResourcesElement = true;
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<    handleNewRelationshipElement");
    }

    private void handleOutermostModelElement() throws SAXException {
        ExtraLoggingContexts.debugLogReadFlowDetails(">>    handleOutermostModelElement()");
        String persistenceID = this._attributesProvider.consumeAttr("obj");
        this._currentModelReadingContext.notePersistenceIDOfModelBeingRead(this._outermostModel, persistenceID);
        ModelVersion version = this._attributesProvider.consumeVersion("ver");
        this._outermostModel.consumeModelVersion(version);
        this.processInternalObject(this._outermostModel);
        ExtraLoggingContexts.debugLogReadFlowDetails("<<    handleOutermostModelElement");
    }

    private AbstractBase handleNewObjectElement(String elementName) throws SAXException {
        String persistenceID;
        AbstractBase obj;
        if (_perfRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails(">>    handleNewObjectElement(): elementName=" + elementName);
        }
        if ((obj = this._currentModelReadingContext.getObjectForNewObjectElement(persistenceID = this._attributesProvider.consumeAttr("obj"), elementName)) != null) {
            if (this._insideExternalResourcesElement) {
                this.processExternalResourceObject(obj);
            } else {
                if (obj instanceof AbstractModel) {
                    AbstractModel model = (AbstractModel)obj;
                    this.pushModelContext(model);
                    model.setSession(this._outermostModel.getSession());
                    model.setService(this._outermostModel.getService());
                }
                this.processInternalObject(obj);
            }
        } else if (persistenceID != null) {
            this._attributesProvider.replenishAttr("obj");
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<    handleNewObjectElement");
        return obj;
    }

    private void handleUnrecognizedObjectElement(String elementName) throws SAXException {
        if (_perfRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails(">>    handleUnrecognizedObjectElement(): elementName=" + elementName);
        }
        String persistenceID = this._attributesProvider.consumeAttr("obj");
        AbstractModelItem unrecognizedObject = this._currentModelReadingContext.newUnrecognizedItem(persistenceID);
        this.acquireAndPushRelatedItemsHolder(unrecognizedObject, null);
        ExtraLoggingContexts.debugLogReadFlowDetails("<<    handleUnrecognizedObjectElement");
    }

    private void processExternalResourceObject(AbstractBase obj) throws SAXException {
        RelatedObjectList[] rolsFromAttrs = this.consumeExternalResourceObjectAttrs(obj);
        this.acquireAndPushRelatedItemsHolder(obj, rolsFromAttrs);
    }

    private void processInternalObject(AbstractBase obj) throws SAXException {
        RelatedObjectList[] rolsFromAttrs = null;
        if (this._attributesProvider.hasAttrsRemainingToBeConsumed()) {
            rolsFromAttrs = this.consumeAttrsCheckingForFullConsumption(obj);
        }
        this.acquireAndPushRelatedItemsHolder(obj, rolsFromAttrs);
    }

    private AbstractBase handleNewObjectUseElement(String useElementName) throws SAXException {
        int lsize;
        String useOfType;
        AbstractBase out;
        String persistenceID;
        if (_perfRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails(">>    handleNewObjectUseElement(): elementName=" + useElementName);
        }
        if ((persistenceID = this._attributesProvider.consumeAttr("ref")) == null) {
            String msg = IQMetadataResourceBundle.getMessageString("XMLV2ModelHandler.MissingAttributeOnElement.fmt.txt", "ref", useElementName);
            throw new SAXException(msg);
        }
        String attrName = this._attributesProvider.getFirstUnconsumedAttrName();
        if (attrName != null) {
            this.reportUnrecognizedXMLAttrName(attrName);
        }
        if ((out = this._currentModelReadingContext.getObjectForUsedObjectElement(useOfType = useElementName.substring(0, (lsize = useElementName.length()) - 3), persistenceID, false)) == null) {
            this._attributesProvider.replenishAttr("ref");
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<    handleNewObjectUseElement");
        return out;
    }

    private void handleUnrecognizedObjectUseElement(String useElementName) throws SAXException {
        String persistenceID;
        if (_perfRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails(">>    handleUnrecognizedObjectUseElement(): elementName=" + useElementName);
        }
        if ((persistenceID = this._attributesProvider.consumeAttr("ref")) == null) {
            String msg = IQMetadataResourceBundle.getMessageString("XMLV2ModelHandler.MissingAttributeOnElement.fmt.txt", "ref", useElementName);
            throw new SAXException(msg);
        }
        int lsize = useElementName.length();
        String useOfType = useElementName.substring(0, lsize - 3);
        this._currentModelReadingContext.getObjectForUsedObjectElement(useOfType, persistenceID, true);
        ExtraLoggingContexts.debugLogReadFlowDetails("<<    handleUnrecognizedObjectUseElement");
    }

    private RelatedObjectList[] consumeAttrsCheckingForFullConsumption(AbstractBase obj) throws SAXException {
        RelatedObjectList[] rolsFromAttrs = null;
        this._objectDoingConsumption = obj;
        obj.consumeAttributes(this._attributesProvider);
        if (this._attributesProvider.hasAttrsRemainingToBeConsumed()) {
            rolsFromAttrs = this.consumeRefNAttrs();
        }
        this._objectDoingConsumption = null;
        String unconsumedAttrName = this._attributesProvider.getFirstUnconsumedAttrName();
        if (unconsumedAttrName != null) {
            this.reportUnrecognizedXMLAttrName(unconsumedAttrName);
        }
        return rolsFromAttrs;
    }

    private RelatedObjectList[] consumeExternalResourceObjectAttrs(AbstractBase obj) throws SAXException {
        this._objectDoingConsumption = obj;
        obj.consumeExternalReferenceAttributes(this._attributesProvider);
        RelatedObjectList[] rolsFromAttrs = null;
        if (this._attributesProvider.hasAttrsRemainingToBeConsumed()) {
            rolsFromAttrs = this.consumeRefNAttrs();
        }
        this._objectDoingConsumption = null;
        String unconsumedAttrName = this._attributesProvider.getFirstUnconsumedAttrName();
        if (unconsumedAttrName != null) {
            this.reportUnrecognizedXMLAttrName(unconsumedAttrName);
        }
        return rolsFromAttrs;
    }

    private RelatedObjectList[] consumeRefNAttrs() throws SAXException {
        int i;
        RelatedObjectList[] out = null;
        String[] values = this._attributesProvider.consumeUnorderedPrefixNAttrs("ref");
        int nonNullValueCount = 0;
        for (i = 0; i < values.length && values[i] != null; ++i) {
            ++nonNullValueCount;
        }
        if (nonNullValueCount > 0) {
            out = new RelatedObjectList[nonNullValueCount];
            for (i = 0; i < nonNullValueCount; ++i) {
                String refnValue = values[i];
                if (refnValue == null) continue;
                int endRelationshipNameIndex = refnValue.indexOf(XMLV2PeepholeOptimizer.POST_RELATIONSHIP_CHAR);
                if (endRelationshipNameIndex != -1) {
                    RelatedObjectList rol;
                    String relationshipName = refnValue.substring(0, endRelationshipNameIndex);
                    relationshipName = relationshipName.intern();
                    out[i] = rol = this.acquireRelatedObjectList(relationshipName);
                    String runningType = "";
                    StringTokenizer st = new StringTokenizer(refnValue.substring(endRelationshipNameIndex + 1), ",;");
                    while (st.hasMoreTokens()) {
                        String persistenceID;
                        String oneObjRef = st.nextToken();
                        int split = oneObjRef.indexOf(58);
                        if (split != -1) {
                            runningType = oneObjRef.substring(0, split);
                            persistenceID = oneObjRef.substring(split + 1);
                        } else {
                            persistenceID = oneObjRef;
                        }
                        AbstractBase refdObj = this._currentModelReadingContext.getObjectForUsedObjectElement(runningType, persistenceID, true);
                        rol.add(refdObj);
                    }
                    continue;
                }
                String attrName = "ref" + (i + 1);
                this.reportUnrecognizedXMLAttrValue(attrName, refnValue);
            }
        }
        return out;
    }

    private void handleEndObjectElement() throws SAXException {
        ExtraLoggingContexts.debugLogReadFlowDetails(">>    handleEndObjectElement()");
        RelatedObjectListsHolder riHolder = (RelatedObjectListsHolder)this._relatedObjectHoldersStack.pop();
        AbstractBase objectWhoseDefinitionHasEnded = riHolder.getObject();
        if (riHolder.hasRelatedObjectsToBeConsumed() || objectWhoseDefinitionHasEnded.mustCallConsumeRelatedObjects()) {
            this.consumeRelatedObjectsCheckingForFullConsumption(objectWhoseDefinitionHasEnded, riHolder);
        }
        this.rePoolUnusedHolder(riHolder);
        if (!this._insideExternalResourcesElement && objectWhoseDefinitionHasEnded instanceof AbstractModel) {
            this._currentModelReadingContext.verifyNoForwardReferencesRemaining();
            if (objectWhoseDefinitionHasEnded != this._outermostModel) {
                this.popModelContext();
            }
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<    handleEndObjectElement");
    }

    private void consumeRelatedObjectsCheckingForFullConsumption(AbstractBase objectWhoseDefinitionHasEnded, RelatedObjectListsHolder rolsHolder) throws SAXException {
        this._objectDoingConsumption = objectWhoseDefinitionHasEnded;
        if (this._insideExternalResourcesElement) {
            objectWhoseDefinitionHasEnded.consumeExternalReferenceRelatedItems(rolsHolder);
        } else {
            objectWhoseDefinitionHasEnded.consumeRelatedObjects(rolsHolder);
        }
        this._objectDoingConsumption = null;
        String unconsumedRelationshipName = rolsHolder.getFirstUnconsumedRelationshipName();
        if (unconsumedRelationshipName != null) {
            this.reportUnrecognizedXMLElementName(unconsumedRelationshipName);
        }
    }

    private void handleEndRelationshipElement(String elementName) throws SAXException {
        if (_perfRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails(">>    handleEndRelationshipElement():  elementName=" + elementName);
        }
        RelatedObjectList rol = (RelatedObjectList)this._relatedObjectListsStack.pop();
        RelatedObjectListsHolder rolsHolder = (RelatedObjectListsHolder)this._relatedObjectHoldersStack.peek();
        if (this._insideExternalResourcesElement && this.elementNamesEqual(elementName, "ExternalResources")) {
            List<Object> objs = rol.getObjects();
            this._currentModelReadingContext.reportUnresolvedExternalResources(objs);
            this._insideExternalResourcesElement = false;
        } else if (this.elementNamesEqual(elementName, "ExternalAssociatedPrompts")) {
            List<Object> objs = rol.getObjects();
            this._currentModelReadingContext.reportExternalAssociatedPromptsReferenced(objs);
        } else {
            rolsHolder.add(rol);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<    handleEndRelationshipElement");
    }

    private boolean elementNamesEqual(String elementName1, String elementName2) {
        return elementName1 == elementName2 || !this._parserIsInterningStrings && elementName1.equals(elementName2);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (_perfRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails(">> characters(): chars=\"" + new String(ch, start, length) + "\"");
        }
        if (this._integratedObjectHandler != null) {
            ExtraLoggingContexts.debugLogReadFlowDetails("      passing characters() info onto foreign handler.");
            this._integratedObjectHandler.characters(ch, start, length);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<< characters");
    }

    private RelatedObjectList acquireRelatedObjectList(String relationshipName) {
        RelatedObjectList acquired = null;
        if (this._unusedRelatedObjectListsPool.size() > 0) {
            acquired = (RelatedObjectList)this._unusedRelatedObjectListsPool.pop();
            acquired.reinitialize(relationshipName);
        } else {
            acquired = new RelatedObjectList(relationshipName);
        }
        return acquired;
    }

    private void acquireAndPushRelatedItemsHolder(AbstractBase objWhoseDefinitionIsBeingRead, RelatedObjectList[] rilsToStartWith) throws SAXException {
        RelatedObjectListsHolder acquired = null;
        if (this._unusedRelatedObjectsHoldersPool.size() > 0) {
            acquired = (RelatedObjectListsHolder)this._unusedRelatedObjectsHoldersPool.pop();
            acquired.reinitialize(objWhoseDefinitionIsBeingRead, rilsToStartWith);
        } else {
            acquired = new RelatedObjectListsHolder(objWhoseDefinitionIsBeingRead, this._currentModelReadingContext, this._parserIsInterningStrings, rilsToStartWith);
        }
        this._relatedObjectHoldersStack.push(acquired);
    }

    private void rePoolUnusedHolder(RelatedObjectListsHolder rolHolder) {
        int count = rolHolder.getRelationshipsCount();
        if (count > 0) {
            RelatedObjectList[] rols = rolHolder.trustedGetROLsStorage();
            for (int i = 0; i < count; ++i) {
                this._unusedRelatedObjectListsPool.push(rols[i]);
            }
        }
        this._unusedRelatedObjectsHoldersPool.push(rolHolder);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (_logger.isEnabled(Level.WARN)) {
            String msg = IQMetadataResourceBundle.getMessageString("XMLV2ModelHandler.WarningReceivedFromParser.fmt.txt", this.getElementLocation());
            _logger.warn(msg, (Throwable)e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (_logger.isEnabled(Level.ERROR)) {
            String msg = IQMetadataResourceBundle.getMessageString("XMLV2ModelHandler.ErrorReceivedFromParser.fmt.txt", this.getElementLocation());
            _logger.error(msg, (Throwable)e);
        }
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (_logger.isEnabled(Level.ERROR)) {
            String msg = IQMetadataResourceBundle.getMessageString("XMLV2ModelHandler.FatalErrorReceivedFromParser.fmt.txt", this.getElementLocation());
            _logger.error(msg, (Throwable)e);
        }
        super.fatalError(e);
    }

    public String getElementLocation() {
        int elementCount = this._elementLocationStack.size();
        StringBuffer buf = new StringBuffer(elementCount * 22);
        for (int i = 0; i < elementCount; ++i) {
            buf.append('<');
            buf.append(this._elementLocationStack.get(i).toString());
            buf.append('>');
        }
        return buf.toString();
    }

    public AbstractBase getObjectDoingConsumption() {
        return this._objectDoingConsumption;
    }

    private String attrsDebugString(Attributes attrs) {
        StringBuffer buf = new StringBuffer(1000);
        int count = attrs.getLength();
        for (int i = 0; i < count; ++i) {
            String attrName = attrs.getQName(i);
            String attrValue = attrs.getValue(i);
            buf.append(attrName);
            buf.append('=');
            buf.append(attrValue);
            if (i == count - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    private void reportUnrecognizedXMLElementName(String elementName) throws SAXException {
        this.unrecognizedXML("XMLV2ModelHandler.UnrecognizedElementName.fmt.txt", new Object[]{elementName}, false);
    }

    private void reportUnrecognizedXMLAttrName(String attrName) throws SAXException {
        this.unrecognizedXML("XMLV2ModelHandler.UnrecognizedAttrName.fmt.txt", new Object[]{attrName}, false);
    }

    private void reportUnrecognizedXMLAttrValue(String attrName, String attrValue) throws SAXException {
        this.unrecognizedXML("XMLV2ModelHandler.UnrecognizedAttrValue.fmt.txt", new Object[]{attrName, attrValue}, true);
    }

    private void unrecognizedXML(String msgKey, Object[] args, boolean error) throws SAXException {
        String msg = IQMetadataResourceBundle.getMessageString(msgKey, args);
        if (error) {
            throw new SAXException(msg);
        }
        if (_logger.isEnabled(Level.WARN)) {
            _logger.warn(msg);
            msg = IQMetadataResourceBundle.getMessageString("XMLV2ModelHandler.XMLLocation.fmt.txt", this.getElementLocation());
            _logger.warn(msg);
        }
    }
}

