/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItemWithIdentity;
import com.sas.iquery.metadata.business.impl.AbstractModelReference;
import com.sas.iquery.metadata.business.impl.AbstractModelRepositoryResource;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.LookThroughDataSelectionImpl;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.OMRTemplates;
import com.sas.iquery.metadata.business.impl.QualifiedColumnImpl;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.StructuredExternalResources;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.JFSResourceFactory;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.physical.inmemory.InMemoryQueryTable;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMember;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.metadata.physical.oma.OMADimension;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.iquery.metadata.physical.oma.OMANamedSet;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMAQualifiedLevel;
import com.sas.iquery.metadata.physical.oma.OMASASLibrary;
import com.sas.iquery.metadata.physical.oma.OMASASOlapServer;
import com.sas.iquery.metadata.physical.oma.OMASASWorkspaceServer;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.strategies.combined.DataSelectionWithEmbedded;
import com.sas.iquery.strategies.combined.LookThroughDataSelectionWithEmbedded;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CalculatedMember;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.NamedSet;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class V2ResourceResolver
implements Runnable {
    private AbstractModel _model;
    private SessionContextInterface _session;
    private StructuredExternalResources _structuredUnresolvedResources;
    private IdentityHashMap _unresolvedToBoundResourceMapping = new IdentityHashMap();
    private IdentityList _resourcesNotResolvedYet = new IdentityList();
    private IdentityHashMap _jomaAssociationsMap = new IdentityHashMap();
    private Exception _exceptionCaught;
    private boolean _done = false;
    private boolean _doResolve = true;
    private ReadingContextV2 _readingContext;
    private List<AssociationList> _filteredAssociationLists = new ArrayList<AssociationList>();
    private static final Logger _logger = LogManager.getLogger(V2ResourceResolver.class);
    private static final Logger _perfRFSLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.summary");
    private static final Logger _perfRFDLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.details");

    V2ResourceResolver(StructuredExternalResources extResources, ReadingContextV2 readingContext) {
        this._readingContext = readingContext;
        this._model = readingContext.getModelBeingRead();
        this._session = this._model.getSession();
        this._structuredUnresolvedResources = extResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExtraLoggingContexts.debugLogReadFlowSummary("V2ResourceResolver starting resolution of external resources");
        try {
            this.resolveResources();
        }
        catch (Exception e) {
            this._exceptionCaught = e;
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("before notifying starter thread");
        V2ResourceResolver v2ResourceResolver = this;
        synchronized (v2ResourceResolver) {
            this._done = true;
            this.notify();
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("after  notifying starter thread");
        ExtraLoggingContexts.debugLogReadFlowSummary("V2ResourceResolver done");
    }

    boolean isDone() {
        return this._done;
    }

    Exception getExceptionWhileRunning() {
        return this._exceptionCaught;
    }

    private void resolveResources() throws SAXException {
        try {
            ExtraLoggingContexts.debugLogReadFlowDetails("start external resource resolution");
            this.locateAndBindExternalModels();
            this.locateAndBindExternalModelItems();
            this.locateAndBindMetadataRepositoryResources();
            ExtraLoggingContexts.debugLogReadFlowDetails("end  external resource resolution");
        }
        catch (MetadataException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
        catch (RemoteException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
        catch (ServiceException e) {
            SAXException se = new SAXException((Exception)((Object)e));
            se.initCause(e);
            throw se;
        }
        catch (MdException e) {
            SAXException se = new SAXException((Exception)((Object)e));
            se.initCause(e);
            throw se;
        }
        catch (DataServicesException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
    }

    public IdentityHashMap trustedGetResourceMapping() {
        return this._unresolvedToBoundResourceMapping;
    }

    public List getResourcesNotResolved() {
        return this._resourcesNotResolvedYet.toList();
    }

    private void locateAndBindExternalModels() throws MetadataException {
        List unresolvedModels = this._structuredUnresolvedResources.getModelResources();
        this._resourcesNotResolvedYet.addAll(unresolvedModels);
        int size = unresolvedModels.size();
        for (int i = 0; i < size; ++i) {
            AbstractModel unresolvedModel = (AbstractModel)unresolvedModels.get(i);
            this.resolveModel(unresolvedModel);
        }
    }

    private void resolveModel(AbstractModel unresolvedModel) throws MetadataException {
        Map<AbstractModelReference, AbstractModel> enclosingModelsMap = this._readingContext.getEnclosingModelsMap();
        Map<BusinessModelReferenceInfo, AbstractModel> mapOfModelsToReuseFromAPIUser = this._readingContext.getModelsToReuse();
        AbstractModelReference modelRef = unresolvedModel.getModelReference();
        AbstractModel boundModel = this.findModelInMap(modelRef, enclosingModelsMap, unresolvedModel);
        if (boundModel == null) {
            boundModel = this.findModelInMap(modelRef, mapOfModelsToReuseFromAPIUser, unresolvedModel);
        }
        if (boundModel == null) {
            String modelPersistentAbsolutePathLocation = unresolvedModel.getLocationWhenUnresolved();
            if (modelPersistentAbsolutePathLocation == null) {
                String unresolvedModelID = unresolvedModel.getID();
                String modelIDBeingRead = this._model.getID();
                String idsOfAvailableModels = AbstractModelReference.commaSeparatedListOfIDs(mapOfModelsToReuseFromAPIUser.keySet().toArray(new AbstractModelReference[mapOfModelsToReuseFromAPIUser.size()]));
                Object[] msgArgs = new Object[]{unresolvedModelID, modelIDBeingRead, idsOfAvailableModels};
                MessageFormatter msg = unresolvedModel instanceof InformationMap ? IQMetadataResourceBundle.getMessageFormatter("V2ResourceResolver.MissingInfoMap.fmt.txt", msgArgs) : IQMetadataResourceBundle.getMessageFormatter("V2ResourceResolver.MissingQuery.fmt.txt", msgArgs);
                throw new MetadataException(msg);
            }
            boundModel = this._readingContext.getResolvedModel(modelPersistentAbsolutePathLocation);
            if (boundModel == null) {
                block11: {
                    if (unresolvedModel instanceof InformationMap) {
                        InformationMapFactory factory = InformationMapFactory.getInstance();
                        try {
                            MetadataInterface mi = IQModelImplUtilities.absolutePathToMetadataInterface(this._session, modelPersistentAbsolutePathLocation, (ServerInterface)this._readingContext.getMetadataServer(), true);
                            if (!(mi instanceof BriefInformationMap)) {
                                Object[] args = new Object[]{modelPersistentAbsolutePathLocation};
                                MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("V2ResourceResolver.NonInformationMapFoundAtPath.fmt.txt", args);
                                throw new MetadataException(mf);
                            }
                            boundModel = (AbstractModel)((Object)factory.newInformationMap(this._session, this._model.getService(), (BriefInformationMap)mi));
                        }
                        catch (MetadataException e) {
                            boolean useUnresolvedModel = false;
                            if (System.getProperty("SASQueryServices.AllowInnerIQModelsToReferToIQModelsInBITrees") != null && (e.hasReasonWithCodes(9, 216) || e.hasReasonWithCodes(9, 215) || e.hasReasonWithCodes(9, 217))) {
                                useUnresolvedModel = true;
                            }
                            if (useUnresolvedModel) break block11;
                            throw e;
                        }
                    }
                }
                if (boundModel != null) {
                    boundModel.markContainerAndContentsNeverChangeable();
                    this._readingContext.addResolvedModel(boundModel, modelPersistentAbsolutePathLocation);
                }
            }
        }
        if (boundModel == null) {
            boundModel = unresolvedModel;
        }
        this.noteBinding(unresolvedModel, boundModel);
    }

    private AbstractModel findModelInMap(AbstractModelReference modelRef, Map mapOfModelsToUse, AbstractModel unresolvedModel) throws MetadataException {
        AbstractModel model = (AbstractModel)mapOfModelsToUse.get(modelRef);
        if (model != null) {
            model = this.validateModelType(unresolvedModel, model);
        }
        return model;
    }

    private AbstractModel validateModelType(AbstractModel unresolvedModel, AbstractModel proposedBoundModel) throws MetadataException {
        String unresolvedModelClassName = unresolvedModel.getClass().toString();
        String proposedBoundModelClassName = proposedBoundModel.getClass().toString();
        if (!proposedBoundModelClassName.equals(unresolvedModelClassName)) {
            if (unresolvedModel instanceof DataSelectionImpl && proposedBoundModel instanceof DataSelectionWithEmbedded || unresolvedModel instanceof LookThroughDataSelectionImpl && proposedBoundModel instanceof LookThroughDataSelectionWithEmbedded) {
                ExtraLoggingContexts.debugLogReadFlowSummary("Allowing to resolve a regular DataSelection or LTDS to a DataSelectionWithEmbedded or LTDSWE.");
            } else {
                proposedBoundModel = null;
                ExtraLoggingContexts.debugLogReadFlowSummary("Cannot bind an unresolved " + unresolvedModelClassName + " to a " + proposedBoundModelClassName + " type");
            }
        }
        return proposedBoundModel;
    }

    private void locateAndBindExternalModelItems() throws MetadataException {
        List unresolvedModels = this._structuredUnresolvedResources.getModelResources();
        int modelsCount = unresolvedModels.size();
        for (int i = 0; i < modelsCount; ++i) {
            AbstractModel unresolvedModel = (AbstractModel)unresolvedModels.get(i);
            AbstractModel boundModel = this.getBoundModel(unresolvedModel);
            List unresolvedReferencedItems = this._structuredUnresolvedResources.getModelItemResources(unresolvedModel);
            if (unresolvedReferencedItems == null) continue;
            this._resourcesNotResolvedYet.addAll(unresolvedReferencedItems);
            for (int j = 0; j < unresolvedReferencedItems.size(); ++j) {
                AbstractModelItem unresolvedItem = (AbstractModelItem)unresolvedReferencedItems.get(j);
                AbstractModelItem boundItem = null;
                if (boundModel.isUnresolved()) {
                    boundItem = unresolvedItem;
                    continue;
                }
                boundItem = unresolvedItem instanceof QualifiedColumnImpl ? this.bindQualifiedColumn(boundModel, (QualifiedColumnImpl)unresolvedItem) : this.bindModelItem(boundModel, (AbstractModelItemWithIdentity)unresolvedItem);
                if (boundItem != null) continue;
                boundItem = unresolvedItem;
            }
        }
    }

    private AbstractModel getBoundModel(AbstractModel unresolvedModel) throws MetadataException {
        AbstractModel boundModel = (AbstractModel)this._unresolvedToBoundResourceMapping.get(unresolvedModel);
        if (boundModel == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("UnexpectedCodePathTaken.txt", new Object[0]));
        }
        return boundModel;
    }

    private AbstractModelItemWithIdentity bindModelItem(AbstractModel resolvedModel, AbstractModelItemWithIdentity unresolvedItem) throws MetadataException {
        AbstractModelItemWithIdentity boundItem = (AbstractModelItemWithIdentity)this._unresolvedToBoundResourceMapping.get(unresolvedItem);
        if (boundItem == null) {
            String interModelIdentity = unresolvedItem.getInterModelIdentity();
            String modelIdentity = IQModelImplUtilities.leftOfDot(interModelIdentity);
            String itemIdentity = IQModelImplUtilities.rightOfDot(interModelIdentity);
            AbstractModel model = resolvedModel.findContainerByID(modelIdentity);
            if (model != null) {
                boundItem = model.getContainedItemWithID(itemIdentity);
            }
            if (boundItem == null) {
                boundItem = unresolvedItem;
                if (model != null) {
                    boundItem.setModel(model);
                }
            }
            this.noteBinding(unresolvedItem, boundItem);
        }
        return boundItem;
    }

    private QualifiedColumnImpl bindQualifiedColumn(AbstractModel resolvedModel, QualifiedColumnImpl unresolvedQC) throws MetadataException {
        QualifiedColumnImpl boundQC = null;
        DataSourceTableImpl2 unresolvedDST = (DataSourceTableImpl2)unresolvedQC.getOwningTable();
        DataSourceTableImpl2 boundDST = (DataSourceTableImpl2)this.bindModelItem(resolvedModel, unresolvedDST);
        if (boundDST.isLive()) {
            List<Column> qCols = boundDST.getColumns();
            Iterator<Column> it = qCols.iterator();
            while (it.hasNext() && boundQC == null) {
                QualifiedColumnImpl qci = (QualifiedColumnImpl)it.next();
                if (!IQModelImplUtilities.sameIgnoreCase(qci.getSasName(), unresolvedQC.getSasName()) || !IQModelImplUtilities.sameIgnoreCase(qci.getSasType(), unresolvedQC.getSasType())) continue;
                boundQC = qci;
            }
            if (boundQC == null) {
                unresolvedQC.setOwningTable(boundDST);
                if (_logger.isEnabled(org.apache.logging.log4j.Level.WARN)) {
                    String msgKey = "V2ResourceResolver.FailedToFindNumericQualifiedColumn.fmt.txt";
                    if ("C".equals(unresolvedQC.getSasType())) {
                        msgKey = "V2ResourceResolver.FailedToFindCharacterQualifiedColumn.fmt.txt";
                    }
                    String msg = IQModelImplUtilities.getMessage(msgKey, unresolvedQC.getLabel(), boundDST.getLabel());
                    _logger.warn(msg);
                }
            }
        }
        if (boundQC == null) {
            boundQC = unresolvedQC;
        }
        this.noteBinding(unresolvedQC, boundQC);
        return boundQC;
    }

    private void locateAndBindMetadataRepositoryResources() throws MetadataException, RemoteException, ServiceException, MdException, DataServicesException {
        List unresolvedReposResources = this._structuredUnresolvedResources.getMetadataRepositoryResources();
        if (unresolvedReposResources.size() > 0) {
            this._resourcesNotResolvedYet.addAll(unresolvedReposResources);
            AvailableReposResources topLevelReposResources = null;
            List omrTopLevelResourcesFound = this.runQueriesToGetOmrObjects(unresolvedReposResources);
            topLevelReposResources = new AvailableReposResources(omrTopLevelResourcesFound);
            this.bindReposResources(unresolvedReposResources, topLevelReposResources);
            this.clearFilteredAssociationLists();
        }
    }

    private void noteBinding(AbstractBase unresolvedObject, AbstractBase boundObject) {
        this._unresolvedToBoundResourceMapping.put(unresolvedObject, boundObject);
        if (unresolvedObject != boundObject) {
            this._resourcesNotResolvedYet.remove(unresolvedObject);
        }
    }

    private void bindReposResources(List<MetadataRepositoryResource> unresolvedReposResources, AvailableReposResources topLevelReposResources) throws RemoteException, ServiceException, MetadataException, MdException, DataServicesException {
        ExtraLoggingContexts.debugLogReadFlowDetails("start binding OMR resources for a root model");
        int size = unresolvedReposResources.size();
        for (int i = 0; i < size; ++i) {
            MetadataRepositoryResource resource = unresolvedReposResources.get(i);
            if (this._unresolvedToBoundResourceMapping.containsKey(resource)) continue;
            AbstractModelRepositoryResource boundResource = null;
            if (resource instanceof OMAColumn) {
                boundResource = this.bindColumn((OMAColumn)resource, topLevelReposResources);
            } else if (resource instanceof OMATable) {
                boundResource = this.bindTable((OMATable)resource, topLevelReposResources);
            } else if (resource instanceof OMASASLibrary) {
                boundResource = this.bindSASLibrary((OMASASLibrary)resource, topLevelReposResources);
            } else if (resource instanceof OMAMeasure) {
                boundResource = this.bindMeasure((OMAMeasure)resource, topLevelReposResources);
            } else if (resource instanceof OMAQualifiedLevel) {
                boundResource = this.bindLevel((OMAQualifiedLevel)resource, topLevelReposResources);
            } else if (resource instanceof OMAHierarchy) {
                boundResource = this.bindHierarchy((OMAHierarchy)resource, topLevelReposResources);
            } else if (resource instanceof OMADimension) {
                boundResource = this.bindDimension((OMADimension)resource, topLevelReposResources);
            } else if (resource instanceof OMANamedSet) {
                boundResource = this.bindNamedSet((OMANamedSet)resource, topLevelReposResources);
            } else if (resource instanceof OMACalculatedMember) {
                boundResource = this.bindCalculatedMember((OMACalculatedMember)resource, topLevelReposResources);
            } else if (resource instanceof OMACube) {
                boundResource = this.bindCube((OMACube)resource, topLevelReposResources);
            } else if (resource instanceof OMAOlapSchema) {
                boundResource = this.bindOlapSchema((OMAOlapSchema)resource, topLevelReposResources);
            } else if (resource instanceof JFSStoredProcess) {
                boundResource = this.bindStoredProcess((JFSStoredProcess)resource, topLevelReposResources);
            } else if (resource instanceof OMASoftwareServer) {
                boundResource = this.bindServer((OMASoftwareServer)resource, topLevelReposResources);
            } else if (resource instanceof InMemoryColumn) {
                boundResource = this.bindColumn((InMemoryColumn)resource, topLevelReposResources);
            } else if (resource instanceof InMemoryTable) {
                boundResource = this.bindTable((InMemoryTable)resource, topLevelReposResources);
            } else if (resource instanceof InMemorySASLibrary) {
                boundResource = this.bindInMemorySASLibrary((InMemorySASLibrary)resource, topLevelReposResources);
            } else {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("BusinessModelResourceList.UnableToBind.UnknownObjectType.fmt.txt", resource.getIdentityString(), resource.getClass().getName()));
            }
            if (!boundResource.isUnresolved()) continue;
            if (_perfRFDLogger.isDebugEnabled()) {
                ExtraLoggingContexts.debugLogReadFlowDetails("a resource is unresolved:" + boundResource);
            }
            if (!boundResource.duplicatesFoundDuringResolution() || !_logger.isEnabled(org.apache.logging.log4j.Level.WARN)) continue;
            Object[] msgArgs = new Object[]{boundResource.getIdentityString()};
            String msg = IQModelImplUtilities.getMessage("BusinessModelResourceList.UnableToBind.DuplicatesFound.fmt.txt", msgArgs);
            _logger.warn(msg);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("end   binding OMR resources for a root model");
    }

    private InMemorySASLibrary bindInMemorySASLibrary(InMemorySASLibrary unresolvedInMemorySASLibrary, AvailableReposResources reposResources) throws MetadataException, RemoteException, MdException {
        ExtraLoggingContexts.debugLogReadFlowDetails(">>  bind InMemorySASLibrary");
        InMemorySASLibrary boundLibrary = (InMemorySASLibrary)this._unresolvedToBoundResourceMapping.get(unresolvedInMemorySASLibrary);
        if (boundLibrary == null) {
            OMASASWorkspaceServer server;
            OMASASWorkspaceServer boundServer;
            List<SoftwareServer> servers = unresolvedInMemorySASLibrary.getSoftwareServers();
            if (servers == null || servers.size() == 0) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedInMemorySASLibrary);
            }
            if (servers.size() != 1) {
                this.unexpectedConditionFound();
            }
            if ((boundServer = (OMASASWorkspaceServer)this.bindServer(server = (OMASASWorkspaceServer)servers.get(0), reposResources)).isUnresolved()) {
                List<com.sas.iquery.metadata.physical.SASLibrary> unresolvedLibs = boundServer.getSasLibraries();
                if (!unresolvedLibs.contains(unresolvedInMemorySASLibrary)) {
                    this.unexpectedConditionFound();
                }
                boundLibrary = unresolvedInMemorySASLibrary;
                this.noteBinding(unresolvedInMemorySASLibrary, boundLibrary);
            } else {
                boundLibrary = new InMemorySASLibrary(unresolvedInMemorySASLibrary);
                boundLibrary.setSASWorkspaceServer(boundServer);
                boundLibrary.setSessionContext(this._session);
                this.noteBinding(unresolvedInMemorySASLibrary, boundLibrary);
                ArrayList<InMemoryTable> boundTables = new ArrayList<InMemoryTable>();
                for (InMemoryTable unboundTable : boundLibrary.getTables()) {
                    InMemoryTable boundTable = this.bindTable(unboundTable, reposResources);
                    boundTables.add(boundTable);
                }
                boundLibrary.setTables(boundTables);
            }
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<  bind InMemorySASLibrary");
        return boundLibrary;
    }

    private InMemoryTable bindTable(InMemoryTable unresolvedTable, AvailableReposResources reposResources) throws MetadataException, RemoteException, MdException {
        ExtraLoggingContexts.debugLogReadFlowDetails(">>  bind InMemoryTable");
        InMemoryTable boundTable = (InMemoryTable)this._unresolvedToBoundResourceMapping.get(unresolvedTable);
        if (boundTable == null) {
            AbstractModelRepositoryResource boundLibrary;
            Schema clientSASLibrary = unresolvedTable.getSchema();
            if (clientSASLibrary == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedTable);
            }
            if (clientSASLibrary instanceof InMemorySASLibrary) {
                boundLibrary = this.bindInMemorySASLibrary((InMemorySASLibrary)clientSASLibrary, reposResources);
            } else if (clientSASLibrary instanceof OMASASLibrary) {
                boundLibrary = this.bindSASLibrary((OMASASLibrary)clientSASLibrary, reposResources);
            } else {
                throw new MetadataException("Unknown schema type for InMemoryTable: " + clientSASLibrary);
            }
            if (boundLibrary.isUnresolved()) {
                if (!boundLibrary.getAccessibleTables().contains(unresolvedTable)) {
                    this.unexpectedConditionFound();
                }
                boundTable = unresolvedTable;
            } else {
                if (unresolvedTable instanceof InMemoryQueryTable) {
                    boundTable = new InMemoryQueryTable((InMemoryQueryTable)unresolvedTable);
                    InMemoryQueryTable qTable = (InMemoryQueryTable)boundTable;
                    List<com.sas.iquery.metadata.physical.SASLibrary> libraries = qTable.getLibraries();
                    ArrayList<AbstractModelRepositoryResource> boundLibraries = new ArrayList<AbstractModelRepositoryResource>(libraries.size());
                    for (com.sas.iquery.metadata.physical.SASLibrary library : libraries) {
                        AbstractModelRepositoryResource bLib = library instanceof InMemorySASLibrary ? this.bindInMemorySASLibrary((InMemorySASLibrary)library, reposResources) : this.bindSASLibrary((OMASASLibrary)library, reposResources);
                        if (bLib.isUnresolved()) {
                            qTable.setUnresolved();
                        }
                        boundLibraries.add(bLib);
                    }
                    qTable.setLibraries(boundLibraries);
                } else {
                    boundTable = new InMemoryTable(unresolvedTable);
                }
                boundTable.setSchema((Schema)((Object)boundLibrary));
            }
            this.noteBinding(unresolvedTable, boundTable);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<  bindTable");
        return boundTable;
    }

    private InMemoryColumn bindColumn(InMemoryColumn unresolvedColumn, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException, DataServicesException {
        ExtraLoggingContexts.debugLogReadFlowDetails(">>  bind InMemoryColumn");
        InMemoryColumn boundColumn = (InMemoryColumn)this._unresolvedToBoundResourceMapping.get(unresolvedColumn);
        if (boundColumn == null) {
            InMemoryTable boundTable;
            InMemoryTable owningTable = (InMemoryTable)unresolvedColumn.getOwningTable();
            if (owningTable == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedColumn);
            }
            if ((boundTable = this.bindTable(owningTable, reposResources)).isUnresolved()) {
                if (!boundTable.getColumns().contains(unresolvedColumn)) {
                    this.unexpectedConditionFound();
                }
                boundColumn = unresolvedColumn;
            } else if (boundTable instanceof InMemoryQueryTable) {
                InMemoryQueryTable qTable = (InMemoryQueryTable)boundTable;
                qTable.prepare();
                List<Column> columns = boundTable.getColumns();
                String sasName = unresolvedColumn.getSasName();
                String sasType = unresolvedColumn.getSasType();
                int size = columns.size();
                for (int i = 0; i < size && boundColumn == null; ++i) {
                    InMemoryColumn col = (InMemoryColumn)columns.get(i);
                    if (!IQModelImplUtilities.sameIgnoreCase(col.getSasName(), sasName) || !IQModelImplUtilities.sameIgnoreCase(col.getSasType(), sasType)) continue;
                    boundColumn = col;
                }
                if (boundColumn == null) {
                    boundColumn = unresolvedColumn;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedColumn, boundTable);
                    boundColumn.setOwningTable(boundTable);
                }
            } else {
                boundColumn = unresolvedColumn;
                boundColumn.setOwningTable(boundTable);
            }
            this.noteBinding(unresolvedColumn, boundColumn);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<  bindColumn");
        return boundColumn;
    }

    private void logWarningWhenUnresolvedWithResolvedConstrainer(MetadataRepositoryResource unresolvedResource, MetadataRepositoryResource withinResolvedResource) throws RemoteException {
        if (this._doResolve && _logger.isEnabled(org.apache.logging.log4j.Level.WARN)) {
            String msg;
            if (withinResolvedResource == null) {
                Object[] msgArgs = new Object[]{unresolvedResource.getType(), unresolvedResource.getLabel()};
                msg = IQModelImplUtilities.getMessage("V2ResourceResolver.FailedToFindRepositoryObject.fmt.txt", msgArgs);
            } else {
                Object[] msgArgs = new Object[]{unresolvedResource.getType(), unresolvedResource.getLabel(), withinResolvedResource.getType(), withinResolvedResource.getLabel()};
                msg = IQModelImplUtilities.getMessage("V2ResourceResolver.FailedToFindRepositoryObjectRelativeToAnother.fmt.txt", msgArgs);
            }
            _logger.warn(msg);
        }
    }

    private OMAColumn bindColumn(OMAColumn unresolvedColumn, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        ExtraLoggingContexts.debugLogReadFlowDetails(">>  bindColumn");
        OMAColumn boundColumn = (OMAColumn)this._unresolvedToBoundResourceMapping.get(unresolvedColumn);
        if (boundColumn == null) {
            OMATable boundTable;
            OMATable owningTable = (OMATable)unresolvedColumn.getOwningTable();
            if (owningTable == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedColumn);
            }
            if ((boundTable = this.bindTable(owningTable, reposResources)).isUnresolved()) {
                if (!boundTable.getColumns().contains(unresolvedColumn)) {
                    this.unexpectedConditionFound();
                }
                boundColumn = unresolvedColumn;
            } else {
                String sasType;
                String sasName;
                PhysicalTable omrTable = (PhysicalTable)boundTable.getOMAObject();
                List<Column> columns = (List<Column>)this._jomaAssociationsMap.get(omrTable);
                if (columns == null) {
                    columns = boundTable.getColumns(false);
                    this._jomaAssociationsMap.put(omrTable, columns);
                }
                if ((boundColumn = V2ResourceResolver.findColumn(columns, sasName = unresolvedColumn.getSasName(), sasType = unresolvedColumn.getSasType())) == null) {
                    boundColumn = unresolvedColumn;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedColumn, boundTable);
                    boundColumn.setOwningTable(boundTable);
                }
            }
            this.noteBinding(unresolvedColumn, boundColumn);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<  bindColumn");
        return boundColumn;
    }

    static OMAColumn findColumn(List columns, String sasName, String sasType) throws MetadataException {
        OMAColumn boundColumn = null;
        int size = columns.size();
        for (int i = 0; i < size && boundColumn == null; ++i) {
            OMAColumn col = (OMAColumn)columns.get(i);
            if (!IQModelImplUtilities.sameIgnoreCase(col.getSasName(), sasName) || !IQModelImplUtilities.sameIgnoreCase(col.getSasType(), sasType)) continue;
            boundColumn = col;
        }
        return boundColumn;
    }

    private OMATable bindTable(OMATable unresolvedTable, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        ExtraLoggingContexts.debugLogReadFlowDetails(">>  bindTable");
        OMATable boundTable = (OMATable)this._unresolvedToBoundResourceMapping.get(unresolvedTable);
        if (boundTable == null) {
            OMASASLibrary boundSASLibrary;
            OMASASLibrary clientSASLibrary = unresolvedTable.getAccessingSASLibraryWhenUnresolved();
            if (clientSASLibrary == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedTable);
            }
            if ((boundSASLibrary = this.bindSASLibrary(clientSASLibrary, reposResources)).isUnresolved()) {
                if (!boundSASLibrary.getAccessibleTables().contains(unresolvedTable)) {
                    this.unexpectedConditionFound();
                }
                boundTable = unresolvedTable;
            } else {
                SASLibrary omrSASLibrary = (SASLibrary)boundSASLibrary.getOMAObject();
                List<PhysicalTable> tables = (List<PhysicalTable>)this._jomaAssociationsMap.get(omrSASLibrary);
                if (tables == null) {
                    if (omrSASLibrary.getIsDBMSLibname() == 0) {
                        AssociationList partialSetOfTables = omrSASLibrary.getTables();
                        tables = AssociationListUtil.filteredSnapshot(partialSetOfTables, PhysicalTable.class);
                        this._filteredAssociationLists.add(partialSetOfTables);
                    } else {
                        RelationalSchema relationalSchemaToUse = null;
                        List<RelationalSchema> relationalSchemas = AssociationListUtil.filteredSnapshot(omrSASLibrary.getUsingPackages(), RelationalSchema.class);
                        if (!relationalSchemas.isEmpty()) {
                            relationalSchemaToUse = relationalSchemas.get(0);
                        }
                        if (relationalSchemaToUse != null) {
                            AssociationList partialSetOfTables = relationalSchemaToUse.getTables();
                            tables = AssociationListUtil.filteredSnapshot(partialSetOfTables, PhysicalTable.class);
                            this._filteredAssociationLists.add(partialSetOfTables);
                        } else {
                            tables = new ArrayList<PhysicalTable>();
                        }
                    }
                    this._jomaAssociationsMap.put(omrSASLibrary, tables);
                }
                PhysicalTable foundTable = null;
                boolean duplicate = false;
                for (PhysicalTable table : tables) {
                    if (!IQModelImplUtilities.sameIgnoreCase(table.getName(), unresolvedTable.getLabel())) continue;
                    if (foundTable != null) {
                        duplicate = true;
                        unresolvedTable.setDuplicatesFoundDuringResolution(true);
                    }
                    foundTable = table;
                }
                if (duplicate || foundTable == null) {
                    boundTable = unresolvedTable;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedTable, boundSASLibrary);
                    boundTable.setAccessingSASLibraryWhenUnresolved(boundSASLibrary);
                } else {
                    boundTable = (OMATable)OMAResourceFactory.getReposObject(foundTable, this._session, this._readingContext.getMetadataServer());
                }
            }
            this.noteBinding(unresolvedTable, boundTable);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<  bindTable");
        return boundTable;
    }

    private OMASASLibrary bindSASLibrary(OMASASLibrary unresolvedSASLibrary, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        ExtraLoggingContexts.debugLogReadFlowDetails(">>  bindSASLibrary");
        OMASASLibrary boundSASLibrary = (OMASASLibrary)this._unresolvedToBoundResourceMapping.get(unresolvedSASLibrary);
        if (boundSASLibrary == null) {
            OMASASWorkspaceServer server;
            OMASASWorkspaceServer boundServer;
            List<SoftwareServer> servers = unresolvedSASLibrary.getSoftwareServers();
            if (servers == null || servers.size() == 0) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedSASLibrary);
            }
            if (servers.size() != 1) {
                this.unexpectedConditionFound();
            }
            if ((boundServer = (OMASASWorkspaceServer)this.bindServer(server = (OMASASWorkspaceServer)servers.get(0), reposResources)).isUnresolved()) {
                List<com.sas.iquery.metadata.physical.SASLibrary> unresolvedLibs = boundServer.getSasLibraries();
                if (!unresolvedLibs.contains(unresolvedSASLibrary)) {
                    this.unexpectedConditionFound();
                }
                boundSASLibrary = unresolvedSASLibrary;
            } else {
                SASLibrary foundSASLibrary = null;
                boolean duplicate = false;
                ServerContext omrServer = boundServer.getServerContext();
                ArrayList<SASLibrary> omrLibs = (ArrayList<SASLibrary>)this._jomaAssociationsMap.get(omrServer);
                if (omrLibs == null) {
                    AssociationList partialSetOfLibs = omrServer.getDataPackages();
                    List<SASLibrary> omrSasLibraries = AssociationListUtil.filteredSnapshot(partialSetOfLibs, SASLibrary.class);
                    this._filteredAssociationLists.add(partialSetOfLibs);
                    omrLibs = new ArrayList<SASLibrary>(omrSasLibraries);
                    this._jomaAssociationsMap.put(omrServer, omrLibs);
                }
                int size = omrLibs.size();
                for (int i = 0; i < size && !duplicate; ++i) {
                    SASLibrary lib = (SASLibrary)omrLibs.get(i);
                    if (!IQModelImplUtilities.sameIgnoreCase(lib.getName(), unresolvedSASLibrary.getLabel())) continue;
                    if (foundSASLibrary != null) {
                        duplicate = true;
                        unresolvedSASLibrary.setDuplicatesFoundDuringResolution(true);
                    }
                    foundSASLibrary = lib;
                }
                if (duplicate || foundSASLibrary == null) {
                    boundSASLibrary = unresolvedSASLibrary;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedSASLibrary, boundServer);
                    boundSASLibrary.setAccessingServerWhenUnresolved(boundServer);
                } else {
                    boundSASLibrary = (OMASASLibrary)OMAResourceFactory.getReposObject(foundSASLibrary, this._session, this._readingContext.getMetadataServer());
                }
            }
            this.noteBinding(unresolvedSASLibrary, boundSASLibrary);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<  bindSASLibrary");
        return boundSASLibrary;
    }

    private OMAMeasure bindMeasure(OMAMeasure unresolvedMeasure, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMAMeasure boundMeasure = (OMAMeasure)this._unresolvedToBoundResourceMapping.get(unresolvedMeasure);
        if (boundMeasure == null) {
            OMACube boundCube;
            OMACube owningCube = (OMACube)unresolvedMeasure.getOwningCube();
            if (owningCube == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedMeasure);
            }
            if ((boundCube = this.bindCube(owningCube, reposResources)).isUnresolved()) {
                if (!boundCube.getMeasures().contains(unresolvedMeasure)) {
                    this.unexpectedConditionFound();
                }
                boundMeasure = unresolvedMeasure;
            } else {
                Cube omrCube = (Cube)boundCube.getOMAObject();
                Measure foundMeasure = null;
                boolean duplicate = false;
                ArrayList measures = new ArrayList(omrCube.getMeasures());
                for (Measure measure : measures) {
                    if (!IQModelImplUtilities.sameIgnoreCase(measure.getName(), unresolvedMeasure.getLabel())) continue;
                    if (foundMeasure != null) {
                        duplicate = true;
                        unresolvedMeasure.setDuplicatesFoundDuringResolution(true);
                    }
                    foundMeasure = measure;
                }
                if (duplicate || foundMeasure == null) {
                    boundMeasure = unresolvedMeasure;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedMeasure, boundCube);
                    boundMeasure.setOwningCube(boundCube);
                } else {
                    boundMeasure = (OMAMeasure)OMAResourceFactory.getReposObject(foundMeasure, this._session, this._readingContext.getMetadataServer());
                }
            }
            this.noteBinding(unresolvedMeasure, boundMeasure);
        }
        return boundMeasure;
    }

    private OMAQualifiedLevel bindLevel(OMAQualifiedLevel unresolvedLevel, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMAQualifiedLevel boundLevel = (OMAQualifiedLevel)this._unresolvedToBoundResourceMapping.get(unresolvedLevel);
        if (boundLevel == null) {
            OMAHierarchy boundHierarchy;
            OMAHierarchy owningHierarchy = (OMAHierarchy)unresolvedLevel.getOwningHierarchy();
            if (owningHierarchy == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedLevel);
            }
            if ((boundHierarchy = this.bindHierarchy(owningHierarchy, reposResources)).isUnresolved()) {
                if (!boundHierarchy.getLevels().contains(unresolvedLevel)) {
                    this.unexpectedConditionFound();
                }
                boundLevel = unresolvedLevel;
            } else {
                Hierarchy omrHierarchy = (Hierarchy)boundHierarchy.getOMAObject();
                Level foundJomaLevel = null;
                boolean duplicate = false;
                ArrayList levels = new ArrayList(omrHierarchy.getLevels());
                for (Level level : levels) {
                    if (!IQModelImplUtilities.sameIgnoreCase(level.getName(), unresolvedLevel.getLabel())) continue;
                    if (foundJomaLevel != null) {
                        duplicate = true;
                        unresolvedLevel.setDuplicatesFoundDuringResolution(true);
                    }
                    foundJomaLevel = level;
                }
                if (duplicate || foundJomaLevel == null) {
                    boundLevel = unresolvedLevel;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedLevel, boundHierarchy);
                    boundLevel.setOwningHierarchy(boundHierarchy);
                } else {
                    boundLevel = boundHierarchy.getRepresentativeLevel(foundJomaLevel, true);
                }
            }
            this.noteBinding(unresolvedLevel, boundLevel);
        }
        return boundLevel;
    }

    private OMACalculatedMember bindCalculatedMember(OMACalculatedMember unresolvedCalculatedMember, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMACalculatedMember boundCalculatedMember = (OMACalculatedMember)this._unresolvedToBoundResourceMapping.get(unresolvedCalculatedMember);
        if (boundCalculatedMember == null) {
            OMAHierarchy boundHierarchy;
            OMAHierarchy owningHierarchy = (OMAHierarchy)unresolvedCalculatedMember.getOwningHierarchy();
            if (owningHierarchy == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedCalculatedMember);
            }
            if ((boundHierarchy = this.bindHierarchy(owningHierarchy, reposResources)).isUnresolved()) {
                if (!boundHierarchy.getCalculatedMembers().contains(unresolvedCalculatedMember)) {
                    this.unexpectedConditionFound();
                }
                boundCalculatedMember = unresolvedCalculatedMember;
            } else {
                Hierarchy omrHierarchy = (Hierarchy)boundHierarchy.getOMAObject();
                CalculatedMember foundCalculatedMember = null;
                boolean duplicate = false;
                ArrayList omrCalculatedMembers = new ArrayList(omrHierarchy.getCalculatedMembers());
                for (CalculatedMember omrCalMember : omrCalculatedMembers) {
                    if (!IQModelImplUtilities.sameIgnoreCase(omrCalMember.getName(), unresolvedCalculatedMember.getLabel())) continue;
                    if (foundCalculatedMember != null) {
                        duplicate = true;
                        unresolvedCalculatedMember.setDuplicatesFoundDuringResolution(true);
                    }
                    foundCalculatedMember = omrCalMember;
                }
                if (duplicate || foundCalculatedMember == null) {
                    boundCalculatedMember = unresolvedCalculatedMember;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedCalculatedMember, boundHierarchy);
                    boundCalculatedMember.setOwningHierarchy(boundHierarchy);
                } else {
                    boundCalculatedMember = (OMACalculatedMember)OMAResourceFactory.getReposObject(foundCalculatedMember, this._session, this._readingContext.getMetadataServer());
                }
            }
            this.noteBinding(unresolvedCalculatedMember, boundCalculatedMember);
        }
        return boundCalculatedMember;
    }

    private OMANamedSet bindNamedSet(OMANamedSet unresolvedNamedSet, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMANamedSet boundNamedSet = (OMANamedSet)this._unresolvedToBoundResourceMapping.get(unresolvedNamedSet);
        if (boundNamedSet == null) {
            OMAHierarchy boundHierarchy;
            OMAHierarchy owningHierarchy = (OMAHierarchy)unresolvedNamedSet.getOwningHierarchy();
            if (owningHierarchy == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedNamedSet);
            }
            if ((boundHierarchy = this.bindHierarchy(owningHierarchy, reposResources)).isUnresolved()) {
                if (!boundHierarchy.getNamedSets().contains(unresolvedNamedSet)) {
                    this.unexpectedConditionFound();
                }
                boundNamedSet = unresolvedNamedSet;
            } else {
                Hierarchy omrHierarchy = (Hierarchy)boundHierarchy.getOMAObject();
                NamedSet foundJomaNamedSet = null;
                boolean duplicate = false;
                ArrayList namedsets = new ArrayList(omrHierarchy.getNamedSets());
                for (NamedSet omrNS : namedsets) {
                    if (!IQModelImplUtilities.sameIgnoreCase(omrNS.getName(), unresolvedNamedSet.getLabel())) continue;
                    if (foundJomaNamedSet != null) {
                        duplicate = true;
                        unresolvedNamedSet.setDuplicatesFoundDuringResolution(true);
                    }
                    foundJomaNamedSet = omrNS;
                }
                if (duplicate || foundJomaNamedSet == null) {
                    boundNamedSet = unresolvedNamedSet;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedNamedSet, boundHierarchy);
                    boundNamedSet.setOwningHierarchy(boundHierarchy);
                } else {
                    boundNamedSet = boundHierarchy.getRepresentativeNamedSet(foundJomaNamedSet);
                }
            }
            this.noteBinding(unresolvedNamedSet, boundNamedSet);
        }
        return boundNamedSet;
    }

    private OMAHierarchy bindHierarchy(OMAHierarchy unresolvedHierarchy, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMAHierarchy boundHierarchy = (OMAHierarchy)this._unresolvedToBoundResourceMapping.get(unresolvedHierarchy);
        if (boundHierarchy == null) {
            OMADimension boundDimension;
            OMADimension owningDimension = (OMADimension)unresolvedHierarchy.getOwningDimension();
            if (owningDimension == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedHierarchy);
            }
            if ((boundDimension = this.bindDimension(owningDimension, reposResources)).isUnresolved()) {
                if (!boundDimension.getHierarchies().contains(unresolvedHierarchy)) {
                    this.unexpectedConditionFound();
                }
                boundHierarchy = unresolvedHierarchy;
            } else {
                Dimension omrDimension = (Dimension)boundDimension.getOMAObject();
                Hierarchy foundHierarchy = null;
                boolean duplicate = false;
                ArrayList dimensions = new ArrayList(omrDimension.getHierarchies());
                for (Hierarchy hier : dimensions) {
                    if (!IQModelImplUtilities.sameIgnoreCase(hier.getName(), unresolvedHierarchy.getLabel())) continue;
                    if (foundHierarchy != null) {
                        duplicate = true;
                        unresolvedHierarchy.setDuplicatesFoundDuringResolution(true);
                    }
                    foundHierarchy = hier;
                }
                if (duplicate || foundHierarchy == null) {
                    boundHierarchy = unresolvedHierarchy;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedHierarchy, boundDimension);
                    boundHierarchy.setOwningDimension(boundDimension);
                } else {
                    boundHierarchy = (OMAHierarchy)OMAResourceFactory.getReposObject(foundHierarchy, this._session, this._readingContext.getMetadataServer());
                }
            }
            this.noteBinding(unresolvedHierarchy, boundHierarchy);
        }
        return boundHierarchy;
    }

    private OMADimension bindDimension(OMADimension unresolvedDimension, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMADimension boundDimension = (OMADimension)this._unresolvedToBoundResourceMapping.get(unresolvedDimension);
        if (boundDimension == null) {
            OMACube boundCube;
            OMACube owningCube = (OMACube)unresolvedDimension.getOwningCube();
            if (owningCube == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedDimension);
            }
            if ((boundCube = this.bindCube(owningCube, reposResources)).isUnresolved()) {
                if (!boundCube.getDimensions().contains(unresolvedDimension)) {
                    this.unexpectedConditionFound();
                }
                boundDimension = unresolvedDimension;
            } else {
                Cube omrCube = (Cube)boundCube.getOMAObject();
                Dimension foundDimension = null;
                boolean duplicate = false;
                ArrayList dimensions = new ArrayList(omrCube.getDimensions());
                for (Dimension dim : dimensions) {
                    if (!IQModelImplUtilities.sameIgnoreCase(dim.getName(), unresolvedDimension.getLabel())) continue;
                    if (foundDimension != null) {
                        duplicate = true;
                        unresolvedDimension.setDuplicatesFoundDuringResolution(true);
                    }
                    foundDimension = dim;
                }
                if (duplicate || foundDimension == null) {
                    boundDimension = unresolvedDimension;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedDimension, boundCube);
                    boundDimension.setOwningCube(boundCube);
                } else {
                    boundDimension = (OMADimension)OMAResourceFactory.getReposObject(foundDimension, this._session, this._readingContext.getMetadataServer());
                    boundDimension.setOwningCube(boundCube);
                }
            }
            this.noteBinding(unresolvedDimension, boundDimension);
        }
        return boundDimension;
    }

    private OMACube bindCube(OMACube unresolvedCube, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMACube boundCube = (OMACube)this._unresolvedToBoundResourceMapping.get(unresolvedCube);
        if (boundCube == null) {
            OMAOlapSchema boundOlapSchema;
            OMAOlapSchema owningOlapSchema = (OMAOlapSchema)unresolvedCube.getOwningOlapSchema();
            if (owningOlapSchema == null) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedCube);
            }
            if ((boundOlapSchema = this.bindOlapSchema(owningOlapSchema, reposResources)).isUnresolved()) {
                if (!boundOlapSchema.getCubes().contains(unresolvedCube)) {
                    this.unexpectedConditionFound();
                }
                boundCube = unresolvedCube;
            } else {
                OLAPSchema omrOlapSchema = (OLAPSchema)boundOlapSchema.getOMAObject();
                Cube foundCube = null;
                boolean duplicate = false;
                AssociationList partialSetOfCubes = omrOlapSchema.getCubes();
                List<Cube> cubes = AssociationListUtil.filteredSnapshot(partialSetOfCubes, Cube.class);
                this._filteredAssociationLists.add(partialSetOfCubes);
                for (Cube cube : cubes) {
                    if (!IQModelImplUtilities.sameIgnoreCase(cube.getName(), unresolvedCube.getLabel())) continue;
                    if (foundCube != null) {
                        duplicate = true;
                        unresolvedCube.setDuplicatesFoundDuringResolution(true);
                    }
                    foundCube = cube;
                }
                if (duplicate || foundCube == null) {
                    boundCube = unresolvedCube;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedCube, boundOlapSchema);
                    boundCube.setOwningOlapSchema(boundOlapSchema);
                } else {
                    boundCube = (OMACube)OMAResourceFactory.getReposObject(foundCube, this._session, this._readingContext.getMetadataServer());
                }
            }
            this.noteBinding(unresolvedCube, boundCube);
        }
        return boundCube;
    }

    private OMAOlapSchema bindOlapSchema(OMAOlapSchema unresolvedOlapSchema, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMAOlapSchema boundOlapSchema = (OMAOlapSchema)this._unresolvedToBoundResourceMapping.get(unresolvedOlapSchema);
        if (boundOlapSchema == null) {
            OMASASOlapServer server;
            OMASASOlapServer boundServer;
            List<SoftwareServer> servers = unresolvedOlapSchema.getSoftwareServers();
            if (servers == null || servers.size() == 0) {
                this.repositoryObjectDoesNotHaveProperParentage(unresolvedOlapSchema);
            }
            if (servers.size() != 1) {
                this.unexpectedConditionFound();
            }
            if ((boundServer = (OMASASOlapServer)this.bindServer(server = (OMASASOlapServer)servers.get(0), reposResources)).isUnresolved()) {
                List unresolvedOlapSchemas = boundServer.getOlapSchemas();
                if (!unresolvedOlapSchemas.contains(unresolvedOlapSchema)) {
                    this.unexpectedConditionFound();
                }
                boundOlapSchema = unresolvedOlapSchema;
            } else {
                ServerContext serverContext = boundServer.getServerContext();
                OLAPSchema foundOlapSchema = null;
                boolean duplicate = false;
                AssociationList partialSetOfDataPackages = serverContext.getDataPackages();
                List<OLAPSchema> olapSchemas = AssociationListUtil.filteredSnapshot(partialSetOfDataPackages, OLAPSchema.class);
                this._filteredAssociationLists.add(partialSetOfDataPackages);
                for (OLAPSchema olapSchema : olapSchemas) {
                    if (!IQModelImplUtilities.sameIgnoreCase(olapSchema.getName(), unresolvedOlapSchema.getLabel())) continue;
                    if (foundOlapSchema != null) {
                        duplicate = true;
                        unresolvedOlapSchema.setDuplicatesFoundDuringResolution(true);
                    }
                    foundOlapSchema = olapSchema;
                }
                if (duplicate || foundOlapSchema == null) {
                    boundOlapSchema = unresolvedOlapSchema;
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedOlapSchema, boundServer);
                    boundOlapSchema.setAccessingServerWhenUnresolved(boundServer);
                } else {
                    boundOlapSchema = (OMAOlapSchema)OMAResourceFactory.getReposObject(foundOlapSchema, this._session, this._readingContext.getMetadataServer());
                }
            }
            this.noteBinding(unresolvedOlapSchema, boundOlapSchema);
        }
        return boundOlapSchema;
    }

    private JFSStoredProcess bindStoredProcess(JFSStoredProcess unresolvedStoredProcess, AvailableReposResources reposResources) throws RemoteException, ServiceException, MetadataException, MdException {
        OMASoftwareServer server = (OMASoftwareServer)unresolvedStoredProcess.getUnresolvedSoftwareServer();
        if (server == null) {
            this.repositoryObjectDoesNotHaveProperParentage(unresolvedStoredProcess);
        }
        if (server instanceof OMASASOlapServer) {
            return this.bindOLAPStoredProcess(unresolvedStoredProcess, reposResources);
        }
        JFSStoredProcess boundStoredProcess = (JFSStoredProcess)this._unresolvedToBoundResourceMapping.get(unresolvedStoredProcess);
        if (boundStoredProcess == null) {
            OMASoftwareServer boundServer = this.bindServer(server, reposResources);
            if (boundServer.isUnresolved()) {
                List unresolvedStoredProcesses = boundServer.getUnresolvedStoredProcesses();
                if (!unresolvedStoredProcesses.contains(unresolvedStoredProcess)) {
                    this.unexpectedConditionFound();
                }
                boundStoredProcess = unresolvedStoredProcess;
            } else {
                String absolutePathToStoredProcess = unresolvedStoredProcess.getLocation();
                PathUrl pathToUnresolvedStoredProcess = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._readingContext.getMetadataServer(), (String)absolutePathToStoredProcess);
                MetadataServerInterface metaServer = boundServer.getMetadataServer();
                ServerContextInterface sci = (ServerContextInterface)metaServer.factoryProcess((Object)boundServer.getServerContext());
                List computeTasks = this.getComputeTasks((com.sas.services.information.metadata.ServerInterface)sci);
                ArrayList<StoredProcessInterface> matchingStoredProcesses = new ArrayList<StoredProcessInterface>();
                for (Object obj : computeTasks) {
                    PathUrl path;
                    if (!(obj instanceof StoredProcessInterface)) continue;
                    StoredProcessInterface sp = (StoredProcessInterface)obj;
                    if (!pathToUnresolvedStoredProcess.getName().equals(sp.getName()) || (path = sp.getPathUrl()) == null || !absolutePathToStoredProcess.equals(path.getAbsolutePath())) continue;
                    matchingStoredProcesses.add(sp);
                }
                if (matchingStoredProcesses.isEmpty()) {
                    LogicalServerInterface logicalServerInterface = boundServer.getNonPooledLogicalServerInterface();
                    computeTasks = this.getComputeTasks((com.sas.services.information.metadata.ServerInterface)logicalServerInterface);
                    for (MetadataInterface omrObject : computeTasks) {
                        StoredProcessInterface sp;
                        PathUrl path;
                        if (!(omrObject instanceof StoredProcessInterface) || !pathToUnresolvedStoredProcess.getName().equals(omrObject.getName()) || (path = (sp = (StoredProcessInterface)omrObject).getPathUrl()) == null || !absolutePathToStoredProcess.equals(path.getAbsolutePath())) continue;
                        matchingStoredProcesses.add(sp);
                    }
                }
                if (matchingStoredProcesses.size() != 1) {
                    boundStoredProcess = unresolvedStoredProcess;
                    if (matchingStoredProcesses.size() > 1) {
                        unresolvedStoredProcess.setDuplicatesFoundDuringResolution(true);
                    }
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedStoredProcess, boundServer);
                } else {
                    StoredProcessInterface sp = (StoredProcessInterface)matchingStoredProcesses.get(0);
                    boundStoredProcess = (JFSStoredProcess)JFSResourceFactory.newJFSResource((MetadataInterface)sp);
                    boundStoredProcess.setAbsolutePathLocation(absolutePathToStoredProcess);
                }
            }
            this.noteBinding(unresolvedStoredProcess, boundStoredProcess);
        }
        return boundStoredProcess;
    }

    private JFSStoredProcess bindOLAPStoredProcess(JFSStoredProcess unresolvedStoredProcess, AvailableReposResources reposResources) throws RemoteException, ServiceException, MetadataException, MdException {
        OMASoftwareServer server = (OMASoftwareServer)unresolvedStoredProcess.getUnresolvedSoftwareServer();
        JFSStoredProcess boundStoredProcess = (JFSStoredProcess)this._unresolvedToBoundResourceMapping.get(unresolvedStoredProcess);
        if (boundStoredProcess == null) {
            OMASoftwareServer boundServer;
            if (server == null) {
                this.unexpectedConditionFound();
            }
            if ((boundServer = this.bindServer(server, reposResources)).isUnresolved()) {
                boundStoredProcess = unresolvedStoredProcess;
            } else {
                String absolutePathToStoredProcess = unresolvedStoredProcess.getLocation();
                PathUrl pathToUnresolvedStoredProcess = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._readingContext.getMetadataServer(), (String)absolutePathToStoredProcess);
                LogicalServerInterface logicalOLAPServer = boundServer.getNonPooledLogicalServerInterface();
                List serverContextServers = AssociationListUtil.getCopyIfASL(logicalOLAPServer.getServed());
                ArrayList<StoredProcessInterface> matchingStoredProcesses = new ArrayList<StoredProcessInterface>();
                if (serverContextServers.size() == 1) {
                    ServerContextInterface serverContext = (ServerContextInterface)serverContextServers.get(0);
                    List computeTasks = this.getComputeTasks((com.sas.services.information.metadata.ServerInterface)serverContext);
                    for (Object obj : computeTasks) {
                        PathUrl path;
                        if (!(obj instanceof StoredProcessInterface)) continue;
                        StoredProcessInterface sp = (StoredProcessInterface)obj;
                        if (!pathToUnresolvedStoredProcess.getName().equals(sp.getName()) || (path = sp.getPathUrl()) == null || !absolutePathToStoredProcess.equals(path.getAbsolutePath())) continue;
                        matchingStoredProcesses.add(sp);
                    }
                    List servers = AssociationListUtil.getCopyIfASL(serverContext.getServers());
                    for (LogicalServerInterface logicalServerInterface : servers) {
                        computeTasks = this.getComputeTasks((com.sas.services.information.metadata.ServerInterface)logicalServerInterface);
                        for (MetadataInterface omrObject : computeTasks) {
                            StoredProcessInterface sp;
                            PathUrl path;
                            if (!(omrObject instanceof StoredProcessInterface) || !pathToUnresolvedStoredProcess.getName().equals(omrObject.getName()) || (path = (sp = (StoredProcessInterface)omrObject).getPathUrl()) == null || !absolutePathToStoredProcess.equals(path.getAbsolutePath()) || matchingStoredProcesses.contains(sp)) continue;
                            matchingStoredProcesses.add(sp);
                        }
                    }
                }
                if (matchingStoredProcesses.size() != 1) {
                    boundStoredProcess = unresolvedStoredProcess;
                    if (matchingStoredProcesses.size() > 1) {
                        unresolvedStoredProcess.setDuplicatesFoundDuringResolution(true);
                    }
                    this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedStoredProcess, boundServer);
                } else {
                    StoredProcessInterface sp = (StoredProcessInterface)matchingStoredProcesses.get(0);
                    boundStoredProcess = (JFSStoredProcess)JFSResourceFactory.newJFSResource((MetadataInterface)sp);
                    boundStoredProcess.setAbsolutePathLocation(absolutePathToStoredProcess);
                }
            }
            this.noteBinding(unresolvedStoredProcess, boundStoredProcess);
        }
        return boundStoredProcess;
    }

    private List getComputeTasks(com.sas.services.information.metadata.ServerInterface serverInterface) throws RemoteException, MdException, ServiceException {
        ServerComponent serverComponent = (ServerComponent)serverInterface.getRepositoryEntity();
        AssociationList partialSetOfComputeTasks = serverComponent.getComputeTasks();
        this._filteredAssociationLists.add(partialSetOfComputeTasks);
        return AssociationListUtil.getCopyIfASL(serverInterface.getComputeTasks(false));
    }

    private OMASoftwareServer bindServer(OMASoftwareServer unresolvedServer, AvailableReposResources reposResources) throws RemoteException, MetadataException, MdException {
        OMASoftwareServer server;
        ExtraLoggingContexts.debugLogReadFlowDetails(">>  bindServer");
        OMASoftwareServer boundServer = (OMASoftwareServer)this._unresolvedToBoundResourceMapping.get(unresolvedServer);
        if (boundServer == null && (server = reposResources.getSoftwareServer()) != null && IQModelImplUtilities.sameIgnoreCase(server.getLabel(), unresolvedServer.getLabel())) {
            boundServer = server;
            this.noteBinding(unresolvedServer, boundServer);
        }
        if (boundServer == null) {
            ServerContext foundServerContext = null;
            boolean duplicateServerContext = false;
            List serversAvailable = reposResources.getJOMAServers();
            Iterator it = serversAvailable.iterator();
            while (it.hasNext() && !duplicateServerContext) {
                Root omrObject = (Root)it.next();
                if (!(omrObject instanceof ServerContext) || !IQModelImplUtilities.sameIgnoreCase(omrObject.getName(), unresolvedServer.getLabel())) continue;
                if (foundServerContext != null) {
                    duplicateServerContext = true;
                    unresolvedServer.setDuplicatesFoundDuringResolution(true);
                }
                foundServerContext = (ServerContext)omrObject;
            }
            if (!duplicateServerContext && foundServerContext != null) {
                boolean wantRelationalServer = unresolvedServer instanceof OMASASWorkspaceServer;
                boundServer = OMAResourceFactory.getOMAServerObject(foundServerContext, this._session, this._readingContext.getMetadataServer(), wantRelationalServer);
                if (wantRelationalServer) {
                    AssociationList partialSetOfUsingComponentsWhenRelational = foundServerContext.getUsingComponents();
                    this._filteredAssociationLists.add(partialSetOfUsingComponentsWhenRelational);
                }
            }
            if (boundServer == null) {
                boundServer = unresolvedServer;
                this.logWarningWhenUnresolvedWithResolvedConstrainer(unresolvedServer, null);
            }
            this.noteBinding(unresolvedServer, boundServer);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("<<  bindServer");
        return boundServer;
    }

    private void unexpectedConditionFound() throws MetadataException {
        MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("BusinessModelResourceList.UnexpectedConditionFound.txt", new Object[0]);
        if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
            _logger.error(mf.toString());
        }
        throw new MetadataException(mf);
    }

    private void repositoryObjectDoesNotHaveProperParentage(MetadataRepositoryResource amrr) throws MetadataException {
        MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("V2ResourceResolver.RepositoryObjectDoesNotHaveProperParentage.fmt.txt", amrr.getIdentityString());
        if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
            _logger.error(mf.toString());
        }
        throw new MetadataException(mf);
    }

    private List runQueriesToGetOmrObjects(List unresolvedResourceList) throws MetadataException, RemoteException, ServiceException, MdException {
        ExtraLoggingContexts.debugLogReadFlowDetails("start creating query to send to OMR");
        List<Object> outJomaObjects = null;
        String resourceResolutionTemplate = this.createResourceResolutionTemplate(unresolvedResourceList);
        ExtraLoggingContexts.debugLogReadFlowDetails("end   creating query to send to OMR");
        if (resourceResolutionTemplate != null) {
            int omrFlags = -2147475196;
            ExtraLoggingContexts.debugLogReadFlowDetails("start querying OMR for required OMA objects");
            ExtraLoggingContexts.debugLogReadFlowDetails("Query template is:");
            ExtraLoggingContexts.debugLogReadFlowDetails(resourceResolutionTemplate);
            ExtraLoggingContexts.debugLogReadFlowSummary("Start querying the repository");
            List smartObjects = null;
            if (!this._doResolve) {
                smartObjects = new ArrayList();
            } else {
                MetadataServerInterface metadataServer = this._readingContext.getMetadataServer();
                smartObjects = IQModelImplUtilities.generalSearch((ServerInterface)metadataServer, omrFlags, resourceResolutionTemplate, "Root", null);
            }
            ExtraLoggingContexts.debugLogReadFlowSummary("End   querying the repository");
            outJomaObjects = IQModelImplUtilities.unwrapOMRSmartObjects(smartObjects);
        } else {
            outJomaObjects = new ArrayList();
        }
        return outJomaObjects;
    }

    private String createResourceResolutionTemplate(List unresolvedOMRResources) throws MetadataException {
        String outTemplate = null;
        ArrayList<MetadataRepositoryResource> servers = new ArrayList<MetadataRepositoryResource>(1);
        ArrayList<MetadataRepositoryResource> libs = new ArrayList<MetadataRepositoryResource>();
        ArrayList<MetadataRepositoryResource> tables = new ArrayList<MetadataRepositoryResource>();
        ArrayList<MetadataRepositoryResource> olapSchemas = new ArrayList<MetadataRepositoryResource>();
        ArrayList<MetadataRepositoryResource> cubes = new ArrayList<MetadataRepositoryResource>();
        ArrayList<MetadataRepositoryResource> storedProcesses = new ArrayList<MetadataRepositoryResource>();
        int size = unresolvedOMRResources.size();
        for (int i = 0; i < size; ++i) {
            MetadataRepositoryResource rr = (MetadataRepositoryResource)unresolvedOMRResources.get(i);
            if (rr instanceof OMAColumn) continue;
            if (rr instanceof OMATable) {
                tables.add(rr);
                continue;
            }
            if (rr instanceof OMASoftwareServer) {
                servers.add(rr);
                continue;
            }
            if (rr instanceof OMASASLibrary) {
                libs.add(rr);
                continue;
            }
            if (rr instanceof OMAOlapSchema) {
                olapSchemas.add(rr);
                continue;
            }
            if (rr instanceof OMACube) {
                cubes.add(rr);
                continue;
            }
            if (!(rr instanceof JFSStoredProcess)) continue;
            storedProcesses.add(rr);
        }
        int serverCount = servers.size();
        if (serverCount == 1) {
            OMASoftwareServer server = (OMASoftwareServer)servers.get(0);
            String serverName = server.getLabel();
            if (server instanceof OMASASWorkspaceServer) {
                outTemplate = OMRTemplates.getRelationalResourceResolutionTemplate(serverName, libs, tables, storedProcesses);
            } else if (server instanceof OMASASOlapServer) {
                outTemplate = OMRTemplates.getOLAPResourceResolutionTemplate(serverName, olapSchemas, cubes, storedProcesses);
            }
        } else {
            if (serverCount > 1) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("V2ResourceResolver.MoreThanOneServerNotSupported.txt", new Object[0]));
            }
            if (unresolvedOMRResources.size() > 0) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("V2ResourceResolver.MustHaveOneServer.txt", new Object[0]));
            }
        }
        return outTemplate;
    }

    private void clearFilteredAssociationLists() throws RemoteException, MdException {
        for (int i = 0; i < this._filteredAssociationLists.size(); ++i) {
            AssociationList al = this._filteredAssociationLists.get(i);
            if (al.getState() != 1) continue;
            al.setState(0);
        }
    }

    public void setDoResolve(boolean doResolve) {
        this._doResolve = doResolve;
    }

    private static class AvailableReposResources {
        List _resources = new ArrayList();
        OMASoftwareServer _softwareServer;

        AvailableReposResources() {
        }

        AvailableReposResources(List resources) {
            this._resources = resources;
        }

        AvailableReposResources(OMASoftwareServer server) {
            this._softwareServer = server;
        }

        OMASoftwareServer getSoftwareServer() {
            return this._softwareServer;
        }

        List getJOMAServers() {
            ArrayList out = new ArrayList();
            int size = this._resources.size();
            for (int i = 0; i < size; ++i) {
                Object obj = this._resources.get(i);
                if (!(obj instanceof ServerContext)) continue;
                out.add(obj);
            }
            return out;
        }
    }
}

