/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.CommaSeparatedString;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class StringOnlyKeyValuesMapping
extends AbstractModelItem {
    private LinkedHashMap<String, String> _underlyingMap;
    private static final String PREFIX_KEY_VALUE = "kv";

    StringOnlyKeyValuesMapping() {
    }

    void set(Map<String, String> map) throws MetadataException {
        this._underlyingMap = new LinkedHashMap<String, String>(map);
    }

    Map<String, String> get() {
        LinkedHashMap<String, String> out = this._underlyingMap != null ? new LinkedHashMap<String, String>(this._underlyingMap) : new LinkedHashMap<String, String>();
        return out;
    }

    int count() {
        int out = 0;
        if (this._underlyingMap != null) {
            out = this._underlyingMap.size();
        }
        return out;
    }

    @Override
    protected String getDefinitionElementName() {
        return "StringOnlyKeyValuesMapping";
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this._underlyingMap != null) {
            String[] inputPair = new String[2];
            int i = 1;
            for (Map.Entry<String, String> entry : this._underlyingMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                inputPair[0] = key;
                inputPair[1] = value;
                String attrName = PREFIX_KEY_VALUE + i;
                IQModelImplUtilities.setCommaSeparatedStringAttr(thisElement, attrName, inputPair);
                ++i;
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._underlyingMap = new LinkedHashMap();
        String[] orderedAttrValues = attrsProvider.consumeOrderedPrefixNAttrs(PREFIX_KEY_VALUE);
        int size = orderedAttrValues.length;
        try {
            for (int i = 0; i < size; ++i) {
                String attrValue = orderedAttrValues[i];
                String[] pair = CommaSeparatedString.split(attrValue);
                this._underlyingMap.put(pair[0], pair[1]);
            }
        }
        catch (IOException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
    }
}

