/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.AggregateEntity;
import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.CascadeRuleSet;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.DrillThroughToDetail;
import com.sas.iquery.metadata.business.FilterCascadeRule;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QueryWriteOption;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.business.SetOperationType;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractModelReference;
import com.sas.iquery.metadata.business.impl.BusinessModelReferenceInfoImpl;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToOlapData;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.CubeContainer;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.OlapServer;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.RelationalServer;
import com.sas.iquery.metadata.physical.SASOlapServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;

public class SetOperationDataSelectionImpl
extends AbstractBusinessModel
implements SetOperationDataSelection,
CancelQuerySupport.CancellableQuery {
    private List<DataSelection> _dataSelections;
    private SetOperationType _setOperation;
    private boolean _generateInlineQuery = false;
    boolean _cancelEnabled = CancelQuerySupport.isCancelQueryEnabledByDefault();

    public SetOperationDataSelectionImpl(AbstractBusinessModel parentBusinessModel) {
        super(parentBusinessModel);
        this._dataSelections = new ArrayList<DataSelection>();
        this._setOperation = SetOperationType.UNION;
    }

    @Override
    public void setDataSelections(List<DataSelection> dataSelections) {
        Preconditions.ensureNonNull(dataSelections, "dataSelections");
        if (dataSelections.size() == 1) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("SetOperationDataSelectionImpl.InvalidArgOneDataSelection.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(formatter);
        }
        this._dataSelections = new ArrayList<DataSelection>(dataSelections);
    }

    @Override
    public List<DataSelection> getDataSelections() {
        return this._dataSelections;
    }

    @Override
    public void setSetOperation(SetOperationType operation) {
        this._setOperation = operation;
    }

    @Override
    public SetOperationType getSetOperation() {
        return this._setOperation;
    }

    private DataSelection _getFirstDataSelection() {
        DataSelection returnValue = null;
        if (!this._dataSelections.isEmpty()) {
            returnValue = this._dataSelections.get(0);
        }
        return returnValue;
    }

    private List<Reason> _getReasonsNotValid() {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        ArrayList nonHiddenResultItems = new ArrayList();
        if (this._dataSelections.size() >= 2) {
            Reason reason;
            Iterator<DataSelection> it = this._dataSelections.iterator();
            while (it.hasNext()) {
                ArrayList<DataItem> columnResultItems = new ArrayList<DataItem>();
                DataSelection selection = it.next();
                for (SelectedItem si : selection.getSelectedItems()) {
                    Role role = si.getRole();
                    if (role == Role.COLUMN) {
                        DataItem dataItem = si.getItem();
                        columnResultItems.add(dataItem);
                        continue;
                    }
                    boolean bl = Role.isOutputResultRole(selection, role);
                    if (!bl) continue;
                    reason = new Reason((Object)this, 5, 3, "DataSourceRelationalQueryImpl.InvalidRole.txt", new Object[0]);
                    reasons.add(reason);
                }
                nonHiddenResultItems.add(columnResultItems);
            }
            DataSelection firstQuery = this._dataSelections.get(0);
            ArrayList firstQueriesItems = (ArrayList)nonHiddenResultItems.get(0);
            int expectedCount = firstQueriesItems.size();
            boolean isMatchingCounts = true;
            for (ArrayList arrayList : nonHiddenResultItems) {
                if (arrayList.size() == expectedCount) continue;
                reason = new Reason((Object)this, 5, 83, "SetOperationDataSelectionImpl.UnequalNumberNonHiddenItems.fmt.txt", this.getIdentityString());
                reasons.add(reason);
                isMatchingCounts = false;
            }
            for (int index = 0; isMatchingCounts && index < expectedCount; ++index) {
                DataItem dataItem = (DataItem)firstQueriesItems.get(index);
                int expectedType = dataItem.getExpressionType();
                int j = 0;
                for (ArrayList arrayList : nonHiddenResultItems) {
                    DataItem item = (DataItem)arrayList.get(index);
                    if (item.getExpressionType() != expectedType) {
                        Reason reason2 = new Reason((Object)this, 5, 84, "SetOperationDataSelectionImpl.TypesNotSame.fmt.txt", this.getIdentityString(), Integer.toString(j + 1), Integer.toString(index + 1), firstQuery.getIdentityString(), item.getIdentityString(), Integer.toString(expectedType), this._dataSelections.get(j).getIdentityString(), dataItem.getIdentityString(), Integer.toString(item.getExpressionType()));
                        reasons.add(reason2);
                    }
                    ++j;
                }
            }
            for (DataSelection selection : this._dataSelections) {
                if (selection.getInputStructure().isRelational()) continue;
                Reason reason2 = new Reason((Object)this, 5, 85, "SetOperationDataSelectionImpl.OnlyRelationalQueriesSupported.fmt.txt", this.getIdentityString());
                reasons.add(reason2);
            }
            boolean expectedFormatting = firstQuery.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
            for (DataSelection dataSelection : this._dataSelections) {
                if (dataSelection.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA) == expectedFormatting) continue;
                Reason reason4 = new Reason((Object)this, 5, 86, "SetOperationDataSelectionImpl.FormatsDoNotMatch.fmt.txt", this.getIdentityString());
                reasons.add(reason4);
            }
        } else {
            Reason reason = new Reason((Object)this, 5, 82, "SetOperationDataSelectionImpl.TwoSelectionsRequired.fmt.txt", this.getIdentityString());
            reasons.add(reason);
        }
        return reasons;
    }

    @Override
    public void addResultItem(DataItem dataItem, Role role) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addResultItems(List<? extends DataItem> dataItems, Role role) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addStep(StepInterface step, Role stepRole) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSelection copy() throws MetadataException {
        SetOperationDataSelection selection = DataSelectionFactory.getInstance().newSetOperationDataSelection(this.getParentBusinessModel());
        selection.setSetOperation(this._setOperation);
        selection.setDataSelections(this._dataSelections);
        return selection;
    }

    @Override
    protected void fireChangeEvent(String eventID) {
        super.fireChangeEvent(eventID);
    }

    @Override
    public BusinessModel getBusinessModel() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection == null) {
            return null;
        }
        return firstDataSelection.getBusinessModel();
    }

    @Override
    public List<FilterItem> getEffectiveFilters() {
        return this.getFilters();
    }

    @Override
    public List<DataItem> getEffectiveResultItems() {
        return this.getResultItems();
    }

    @Override
    public <T extends BusinessRule> List<T> getEffectiveRules(Class<T> type) {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection == null) {
            return Collections.emptyList();
        }
        return firstDataSelection.getEffectiveRules(type);
    }

    @Override
    public List<DataItem> getEffectiveSortOrderPrecedence() {
        return this.getSortOrderPrecedence();
    }

    @Override
    public String getEmptyDataFormat() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection == null) {
            return null;
        }
        return firstDataSelection.getEmptyDataFormat();
    }

    @Override
    public EntityInterface getEntity() {
        AggregateEntity entity = new AggregateEntity();
        if (this._dataSelections != null && this._dataSelections.size() > 2) {
            for (int index = 0; index < this._dataSelections.size(); ++index) {
                DataSelection selection = this._dataSelections.get(index);
                entity.addEntity(selection.getEntity(), Integer.toString(index));
            }
        }
        return entity.getEntityInterface();
    }

    @Override
    public PromptValuesInterface getPromptValues() {
        Locale labelLocale = LocaleUtilities.getDefaultViewerLocale(this);
        PromptGroup pGroup = new PromptGroup();
        pGroup.setPromptGroupHidden(true);
        pGroup.setPromptGroupLabel("SetOperationDataSelection PromptGroup", labelLocale);
        PromptValues values = new PromptValues((PromptGroupInterface)pGroup, null);
        if (this._dataSelections != null && this._dataSelections.size() >= 2) {
            for (int index = 0; index < this._dataSelections.size(); ++index) {
                DataSelection selection = this._dataSelections.get(index);
                PromptValuesInterface pv = selection.getPromptValues();
                values.addPromptValuesDelegate(pv);
            }
        }
        return values;
    }

    @Override
    public List<FilterItem> getFilters() {
        return new ArrayList<FilterItem>();
    }

    @Override
    public StructureOfData getInputStructure() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection == null) {
            StructureOfData inputStructure = new StructureOfData();
            return inputStructure;
        }
        return firstDataSelection.getInputStructure();
    }

    @Override
    public DataSelection getParentDataSelection() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection == null) {
            return null;
        }
        return firstDataSelection.getParentDataSelection();
    }

    @Override
    public BusinessQuery getParentQuery() {
        return null;
    }

    @Override
    public boolean getQueryProperty(BusinessQueryProperty key) {
        boolean result = false;
        if (key == BusinessQueryProperty.RETURN_UNFORMATTED_DATA) {
            DataSelection firstDataSelection = this._getFirstDataSelection();
            if (firstDataSelection != null) {
                result = firstDataSelection.getQueryProperty(key);
            }
        } else if (key == BusinessQueryProperty.RETURN_DISTINCT_VALUES) {
            if (this._setOperation != SetOperationType.UNION_ALL) {
                result = true;
            }
        } else if (key == BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION) {
            result = this._generateInlineQuery;
        }
        return result;
    }

    @Override
    protected void accumulateReasonsNotPersistable(List<Reason> reasons) {
        super.accumulateReasonsNotPersistable(reasons);
        for (DataSelection ds : this._dataSelections) {
            reasons.addAll(ds.getReasonsNotPersistable());
        }
    }

    @Override
    public List<Reason> getReasonsNotValid() {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        if (this.hasCycleInDownwardDefinition()) {
            reasons.add(new Reason((Object)this, 2, 200, "AbstractModelItem.ObjectHasCycleInItsDefinition.fmt.txt", this.getIdentityString()));
        } else {
            for (DataSelection ds : this._dataSelections) {
                List<Reason> moreReasons = ds.getReasonsNotValid();
                reasons.addAll(moreReasons);
            }
            reasons.addAll(this._getReasonsNotValid());
        }
        return reasons;
    }

    @Override
    public BusinessModelReferenceInfo getReferenceInfo() {
        return new BusinessModelReferenceInfoImpl(this, this.getID());
    }

    @Override
    public <T extends BusinessRule> List<T> getRelevantRules(Class<T> type) {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection == null) {
            return new ArrayList();
        }
        return firstDataSelection.getRelevantRules(type);
    }

    @Override
    public Role getResultItemRole(DataItem dataItem) throws MetadataException {
        Role resultItemRole = null;
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            resultItemRole = firstDataSelection.getResultItemRole(dataItem);
        }
        return resultItemRole;
    }

    @Override
    public List<DataItem> getResultItems() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        List<DataItem> resultItems = firstDataSelection != null ? firstDataSelection.getResultItems() : new ArrayList<DataItem>();
        return resultItems;
    }

    @Override
    public List<SelectedItem> getSelectedItems() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        List<SelectedItem> resultItems = firstDataSelection != null ? firstDataSelection.getSelectedItems() : new ArrayList<SelectedItem>();
        return resultItems;
    }

    @Override
    public List<DataItem> getResultItems(Role withThisRole) throws MetadataException {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        List<DataItem> resultItems = firstDataSelection != null ? firstDataSelection.getResultItems(withThisRole) : new ArrayList<DataItem>();
        return resultItems;
    }

    @Override
    public List<SelectedItem> getSelectedItems(Role withThisRole) throws MetadataException {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        List<SelectedItem> resultItems = firstDataSelection != null ? firstDataSelection.getSelectedItems(withThisRole) : new ArrayList<SelectedItem>();
        return resultItems;
    }

    @Override
    public int getResultSetIndex(String dataItemID) {
        int index = -1;
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            index = firstDataSelection.getResultSetIndex(dataItemID);
        }
        return index;
    }

    @Override
    public List<DataItem> getSolveOrderPrecedence() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        List<DataItem> solveOrder = firstDataSelection != null ? firstDataSelection.getSolveOrderPrecedence() : new ArrayList<DataItem>();
        return solveOrder;
    }

    @Override
    public List<Object> getSortCriteria(Role businessSortRole) {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        List<Object> sortCriteria = firstDataSelection != null ? firstDataSelection.getSortCriteria(businessSortRole) : new ArrayList<Object>();
        return sortCriteria;
    }

    @Override
    public BusinessQueryActionType getSortDirection(Role businessSortRole) {
        BusinessQueryActionType sortDirection = BusinessQueryActionType.SORT_NONE;
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            sortDirection = firstDataSelection.getSortDirection(businessSortRole);
        }
        return sortDirection;
    }

    @Override
    public List<DataItem> getSortItems() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        List<DataItem> sortItems = firstDataSelection != null ? firstDataSelection.getSortItems() : new ArrayList<DataItem>();
        return sortItems;
    }

    @Override
    public List<DataItem> getSortOrderPrecedence() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        List<DataItem> sortOrder = firstDataSelection != null ? firstDataSelection.getSortOrderPrecedence() : new ArrayList<DataItem>();
        return sortOrder;
    }

    @Override
    public StepInterface getStep(int stepNumber, Role stepRole) {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        StepInterface step = firstDataSelection != null ? firstDataSelection.getStep(stepNumber, stepRole) : null;
        return step;
    }

    @Override
    public List<StepInterface> getSteps(Role stepRole) {
        ArrayList<StepInterface> steps = new ArrayList<StepInterface>();
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            steps.addAll(firstDataSelection.getSteps(stepRole));
        }
        return steps;
    }

    @Override
    public String getTotalLabel(Role businessTotalRole, String typeOfTotal) {
        String label = null;
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            label = firstDataSelection.getTotalLabel(businessTotalRole, typeOfTotal);
        }
        return label;
    }

    @Override
    public BusinessQueryTotalLocationType getTotalLocation() {
        BusinessQueryTotalLocationType totalLocation = null;
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            totalLocation = firstDataSelection.getTotalLocation();
        }
        return totalLocation;
    }

    @Override
    public BusinessQueryTotalModeType getTotalMode() {
        BusinessQueryTotalModeType totalMode = null;
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            totalMode = firstDataSelection.getTotalMode();
        }
        return totalMode;
    }

    @Override
    public String getTotalType(Role businessTotalRole) {
        TotalingType totalingType = TotalingType.TOTAL_NONE;
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            totalingType = firstDataSelection.getTotalingType(businessTotalRole);
        }
        return totalingType == null ? null : totalingType.toString();
    }

    @Override
    public List<BusinessQueryActionType> getValidActions() {
        ArrayList<BusinessQueryActionType> returnList = new ArrayList<BusinessQueryActionType>();
        returnList.add(BusinessQueryActionType.PROPERTY_INLINE_SETOPERATIONDATASELECTION);
        return returnList;
    }

    @Override
    public void initialize(BusinessModel baseModel) {
    }

    @Override
    public LookThroughDataSelection insertNewChild(List aboveTheseChildren) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LookThroughDataSelection insertNewChild(LookThroughDataSelection currentChildDS) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertResultItemsAt(DataItem dataItem, Role role, int index) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertSelectedItemAt(SelectedItem item, int index) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isActionSupported(BusinessQueryActionType actionType) {
        boolean supported = actionType == BusinessQueryActionType.PROPERTY_INLINE_SETOPERATIONDATASELECTION;
        return supported;
    }

    @Override
    public boolean isValid() {
        return this.getReasonsNotValid().size() == 0;
    }

    @Override
    public void removeChildAndCollapse(LookThroughDataSelection child) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeResultItem(DataItem dataItem) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSelectedItem(SelectedItem item) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeResultItems(List<? extends DataItem> dataItems) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeStep(int stepNumber, Role stepRole) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String retrieveStrategyClassName() {
        String strategyClassName = "com.sas.iquery.strategies.sas.oma.relational.RelationalStrategy";
        return strategyClassName;
    }

    @Override
    public void setActionSupported(BusinessQueryActionType actionType, boolean actionSupported) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmptyDataFormat(String replacementString) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFilters(List<? extends FilterItem> inputFilters) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQueryProperty(BusinessQueryProperty key, boolean value) throws MetadataException {
        if (key != BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION) {
            throw new UnsupportedOperationException();
        }
        this._generateInlineQuery = value;
        this.fireChangeEvent("A query property has changed");
    }

    @Override
    public void setResultItemRole(DataItem dataItem, Role role) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setResultItems(List<? extends DataItem> dataItems) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedItems(List<? extends SelectedItem> newSelectedItems) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSolveOrderPrecedence(List<? extends DataItem> solveOrderPrecedence) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSortCriteria(List<? extends Object> criteria, Role businessSortRole) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSortDirection(BusinessQueryActionType sortDirection, Role businessSortRole) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSortOrderPrecedence(List<? extends DataItem> inputPrecedence) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSteps(List<StepInterface> setOfSteps, Role stepRole) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTotalLabel(String totalLabel, Role businessTotalRole, String typeOfTotal) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTotalType(String totalingType, Role businessTotalRole) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTotalLocation(BusinessQueryTotalLocationType totalLocation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTotalMode(BusinessQueryTotalModeType totalMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAxisValuesCoalesced(boolean indicator) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getDefinitionElementName() {
        return "SetOperationDataSelection";
    }

    @Override
    public synchronized void addBusinessItem(BusinessItem businessItem) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void addBusinessItem(int index, BusinessItem businessItem) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBusinessRule(BusinessRule rule) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBusinessRule(int index, BusinessRule rule) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDataSource(DataSource dataSource) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDataSource(int index, DataSource dataSource) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(boolean includeBaseModels, BusinessModelObject businessModelObject) {
        return super.contains(includeBaseModels, businessModelObject);
    }

    @Override
    public boolean contains(BusinessModelObject businessModelObject) {
        return super.contains(businessModelObject);
    }

    @Override
    public String generateIntraModelID(String proposedID) {
        return super.generateIntraModelID(proposedID);
    }

    @Override
    public BusinessModel getBaseModel() {
        return super.getBaseModel();
    }

    @Override
    public List<String> getBaseModelIDs() {
        return super.getBaseModelIDs();
    }

    @Override
    public BusinessItem getBusinessItemByID(String id) throws MetadataException {
        return super.getBusinessItemByID(id);
    }

    @Override
    public BusinessRule getBusinessRuleByID(String id) throws MetadataException {
        return super.getBusinessRuleByID(id);
    }

    @Override
    public List getChildren() {
        return super.getChildren();
    }

    @Override
    public DataSource getDataSourceByID(String id) throws MetadataException {
        return super.getDataSourceByID(id);
    }

    @Override
    public List getDescendents() {
        return super.getDescendents();
    }

    @Override
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    public String getFamilyStateDebugString() {
        return super.getFamilyStateDebugString();
    }

    @Override
    public String getID() {
        return super.getID();
    }

    @Override
    public String getLabel() {
        return super.getLabel();
    }

    @Override
    public IntelligentQueryMetadataServiceInterface getMetadataService() {
        return super.getMetadataService();
    }

    @Override
    public synchronized <T> List<T> getObjects(boolean includeBaseModels, @Nonnull Class<T> type) {
        return super.getObjects(includeBaseModels, type);
    }

    @Override
    public <T> List<T> getObjects(int flags, Class<T> type) {
        ArrayList<T> objects = new ArrayList<T>();
        for (DataSelection ds : this._dataSelections) {
            objects.addAll(ds.getObjects(flags, type));
        }
        return objects;
    }

    @Override
    public <T extends BusinessModelObject> List<T> getObjectsBasedOn(BusinessModelObject baseObject, Class<T> type) throws MetadataException {
        return super.getObjectsBasedOn(baseObject, type);
    }

    @Override
    public synchronized <T extends BusinessModelObject> List<T> getObjectsWithInvalidIDs(@Nonnull Class<T> type) {
        return super.getObjectsWithInvalidIDs(type);
    }

    @Override
    public BusinessModel getParentBusinessModel() {
        return super.getParentBusinessModel();
    }

    @Override
    public List<Reason> getReasonsUnusable() {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        if (this.hasCycleInDownwardDefinition()) {
            reasons.add(new Reason((Object)this, 2, 200, "AbstractModelItem.ObjectHasCycleInItsDefinition.fmt.txt", this.getIdentityString()));
        } else {
            for (DataSelection ds : this._dataSelections) {
                reasons.addAll(ds.getReasonsUnusable());
            }
        }
        return reasons;
    }

    @Override
    public <T> List<T> getResources(Class<T> type, int flags) {
        ArrayList<T> resources = new ArrayList<T>();
        for (DataSelection ds : this._dataSelections) {
            resources.addAll(ds.getResources(type, flags));
        }
        return resources;
    }

    @Override
    public <T> List<T> getResources(Class<T> type) {
        return super.getResources(type);
    }

    @Override
    public ServerProperties getServerProperties() throws MetadataException {
        return super.getServerProperties();
    }

    @Override
    public SessionContextInterface getSession() {
        return super.getSession();
    }

    @Override
    public StructureOfData getStructure() {
        return super.getStructure();
    }

    @Override
    public List<BusinessModelResource> getUnresolvedResources() {
        return super.getUnresolvedResources();
    }

    @Override
    public boolean isDataSourceCompatible(DataSource dataSource) {
        return false;
    }

    @Override
    public boolean isIntraModelIDInUse(String ID) {
        return super.isIntraModelIDInUse(ID);
    }

    @Override
    public boolean isLegalID(String ID) {
        return super.isLegalID(ID);
    }

    @Override
    public boolean isPersistable() {
        return super.isPersistable();
    }

    @Override
    public boolean isReadOnly() {
        return super.isReadOnly();
    }

    @Override
    public boolean isUsableInQuery() {
        return super.isUsableInQuery();
    }

    @Override
    public boolean isValidLabel(String label) {
        return super.isValidLabel(label);
    }

    @Override
    public CompoundFilter newCompoundFilter() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAxisValuesCoalesced() {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            return firstDataSelection.isAxisValuesCoalesced();
        }
        return false;
    }

    @Override
    public RootDataItem newDataItem() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RootDataItem newDataItem(PhysicalResource physicalResource, Properties options) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataItemReference newDataItemReference(DataItem baseDataItem) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    public DataSourceCube newDataSourceCube(SASOlapServer server, CubeContainer schema, Cube cube) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSourceTable newDataSourceTable(RelationalServer server, RelationalSchema accessingSchema, Table table) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DrillThroughToDetail newDrillThroughToDetail() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterItem newFilterItem() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Governing newGoverning() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Join newJoin() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Prompt newPrompt() throws MetadataException {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection == null) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RunStoredProcess newRunStoredProcess() throws MetadataException {
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public synchronized List<BusinessItem> removeBusinessItem(BusinessItem businessItem) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BusinessRule> removeBusinessRule(BusinessRule rule) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeChild(BusinessModel child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BusinessModelObject> removeDataSource(DataSource dataSource) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel businessModel) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel businessModel, boolean recursive) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, boolean recursive) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setBusinessItems(List<BusinessItem> businessItemsToSet) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
    }

    @Override
    public void setID(String ID) throws MetadataException {
        super.setID(ID);
    }

    @Override
    public void setLabel(String label) throws MetadataException {
        super.setLabel(label);
    }

    @Override
    public void setReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this._setOperation.toString();
    }

    @Override
    public <T extends BusinessModelObject> List<T> getObjectsBasedOn(PhysicalResource baseResource, Class<T> type) throws MetadataException {
        return super.getObjectsBasedOn(baseResource, type);
    }

    @Override
    public DataSourceCube newDataSourceCube(AccessPathToOlapData accessPath, Cube cube) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSourceCube newDataSourceCube(OlapServer server, OlapSchema schema, Cube cube) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSourceRelationalQuery newDataSourceRelationalQuery(BusinessQuery businessQuery) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSourceTable newDataSourceTable(AccessPath accessPath, Table table) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends BusinessModelResource> List<T> getQueryResources(Class<T> type, int flags) {
        return new ArrayList();
    }

    @Override
    public void addListener(PropertyChangeListener listener) {
        super.addListener(listener);
    }

    @Override
    public void removeListener(PropertyChangeListener listener) {
        super.removeListener(listener);
    }

    @Override
    public List<PropertyChangeListener> getListeners() {
        return super.getListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    @Override
    public List<DataSource> getEffectiveDataSources() throws MetadataException {
        ArrayList<DataSource> combinedDataSources = new ArrayList<DataSource>();
        for (DataSelection selection : this._dataSelections) {
            List<DataSource> selectionsDataSources = selection.getEffectiveDataSources();
            Utils.addButNoDuplicates(combinedDataSources, selectionsDataSources);
        }
        return combinedDataSources;
    }

    @Override
    public List<Join> getEffectiveJoinPath() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractModelReference getModelReference() throws MetadataException {
        return null;
    }

    @Override
    protected void replaceDirectReferences(Object replaceThis, Object withThis) {
    }

    @Override
    protected void clearReferencesToModelItems() {
        super.clearReferencesToModelItems();
        CancelQuerySupport.unRegisterQuery(this);
        if (this._dataSelections != null) {
            this._dataSelections.clear();
        }
    }

    @Override
    protected void accumulateDirectlyReferencedModelsInDownwardDefinition(List<? super Model> intoList) {
        super.accumulateDirectlyReferencedModelsInDownwardDefinition(intoList);
        if (this._dataSelections != null) {
            intoList.addAll(this._dataSelections);
        }
    }

    @Override
    public boolean isCancelEnabled() {
        return this._cancelEnabled;
    }

    @Override
    public void setCancelEnabled(boolean enable) {
        if (!enable) {
            CancelQuerySupport.unRegisterQuery(this);
        }
        this._cancelEnabled = enable;
    }

    @Override
    protected void resolveExternalDependenciesV1(ReadingContext resolutionContext) throws MetadataException {
    }

    @Override
    public FilterCascadeRule newFilterCascadeRule() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CascadeRuleSet getCascadeRuleSet() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> write(Element parentElement, Map<QueryWriteOption, Object> writeOptions) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        return null;
    }

    @Override
    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
    }

    @Override
    public void setGroups(List<BusinessGroup> group) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BusinessGroup> getGroups() {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroups() {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsByType(BusinessGroup.Type type) {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsContaining(BusinessModelObject bi, BusinessGroup.Type type) {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsContaining(BusinessModelObject bi) {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public List<BusinessGroup> getGroupsContaining(BusinessModelObject bmObject, BusinessGroup.Type type) {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public void setTotalingType(TotalingType totalingType, Role businessTotalRole) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TotalingType getTotalingType(Role businessTotalRole) {
        TotalingType totalingType = TotalingType.TOTAL_NONE;
        DataSelection firstDataSelection = this._getFirstDataSelection();
        if (firstDataSelection != null) {
            totalingType = firstDataSelection.getTotalingType(businessTotalRole);
        }
        return totalingType;
    }
}

