/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RequiredDataSourcesImpl
extends AbstractBusinessModelObject
implements RequiredDataSources {
    private List<DataSource> _dataSources;
    public static final String EVENT_REQUIRED_DATA_SOURCES_CHANGED = "The Required Data Sources rule's list of data sources changed.";

    public RequiredDataSourcesImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    public RequiredDataSourcesImpl() {
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "RDS_";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RequiredDataSourcesImpl clone = (RequiredDataSourcesImpl)super.clone();
        clone._dataSources = ListUtils.newList(this._dataSources);
        return clone;
    }

    @Override
    public List<DataSource> getDataSources() throws MetadataException {
        return ListUtils.newList(this._dataSources);
    }

    @Override
    public void setDataSources(List<? extends DataSource> dataSources) throws MetadataException {
        this.changeableCheck();
        this._dataSources = ListUtils.newList(dataSources);
        Preconditions.ensureNonNullTypedElements(this._dataSources, DataSource.class);
        this.fireChangeEvent(EVENT_REQUIRED_DATA_SOURCES_CHANGED);
    }

    @Override
    protected String getDefinitionElementName() {
        return "RequiredDataSources";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        RequiredDataSourcesImpl.writeRelatedObjects(this._dataSources, thisElement, writingContext, "DataSources");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._dataSources = riHolder.consumeObjects("DataSources", DataSource.class);
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._dataSources = RequiredDataSourcesImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "DataSourceList", new Class[]{DataSource.class});
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        for (int i = 0; i < this._dataSources.size(); ++i) {
            DataSource dataSource = this._dataSources.get(i);
            dataSource = (DataSource)Utils.replaceResource(dataSource, oldResource, newResource, model, recursive);
            this._dataSources.set(i, dataSource);
        }
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this._dataSources != null) {
            intoList.addAll(this._dataSources);
        }
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        RequiredDataSourcesImpl.replaceInList(this._dataSources, oldObject, newObject);
    }
}

