/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.Base;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.ObjectProvider;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

final class RelatedObjectList {
    private String _relationshipName;
    private final ArrayList<Object> _relatedObjects;

    RelatedObjectList(String relationshipName) {
        this._relationshipName = relationshipName;
        this._relatedObjects = new ArrayList();
    }

    RelatedObjectList(String relationshipName, List<? extends Object> initialList) {
        this._relationshipName = relationshipName;
        this._relatedObjects = new ArrayList<Object>(initialList);
    }

    void reinitialize(String relationshipName) {
        this._relationshipName = relationshipName;
        this._relatedObjects.clear();
    }

    String getRelationshipName() {
        return this._relationshipName;
    }

    void add(Base obj) {
        if (!(obj instanceof ReadingContextV2.UnrecognizedItem)) {
            this._relatedObjects.add(obj);
        }
    }

    void add(ObjectProvider adapter) {
        this._relatedObjects.add(adapter);
    }

    AbstractBase getObject() throws SAXException {
        AbstractBase out = null;
        int size = this._relatedObjects.size();
        if (size == 1) {
            out = (AbstractBase)this._relatedObjects.get(0);
        } else if (size > 1) {
            String msg = IQMetadataResourceBundle.getMessageString("RelatedObjectList.CardinalityError.fmt.txt", this._relationshipName);
            throw new SAXException(msg);
        }
        return out;
    }

    Object getForeignObject() throws SAXException {
        Object out = null;
        int size = this._relatedObjects.size();
        if (size == 1) {
            ObjectProvider adapter = (ObjectProvider)this._relatedObjects.get(0);
            out = adapter.getObject();
        } else if (size > 1) {
            String msg = IQMetadataResourceBundle.getMessageString("RelatedObjectList.CardinalityError.fmt.txt", this._relationshipName);
            throw new SAXException(msg);
        }
        return out;
    }

    List<Object> getObjects() {
        return new ArrayList<Object>(this._relatedObjects);
    }
}

