/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelReference;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.PersistenceProvider;
import com.sas.iquery.metadata.business.impl.ReadFactoryV2;
import com.sas.iquery.metadata.business.impl.StructuredExternalResources;
import com.sas.iquery.metadata.business.impl.V2ResourceResolver;
import com.sas.iquery.metadata.business.impl.thread.ThreadPool;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.IntegratedReadingContext;
import com.sas.util.xmlpersist.PromptsReadingContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ReadingContextV2 {
    private AbstractModel _modelBeingRead;
    private HashMap<String, AbstractBase> _regularItemsRefdByPersistenceID = new HashMap();
    private HashMap<String, AbstractBase> _unresolvedForwardReferencesWithinModel = new HashMap(40);
    private StructuredExternalResources _structuredUnresolvedExternalResources;
    private V2ResourceResolver _resolver;
    private ArrayList<AbstractBase> _allObjsCreated = new ArrayList(100);
    private DataItemActionType _diUsageWhenMissing = null;
    private ReadingContextV2 _outerModelContext;
    private ArrayList<ReadingContextV2> _immediateInnerModelContexts = new ArrayList();
    private XMLWideReadingContext _xmlWideContext;
    private Element _embeddedDataElement;
    private boolean _doResolveExternalResources = true;
    private IQIntegratedReadingContext _integratedReadingContext;
    private LoggerFactoryInterface _promptsLogger;
    private PromptsReadingContext _reusedPromptsReadingContext;
    private List _associatedPromptSmartObjects;
    private ArrayList<DataSourceTableImpl2.ReadModification> _dstReadMods;
    private MetadataServerInterface _metadataServer;
    private static final Logger _logger = LogManager.getLogger(ReadingContextV2.class);
    private static final Logger _perfRFSLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.summary");
    private static final ReadFactoryV2 readFactory = ReadFactoryV2.getInstance();
    private static final boolean ENABLE_ASYNCHRONOUS_RESOLUTION = true;

    public ReadingContextV2(AbstractModel modelBeingRead) {
        this(modelBeingRead, (MetadataServerInterface)null);
    }

    public ReadingContextV2(AbstractModel modelBeingRead, MetadataServerInterface metadataServer) {
        this._metadataServer = metadataServer;
        this._modelBeingRead = modelBeingRead;
        this._xmlWideContext = new XMLWideReadingContext();
    }

    public ReadingContextV2(AbstractModel modelBeingRead, Element embeddedDataElement) {
        this(modelBeingRead);
        this._embeddedDataElement = embeddedDataElement;
    }

    private ReadingContextV2(AbstractModel enclosedModelBeingRead, ReadingContextV2 outerModelContext) {
        this._modelBeingRead = enclosedModelBeingRead;
        this._outerModelContext = outerModelContext;
        this._xmlWideContext = outerModelContext._xmlWideContext;
    }

    MetadataServerInterface getMetadataServer() throws MetadataException {
        MetadataServerInterface out = this._metadataServer;
        if (out == null) {
            out = this._modelBeingRead.getAuthServer();
        }
        return out;
    }

    LoggerFactoryInterface getPromptsLogger() {
        if (this._promptsLogger == null) {
            SessionContextInterface session = this._modelBeingRead.getSession();
            this._promptsLogger = PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)session);
        }
        return this._promptsLogger;
    }

    private PromptsReadingContext newPromptsReadingContext() throws SAXException {
        PromptsReadingContext out = null;
        try {
            if (this._integratedReadingContext == null) {
                this._integratedReadingContext = new IQIntegratedReadingContext(this);
                this._integratedReadingContext.setServer(this.getMetadataServer());
            }
            SessionContextInterface session = this._modelBeingRead.getSession();
            UserContextInterface userContext = session.getUserContext();
            out = PersistenceFactoryWithServices.newReadingContext((UserContextInterface)userContext, (IntegratedReadingContext)this._integratedReadingContext);
        }
        catch (IllegalStateException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
        catch (RemoteException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
        catch (MetadataException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
        return out;
    }

    PromptsReadingContext getReusedPromptsReadingContext() throws SAXException {
        if (this._reusedPromptsReadingContext == null) {
            this._reusedPromptsReadingContext = this.newPromptsReadingContext();
        }
        return this._reusedPromptsReadingContext;
    }

    ReadingContextV2 newInnerModelContext(AbstractModel innerModel) {
        ReadingContextV2 out = new ReadingContextV2(innerModel, this);
        this._immediateInnerModelContexts.add(out);
        return out;
    }

    ReadingContextV2 getOuterModelContext() {
        return this._outerModelContext;
    }

    ArrayList<ReadingContextV2> trustedGetImmediateInnerModelContexts() {
        return this._immediateInnerModelContexts;
    }

    public AbstractModel getModelBeingRead() {
        return this._modelBeingRead;
    }

    public AbstractBase getObjectForUsedObjectElement(String useOfType, String persistenceID, boolean allowReturningUnrecognizedObject) {
        AbstractBase out = this._regularItemsRefdByPersistenceID.get(persistenceID);
        if (out == null && (out = this._unresolvedForwardReferencesWithinModel.get(persistenceID)) == null) {
            out = this.newForwardReferenceObject(useOfType, persistenceID, allowReturningUnrecognizedObject);
        }
        return out;
    }

    private AbstractBase getNewRegularObject(String type, String persistenceID) {
        AbstractBase out = this.newObject(type);
        if (persistenceID != null && out != null) {
            this._regularItemsRefdByPersistenceID.put(persistenceID, out);
        }
        return out;
    }

    private AbstractBase newForwardReferenceObject(String type, String persistenceID, boolean allowReturningUnrecognizedObject) {
        AbstractBase out = this.newObject(type);
        if (out == null && allowReturningUnrecognizedObject) {
            out = this.newUnrecognizedItem(persistenceID);
            if (_logger.isEnabled(Level.WARN)) {
                String msg = IQModelImplUtilities.getMessage("XMLV2ModelHandler.UnrecognizedElementName.fmt.txt", type);
                _logger.warn(msg);
            }
        }
        if (out != null) {
            this._unresolvedForwardReferencesWithinModel.put(persistenceID, out);
        }
        return out;
    }

    private AbstractBase newObject(String type) {
        AbstractBase out = readFactory.newObject(type);
        if (out != null) {
            out.setModel(this._modelBeingRead);
            this._allObjsCreated.add(out);
        }
        return out;
    }

    private AbstractBase findAndUseForwardReferenceAsRegularObject(String persistenceID) {
        AbstractBase out = this._unresolvedForwardReferencesWithinModel.remove(persistenceID);
        if (out != null) {
            this._regularItemsRefdByPersistenceID.put(persistenceID, out);
        }
        return out;
    }

    public void notePersistenceIDOfModelBeingRead(AbstractModel model, String persistenceID) {
        if (persistenceID != null) {
            this._regularItemsRefdByPersistenceID.put(persistenceID, model);
        }
    }

    public AbstractBase getObjectForNewObjectElement(String persistenceID, String elementName) throws SAXException {
        AbstractBase obj = null;
        if (persistenceID != null) {
            obj = this.findAndUseForwardReferenceAsRegularObject(persistenceID);
        }
        if (obj == null) {
            obj = this.getNewRegularObject(elementName, persistenceID);
        }
        return obj;
    }

    AbstractModelItem newUnrecognizedItem(String persistenceID) {
        UnrecognizedItem out = new UnrecognizedItem();
        if (persistenceID != null) {
            this._regularItemsRefdByPersistenceID.put(persistenceID, out);
        }
        return out;
    }

    public void reportUnresolvedExternalResources(List topLevelExternalResources) throws SAXException {
        this._structuredUnresolvedExternalResources = new StructuredExternalResources(this._modelBeingRead);
        this._structuredUnresolvedExternalResources.initializeWithUnresolvedResources(topLevelExternalResources);
        if (this._outerModelContext == null) {
            this.startResolution();
        } else {
            ExtraLoggingContexts.debugLogReadFlowSummary("Delaying resolution for an inner model's external resources until outer models are fully populated ...");
        }
    }

    void reportExternalAssociatedPromptsReferenced(List<PersistenceProvider.PersistenceProviderForAssociatedPrompt> associatedPrompts) throws SAXException {
        try {
            PromptsReadingContext prc = this.newPromptsReadingContext();
            HashMap<String, PromptDefinitionInterface> availableObjects = new HashMap<String, PromptDefinitionInterface>();
            if (this._associatedPromptSmartObjects != null) {
                for (int i = 0; i < this._associatedPromptSmartObjects.size(); ++i) {
                    OMRPromptDefinitionInterface omrPrompt = (OMRPromptDefinitionInterface)this._associatedPromptSmartObjects.get(i);
                    String promptPersistenceID = this.getPromptPersistenceID(omrPrompt);
                    PromptDefinitionInterface realPromptDefinition = PromptsPersistUtil.getPromptDefinitionFromSmartObject((OMRPromptDefinitionInterface)omrPrompt, (PromptsReadingContext)prc, (SessionContextInterface)this._modelBeingRead.getSession());
                    availableObjects.put(promptPersistenceID, realPromptDefinition);
                }
            }
            HashMap<AbstractBase, String> objectToPersistenceID = this.reverseUniqueValuedMap(this._regularItemsRefdByPersistenceID);
            for (PersistenceProvider.PersistenceProviderForAssociatedPrompt pp : associatedPrompts) {
                String persistenceID = (String)objectToPersistenceID.get(pp);
                PromptDefinitionInterface realPromptDefinition = (PromptDefinitionInterface)availableObjects.get(persistenceID);
                pp.setPrompt(realPromptDefinition);
            }
        }
        catch (RemoteException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
        catch (ServiceException e) {
            SAXException se = new SAXException((Exception)((Object)e));
            se.initCause(e);
            throw se;
        }
    }

    private HashMap<AbstractBase, String> reverseUniqueValuedMap(HashMap<String, AbstractBase> map) {
        HashMap<AbstractBase, String> out = new HashMap<AbstractBase, String>();
        for (Map.Entry<String, AbstractBase> entry : map.entrySet()) {
            out.put(entry.getValue(), entry.getKey());
        }
        return out;
    }

    private String getPromptPersistenceID(OMRPromptDefinitionInterface omrPrompt) throws RemoteException, SAXException {
        String promptName = omrPrompt.getName();
        if (!promptName.startsWith("Private Prompt. ID in XML: ")) {
            throw new SAXException(IQModelImplUtilities.getMessage("ReadingContextV2.InvalidPrivatePromptName.fmt.txt", promptName, "Private Prompt. ID in XML: "));
        }
        String promptPersistenceID = promptName.substring("Private Prompt. ID in XML: ".length());
        return promptPersistenceID;
    }

    private void startResolution() {
        this._resolver = new V2ResourceResolver(this._structuredUnresolvedExternalResources, this);
        this._resolver.setDoResolve(this._doResolveExternalResources);
        ExtraLoggingContexts.debugLogReadFlowSummary("starting resolution ...");
        if (this._modelBeingRead instanceof InformationMap) {
            ThreadPool.instance().executeAsynchronously(this._resolver);
        } else {
            this._resolver.run();
        }
    }

    public List<AbstractBase> trustedGetObjsCreatedDuringRead() {
        return this._allObjsCreated;
    }

    private boolean hasExternalResources() {
        return this._structuredUnresolvedExternalResources != null;
    }

    private boolean isResolutionStarted() {
        return this._resolver != null;
    }

    List replaceExternalResourcesWithinModel() throws MetadataException {
        ArrayList out = new ArrayList();
        if (this.hasExternalResources()) {
            this.finishExternalResourceResolution();
            ExtraLoggingContexts.debugLogReadFlowSummary("start bound resource replacement");
            IdentityHashMap resourceMapping = this._resolver.trustedGetResourceMapping();
            this.replaceUnresolvedResourcesWithResolvedResources(resourceMapping);
            out.addAll(this._resolver.getResourcesNotResolved());
            ExtraLoggingContexts.debugLogReadFlowSummary("end   bound resource replacement");
        }
        return out;
    }

    private void finishExternalResourceResolution() throws MetadataException {
        if (!this.isResolutionStarted()) {
            this.startResolution();
        }
        this.waitForResolutionToBeDone();
        Exception exceptionDuringResolution = this._resolver.getExceptionWhileRunning();
        if (exceptionDuringResolution != null) {
            SAXException e;
            ExtraLoggingContexts.debugLogReadFlowSummary("Exception occurred during resource resolution and is being thrown now by our main thread!!");
            MessageFormatter message = null;
            if (exceptionDuringResolution instanceof SAXException && (e = (SAXException)exceptionDuringResolution).getException() != null) {
                message = IQModelImplUtilities.getMessageFormatter(e.getException());
            }
            throw new MetadataException(message, (Throwable)exceptionDuringResolution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResolutionToBeDone() throws MetadataException {
        if (this.isResolutionStarted() && !this._resolver.isDone()) {
            long startWait = 0L;
            if (_perfRFSLogger.isDebugEnabled()) {
                startWait = System.currentTimeMillis();
                ExtraLoggingContexts.debugLogReadFlowSummary("Waiting for resolution to be done ...");
            }
            V2ResourceResolver v2ResourceResolver = this._resolver;
            synchronized (v2ResourceResolver) {
                try {
                    while (!this._resolver.isDone()) {
                        this._resolver.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new MetadataException(e);
                }
                if (_perfRFSLogger.isDebugEnabled()) {
                    long endWait = System.currentTimeMillis();
                    ExtraLoggingContexts.debugLogReadFlowSummary("Done waiting for resolution (waited " + (endWait - startWait) + "ms).");
                }
            }
        }
    }

    private void replaceUnresolvedResourcesWithResolvedResources(IdentityHashMap resourceMapping) throws MetadataException {
        int allSize = this._allObjsCreated.size();
        ArrayList<AbstractBase> objectsThatMayReferenceResources = new ArrayList<AbstractBase>(allSize + 1);
        for (AbstractBase obj : this._allObjsCreated) {
            if (obj.isUnresolved()) continue;
            objectsThatMayReferenceResources.add(obj);
        }
        if (IQModelImplUtilities.firstIndexOfUsingEqualsEquals(objectsThatMayReferenceResources, this._modelBeingRead) == -1) {
            objectsThatMayReferenceResources.add(this._modelBeingRead);
        }
        ArrayList workingList = new ArrayList();
        int size = objectsThatMayReferenceResources.size();
        for (int i = 0; i < size; ++i) {
            AbstractBase obj = (AbstractBase)objectsThatMayReferenceResources.get(i);
            workingList.clear();
            obj.accumulateDirectlyReferencedBaseObjects(workingList);
            int workingSize = workingList.size();
            for (int j = 0; j < workingSize; ++j) {
                Object workingObject = workingList.get(j);
                if (workingObject instanceof AbstractBase) {
                    AbstractBase refdObj = (AbstractBase)workingObject;
                    AbstractBase shouldReplaceWith = (AbstractBase)resourceMapping.get(refdObj);
                    if (shouldReplaceWith == null || refdObj == shouldReplaceWith) continue;
                    obj.replaceDirectReferences(refdObj, shouldReplaceWith);
                    continue;
                }
                if (workingObject == null) continue;
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("ReadingContextV2.UnexpectedObjectTypeFound.fmt.txt", workingObject.getClass().getName()));
            }
        }
    }

    public void setModelsToReuse(Map<BusinessModelReferenceInfo, AbstractModel> modelsToReuse) {
        if (modelsToReuse == null) {
            modelsToReuse = new HashMap<BusinessModelReferenceInfo, AbstractModel>();
        }
        this._xmlWideContext._modelsToReuse = modelsToReuse;
    }

    public Map<BusinessModelReferenceInfo, AbstractModel> getModelsToReuse() {
        return this._xmlWideContext._modelsToReuse;
    }

    public Document getDocToReuseForReadingEntities() throws SAXException {
        if (this._xmlWideContext._reuseEntitiesDoc == null) {
            try {
                this._xmlWideContext._reuseEntitiesDoc = IQModelImplUtilities.newDocument();
            }
            catch (MetadataException e) {
                SAXException se = new SAXException(e);
                se.initCause(e);
                throw se;
            }
        }
        return this._xmlWideContext._reuseEntitiesDoc;
    }

    public DataItemActionType getDataItemUsageWhenMissing() {
        return this._diUsageWhenMissing;
    }

    public void setDataItemUsageWhenMissing(DataItemActionType usage) {
        this._diUsageWhenMissing = usage;
    }

    public void verifyNoForwardReferencesRemaining() throws SAXException {
        int unresolvedForwardReferenceCount = this._unresolvedForwardReferencesWithinModel.size();
        if (unresolvedForwardReferenceCount > 0) {
            String persistenceID = new ArrayList<String>(this._unresolvedForwardReferencesWithinModel.keySet()).get(0);
            AbstractBase unresolvedForwardReference = this._unresolvedForwardReferencesWithinModel.get(persistenceID);
            Object[] args = new Object[]{Integer.toString(unresolvedForwardReferenceCount), unresolvedForwardReference.getClass().getName(), persistenceID};
            throw new SAXException(IQModelImplUtilities.getMessage("ReadingContextV2.UnresolvedForwardReferencesRemain.fmt.txt", args));
        }
    }

    public boolean isDoResolveExternalResources() {
        return this._doResolveExternalResources;
    }

    public void setDoResolveExternalResources(boolean resolveExternalResources) {
        this._doResolveExternalResources = resolveExternalResources;
    }

    void setDSTReadMods(ArrayList<DataSourceTableImpl2.ReadModification> readMods) {
        this._dstReadMods = readMods;
    }

    ArrayList<DataSourceTableImpl2.ReadModification> getDSTReadMods() {
        if (this._dstReadMods == null) {
            this._dstReadMods = new ArrayList();
        }
        return this._dstReadMods;
    }

    public Element getEmbeddedDataElement() {
        return this._embeddedDataElement;
    }

    Map<AbstractModelReference, AbstractModel> getEnclosingModelsMap() throws MetadataException {
        HashMap<AbstractModelReference, AbstractModel> out = new HashMap<AbstractModelReference, AbstractModel>();
        for (ReadingContextV2 outerModelContext = this._outerModelContext; outerModelContext != null; outerModelContext = outerModelContext.getOuterModelContext()) {
            AbstractModel outerModel = outerModelContext.getModelBeingRead();
            AbstractModelReference modelRef = outerModel.getModelReference();
            out.put(modelRef, outerModel);
        }
        return out;
    }

    AbstractModel getResolvedModel(String modelLocation) {
        return (AbstractModel)this._xmlWideContext._externalModelsAlreadyResolved.get(modelLocation);
    }

    void addResolvedModel(AbstractModel resolvedModel, String modelLocation) {
        this._xmlWideContext._externalModelsAlreadyResolved.put(modelLocation, resolvedModel);
    }

    void setAssociatedPromptSmartObjects(List privatePromptSmartObjects) {
        this._associatedPromptSmartObjects = privatePromptSmartObjects;
    }

    private static class XMLWideReadingContext {
        private Map<BusinessModelReferenceInfo, AbstractModel> _modelsToReuse = new HashMap<BusinessModelReferenceInfo, AbstractModel>();
        private Document _reuseEntitiesDoc;
        private Map<String, AbstractModel> _externalModelsAlreadyResolved = new HashMap<String, AbstractModel>();

        private XMLWideReadingContext() {
        }
    }

    private static class IQIntegratedReadingContext
    implements IntegratedReadingContext {
        private ReadingContextV2 _internalReadingContext;
        private Object _server;

        private IQIntegratedReadingContext(ReadingContextV2 internalReadingContext) {
            this._internalReadingContext = internalReadingContext;
        }

        public Object getServer() {
            return this._server;
        }

        public void setServer(Object server) {
            this._server = server;
        }

        public String modifySbipURL(String input) {
            return input;
        }

        public Object getObject(String reference) {
            String persistenceID;
            String type;
            AbstractBase out = null;
            int indexOfColon = reference.indexOf(58);
            if (indexOfColon >= 0 && (out = this._internalReadingContext.getObjectForUsedObjectElement(type = reference.substring(0, indexOfColon), persistenceID = reference.substring(indexOfColon + 1), false)) == null && _logger.isDebugEnabled()) {
                _logger.debug("Did not recognize the type in the integrated object reference: " + reference);
            }
            return out;
        }
    }

    static class UnrecognizedItem
    extends AbstractModelItem {
        UnrecognizedItem() {
        }

        @Override
        protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        }

        @Override
        protected String getDefinitionElementName() {
            return null;
        }

        @Override
        protected void replaceDirectReferences(Object oldObject, Object newObject) {
        }
    }
}

