/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItemWithIdentity;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class ReadingContext {
    private AbstractModel _modelBeingRead;
    private Map _resolvedObjectDefinitions = new HashMap(500);
    private Map _unresolvedObjectDefinitions = new HashMap();
    private List<AbstractModelItem> _itemsCreatedDuringRead = new ArrayList<AbstractModelItem>();
    private int _nextAutoGeneratedPersistenceNumber = 0;
    private boolean _doResolveExternalResources = true;
    private MetadataServerInterface _metadataServer;

    ReadingContext(AbstractModel modelBeingRead) {
        this(modelBeingRead, null);
    }

    ReadingContext(AbstractModel modelBeingRead, MetadataServerInterface metadataServer) {
        this._modelBeingRead = modelBeingRead;
        this._metadataServer = metadataServer;
    }

    public AbstractModel getModelBeingRead() {
        return this._modelBeingRead;
    }

    MetadataServerInterface getMetadataServer() throws MetadataException {
        MetadataServerInterface out = this._metadataServer;
        if (out == null) {
            out = this._modelBeingRead.getAuthServer();
        }
        return out;
    }

    public AbstractModelItem getDefinition(String persistenceID) {
        AbstractModelItem out = (AbstractModelItem)this._resolvedObjectDefinitions.get(persistenceID);
        if (out == null) {
            out = (AbstractModelItem)this._unresolvedObjectDefinitions.get(persistenceID);
        }
        return out;
    }

    public void addResolvedDefinition(String persistenceID, AbstractModelItem item) {
        this._resolvedObjectDefinitions.put(persistenceID, item);
    }

    public Map getImportDefinitionsOfType(Class type) {
        HashMap outMap = new HashMap();
        for (Map.Entry entry : this._unresolvedObjectDefinitions.entrySet()) {
            AbstractModelItem item = (AbstractModelItem)entry.getValue();
            if (!type.isInstance(item)) continue;
            outMap.put(entry.getKey(), item);
        }
        return outMap;
    }

    public List getUnresolvedObjectDefinitions() {
        return ListUtils.newList(this._unresolvedObjectDefinitions.values());
    }

    public AbstractModelItem readExternalReferenceElement(Element element) throws MetadataException {
        String elementName = element.getTagName();
        String attrName = this._modelBeingRead.v1GetXrefPersistenceIDAttrName(elementName);
        String persistenceID = IQModelImplUtilities.getAttr(element, attrName);
        if (persistenceID == null) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("ReadingContext.NoPersistenceID.fmt.txt", elementName);
            throw new MetadataException(errorMsg);
        }
        AbstractModelItem xrefItem = (AbstractModelItem)this._unresolvedObjectDefinitions.get(persistenceID);
        if (xrefItem == null) {
            String uselessElementName = elementName;
            if (elementName.endsWith("Use")) {
                uselessElementName = elementName.substring(0, elementName.length() - 3);
            }
            xrefItem = this.newUnresolvedObject(uselessElementName, persistenceID);
            this._unresolvedObjectDefinitions.put(persistenceID, xrefItem);
        }
        xrefItem.readExternalReferenceV1(element, this);
        return xrefItem;
    }

    public AbstractModelItem readModelElement(Element element) throws MetadataException {
        AbstractModelItem out = null;
        String elementName = element.getTagName();
        String persistenceIDAttrName = this._modelBeingRead.v1GetModelPersistenceIDAttrName(elementName);
        String persistenceID = IQModelImplUtilities.getAttr(element, persistenceIDAttrName);
        if (persistenceIDAttrName.equals("imid") && persistenceID != null) {
            persistenceID = this._modelBeingRead.getIdentity() + "." + persistenceID;
        }
        if (elementName.endsWith("Use")) {
            if (persistenceID == null) {
                MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("ReadingContext.MissingElementAttribute.fmt.txt", elementName, persistenceIDAttrName);
                throw new MetadataException(errorMsg);
            }
            out = (AbstractModelItem)this._resolvedObjectDefinitions.get(persistenceID);
            if (out == null && (out = (AbstractModelItem)this._unresolvedObjectDefinitions.get(persistenceID)) == null) {
                String uselessElementName = elementName.substring(0, elementName.length() - 3);
                out = this.newUnresolvedObject(uselessElementName, persistenceID);
                this._unresolvedObjectDefinitions.put(persistenceID, out);
            }
        } else {
            out = this._modelBeingRead.newModelItemForElementName(elementName, this);
            out.readDefinitionV1(element, this);
            AbstractModelItem equiv = out.getConstantEquivalent();
            if (equiv != null) {
                out = equiv;
            }
            if (persistenceID == null) {
                persistenceID = this.genFakePersistenceID();
            }
            this._resolvedObjectDefinitions.put(persistenceID, out);
        }
        return out;
    }

    private AbstractModelItem newUnresolvedObject(String uselessElementName, String persistenceID) throws MetadataException {
        AbstractModelItem out = this._modelBeingRead.newModelItemForElementName(uselessElementName, this);
        out.setIsUnresolved(true);
        if (out instanceof AbstractModelItemWithIdentity) {
            AbstractModelItemWithIdentity idobj = (AbstractModelItemWithIdentity)out;
            idobj.setIdentityOutsideModelWhenUnresolved(persistenceID);
            idobj.setModel(this._modelBeingRead);
        }
        return out;
    }

    private String genFakePersistenceID() {
        StringBuffer buf = new StringBuffer(5);
        buf.append('.');
        buf.append(Integer.toString(this._nextAutoGeneratedPersistenceNumber++));
        return buf.toString();
    }

    public void replaceUnresolvedReferencesWithResolvedReferences() throws MetadataException {
        List<String> persistenceIDsForUnresolvedObjects = ListUtils.newList(this._unresolvedObjectDefinitions.keySet());
        for (String persistenceID : persistenceIDsForUnresolvedObjects) {
            AbstractModelItem resolvedObject = (AbstractModelItem)this._resolvedObjectDefinitions.get(persistenceID);
            if (resolvedObject == null) continue;
            AbstractModelItem unresolvedObject = (AbstractModelItem)this._unresolvedObjectDefinitions.get(persistenceID);
            this._modelBeingRead.replaceDirectReferences(unresolvedObject, resolvedObject);
            for (AbstractModelItem obj : this._itemsCreatedDuringRead) {
                obj.replaceDirectReferences(unresolvedObject, resolvedObject);
            }
            this._unresolvedObjectDefinitions.remove(persistenceID);
        }
    }

    public abstract SessionContextInterface getSession();

    public void addItemCreatedDuringRead(AbstractModelItem item) {
        this._itemsCreatedDuringRead.add(item);
    }

    public List<AbstractModelItem> trustedGetObjsCreatedDuringRead() {
        return this._itemsCreatedDuringRead;
    }

    public void replaceReferencesWith(AbstractModelItem oldItem, AbstractModelItem newItem) throws MetadataException {
        for (AbstractModelItem modelItem : this._itemsCreatedDuringRead) {
            modelItem.replaceDirectReferences(oldItem, newItem);
        }
    }

    public boolean isDoResolveExternalResources() {
        return this._doResolveExternalResources;
    }

    public void setDoResolveExternalResources(boolean resolveExternalResources) {
        this._doResolveExternalResources = resolveExternalResources;
    }
}

