/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class QueryProperties
extends AbstractModelItem {
    private HashMap<BusinessQueryProperty, Boolean> _properties = new HashMap();
    private List<BusinessQueryProperty> _persistable = new ArrayList<BusinessQueryProperty>();

    QueryProperties() {
        this._properties.put(BusinessQueryProperty.RETURN_DISTINCT_VALUES, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.EXCLUDE_EMPTY_DATA, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.JOIN_PATH_OPTIMIZATIONS_DISABLED, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.BUSINESS_QUERY_PARENT_VALUES_TOTAL_VALUES_IGNORED, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.OLAP_SELECTED_PARENTS_ONLY, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.BUSINESS_QUERY_OLAP_MEASURE_GROUPING, Boolean.FALSE);
        this._properties.put(BusinessQueryProperty.PERSIST_GROUPINGS, Boolean.FALSE);
        this._persistable.add(BusinessQueryProperty.RETURN_DISTINCT_VALUES);
        this._persistable.add(BusinessQueryProperty.EXCLUDE_EMPTY_DATA);
        this._persistable.add(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE);
        this._persistable.add(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
        this._persistable.add(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION);
        this._persistable.add(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS);
        this._persistable.add(BusinessQueryProperty.JOIN_PATH_OPTIMIZATIONS_DISABLED);
        this._persistable.add(BusinessQueryProperty.PERSIST_GROUPINGS);
    }

    void clear() {
        this._properties.clear();
    }

    void dispose() {
        this._properties.clear();
        this._persistable.clear();
    }

    Map<BusinessQueryProperty, Boolean> getProperties() {
        return this._properties;
    }

    @Override
    protected String getDefinitionElementName() {
        return "QueryProperties";
    }

    boolean set(BusinessQueryProperty property, boolean value) {
        boolean out = false;
        Boolean oldValueObject = this._properties.put(property, value ? Boolean.TRUE : Boolean.FALSE);
        if (oldValueObject == null || oldValueObject != value) {
            out = true;
        }
        return out;
    }

    Boolean get(BusinessQueryProperty property) {
        return this._properties.get(property);
    }

    boolean containsPersistableValues() {
        boolean out = false;
        Iterator<BusinessQueryProperty> it = this._persistable.iterator();
        while (!out && it.hasNext()) {
            BusinessQueryProperty prop = it.next();
            Boolean bool = this.get(prop);
            out = bool;
        }
        return out;
    }

    boolean contains(BusinessQueryProperty property) {
        return this._properties.containsKey(property);
    }

    void remove(BusinessQueryProperty property) {
        this._properties.remove(property);
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        String buf = this.computeQueryPropertyAttribute(true);
        if (buf.length() > 0) {
            IQModelImplUtilities.setAttr(thisElement, "setProperties", buf);
        }
    }

    String computeQueryPropertyAttribute(boolean isTrueProps) {
        StringBuffer buf = new StringBuffer(80);
        for (BusinessQueryProperty prop : this._persistable) {
            this.appendToAttrBuf(buf, prop, isTrueProps);
        }
        return buf.toString();
    }

    private void appendToAttrBuf(StringBuffer buf, BusinessQueryProperty property, boolean isTrueProps) {
        Boolean value = this._properties.get(property);
        if (value != null && value == isTrueProps) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(property.getPersistentForm());
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        String attrValue = attrsProvider.consumeAttr("setProperties");
        if (attrValue != null) {
            this.parseAndPopulate(attrValue, Boolean.TRUE);
        }
    }

    void parseAndPopulate(String attrValue, Boolean propertyValue) {
        StringTokenizer st = new StringTokenizer(attrValue, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            BusinessQueryProperty prop = BusinessQueryProperty.fromPersistentForm(token);
            if (prop == null) continue;
            this._properties.put(prop, propertyValue);
        }
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }
}

