/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.storage.olap.MetadataInterface;
import java.util.List;
import org.w3c.dom.Element;

public class QualifiedLevelImpl
extends AbstractModelItem
implements QualifiedLevel {
    private Hierarchy _hierarchy;
    private Level _level;

    public QualifiedLevelImpl() {
    }

    public QualifiedLevelImpl(Hierarchy hierarchy, Level level) {
        if (hierarchy == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("QualifiedLevelImplHierarchyRequired.txt", new Object[0]));
        }
        if (level == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("QualifiedLevelImplLevelRequired.txt", new Object[0]));
        }
        this._hierarchy = hierarchy;
        this._level = level;
    }

    @Override
    public Hierarchy getOwningHierarchy() throws MetadataException {
        return this._hierarchy;
    }

    @Override
    public String getLevelName() throws MetadataException {
        return this._level.getLevelName();
    }

    @Override
    public String getLevelUniqueName() throws MetadataException {
        Dimension dimA = this.getOwningDimension();
        List<Hierarchy> numberOf = dimA.getHierarchies();
        String dim = this._hierarchy.getDimensionName();
        String hie = this._hierarchy.getHierarchyName();
        StringBuffer levelU = new StringBuffer("[");
        if (dim.equalsIgnoreCase(hie) && numberOf.size() == 1) {
            levelU.append(hie);
        } else {
            levelU.append(dim).append("].[").append(hie);
        }
        levelU.append("].[").append(this.toString()).append("]");
        return levelU.toString();
    }

    @Override
    public String getLevelCaption() throws MetadataException {
        return this._level.getLevelCaption();
    }

    @Override
    public List<Member> getMembers() throws MetadataException {
        Dimension dim = this.getOwningDimension();
        if (dim == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("QualifiedLevelImplNoDimension.txt", new Object[0]));
        }
        OLAPServerUtilities olapServerUtil = OLAPServerUtilities.getInstance();
        olapServerUtil.setOlapMetadata(dim);
        MetadataInterface olapMetadata = olapServerUtil.getOlapMetadata();
        List<Member> members = olapServerUtil.getMembers(olapMetadata, dim.getCubeName(), dim, this._hierarchy, this.getLevelName());
        return members;
    }

    @Override
    public int getLevelNumber() throws MetadataException {
        return this._level.getLevelNumber();
    }

    @Override
    public String getSasFormat() throws MetadataException {
        return this._level.getSasFormat();
    }

    @Override
    protected String getDefinitionElementName() {
        return "QualifiedLevel";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        List<Element> subelements = IQModelImplUtilities.getSubelements(thisElement);
        int size = subelements.size();
        for (int i = 0; i < size; ++i) {
            Element element = subelements.get(i);
            AbstractModelItem item = readingContext.readModelElement(element);
            if (item instanceof Level) {
                this._level = (Level)((Object)item);
                continue;
            }
            if (!(item instanceof Hierarchy)) continue;
            this._hierarchy = (Hierarchy)((Object)item);
        }
    }

    public Level getLevel() {
        return this._level;
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    public String getDimensionName() throws MetadataException {
        return this._level.getDimensionName();
    }

    @Override
    public boolean isInMeasureDimension() throws MetadataException {
        return this._level.isInMeasureDimension();
    }

    @Override
    public Dimension getOwningDimension() throws MetadataException {
        return this._level.getOwningDimension();
    }

    @Override
    public String getCubeName() throws MetadataException {
        return this._hierarchy.getCubeName();
    }

    @Override
    public String getUniqueName() throws MetadataException {
        return this._level.getUniqueName();
    }

    @Override
    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        return this._level.getUniqueNameWithHierarchyAllMember();
    }

    @Override
    public String getLabel() {
        return this._level.getLabel();
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public String getIdentityString() {
        String msg = IQMetadataResourceBundle.getMessageString("IdentityStringThreeArgs.fmt.txt", "QualifiedLevel", this.getLabel(), "-");
        return msg;
    }

    @Override
    public String getDescription() {
        return this._level.getDescription();
    }

    @Override
    public int getExpressionType() {
        return this._level.getExpressionType();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        QualifiedLevelImpl clone = (QualifiedLevelImpl)super.clone();
        clone._hierarchy = this._hierarchy;
        clone._level = this._level;
        return clone;
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof QualifiedLevelImpl) {
            QualifiedLevelImpl qlevel_lhs = (QualifiedLevelImpl)obj;
            if (qlevel_lhs._hierarchy.equals(this._hierarchy) && qlevel_lhs._level.equals(this._level)) {
                rc = true;
            }
        }
        return rc;
    }

    public int hashCode() {
        int hashCode = 19;
        hashCode = hashCode * 7 + this._level.hashCode();
        hashCode = hashCode * 7 + this._hierarchy.hashCode();
        return hashCode;
    }

    protected boolean isReferrableByIDWithinPersistence() {
        return true;
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._hierarchy == null) {
            reasons.add(new Reason((Object)this, 2, 52, "QualifiedLevelImpl.NoHierarchyDefinedForQualifiedLevel.fmt.txt", this.getIdentityString()));
        }
        if (this._level == null) {
            reasons.add(new Reason((Object)this, 2, 53, "QualifiedLevelImpl.NoLevelDefinedForQualifiedLevel.fmt.txt", this.getIdentityString()));
        }
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._hierarchy);
        intoList.add(this._level);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._hierarchy = (Hierarchy)QualifiedLevelImpl.replace(this._hierarchy, oldObject, newObject);
        this._level = (Level)QualifiedLevelImpl.replace(this._level, oldObject, newObject);
    }
}

