/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.Entity;
import com.sas.entities.EntityInterface;
import com.sas.entities.persist.EntityConverter;
import com.sas.entities.persist.EntityPersistenceUtility;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.FolderItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractLocalizableBusinessModelObject;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.LocalizableString;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PromptImpl
extends AbstractLocalizableBusinessModelObject
implements Prompt,
FolderItem {
    public static final String EVENT_PROMPT_DEFINITION_CHANGED = "The prompt definition changed.";
    private AttributeDescriptorInterface attributeDescriptor;
    private PromptDefinitionInterface promptDefinition;
    private static final Logger _logger = LogManager.getLogger(PromptImpl.class);

    PromptImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    public PromptImpl() {
    }

    @Override
    public AttributeDescriptorInterface getAttributeDescriptor() {
        return this.attributeDescriptor;
    }

    @Override
    public void setAttributeDescriptor(AttributeDescriptorInterface descriptor) {
        this.attributeDescriptor = descriptor;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.promptDefinition;
    }

    @Override
    public void setPromptDefinition(PromptDefinitionInterface definition) {
        if (!IQModelImplUtilities.same(this.promptDefinition, definition)) {
            this.promptDefinition = definition;
            this.fireChangeEvent(EVENT_PROMPT_DEFINITION_CHANGED);
        }
    }

    @Override
    public int getExpressionType() {
        int returnType = 0;
        if (this.promptDefinition != null) {
            int sqlType = this.promptDefinition.getPromptDataType().getExpressionUsage();
            try {
                returnType = ExpressionUtil.getExprType(sqlType);
            }
            catch (IQueryServicesRuntimeException e) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug(e.getMessage());
                }
                returnType = 3;
            }
        }
        return returnType;
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "P_";
    }

    @Override
    protected String getDefinitionElementName() {
        return "Prompt";
    }

    @Override
    public void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this.promptDefinition != null) {
            PromptImpl.writeForeignObjectUnderNewSubelement(this.promptDefinition, thisElement, writingContext, "PromptModel");
        } else if (this.attributeDescriptor != null) {
            if (this.attributeDescriptor.getName() == null) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("PromptImplNullAttribute.txt", new Object[0]));
            }
            EntityInterface entity = this.wrapAttributeDescriptorInEntity(this.attributeDescriptor);
            PromptImpl.writeForeignObjectUnderNewSubelement(entity, thisElement, writingContext, "PromptModel");
        }
    }

    private EntityInterface wrapAttributeDescriptorInEntity(AttributeDescriptorInterface ad) {
        Entity entity = new Entity();
        entity.setEntityKey("");
        AttributeGroupInterface attGroup = entity.getAttributeGroup();
        attGroup.addAttributeDescriptor(ad, 0);
        return entity;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        Object fObject = riHolder.consumeForeignObject("PromptModel");
        if (fObject != null) {
            try {
                if (fObject instanceof EntityInterface) {
                    this.attributeDescriptor = this.transform((EntityInterface)fObject);
                    this.promptDefinition = this.transform(this.attributeDescriptor);
                } else if (fObject instanceof PromptDefinitionInterface) {
                    this.promptDefinition = (PromptDefinitionInterface)fObject;
                }
            }
            catch (MetadataException e) {
                SAXException se = new SAXException(e.toString());
                se.initCause(e);
                throw se;
            }
        }
    }

    @Override
    public void readDefinitionV1(Element promptElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(promptElement, readingContext);
        String xmlEntity = IQModelImplUtilities.getAttr(promptElement, "entity");
        this.attributeDescriptor = this.transform(xmlEntity);
        this.promptDefinition = this.transform(this.attributeDescriptor);
    }

    private PromptDefinitionInterface transform(AttributeDescriptorInterface attributeDescriptor) {
        LoggerFactoryInterface pvLogger = PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)this.getBusinessModel().getSession());
        return EntityConverter.DEFAULT_INSTANCE.newPromptDefinition(attributeDescriptor, pvLogger, "");
    }

    private AttributeDescriptorInterface transform(String xmlEntity) throws MetadataException {
        AttributeDescriptorInterface ad = null;
        if (xmlEntity != null && xmlEntity.length() > 0) {
            EntityInterface entity = null;
            try {
                entity = EntityPersistenceUtility.createEntityFromXML((String)xmlEntity);
            }
            catch (Exception e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    String msg = IQMetadataResourceBundle.getMessageString("PromptImpl.PersistenceFailedReadingEntity.fmt.txt", xmlEntity);
                    _logger.error(msg, (Throwable)e);
                }
                throw new MetadataException(e);
            }
            ad = this.transform(entity);
        }
        return ad;
    }

    private AttributeDescriptorInterface transform(EntityInterface entity) throws MetadataException {
        AttributeDescriptorInterface outAttributeDescriptor = null;
        try {
            AttributeDescriptorInterface[] attrDesList = entity.getAttributeDescriptors();
            if (attrDesList.length == 2) {
                for (int i = 0; i < attrDesList.length; ++i) {
                    AttributeDescriptorInterface attribDesc = attrDesList[i];
                    if (attribDesc.getName().equals("entityKey")) continue;
                    outAttributeDescriptor = attribDesc;
                }
            }
        }
        catch (RemoteException re) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("PromptImplBadAttributeGroup.txt", new Object[0]), (Throwable)re);
        }
        return outAttributeDescriptor;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PromptImpl clone = (PromptImpl)super.clone();
        if (this.attributeDescriptor != null) {
            EntityInterface entity = this.wrapAttributeDescriptorInEntity(this.attributeDescriptor);
            String xmlEntity = EntityPersistenceUtility.writeXMLToString((EntityInterface)entity, null);
            try {
                clone.attributeDescriptor = this.transform(xmlEntity);
            }
            catch (MetadataException e) {
                CloneNotSupportedException e2 = new CloneNotSupportedException(IQMetadataResourceBundle.getMessageString("PromptImpl.CannotClonePrompt.fmt.txt", this.getIdentityString()));
                e2.initCause(e);
                throw e2;
            }
        }
        if (this.promptDefinition != null) {
            clone.promptDefinition = (PromptDefinitionInterface)this.promptDefinition.clone();
        }
        return clone;
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this.promptDefinition == null) {
            reasons.add(new Reason((Object)this, 2, 113, "PromptImpl.PromptDefinitionNotSet.fmt.txt", this.getIdentityString()));
        } else {
            Locale locale = LocaleUtilities.getDefaultViewerLocale(this.getBusinessModel());
            Collection pdErrors = this.promptDefinition.validateDefinition(locale);
            if (!pdErrors.isEmpty()) {
                for (ValidationEntry next : pdErrors) {
                    reasons.add(new Reason((Object)this, 2, 114, "PromptImpl.ReasonText.fmt.txt", next));
                }
            }
        }
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this.promptDefinition != null && !(this.promptDefinition instanceof SharedPromptDefinitionInterface)) {
            intoList.addAll(this.promptDefinition.getReferencedResources(BusinessItem.class, true));
        }
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    @Override
    protected LocalizableString _getDescriptions() {
        Object desc = null;
        desc = this.promptDefinition != null ? this.promptDefinition.getPromptDescriptions() : new LocalizablePersistableString();
        return desc;
    }

    @Override
    protected LocalizableString _getLabels() {
        Object labels = null;
        labels = this.promptDefinition != null ? this.promptDefinition.getPromptLabels() : new LocalizablePersistableString();
        return labels;
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws MetadataException {
        PromptDefinitionInterface promptDef = this.getPromptDefinition();
        PropertyList ret = new PropertyList();
        if (promptDef instanceof MultiLocaleProperties) {
            ret = locale == null ? ((MultiLocaleProperties)promptDef).getLocalizableProperties() : ((MultiLocaleProperties)promptDef).getLocalizableProperties(locale);
        }
        return ret;
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws MetadataException {
        super.setLocalizableProperties(locale, this, map);
        String locID = this.getLocalizationID();
        if (map.containsNestedProperty(locID)) {
            PropertyMap objectMap = map.getNestedProperties(locID);
            PromptDefinitionInterface promptDef = this.getPromptDefinition();
            if (promptDef instanceof MultiLocaleProperties) {
                if (locale == null) {
                    ((MultiLocaleProperties)promptDef).setLocalizableProperties(objectMap);
                } else {
                    ((MultiLocaleProperties)promptDef).setLocalizableProperties(locale, objectMap);
                }
            }
        }
    }

    @Override
    public String getLocalizationPrependKey() {
        return "Prompts";
    }
}

