/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.CommaSeparatedString;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class OlapDataItemSortCriteria
extends AbstractModelItem {
    private List<String[]> _criteria = null;
    private static final String ATTR_PREFIX = "crit";

    OlapDataItemSortCriteria() {
    }

    OlapDataItemSortCriteria(List<String[]> criteria) {
        this._criteria = OlapDataItemSortCriteria.validateAndCopyCriteria(criteria);
    }

    public List<String[]> get() {
        return OlapDataItemSortCriteria.copyCriteria(this._criteria);
    }

    private static List<String[]> validateAndCopyCriteria(List<String[]> criteria) {
        ArrayList<Object> out;
        if (criteria == null) {
            out = new ArrayList<String[]>();
        } else {
            int size = criteria.size();
            out = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                String[] obj = criteria.get(i);
                if (!(obj instanceof String[])) {
                    throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemReferenceSortCriteriaBadObjectInList.fmt.txt", obj.getClass().getName()));
                }
                String[] sa = obj;
                for (int j = 0; j < sa.length; ++j) {
                    if (sa[j] != null) continue;
                    throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemReferenceSortCriteriaBadObjectInList.fmt.txt", obj.getClass().getName()));
                }
                out.add((String[])sa.clone());
            }
        }
        return out;
    }

    private static List<String[]> copyCriteria(List<String[]> criteria) {
        ArrayList<Object> out = null;
        if (criteria == null) {
            out = new ArrayList<String[]>();
        } else {
            int size = criteria.size();
            out = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                String[] sa = criteria.get(i);
                out.add((String[])sa.clone());
            }
        }
        return out;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OlapDataItemSortCriteria out = (OlapDataItemSortCriteria)super.clone();
        out._criteria = OlapDataItemSortCriteria.copyCriteria(this._criteria);
        return out;
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this._criteria != null) {
            int size = this._criteria.size();
            for (int i = 0; i < size; ++i) {
                String[] oneMultiCriteria = this._criteria.get(i);
                IQModelImplUtilities.setCommaSeparatedStringAttr(thisElement, ATTR_PREFIX + (i + 1), oneMultiCriteria);
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._criteria = new ArrayList<String[]>();
        String[] allCriteriaOriginallyAsList = attrsProvider.consumeOrderedPrefixNAttrs(ATTR_PREFIX);
        try {
            for (int i = 0; i < allCriteriaOriginallyAsList.length; ++i) {
                String[] oneMultiCriteria;
                String attrValue = allCriteriaOriginallyAsList[i];
                if (attrValue == null || (oneMultiCriteria = CommaSeparatedString.split(attrValue)) == null) continue;
                this._criteria.add(oneMultiCriteria);
            }
        }
        catch (IOException e) {
            SAXException se = new SAXException(e);
            se.initCause(e);
            throw se;
        }
    }

    @Override
    protected String getDefinitionElementName() {
        return "OlapDataItemSortCriteria";
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }
}

