/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.business.impl.OMRAttrs;
import java.util.List;

public class OMRTemplates {
    private static final String INITIAL_GET_TABLES_IN_LIBRARY_DESIGN_TIME_TEMPLATE = "<Templates>   <SASLibrary {SAS_LIBRARY_ATTRS}><Tables/><UsingPackages/></SASLibrary>   <DatabaseSchema {DB_SCHEMA_ATTRS}><Tables/></DatabaseSchema>   <PhysicalTable {TABLE_ATTRS}><PropertySets/></PhysicalTable>   <PropertySet {PROPERTY_SET_ATTRS}><Properties/></PropertySet>   <Property {PROPERTY_ATTRS}/></Templates>";
    private static final String GET_TABLES_IN_LIBRARY_DESIGN_TIME_TEMPLATE = OMRTemplates.substituteAttrsIntoTablesInLibraryTemplate("<Templates>   <SASLibrary {SAS_LIBRARY_ATTRS}><Tables/><UsingPackages/></SASLibrary>   <DatabaseSchema {DB_SCHEMA_ATTRS}><Tables/></DatabaseSchema>   <PhysicalTable {TABLE_ATTRS}><PropertySets/></PhysicalTable>   <PropertySet {PROPERTY_SET_ATTRS}><Properties/></PropertySet>   <Property {PROPERTY_ATTRS}/></Templates>");
    private static final String INITIAL_GET_COLUMNS_IN_TABLE_DESIGN_TIME_TEMPLATE = "<Templates>   <PhysicalTable {TABLE_ATTRS}><Columns/></PhysicalTable>   <Column {COLUMN_ATTRS}><Keys/></Column>   <ForeignKey {FOREIGN_KEY_ATTRS}/>   <UniqueKey {UNIQUE_KEY_ATTRS}/></Templates>";
    private static final String GET_COLUMNS_IN_TABLE_DESIGN_TIME_TEMPLATE = OMRTemplates.substituteAttrsIntoTableAndAllBelow("<Templates>   <PhysicalTable {TABLE_ATTRS}><Columns/></PhysicalTable>   <Column {COLUMN_ATTRS}><Keys/></Column>   <ForeignKey {FOREIGN_KEY_ATTRS}/>   <UniqueKey {UNIQUE_KEY_ATTRS}/></Templates>");
    private static final String STORED_PROCESS_TEMPLATE_PORTION = "   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/>";
    private static final String INITIAL_RELATIONAL_RESOLUTION_TEMPLATE_WITH_TABLES = "<XMLSelect search=\"ServerContext[{SERVER_NAME}]\"/> <Templates>   <ServerContext {SERVER_CONTEXT_ATTRS}><DataPackages search=\"{CLIENT_SASLIBRARY_NAMES}\"/><UsingComponents search=\"@ClassIdentifier='440196d4-90f0-11d0-9f41-00a024bb830c' OR @ClassIdentifier='620963ee-32bf-4128-bf5f-4b0df8ff90eb'\"/></ServerContext>   <SASLibrary {SAS_LIBRARY_ATTRS}><Tables search=\"{TABLE_NAMES}\"/><UsingPackages/></SASLibrary>   <DatabaseSchema {DB_SCHEMA_ATTRS}><Tables search=\"{TABLE_NAMES}\"/></DatabaseSchema>   <PhysicalTable {TABLE_ATTRS}><Columns/><PropertySets/></PhysicalTable>   <Column {COLUMN_ATTRS}/>   <PropertySet {PROPERTY_SET_ATTRS}><Properties/></PropertySet>   <Property {PROPERTY_ATTRS}/>   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/></Templates>";
    private static final String INITIAL_RELATIONAL_RESOLUTION_TEMPLATE_NO_TABLES = "<XMLSelect search=\"ServerContext[{SERVER_NAME}]\"/> <Templates>   <ServerContext {SERVER_CONTEXT_ATTRS}><UsingComponents search=\"@ClassIdentifier='440196d4-90f0-11d0-9f41-00a024bb830c' OR @ClassIdentifier='620963ee-32bf-4128-bf5f-4b0df8ff90eb'\"/></ServerContext>   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/></Templates>";
    private static final String RELATIONAL_RESOLUTION_TEMPLATE_WITH_TABLES = OMRTemplates.substituteRelationalAttrs("<XMLSelect search=\"ServerContext[{SERVER_NAME}]\"/> <Templates>   <ServerContext {SERVER_CONTEXT_ATTRS}><DataPackages search=\"{CLIENT_SASLIBRARY_NAMES}\"/><UsingComponents search=\"@ClassIdentifier='440196d4-90f0-11d0-9f41-00a024bb830c' OR @ClassIdentifier='620963ee-32bf-4128-bf5f-4b0df8ff90eb'\"/></ServerContext>   <SASLibrary {SAS_LIBRARY_ATTRS}><Tables search=\"{TABLE_NAMES}\"/><UsingPackages/></SASLibrary>   <DatabaseSchema {DB_SCHEMA_ATTRS}><Tables search=\"{TABLE_NAMES}\"/></DatabaseSchema>   <PhysicalTable {TABLE_ATTRS}><Columns/><PropertySets/></PhysicalTable>   <Column {COLUMN_ATTRS}/>   <PropertySet {PROPERTY_SET_ATTRS}><Properties/></PropertySet>   <Property {PROPERTY_ATTRS}/>   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/></Templates>");
    private static final String RELATIONAL_RESOLUTION_TEMPLATE_NO_TABLES = OMRTemplates.substituteRelationalAttrs("<XMLSelect search=\"ServerContext[{SERVER_NAME}]\"/> <Templates>   <ServerContext {SERVER_CONTEXT_ATTRS}><UsingComponents search=\"@ClassIdentifier='440196d4-90f0-11d0-9f41-00a024bb830c' OR @ClassIdentifier='620963ee-32bf-4128-bf5f-4b0df8ff90eb'\"/></ServerContext>   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/></Templates>");
    private static final String INITIAL_OLAP_RESOLUTION_TEMPLATE_WITH_CUBES = "<XMLSelect search=\"ServerContext[{SERVER_NAME}]\"/> <Templates>   <ServerContext {SERVER_CONTEXT_ATTRS}><DataPackages search=\"{OLAP_SCHEMA_NAMES}\"/><UsingComponents/></ServerContext>   <OLAPSchema {OLAP_SCHEMA_ATTRS}><Cubes search=\"{CUBE_NAMES}\"/></OLAPSchema>   <Cube {CUBE_ATTRS}><Dimensions/><Measures/><Notes/></Cube>   <Dimension {DIMENSION_ATTRS}><Cubes/><Hierarchies/></Dimension>   <SharedDimension {SHAREDDIMENSION_ATTRS}><Cubes search=\"{CUBE_NAMES}\"/><Hierarchies/></SharedDimension>   <Measure {MEASURE_ATTRS}><OwningDimension/></Measure>   <CalculatedMeasure {MEASURE_ATTRS}><OwningDimension/><Properties/></CalculatedMeasure>   <Hierarchy {HIERARCHY_ATTRS}><CalculatedMembers/><Levels/><NamedSets/></Hierarchy>   <Level {LEVEL_ATTRS}/>   <NamedSet {NAMED_SET_ATTRS}/>   <CalculatedMember {CALCULATED_MEMBER_ATTRS}><AssociatedLevel/></CalculatedMember>   <Property {PROPERTY_ATTRS}/>   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/></Templates>";
    private static final String INITIAL_OLAP_RESOLUTION_TEMPLATE_NO_CUBES = "<XMLSelect search=\"ServerContext[{SERVER_NAME}]\"/> <Templates>   <ServerContext {SERVER_CONTEXT_ATTRS}><UsingComponents/></ServerContext>   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/></Templates>";
    private static final String OLAP_RESOLUTION_TEMPLATE_WITH_CUBES = OMRTemplates.substituteOLAPAttrs("<XMLSelect search=\"ServerContext[{SERVER_NAME}]\"/> <Templates>   <ServerContext {SERVER_CONTEXT_ATTRS}><DataPackages search=\"{OLAP_SCHEMA_NAMES}\"/><UsingComponents/></ServerContext>   <OLAPSchema {OLAP_SCHEMA_ATTRS}><Cubes search=\"{CUBE_NAMES}\"/></OLAPSchema>   <Cube {CUBE_ATTRS}><Dimensions/><Measures/><Notes/></Cube>   <Dimension {DIMENSION_ATTRS}><Cubes/><Hierarchies/></Dimension>   <SharedDimension {SHAREDDIMENSION_ATTRS}><Cubes search=\"{CUBE_NAMES}\"/><Hierarchies/></SharedDimension>   <Measure {MEASURE_ATTRS}><OwningDimension/></Measure>   <CalculatedMeasure {MEASURE_ATTRS}><OwningDimension/><Properties/></CalculatedMeasure>   <Hierarchy {HIERARCHY_ATTRS}><CalculatedMembers/><Levels/><NamedSets/></Hierarchy>   <Level {LEVEL_ATTRS}/>   <NamedSet {NAMED_SET_ATTRS}/>   <CalculatedMember {CALCULATED_MEMBER_ATTRS}><AssociatedLevel/></CalculatedMember>   <Property {PROPERTY_ATTRS}/>   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/></Templates>");
    private static final String OLAP_RESOLUTION_TEMPLATE_NO_CUBES = OMRTemplates.substituteOLAPAttrs("<XMLSelect search=\"ServerContext[{SERVER_NAME}]\"/> <Templates>   <ServerContext {SERVER_CONTEXT_ATTRS}><UsingComponents/></ServerContext>   <LogicalServer {LOGICAL_SERVER_ATTRS}>{STORED_PROCESSES_SEARCH}<ServiceTypes/></LogicalServer>   <ClassifierMap {CLASSIFIER_MAP_ATTRS}/>   <ServiceType {SERVICE_TYPE_ATTRS}/></Templates>");
    private static final String GET_SERVERS_TEMPLATE = "<Templates>   <ServerContext><UsingComponents/></ServerContext></Templates>";

    static String getRelationalResourceResolutionTemplate(String serverName, List clientOMASASLibraries, List omaTables, List storedProcesses) {
        String outTemplate = null;
        outTemplate = clientOMASASLibraries.size() > 0 || omaTables.size() > 0 ? RELATIONAL_RESOLUTION_TEMPLATE_WITH_TABLES : RELATIONAL_RESOLUTION_TEMPLATE_NO_TABLES;
        String serverClause = OMRTemplates.getNameClause(serverName);
        String libNamesClause = OMRTemplates.listToNamesClause(clientOMASASLibraries);
        String tableNamesClause = OMRTemplates.listToNamesClause(omaTables);
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SERVER_NAME}", serverClause);
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{CLIENT_SASLIBRARY_NAMES}", libNamesClause);
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{TABLE_NAMES}", tableNamesClause);
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{TABLE_NAMES}", tableNamesClause);
        outTemplate = OMRTemplates.replaceStoredProcessSearchSection(outTemplate, storedProcesses);
        return outTemplate;
    }

    private static String replaceStoredProcessSearchSection(String template, List storedProcesses) {
        String storedProcessesSearch = null;
        if (storedProcesses.size() > 0) {
            String storedProcessNamesClause = OMRTemplates.listToNamesClause(storedProcesses);
            storedProcessesSearch = "<ComputeTasks search=\"" + storedProcessNamesClause + "\"/>";
        } else {
            storedProcessesSearch = "";
        }
        template = OMRTemplates.replaceFirst(template, "{STORED_PROCESSES_SEARCH}", storedProcessesSearch);
        return template;
    }

    static String getOLAPResourceResolutionTemplate(String serverName, List olapSchemas, List cubes, List storedProcesses) {
        String outTemplate = null;
        outTemplate = olapSchemas.size() > 0 || cubes.size() > 0 ? OLAP_RESOLUTION_TEMPLATE_WITH_CUBES : OLAP_RESOLUTION_TEMPLATE_NO_CUBES;
        String serverClause = OMRTemplates.getNameClause(serverName);
        String olapSchemasClause = OMRTemplates.listToNamesClause(olapSchemas);
        String cubesClause = OMRTemplates.listToNamesClause(cubes);
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SERVER_NAME}", serverClause);
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{OLAP_SCHEMA_NAMES}", olapSchemasClause);
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{CUBE_NAMES}", cubesClause);
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{CUBE_NAMES}", cubesClause);
        outTemplate = OMRTemplates.replaceStoredProcessSearchSection(outTemplate, storedProcesses);
        return outTemplate;
    }

    public static String getTablesInLibraryTemplate() {
        return GET_TABLES_IN_LIBRARY_DESIGN_TIME_TEMPLATE;
    }

    public static String getColumnsInTableTemplate() {
        return GET_COLUMNS_IN_TABLE_DESIGN_TIME_TEMPLATE;
    }

    private static String substituteAttrsIntoTablesInLibraryTemplate(String initialTemplate) {
        String outTemplate = initialTemplate;
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SAS_LIBRARY_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_SASLibrary));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{DB_SCHEMA_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_DatabaseSchema));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{TABLE_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_PhysicalTable));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{PROPERTY_SET_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_PropertySet));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{PROPERTY_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Property));
        return outTemplate;
    }

    private static String substituteAttrsIntoTableAndAllBelow(String initialTemplate) {
        String outTemplate = initialTemplate;
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{TABLE_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_PhysicalTable));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{COLUMN_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Column));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{FOREIGN_KEY_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_ForeignKey));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{UNIQUE_KEY_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_UniqueKey));
        return outTemplate;
    }

    private static String substituteRelationalAttrs(String initialTemplate) {
        String outTemplate = initialTemplate;
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SERVER_CONTEXT_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_ServerContext));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SAS_LIBRARY_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_SASLibrary));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{DB_SCHEMA_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_DatabaseSchema));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{TABLE_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_PhysicalTable));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{COLUMN_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Column));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{PROPERTY_SET_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_PropertySet));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{PROPERTY_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Property));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{LOGICAL_SERVER_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_LogicalServer));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{CLASSIFIER_MAP_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_ClassifierMap_AsStoredProcess));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SERVICE_TYPE_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_ServiceType));
        return outTemplate;
    }

    private static String substituteOLAPAttrs(String initialTemplate) {
        String outTemplate = initialTemplate;
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SERVER_CONTEXT_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_ServerContext));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{OLAP_SCHEMA_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_OLAPSchema));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{CUBE_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Cube));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{DIMENSION_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Dimension));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SHAREDDIMENSION_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Dimension));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{MEASURE_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Measure));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{MEASURE_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Measure));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{HIERARCHY_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Hierarchy));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{LEVEL_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Level));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{NAMED_SET_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_NamedSet));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{CALCULATED_MEMBER_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_CalculatedMember));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{PROPERTY_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_Property));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{LOGICAL_SERVER_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_LogicalServer));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{CLASSIFIER_MAP_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_ClassifierMap_AsStoredProcess));
        outTemplate = OMRTemplates.replaceFirst(outTemplate, "{SERVICE_TYPE_ATTRS}", OMRTemplates.attrArrayToQueryAttrs(OMRAttrs.ATTRS_ServiceType));
        return outTemplate;
    }

    private static String attrArrayToQueryAttrs(String[] attrs) {
        String out = "";
        if (attrs != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < attrs.length; ++i) {
                sb.append(attrs[i]);
                sb.append("=\"\"");
                if (i == attrs.length - 1) continue;
                sb.append(' ');
            }
            out = sb.toString();
        }
        return out;
    }

    private static String listToNamesClause(List objects) {
        StringBuffer buf = new StringBuffer();
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            Object obj = objects.get(i);
            if (obj == null) continue;
            if (buf.length() > 0) {
                buf.append(" OR ");
            }
            if (obj instanceof NamedObjectInterface) {
                OMRTemplates.appendNameClause(buf, ((NamedObjectInterface)obj).getLabel());
                continue;
            }
            OMRTemplates.appendNameClause(buf, obj.toString());
        }
        return buf.toString();
    }

    private static String getNameClause(String name) {
        return "@Name='" + name + "'";
    }

    private static void appendNameClause(StringBuffer buf, String name) {
        buf.append("@Name='").append(name).append('\'');
    }

    private static String replaceFirst(String input, String replaceFirstValue, String replaceWithThis) {
        String out = input;
        int index = input.indexOf(replaceFirstValue);
        if (index > -1) {
            out = input.substring(0, index) + replaceWithThis + input.substring(index + replaceFirstValue.length());
        }
        return out;
    }

    public static String getGetServersTemplate() {
        return GET_SERVERS_TEMPLATE;
    }
}

