/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinPathGenerator;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.business.impl.JoinAutoJoiner;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoinPathGeneratorImpl
implements JoinPathGenerator {
    private final BusinessQuery _businessQuery;
    private List<DataSource> _uniqueDataSourceList = null;
    private List<DataSource> _autoAddedDataSources = null;
    private List<List<DataSource>> _joinGroups = null;
    private static final Logger _logger = LogManager.getLogger(JoinPathGeneratorImpl.class);
    private final Comparator<DataItem> sortByDataItemLabels = new Comparator<DataItem>(){

        @Override
        public int compare(DataItem item1, DataItem item2) {
            String label1 = item1.getLabel();
            String label2 = item2.getLabel();
            if (label1 == null && label2 == null) {
                return 0;
            }
            if (label1 == null) {
                return -1;
            }
            if (label2 == null) {
                return 1;
            }
            return label1.compareTo(label2);
        }
    };

    public JoinPathGeneratorImpl(BusinessQuery businessQuery) {
        this._businessQuery = businessQuery;
    }

    @Override
    public List<BusinessModelObject> generateJoinPath() throws MetadataException {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<BusinessModelObject> list = this.generateJoinPath(effectiveObjectCache);
            return list;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    public List<BusinessModelObject> generateJoinPath(EffectiveObjectsCache effectiveObjectCache) throws MetadataException {
        List<FilterItem> filters = effectiveObjectCache.getEffectiveFilters(this._businessQuery);
        return this.generateJoinPath(filters, effectiveObjectCache);
    }

    public List<BusinessModelObject> generateJoinPath(Collection<? extends FilterItem> filters, EffectiveObjectsCache effectiveObjectCache) throws MetadataException {
        List<Join> explicitJoinPath;
        ArrayList<Join> joinImplInSelection = new ArrayList<Join>();
        this._uniqueDataSourceList = this.extractUniqueDataSources(filters, effectiveObjectCache);
        int size = this._uniqueDataSourceList.size();
        if (size == 1) {
            return ListUtils.newList(this._uniqueDataSourceList);
        }
        List<Join> joins = this._businessQuery.getBusinessModel().getObjects(true, Join.class);
        if (this._businessQuery instanceof ExplicitJoinPathSupport && (explicitJoinPath = ((ExplicitJoinPathSupport)((Object)this._businessQuery)).getExplicitJoinPath()) != null && explicitJoinPath.size() > 0) {
            joinImplInSelection.addAll(explicitJoinPath);
            for (Join explicitJoin : explicitJoinPath) {
                DataSourceTable explicitLeft = explicitJoin.getLeftDataSource();
                DataSourceTable explicitRight = explicitJoin.getRightDataSource();
                Iterator<Join> iterator2 = joins.iterator();
                while (iterator2.hasNext()) {
                    Join overallJoin = iterator2.next();
                    DataSourceTable overallLeft = overallJoin.getLeftDataSource();
                    DataSourceTable overallRight = overallJoin.getRightDataSource();
                    if ((overallLeft != explicitLeft || overallRight != explicitRight) && (overallLeft != explicitRight || overallRight != explicitLeft)) continue;
                    iterator2.remove();
                }
            }
            joins.addAll(0, explicitJoinPath);
        }
        Map<DataSource, Map<DataSourceTable, Join>> joinTableList = this.constructJoinMapList(joins);
        this.extractJoinInfoForSelectedDataSources(size, this._uniqueDataSourceList, joinTableList, joinImplInSelection);
        Map<DataSource, Map<DataSourceTable, Join>> searchJoinImplInSelection = this.constructJoinMapList(joinImplInSelection);
        this._joinGroups = this.constructJoinGroups(searchJoinImplInSelection, this._uniqueDataSourceList);
        if (this._joinGroups.size() != 1) {
            this._autoAddedDataSources = this.autoJoin(this._uniqueDataSourceList, this._joinGroups, joinTableList, joinImplInSelection);
        }
        if (this._autoAddedDataSources != null) {
            this._uniqueDataSourceList.addAll(this._autoAddedDataSources);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("joinTableList ...........=" + joinTableList);
            _logger.debug("_uniqueDataSourceList ...=" + this._uniqueDataSourceList);
            StringBuffer joinImplInSelectionString = new StringBuffer();
            for (Join join : joinImplInSelection) {
                joinImplInSelectionString.append(join.getJoinCondition().toString());
            }
            _logger.debug("_joinImplInSelection ....=" + joinImplInSelectionString);
            _logger.debug("searchJoinImplInSelection=" + searchJoinImplInSelection);
            _logger.debug("joinGroups ..............=" + this._joinGroups);
            _logger.debug("_uniqueDataSourceList ...=" + this._uniqueDataSourceList);
        }
        return new ArrayList<BusinessModelObject>(joinImplInSelection);
    }

    private void extractJoinInfoForSelectedDataSources(int size, List<DataSource> uniqueDataSourceList, Map<DataSource, Map<DataSourceTable, Join>> joinTableList, List<Join> joinsInSelection) {
        for (int index = 0; index < size - 1; ++index) {
            for (int index2 = index + 1; index2 < size; ++index2) {
                DataSource leftDataSource = uniqueDataSourceList.get(index);
                DataSource rightDataSource = uniqueDataSourceList.get(index2);
                Join join = null;
                Map<DataSourceTable, Join> leftBasedMatchingMap = joinTableList.get(leftDataSource);
                if (leftBasedMatchingMap != null) {
                    join = leftBasedMatchingMap.get(rightDataSource);
                } else {
                    Map<DataSourceTable, Join> rightBasedMatchingMap = joinTableList.get(rightDataSource);
                    if (rightBasedMatchingMap != null) {
                        join = rightBasedMatchingMap.get(leftDataSource);
                    }
                }
                if (join == null || joinsInSelection.contains(join)) continue;
                joinsInSelection.add(join);
            }
        }
    }

    private List<DataSource> autoJoin(List<DataSource> uniqueDataSourceList, List<List<DataSource>> joinGroups, Map<DataSource, Map<DataSourceTable, Join>> joinTableList, List<Join> joinImplInSelection) throws MetadataException {
        JoinAutoJoiner joinAutoJoiner = new JoinAutoJoiner();
        List<List<DataSource>> addedDataSources = joinAutoJoiner.findPathsForAllGroups(joinTableList, joinGroups);
        ArrayList<DataSource> addTheseDataSources = new ArrayList<DataSource>();
        if (addedDataSources.size() == 0) {
            MessageFormatter msg = this.errormsgDataSourcesCanNotBeJoined(joinGroups);
            throw new MetadataException(msg);
        }
        for (List<DataSource> joinPath : addedDataSources) {
            int joinPathSize = joinPath.size();
            for (int index = 0; index < joinPathSize - 1; ++index) {
                Map<DataSourceTable, Join> temp1;
                Join tempJoin;
                DataSource tempDataSource1 = joinPath.get(index);
                DataSource tempDataSource2 = joinPath.get(index + 1);
                if (!uniqueDataSourceList.contains(tempDataSource1) && !addTheseDataSources.contains(tempDataSource1)) {
                    addTheseDataSources.add(tempDataSource1);
                }
                if (!uniqueDataSourceList.contains(tempDataSource2) && !addTheseDataSources.contains(tempDataSource2)) {
                    addTheseDataSources.add(tempDataSource2);
                }
                if (joinImplInSelection.contains(tempJoin = (temp1 = joinTableList.get(tempDataSource1)).get(tempDataSource2))) continue;
                joinImplInSelection.add(tempJoin);
            }
        }
        return addTheseDataSources;
    }

    private List<DataSource> extractUniqueDataSources(Collection<? extends FilterItem> filters, EffectiveObjectsCache effectiveObjectCache) throws MetadataException {
        List<RequiredDataSources> requiredList;
        List<QualifiedColumn> resources;
        List<Join> explicitJoinPath;
        ArrayList<QualifiedColumn> columnList = new ArrayList<QualifiedColumn>();
        ArrayList<DataSource> uniqueDataSourceList = new ArrayList<DataSource>();
        if (this._businessQuery instanceof ExplicitJoinPathSupport && (explicitJoinPath = ((ExplicitJoinPathSupport)((Object)this._businessQuery)).getExplicitJoinPath()) != null) {
            for (Join join : explicitJoinPath) {
                DataSourceTable right;
                DataSourceTable dataSourceTable = join.getLeftDataSource();
                if (!uniqueDataSourceList.contains(dataSourceTable)) {
                    uniqueDataSourceList.add(dataSourceTable);
                }
                if (!uniqueDataSourceList.contains(right = join.getLeftDataSource())) {
                    uniqueDataSourceList.add(right);
                }
                resources = join.getJoinCondition().getResources(QualifiedColumn.class, 65531);
                columnList.addAll(resources);
            }
        }
        if ((requiredList = effectiveObjectCache.getEffectiveRequiredDataSources(this._businessQuery)).size() > 0) {
            RequiredDataSources rds = requiredList.get(requiredList.size() - 1);
            List<DataSource> requiredDataSources = rds.getDataSources();
            for (DataSource dataSource : requiredDataSources) {
                if (uniqueDataSourceList.contains(dataSource)) continue;
                uniqueDataSourceList.add(dataSource);
            }
        }
        ArrayList<DataItem> sortedDataItems = new ArrayList<DataItem>(effectiveObjectCache.getEffectiveResultItems(this._businessQuery));
        Collections.sort(sortedDataItems, this.sortByDataItemLabels);
        for (int index = 0; index < sortedDataItems.size(); ++index) {
            List<QualifiedColumn> list = sortedDataItems.get(index).getResources(QualifiedColumn.class, 65531);
            columnList.addAll(list);
        }
        if (filters != null) {
            for (FilterItem filterItem : filters) {
                ExpressionInterface expression;
                if (filterItem == null || (expression = filterItem.getExpression()) == null) continue;
                resources = expression.getResources(QualifiedColumn.class, 65531);
                columnList.addAll(resources);
            }
        }
        for (QualifiedColumn qualifiedColumn : columnList) {
            DataSource dataSource;
            dataSource = qualifiedColumn.getDataSource();
            if (uniqueDataSourceList.contains(dataSource)) continue;
            uniqueDataSourceList.add(dataSource);
        }
        this._extractDataSourcesAndAddToList(uniqueDataSourceList, effectiveObjectCache.getEffectiveSortOrderPrecedence(this._businessQuery));
        if (uniqueDataSourceList.size() == 0) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("JoinGeneration.extractUniqueDataSources.NoDataSource.txt", new Object[0]);
            Reason reason = new Reason((Object)this._businessQuery, 2, 71, "JoinGeneration.extractUniqueDataSources.NoDataSource.txt", new Object[0]);
            MetadataException e = new MetadataException(msg, Arrays.asList(reason));
            throw e;
        }
        return uniqueDataSourceList;
    }

    private void _extractDataSourcesAndAddToList(List<DataSource> uniqueListToUpdate, List<? extends BusinessItem> items) throws MetadataException {
        if (items != null) {
            for (BusinessItem businessItem : items) {
                List<QualifiedColumn> columns = businessItem.getResources(QualifiedColumn.class, 65531);
                for (QualifiedColumn column : columns) {
                    DataSourceTable dataSource = column.getDataSource();
                    if (uniqueListToUpdate.contains(dataSource)) continue;
                    uniqueListToUpdate.add(dataSource);
                }
            }
        }
    }

    private Map<DataSource, Map<DataSourceTable, Join>> constructJoinMapList(List<Join> joinList) {
        LinkedHashMap<DataSource, Map<DataSourceTable, Join>> joinMap = new LinkedHashMap<DataSource, Map<DataSourceTable, Join>>();
        LinkedHashMap listOfJoinImpl = null;
        DataSourceTable dataSource = null;
        for (Join join : joinList) {
            dataSource = join.getLeftDataSource();
            listOfJoinImpl = !joinMap.containsKey(dataSource) ? new LinkedHashMap() : (LinkedHashMap)joinMap.get(dataSource);
            listOfJoinImpl.put(join.getRightDataSource(), join);
            joinMap.put(dataSource, listOfJoinImpl);
            dataSource = join.getRightDataSource();
            listOfJoinImpl = !joinMap.containsKey(dataSource) ? new LinkedHashMap() : (LinkedHashMap)joinMap.get(dataSource);
            listOfJoinImpl.put(join.getLeftDataSource(), join);
            joinMap.put(dataSource, listOfJoinImpl);
        }
        return joinMap;
    }

    private List<List<DataSource>> constructJoinGroups(Map<DataSource, Map<DataSourceTable, Join>> selectedJoinImpl, List<DataSource> uniqueDataSourceList) {
        ArrayList<List<DataSource>> joinGroups = new ArrayList<List<DataSource>>();
        int size = uniqueDataSourceList.size();
        List<DataSource> tempLeftList = null;
        List<DataSource> tempRightList = null;
        for (int index = 0; index < size - 1; ++index) {
            for (int index2 = index + 1; index2 < size; ++index2) {
                Map<DataSourceTable, Join> temp1;
                DataSource leftDataSource = uniqueDataSourceList.get(index);
                DataSource rightDataSource = uniqueDataSourceList.get(index2);
                this.addToJoinGroups(joinGroups, leftDataSource);
                this.addToJoinGroups(joinGroups, rightDataSource);
                if (!selectedJoinImpl.containsKey(leftDataSource) || !(temp1 = selectedJoinImpl.get(leftDataSource)).containsKey(rightDataSource) || (tempLeftList = this.checkForJoinGroup(joinGroups, leftDataSource)).equals(tempRightList = this.checkForJoinGroup(joinGroups, rightDataSource))) continue;
                for (DataSource tempDataSource : tempRightList) {
                    tempLeftList.add(tempDataSource);
                }
                tempRightList.clear();
                joinGroups.remove(tempRightList);
            }
        }
        return joinGroups;
    }

    private List<DataSource> checkForJoinGroup(List<List<DataSource>> joinGroups, DataSource ds) {
        for (List<DataSource> joinGroup : joinGroups) {
            if (!joinGroup.contains(ds)) continue;
            return joinGroup;
        }
        return null;
    }

    private void addToJoinGroups(List<List<DataSource>> joinGroups, DataSource ds) {
        List<DataSource> jgroup = null;
        jgroup = this.checkForJoinGroup(joinGroups, ds);
        if (jgroup == null) {
            jgroup = new ArrayList<DataSource>();
            jgroup.add(ds);
            joinGroups.add(jgroup);
        }
    }

    private MessageFormatter errormsgDataSourcesCanNotBeJoined(List<List<DataSource>> joinGroups) throws MetadataException {
        String tempTableName;
        DataSourceTable tempTable;
        List<DataSource> listJoinGroupOne = joinGroups.get(0);
        List<DataSource> listJoinGroupTwo = joinGroups.get(1);
        MessageFormatter msg = null;
        ArrayList<String> tableList1 = new ArrayList<String>();
        ArrayList<String> tableList2 = new ArrayList<String>();
        for (DataSource dataSource : listJoinGroupOne) {
            if (!(dataSource instanceof DataSourceTable)) {
                msg = IQMetadataResourceBundle.getMessageFormatter("JoinGeneration.errormsgDataSourcesCanNotBeJoined.NotATable.fmt.txt", dataSource);
                break;
            }
            tempTable = (DataSourceTable)dataSource;
            tempTableName = tempTable.getLabel();
            tableList1.add(tempTableName);
        }
        if (msg == null) {
            for (DataSource dataSource : listJoinGroupTwo) {
                if (!(dataSource instanceof DataSourceTable)) {
                    msg = IQMetadataResourceBundle.getMessageFormatter("JoinGeneration.errormsgDataSourcesCanNotBeJoined.NotATable.fmt.txt", dataSource);
                    break;
                }
                tempTable = (DataSourceTable)dataSource;
                tempTableName = tempTable.getLabel();
                tableList2.add(tempTableName);
            }
        }
        if (msg == null) {
            msg = IQMetadataResourceBundle.getMessageFormatter("JoinGeneration.errormsgDataSourcesCanNotBeJoined.NoJoinBetweenLists.fmt.txt", new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, tableList1.toArray()), new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, tableList2.toArray()));
        }
        return msg;
    }

    @Override
    public List<DataSource> getAutoAddedDataSources() {
        if (this._autoAddedDataSources == null) {
            return new ArrayList<DataSource>();
        }
        return new ArrayList<DataSource>(this._autoAddedDataSources);
    }

    @Override
    public List<DataSource> getUniqueDataSources() throws MetadataException {
        if (this._uniqueDataSourceList == null) {
            return new ArrayList<DataSource>();
        }
        return new ArrayList<DataSource>(this._uniqueDataSourceList);
    }

    @Override
    public List<List<DataSource>> getJoinGroups() throws MetadataException {
        if (this._joinGroups == null) {
            this._joinGroups = new ArrayList<List<DataSource>>();
        }
        return this._joinGroups;
    }
}

