/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.impl.JoinFeeder;
import com.sas.iquery.metadata.business.impl.JoinInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class JoinNodeTree {
    protected List childrenJoinNodes = new ArrayList();
    protected DataSource myDataSource = null;
    protected List childrenDataSources = null;
    protected List joinPath = new ArrayList();
    protected JoinFeeder joinFeeder = null;
    protected int myLevel = 0;
    protected int myCost = 0;
    protected boolean childrenSetup = false;

    public JoinNodeTree(DataSource ds, JoinFeeder joinFeeder) {
        this.myDataSource = ds;
        this.joinFeeder = joinFeeder;
    }

    protected boolean setup(int maxlevel, int lowestCostFound) {
        boolean returnvalue = false;
        if (this.myLevel < maxlevel) {
            this.childrenDataSources = this.joinFeeder.findJoinObjectsLookfor(this.myDataSource);
            this._removeDataSourcesInMyJoinPath();
            returnvalue = this._setupChildren(maxlevel, lowestCostFound);
        }
        return returnvalue;
    }

    protected void _removeDataSourcesInMyJoinPath() {
        ListIterator toKeep = this.childrenDataSources.listIterator();
        while (toKeep.hasNext()) {
            JoinInfo jointoKeep = (JoinInfo)toKeep.next();
            if (!this.joinPath.contains(jointoKeep.getDataSource())) continue;
            toKeep.remove();
        }
    }

    protected boolean _setupChildren(int maxlevel, int lowestCostFound) {
        boolean returnvalue = false;
        boolean returnFromMethod = false;
        DataSource tempDataSource = null;
        int costSum = 0;
        if (!this.childrenSetup) {
            for (JoinInfo joinInfo : this.childrenDataSources) {
                costSum = this.myCost + joinInfo.getCost();
                if (lowestCostFound != -1 && costSum >= lowestCostFound) continue;
                returnvalue = true;
                tempDataSource = joinInfo.getDataSource();
                JoinNodeTree joinNode = new JoinNodeTree(tempDataSource, this.joinFeeder);
                ArrayList<DataSource> tempJoinPath = new ArrayList<DataSource>(this.joinPath);
                tempJoinPath.add(this.myDataSource);
                joinNode.setMyLevel(this.myLevel + 1);
                joinNode.setMyCost(costSum);
                joinNode.setJoinPath(tempJoinPath);
                returnFromMethod = joinNode.setup(maxlevel, lowestCostFound);
                if (returnFromMethod) {
                    returnvalue = true;
                }
                this.childrenJoinNodes.add(joinNode);
            }
            this.childrenSetup = true;
        } else {
            for (JoinNodeTree joinNode : this.childrenJoinNodes) {
                returnFromMethod = joinNode.setup(maxlevel, lowestCostFound);
                if (!returnFromMethod) continue;
                returnvalue = true;
            }
        }
        return returnvalue;
    }

    protected List returnAllDataSources(int maxlevel, List allDataSources) {
        if (this.myLevel == maxlevel) {
            JoinInfo joinInfo = new JoinInfo(this.myDataSource, this.myCost, this.joinPath);
            allDataSources.add(joinInfo);
        } else if (this.myLevel < maxlevel) {
            for (JoinNodeTree joinNode : this.childrenJoinNodes) {
                joinNode.returnAllDataSources(maxlevel, allDataSources);
            }
        }
        return allDataSources;
    }

    public int getMyLevel() {
        return this.myLevel;
    }

    public void setMyLevel(int myLevel) {
        this.myLevel = myLevel;
    }

    public int getMyCost() {
        return this.myCost;
    }

    public void setMyCost(int myCost) {
        this.myCost = myCost;
    }

    public List getJoinPath() {
        return this.joinPath;
    }

    public void setJoinPath(List joinPath) {
        this.joinPath = joinPath;
    }
}

