/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.Cardinality;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.CopyFromInterface;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinRelationshipType;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.JoinTypeList;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JoinImpl
extends AbstractBusinessModelObject
implements Join,
CopyFromInterface {
    private static final JoinRelationshipType NOXML_RELATIONSHIP_TYPE = JoinRelationshipType.ALLOWED;
    private static final int NOXML_COST = 50;
    private static final Cardinality NOXML_CARDINALITY = Cardinality.ONE_TO_MANY;
    private static final JoinType NOXML_JOINTYPE = JoinType.INNER;
    private DataSourceTable _leftDataSource;
    private DataSourceTable _rightDataSource;
    private JoinRelationshipType _relationshipType = JoinRelationshipType.ALLOWED;
    private int _cost = 50;
    private Cardinality _cardinality = Cardinality.UNKNOWN;
    private JoinType _joinType = JoinType.NONE;
    private JoinTypeList _allowedJoinTypes = (JoinTypeList)JoinTypeList.ALL_JOIN_TYPES.clone();
    private ConditionalExpression _joinCondition = null;
    private static final Logger _logger = LogManager.getLogger(JoinImpl.class);

    JoinImpl(AbstractBusinessModel businessModel) throws MetadataException {
        super(businessModel);
    }

    public JoinImpl() {
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "JOIN_";
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        this._leftDataSource = (DataSourceTable)Utils.replaceResource(this._leftDataSource, oldResource, newResource, model, recursive);
        this._rightDataSource = (DataSourceTable)Utils.replaceResource(this._rightDataSource, oldResource, newResource, model, recursive);
        this._joinCondition = (ConditionalExpression)Utils.replaceResource(this._joinCondition, oldResource, newResource, model, recursive);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JoinImpl newJoin = (JoinImpl)super.clone();
        if (this._allowedJoinTypes != null) {
            newJoin._allowedJoinTypes = (JoinTypeList)this._allowedJoinTypes.clone();
        }
        if (this._joinCondition != null) {
            newJoin._joinCondition = (ConditionalExpression)this._joinCondition.clone();
        }
        return newJoin;
    }

    @Override
    public DataSourceTable getLeftDataSource() {
        return this._leftDataSource;
    }

    @Override
    public void setLeftDataSource(DataSourceTable leftDataSource) {
        this.changeableCheck();
        this._leftDataSource = leftDataSource;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    public DataSourceTable getRightDataSource() {
        return this._rightDataSource;
    }

    @Override
    public void setRightDataSource(DataSourceTable rightDataSource) {
        this.changeableCheck();
        this._rightDataSource = rightDataSource;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    public JoinRelationshipType getRelationshipType() {
        return this._relationshipType;
    }

    @Override
    public void setRelationshipType(JoinRelationshipType relationshipType) {
        this.changeableCheck();
        this._relationshipType = relationshipType;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    public int getCost() {
        return this._cost;
    }

    @Override
    public void setCost(int cost) {
        this.changeableCheck();
        this._cost = cost;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    public Cardinality getCardinality() {
        return this._cardinality;
    }

    @Override
    public void setCardinality(Cardinality cardinality) {
        this.changeableCheck();
        this._cardinality = cardinality;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    public JoinType getType() {
        return this._joinType;
    }

    @Override
    public void setType(JoinType joinType) {
        this.changeableCheck();
        this._joinType = joinType;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    public JoinTypeList getAllowedTypes() {
        return this._allowedJoinTypes;
    }

    @Override
    public void setAllowedTypes(JoinTypeList allowedJoinTypes) {
        this.changeableCheck();
        this._allowedJoinTypes = allowedJoinTypes;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    public ConditionalExpression getJoinCondition() {
        return this._joinCondition;
    }

    @Override
    public void setJoinCondition(ConditionalExpression expression) {
        this.changeableCheck();
        this._joinCondition = expression;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._joinType = JoinType.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "joinType"));
        this._relationshipType = JoinRelationshipType.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "relationshipType"));
        this._cost = IQModelImplUtilities.getIntAttr(thisElement, "cost", 50);
        this._cardinality = Cardinality.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "card"));
        String allowedJoinTypesAttr = IQModelImplUtilities.getAttr(thisElement, "allowJoinTypes");
        JoinTypeList joinTypeList = new JoinTypeList();
        String[] allowedJoinTypes = allowedJoinTypesAttr.split(",", 0);
        for (int index = 0; index < allowedJoinTypes.length; ++index) {
            String joinType = allowedJoinTypes[index];
            JoinType allowedJoinType = JoinType.fromPersistentForm(joinType);
            if (allowedJoinType != null) {
                joinTypeList.add(allowedJoinType);
                continue;
            }
            if (!_logger.isDebugEnabled()) continue;
            String msg = IQMetadataResourceBundle.getMessageString("JoinImplInvalidJoinType.fmt.txt", joinType);
            _logger.debug(msg);
        }
        this._allowedJoinTypes = joinTypeList;
        this._joinCondition = (ConditionalExpression)JoinImpl.v1_readItemUnderSubelement(thisElement, readingContext, "JoinCond", new Class[]{ConditionalExpression.class});
        this._leftDataSource = (DataSourceTable)((Object)JoinImpl.v1_readItemUnderSubelement(thisElement, readingContext, "LeftDataSource", new Class[]{DataSourceTable.class}));
        if (this._leftDataSource == null) {
            this._leftDataSource = (DataSourceTable)((Object)JoinImpl.v1_readItemUnderSubelement(thisElement, readingContext, "leftDataSource", new Class[]{DataSourceTable.class}));
        }
        this._rightDataSource = (DataSourceTable)((Object)JoinImpl.v1_readItemUnderSubelement(thisElement, readingContext, "RightDataSource", new Class[]{DataSourceTable.class}));
        if (this._rightDataSource == null) {
            this._rightDataSource = (DataSourceTable)((Object)JoinImpl.v1_readItemUnderSubelement(thisElement, readingContext, "rightDataSource", new Class[]{DataSourceTable.class}));
        }
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setEnumAttr(thisElement, "joinType", this._joinType, NOXML_JOINTYPE);
        IQModelImplUtilities.setEnumAttr(thisElement, "relationshipType", this._relationshipType, NOXML_RELATIONSHIP_TYPE);
        IQModelImplUtilities.setIntAttr(thisElement, "cost", this._cost, 50);
        IQModelImplUtilities.setEnumAttr(thisElement, "card", this._cardinality, NOXML_CARDINALITY);
        StringBuffer attrValue = new StringBuffer();
        Iterator itJoinTypes = this._allowedJoinTypes.iterator();
        while (itJoinTypes.hasNext()) {
            JoinType jType = (JoinType)itJoinTypes.next();
            attrValue.append(jType.getPersistentForm());
            if (!itJoinTypes.hasNext()) continue;
            attrValue.append(',');
        }
        IQModelImplUtilities.setAttr(thisElement, "allowJoinTypes", attrValue.toString());
        JoinImpl.writeRelatedObject(this._leftDataSource, thisElement, writingContext, "LeftDataSource");
        JoinImpl.writeRelatedObject(this._rightDataSource, thisElement, writingContext, "RightDataSource");
        JoinImpl.writeRelatedObject(this._joinCondition, thisElement, writingContext, "JoinCondition");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._joinType = JoinType.consumeValue(attrsProvider, "joinType", NOXML_JOINTYPE);
        this._relationshipType = JoinRelationshipType.consumeValue(attrsProvider, "relationshipType", NOXML_RELATIONSHIP_TYPE);
        this._cost = attrsProvider.consumeIntAttr("cost", 50);
        this._cardinality = Cardinality.consumeValue(attrsProvider, "card", NOXML_CARDINALITY);
        String allowedJoinTypesAttr = attrsProvider.consumeAttr("allowJoinTypes");
        JoinTypeList joinTypeList = new JoinTypeList();
        if (allowedJoinTypesAttr != null) {
            String[] allowedJoinTypes = allowedJoinTypesAttr.split(",", 0);
            for (int index = 0; index < allowedJoinTypes.length; ++index) {
                String joinType = allowedJoinTypes[index];
                JoinType allowedJoinType = JoinType.fromPersistentForm(joinType);
                if (allowedJoinType != null) {
                    joinTypeList.add(allowedJoinType);
                    continue;
                }
                if (!_logger.isDebugEnabled()) continue;
                String msg = IQMetadataResourceBundle.getMessageString("JoinImplInvalidJoinType.fmt.txt", joinType);
                _logger.debug(msg);
            }
        }
        this._allowedJoinTypes = joinTypeList;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._leftDataSource = (DataSourceTable)((Object)riHolder.consumeObject("LeftDataSource"));
        this._rightDataSource = (DataSourceTable)((Object)riHolder.consumeObject("RightDataSource"));
        this._joinCondition = (ConditionalExpression)riHolder.consumeObject("JoinCondition");
    }

    @Override
    protected String getDefinitionElementName() {
        return "Join";
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._leftDataSource == null) {
            reasons.add(new Reason((Object)this, 2, 44, "JoinImpl.NoLeftDataSourceDefinedForJoin.fmt.txt", this.getIdentityString()));
        }
        if (this._rightDataSource == null) {
            reasons.add(new Reason((Object)this, 2, 45, "JoinImpl.NoRightDataSourceDefinedForJoin.fmt.txt", this.getIdentityString()));
        }
        if (this._relationshipType == null) {
            reasons.add(new Reason((Object)this, 2, 46, "JoinImpl.JoinRelationshipTypeNotSet.fmt.txt", this.getIdentityString()));
        }
        if (this._cardinality == null) {
            reasons.add(new Reason((Object)this, 2, 47, "JoinImpl.JoinCardinalityNotSet.fmt.txt", this.getIdentityString()));
        }
        if (this._joinType == null) {
            reasons.add(new Reason((Object)this, 2, 48, "JoinImpl.JoinTypeNotSet.fmt.txt", this.getIdentityString()));
        }
        if (this._joinCondition == null) {
            reasons.add(new Reason((Object)this, 2, 49, "JoinImpl.JoinConditionNotSet.fmt.txt", this.getIdentityString()));
        }
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._joinCondition);
        intoList.add(this._leftDataSource);
        intoList.add(this._rightDataSource);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._joinCondition = (ConditionalExpression)JoinImpl.replace(this._joinCondition, oldObject, newObject);
        this._leftDataSource = (DataSourceTable)JoinImpl.replace(this._leftDataSource, oldObject, newObject);
        this._rightDataSource = (DataSourceTable)JoinImpl.replace(this._rightDataSource, oldObject, newObject);
    }

    @Override
    public void copyFrom(Object obj) throws MetadataException {
        this._copyFrom(obj);
    }
}

