/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.entities.persist.EntityPersistenceUtility;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.util.LocalizableString;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class IntegratedObjectWriter {
    static final String XML_LANG_ATTR_TAG = "xml:lang";
    private static final Logger _logger = LogManager.getLogger(IntegratedObjectWriter.class);
    private static IntegratedObjectWriter _singletonInstance = new IntegratedObjectWriter();
    static final String PRIVATE_PROMPT_NAME_PREFIX = "Private Prompt. ID in XML: ";
    private static Map PROMPT_WRITING_OPTIONS = new HashMap(4);
    private static Map PROMPTGROUP_WRITING_OPTIONS;

    private IntegratedObjectWriter() {
    }

    public static IntegratedObjectWriter getInstance() {
        return _singletonInstance;
    }

    void writeUnderNewSubelement(PersistenceInterface persistenceInterface, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        if (persistenceInterface != null) {
            if (persistenceInterface instanceof PromptDefinitionInterface) {
                this.writePrompt((PromptDefinitionInterface)persistenceInterface, parentNode, writingContext, newSubelementName);
            } else {
                Element newSubelement = IQModelImplUtilities.newSubelement(parentNode, newSubelementName);
                Map writingOptions = persistenceInterface instanceof PromptGroupInterface ? PROMPTGROUP_WRITING_OPTIONS : PROMPT_WRITING_OPTIONS;
                PromptsWritingContext promptWritingContext = writingContext.getReusedPromptsWritingContext(writingOptions);
                try {
                    persistenceInterface.write((Node)newSubelement, (IntegratedWritingContext)promptWritingContext);
                }
                catch (BackingStoreException e) {
                    throw new MetadataException(e);
                }
            }
        }
    }

    private void writePrompt(PromptDefinitionInterface obj, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        if (obj != null) {
            Element newSubelement = IQModelImplUtilities.newSubelement(parentNode, newSubelementName);
            if (writingContext.isWriteOperationToOMR()) {
                this.writePromptAsPrivateObject(obj, newSubelement, writingContext);
            } else {
                PromptsWritingContext promptWritingContext = writingContext.getReusedPromptsWritingContext(PROMPT_WRITING_OPTIONS);
                try {
                    obj.write((Node)newSubelement, (IntegratedWritingContext)promptWritingContext);
                }
                catch (BackingStoreException e) {
                    throw new MetadataException(e);
                }
            }
        }
    }

    private void writePromptAsPrivateObject(PromptDefinitionInterface obj, Node parentNode, WritingContext writingContext) throws MetadataException {
        try {
            UserContextInterface user = writingContext.getModel().getSession().getUserContext();
            PromptsWritingContext promptWritingContext = writingContext.newPromptsWritingContext(PROMPT_WRITING_OPTIONS);
            OMRPromptDefinitionInterface privatePromptToUse = PromptsPersistUtil.newDefinitionSmartObject((PromptDefinitionInterface)obj, (UserContextInterface)user, (RepositoryInterface)writingContext.getRepository(), (String)"", (PromptsWritingContext)promptWritingContext);
            String promptExternalIdentity = writingContext.addReferencedPrivatePrompt(privatePromptToUse);
            privatePromptToUse.setName(PRIVATE_PROMPT_NAME_PREFIX + promptExternalIdentity);
            Element associatedPromptElement = IQModelImplUtilities.newSubelement(parentNode, "AssociatedPromptUse");
            IQModelImplUtilities.setAttr(associatedPromptElement, "ref", promptExternalIdentity);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
    }

    void writeUnderNewSubelement(LocalizableString localizableString, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        PersistenceInterface persistableForm = null;
        persistableForm = localizableString instanceof PersistenceInterface ? (PersistenceInterface)localizableString : (PersistenceInterface)IQModelImplUtilities.copyToLocalizablePersistableString(localizableString);
        this.writeUnderNewSubelement(persistableForm, parentNode, writingContext, newSubelementName);
    }

    void writeUnderNewSubelement(EntityInterface entity, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        if (IQModelImplUtilities.hasMeaningfulContent(entity)) {
            Element newSubelement = IQModelImplUtilities.newSubelement(parentNode, newSubelementName);
            this.writeUnder(entity, newSubelement, writingContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeUnder(EntityInterface entity, Node parentNode, WritingContext writingContext) throws MetadataException {
        HashMap mapToPutVersionInto = new HashMap(4, 0.9f);
        EntityPersistenceUtility.write((EntityInterface)entity, (Node)parentNode, (boolean)true, mapToPutVersionInto);
        String entityVersionNumber = (String)mapToPutVersionInto.get("version");
        if (entityVersionNumber == null) {
            _logger.debug("Version information for an entity is not available");
            return;
        }
        ModelVersion softwareVersion = ModelVersion.THIS_SOFTWARE_VERSION;
        ModelVersion entityModelVersion = new ModelVersion(entityVersionNumber);
        if (softwareVersion.laterThanOrSame(entityModelVersion)) {
            writingContext.adjustModelVersion(entityModelVersion);
            return;
        }
        MessageFormatter err = IQModelImplUtilities.getMessageFormatter("UnsupportedEntityVersion.fmt.txt", entityVersionNumber);
        throw new MetadataException(err);
    }

    static {
        PROMPT_WRITING_OPTIONS.put("PROMPT_VALUES_XML_WRITE_ALL_DEFINITIONS", null);
        PROMPT_WRITING_OPTIONS.put("removeUnreferencedPersistenceIDs", null);
        PROMPT_WRITING_OPTIONS = Collections.unmodifiableMap(PROMPT_WRITING_OPTIONS);
        PROMPTGROUP_WRITING_OPTIONS = new HashMap(4);
        PROMPTGROUP_WRITING_OPTIONS.putAll(PROMPT_WRITING_OPTIONS);
        PROMPTGROUP_WRITING_OPTIONS.put("PROMPT_GROUP_XML_WRITE_REFS_NOT_DEFINITIONS", null);
        PROMPTGROUP_WRITING_OPTIONS = Collections.unmodifiableMap(PROMPTGROUP_WRITING_OPTIONS);
    }
}

