/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.impl.EntityHandler;
import com.sas.iquery.metadata.business.impl.ObjectProvider;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.util.PromptContentHandler;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IntegratedObjectHandlerAdapter
implements ObjectProvider {
    private ContentHandler _handler;

    public static IntegratedObjectHandlerAdapter newAdapterForElement(String elementName, ReadingContextV2 readingContext) throws SAXException {
        IntegratedObjectHandlerAdapter out = null;
        ContentHandler handler = IntegratedObjectHandlerAdapter.getIntegratedObjectContentHandler(elementName, readingContext);
        if (handler != null) {
            out = new IntegratedObjectHandlerAdapter(handler);
        }
        return out;
    }

    private IntegratedObjectHandlerAdapter(ContentHandler handler) {
        if (!(handler instanceof EntityHandler) && !(handler instanceof PromptContentHandler)) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IntegratedObjectHandlerAdapter.InvalidContentHandler.fmt.txt", handler.getClass().getName());
            throw new IQueryServicesRuntimeException(formatter);
        }
        this._handler = handler;
    }

    public ContentHandler getContentHandler() {
        return this._handler;
    }

    public boolean isDone() {
        boolean out = false;
        if (this._handler instanceof EntityHandler) {
            out = ((EntityHandler)this._handler).isDone();
        } else if (this._handler instanceof PromptContentHandler) {
            out = ((PromptContentHandler)this._handler).getObject() != null;
        }
        return out;
    }

    @Override
    public Object getObject() {
        EntityInterface out = null;
        if (this._handler instanceof EntityHandler) {
            out = ((EntityHandler)this._handler).getEntity();
        } else if (this._handler instanceof PromptContentHandler) {
            out = ((PromptContentHandler)this._handler).getObject();
        }
        return out;
    }

    private static ContentHandler getIntegratedObjectContentHandler(String elementName, ReadingContextV2 readingContext) throws SAXException {
        EntityHandler out = null;
        if ("Entity".equals(elementName)) {
            out = new EntityHandler(readingContext.getDocToReuseForReadingEntities());
        } else {
            LoggerFactoryInterface pvLogger = readingContext.getPromptsLogger();
            PromptsReadingContext prc = readingContext.getReusedPromptsReadingContext();
            out = PromptContentHandler.newHandlerForElement2((String)elementName, (LoggerFactoryInterface)pvLogger, (PromptsReadingContext)prc);
        }
        return out;
    }
}

