/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.ChangeHistoryItem;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterCascadeRule;
import com.sas.iquery.metadata.business.FilterSet;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.FilterSetRuleItems;
import com.sas.iquery.metadata.business.FilterSetRulesContainer;
import com.sas.iquery.metadata.business.ForeignKey;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.KeyRelationships;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.UniqueKey;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelReference;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.BusinessModelReferenceInfoImpl;
import com.sas.iquery.metadata.business.impl.ColumnManagerImpl2;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.FilterSetImpl;
import com.sas.iquery.metadata.business.impl.FilterSetRuleItemsImpl;
import com.sas.iquery.metadata.business.impl.ForeignKeyImpl;
import com.sas.iquery.metadata.business.impl.IQUsageVersions;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.InformationMapExternalResourceResolver;
import com.sas.iquery.metadata.business.impl.InformationMapReadingContext;
import com.sas.iquery.metadata.business.impl.KeyRelationshipsImpl;
import com.sas.iquery.metadata.business.impl.QualifiedColumnImpl;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.business.impl.StringOnlyKeyValuesMapping;
import com.sas.iquery.metadata.business.impl.UniqueKeyImpl;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.impl.XMLV2ModelHandler;
import com.sas.iquery.metadata.business.impl.XMLV2VersionHandler;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.OMRBriefInformationMap;
import com.sas.iquery.metadata.impl.cache.TextStoreMgr;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Key;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.metadata.physical.oma.OMAPrimaryKey;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceResolutionTypeComparator;
import com.sas.iquery.metadata.resourceutil.physical.ResourceReplacementProxy;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.AuthResult;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.util.UsageVersion;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InformationMapImpl2
extends AbstractBusinessModel
implements InformationMap,
FilterSetRulesContainer {
    private static final int MAX_OMR_DESC_LENGTH = 200;
    private BriefInformationMap briefMap;
    private List<String> keywords = new ArrayList<String>();
    private StringOnlyKeyValuesMapping _attributes = new StringOnlyKeyValuesMapping();
    private EntityInterface extendedAttributes;
    private FilterSet _generalFilterSet = null;
    private boolean _loadedLocalizableProperties = false;
    private static final String SQ = "\"";
    private static final String NA = "\"N/A\"";
    private static final Logger _auditLogger = LogManager.getLogger((String)"com.sas.iquery.audit");
    private static final Logger _logger = LogManager.getLogger(InformationMapImpl2.class);
    private static final Logger _perfMRLogger = LogManager.getLogger((String)"com.sas.iquery.perf.MapReading");
    private static final Logger _persistRFSLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.summary");
    private static final Logger _persistRFDLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.details");
    private static final Logger _sessionLogger = LogManager.getLogger((String)"com.sas.services.session.SessionService");
    private static final Logger _amLogger = LogManager.getLogger(AbstractModel.class);
    private static final int KEYACTIONS_SAVE_ID = 3;
    private static final int KEYACTIONS_OPEN_ID = 4;
    private static final String KEY_INDEX_TEMPLATE = "<TEMPLATES><PhysicalTable>    <Columns/>    <Indexes/>    <UniqueKeys/>    <ForeignKeys/></PhysicalTable><Column>    <ForeignKeyAssociations/>    <Indexes/>    <Keys/>    <UniqueKeyAssociations/></Column><Index>    <Columns/></Index><ForeignKey>    <KeyAssociations/>    <PartnerUniqueKey/>    <KeyedColumns/></ForeignKey><UniqueKey>    <ForeignKeys/>    <KeyedColumns/></UniqueKey><KeyAssociation>    <ForeignKeyColumn/>    <OwningForeignKey/>    <UniqueKeyColumn/></KeyAssociation></TEMPLATES>";
    static final String CDATA_OPEN = "<![CDATA[";
    static final String CDATA_CLOSE = "]]>";
    private static final String linesep = System.getProperty("line.separator");
    static final String INFORMATION_MAP_TRANSFORM_ROLE = "InformationMap";
    protected static final String READ_TEMPLATE_LATE_BINDING = "<TEMPLATES><Transformation><Prompts/><Notes search=\"@TextRole=''LocaleProperties'' and @Name=''{0}''\"/><SourceCode/><Keywords/></Transformation></TEMPLATES>";
    private static final String READ_TEMPLATE_LATE_BINDING_NO_SOURCE = "<TEMPLATES><Transformation><Prompts/><Notes search=\"@TextRole=''LocaleProperties'' and @Name=''{0}''\"/><Keywords/></Transformation></TEMPLATES>";
    public static final String XML_PERSISTENCE_SYNTAX_VERSION_LATER_THAN_912 = "00000007";
    private static final List<String> SAVE_OPTIONS = Arrays.asList("AllowMajorVersionIncrease", "AllowMinorVersionIncrease");
    private static final List<String> SAVE_VALUES = Arrays.asList("true", "false");

    InformationMapImpl2() {
    }

    public static InformationMap newInformationMap(IntelligentQueryMetadataServiceInterface service, SessionContextInterface session) {
        return new InformationMapImpl2(service, session);
    }

    public static InformationMap newInformationMap(IntelligentQueryMetadataServiceInterface service, SessionContextInterface session, Locale dataLocale) {
        return new InformationMapImpl2(service, session, dataLocale);
    }

    protected InformationMapImpl2(IntelligentQueryMetadataServiceInterface service, SessionContextInterface session) {
        this(service, session, LocaleUtilities.getDefaultComputationalLocale(session));
    }

    protected InformationMapImpl2(IntelligentQueryMetadataServiceInterface service, SessionContextInterface session, Locale locale) {
        super(session, service, locale);
        Preconditions.ensureNonNull(locale, "locale");
        this.extendedAttributes = null;
    }

    @Override
    public BriefInformationMap getBriefMap() throws MetadataException {
        return this.briefMap;
    }

    @Override
    public void setBriefMap(BriefInformationMap bmap) {
        this.briefMap = bmap;
    }

    @Override
    public AbstractModelReference getModelReference() throws MetadataException {
        return (AbstractModelReference)((Object)this.getReferenceInfo());
    }

    @Override
    public BusinessModelReferenceInfo getReferenceInfo() {
        String businessModelID = this.getID();
        PathUrl path = null;
        String location = null;
        if (this.isUnresolved()) {
            location = this.getLocationWhenUnresolved();
        } else if (this.briefMap != null) {
            try {
                path = this.briefMap.getPathUrl();
                if (path != null) {
                    location = path.toString();
                }
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return new BusinessModelReferenceInfoImpl(this, businessModelID, location, "InformationService PathUrl");
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    public List<String> getKeywords() {
        assert (this.keywords != null);
        return new ArrayList<String>(this.keywords);
    }

    public void setKeywords(List<String> keywords) {
        assert (keywords != null);
        this.keywords = new ArrayList<String>(keywords);
    }

    public void removeKeyword(String keyword) {
        this.keywords.remove(keyword);
    }

    @Override
    public Map<String, String> getAttributes() throws MetadataException {
        return this._attributes.get();
    }

    @Override
    public void setAttributes(Map<String, String> attributeMap) throws MetadataException {
        if (attributeMap != null) {
            this._attributes.set(attributeMap);
        } else {
            this._attributes.set(Collections.emptyMap());
        }
    }

    @Override
    public void setLabel(String label) throws MetadataException {
        if (label != null) {
            for (int i = 0; i < label.length(); ++i) {
                if (!Character.isISOControl(label.charAt(i))) continue;
                MessageFormatter reasonMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.InvalidLabelChars.fmt.txt", Integer.toString(i + 1));
                throw new MetadataException(reasonMsg);
            }
        }
        super.setLabel(label);
    }

    @Override
    public void setExtendedAttributes(EntityInterface attrEntity) throws MetadataException {
        this.extendedAttributes = attrEntity;
    }

    @Override
    public EntityInterface getExtendedAttributes() {
        return this.extendedAttributes;
    }

    @Override
    public KeyRelationships getKeyRelationships() throws MetadataException {
        Table table;
        RepositoryInterface repository = null;
        String jomaType = "PHYSICALTABLE";
        List<DataSourceTable> dataSourceTables = this.getObjects(true, DataSourceTable.class);
        boolean empty = true;
        MessageFormatter unresolvedMsg = null;
        try {
            FilterComponent mainFilterComponent = new FilterComponent();
            mainFilterComponent.setAggregation(1);
            for (DataSourceTable dataSourceTable : dataSourceTables) {
                table = dataSourceTable.getTable();
                if (!(table instanceof OMAWrapper)) continue;
                OMAWrapper wrapper = (OMAWrapper)((Object)table);
                Root jomaObject = (Root)wrapper.getOMAObject();
                if (jomaObject != null) {
                    jomaType = jomaObject.getCMetadataType();
                    FilterComponent subFilterComponent = new FilterComponent("Id", 0, jomaObject.getFQID());
                    mainFilterComponent.addComponent(subFilterComponent);
                    empty = false;
                    continue;
                }
                if (!_logger.isEnabled(Level.WARN)) continue;
                Object[] args = new Object[]{table};
                unresolvedMsg = IQModelImplUtilities.getMessageFormatter("BusinessModelObjectImplObjectNotResolved.fmt.txt", args);
                _logger.warn(unresolvedMsg.toString());
            }
            repository = this.getRepository();
            if (repository != null) {
                if (!empty) {
                    IQModelImplUtilities.reGetObjectsWithTemplate(repository, jomaType, KEY_INDEX_TEMPLATE, 532480, mainFilterComponent);
                } else if (unresolvedMsg != null) {
                    throw new MetadataException(unresolvedMsg);
                }
            } else if (_logger.isEnabled(Level.WARN)) {
                String msg = IQModelImplUtilities.getMessage("InformationMap.NullRepositoryType.txt", new Object[0]);
                _logger.warn(msg);
            }
        }
        catch (RemoteException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw new MetadataException(e);
        }
        catch (ServiceException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw new MetadataException(e);
        }
        KeyRelationshipsImpl keyRelationships = new KeyRelationshipsImpl();
        for (DataSourceTable dataSourceTable : dataSourceTables) {
            table = dataSourceTable.getTable();
            if (table.isUnresolved()) continue;
            List<UniqueKey> businessUniqueKeys = this.createBusinessUniqueKeys(dataSourceTable);
            List<ForeignKey> businessForeignKeys = this.createBusinessForeignKeys(dataSourceTable);
            keyRelationships.addTableAndKeys(dataSourceTable, businessUniqueKeys, businessForeignKeys);
        }
        return keyRelationships;
    }

    @Override
    public synchronized List<BusinessItem> removeBusinessItem(BusinessItem businessItem) throws MetadataException {
        List<BusinessItem> dependentItems = super.removeBusinessItem(businessItem);
        MapFolder folder = this.getMapFolderContaining(businessItem);
        this.removeBusinessItem(businessItem, folder);
        for (BusinessItem item : dependentItems) {
            folder = this.getMapFolderContaining(item);
            this.removeBusinessItem(item, folder);
        }
        return dependentItems;
    }

    @Override
    public FilterCascadeRule newFilterCascadeRule() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Map<String, String> save(FolderInterface folderToSaveInto, String changeHistoryDescription, Map<String, String> saveOptions) throws MetadataException {
        HashMap<String, String> validatedOptions = saveOptions == null ? Collections.emptyMap() : new HashMap<String, String>(saveOptions);
        this.verifySaveOptions(validatedOptions);
        Preconditions.ensureNonNull(folderToSaveInto, "folderToSaveInto");
        String mapName = this.getLabel();
        if (mapName == null || mapName.length() == 0) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.CannotSaveWithNullOrEmptyName.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
        if (mapName.length() > 60) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.NameIsLongerThan60CharMax.fmt.txt", mapName);
            throw new MetadataException(formatter);
        }
        return this.write(folderToSaveInto, changeHistoryDescription, this.briefMap, validatedOptions);
    }

    @Override
    public BriefInformationMap save(FolderInterface folderToSaveInto, String changeHistoryDescription) throws MetadataException {
        this.save(folderToSaveInto, changeHistoryDescription, Collections.emptyMap());
        return this.getBriefMap();
    }

    @Override
    public synchronized BriefInformationMap save(String changeHistoryDescription) throws MetadataException {
        try {
            FolderInterface folderToSaveInto = null;
            if (this.briefMap == null) {
                MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.MapNotPreviouslySaved.txt", new Object[0]);
                throw new MetadataException(errorMsg);
            }
            folderToSaveInto = this.briefMap.getOwningFolder();
            return this.save(folderToSaveInto, changeHistoryDescription);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> write(FolderInterface folderToSaveInto, String changeNote, MetadataInterface readFromSmartObject, Map<String, String> saveOptions) throws MetadataException {
        HashMap<String, String> saveOperationResultsForUser = new HashMap<String, String>();
        BriefInformationMap outBriefObject = null;
        AbstractModel.FailedWriteCleanupInfo cleanupInfo = null;
        try {
            Object syncObject;
            List promptsFromReplacedMap = null;
            BriefInformationMap briefObjectToReplace = null;
            if (readFromSmartObject != null && !readFromSmartObject.isCompatible()) {
                UsageVersion versionFromMapOriginallyRead = readFromSmartObject.getUsageVersion();
                Object[] args = new Object[]{this.getLabel(), versionFromMapOriginallyRead, OMRBriefInformationMap.CURRENT_VERSION};
                MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.WriteOverNotAllowedBecauseRunningOlderSoftware.fmt.txt", args);
                throw new MetadataException(formatter);
            }
            RepositoryInterface ri = folderToSaveInto.getRepository();
            if (!(ri instanceof OMIRepositoryInterface)) {
                MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("AbstractModel.NonMetadataServerRepositoryTypeNotSupported.txt", new Object[0]);
                throw new MetadataException(formatter);
            }
            cleanupInfo = new AbstractModel.FailedWriteCleanupInfo();
            ChangeHistoryItem historyItem = this.newChangeHistoryItem(changeNote);
            this._changeHistory.add(historyItem);
            cleanupInfo.setUpdatedChangeHistory(this._changeHistory);
            AbstractModel.ModelWritingInput input = new AbstractModel.ModelWritingInput(true, false);
            OMIRepositoryInterface repos = (OMIRepositoryInterface)ri;
            input.setRepository(repos);
            cleanupInfo.setRepository(repos);
            input.setCleanupInfo(cleanupInfo);
            AbstractModel.ModelWritingResults writeResults = this.writeModelUnderAndFinalizeXML(input);
            Element modelElement = writeResults.getElement();
            StringBuffer mapXMLBuffer = new StringBuffer();
            mapXMLBuffer.append(this.getStoredTextPrefix()).append("<?xml version='1.0' encoding='UTF-8'?>").append(IQModelImplUtilities.toString(modelElement));
            String mapXML = mapXMLBuffer.toString();
            List privatePromptsCreated = writeResults.getPrivateExternalPromptsNeedingAssociations();
            List transformationSourcesToLinkTo = InformationMapImpl2.computeTransformationSources(writeResults.getMetadataRepositoryResources());
            briefObjectToReplace = (BriefInformationMap)folderToSaveInto.getItemByType(this.getLabel(), INFORMATION_MAP_TRANSFORM_ROLE);
            this.checkAuthorizationToWrite(briefObjectToReplace, folderToSaveInto, repos);
            boolean replacingObject = briefObjectToReplace != null;
            UsageVersion usageVersionToWrite = this.getUsageVersionToWrite(writeResults);
            Transformation transform = null;
            BriefInformationMap smartObjectToSaveTo = null;
            if (!replacingObject) {
                transform = (Transformation)InformationMapImpl2.newOmrObject("Transformation", repos, this.getLabel());
                transform.setTransformRole(this.getOMRTransformRole());
                transform.setPublicType(this.getPublicTypeToWrite());
                smartObjectToSaveTo = repos.factoryProcess((Object)transform);
                this.moveNotes(readFromSmartObject, transform);
                ThreadContext.put((String)"actionType", (String)"New");
            } else {
                smartObjectToSaveTo = briefObjectToReplace;
                promptsFromReplacedMap = smartObjectToSaveTo.getPrompts();
                Root omrObject = (Root)smartObjectToSaveTo.getRepositoryEntity();
                if (!(omrObject instanceof Transformation)) {
                    InformationMapImpl2.staticPersistenceError(IQModelImplUtilities.getMessageFormatter("OMRInformationMapPersistor.PersistingToNonTransformationObj.txt", new Object[0]));
                }
                transform = (Transformation)omrObject;
                double previousVersionEncoded = transform.getUsageVersion();
                UsageVersion previousVersion = UsageVersion.decode((double)previousVersionEncoded);
                this.writetimeVersionIncreaseCheck(usageVersionToWrite, previousVersion, saveOptions, saveOperationResultsForUser);
                ThreadContext.put((String)"actionType", (String)"Replace");
            }
            if (!(smartObjectToSaveTo instanceof BriefInformationMap)) {
                Object[] args = new Object[]{smartObjectToSaveTo == null ? "null" : smartObjectToSaveTo.getClass().getName()};
                MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.FailedToCreateProperObjectType.fmt.txt", args);
                throw new MetadataException(formatter);
            }
            outBriefObject = smartObjectToSaveTo;
            Object object = syncObject = InformationMapImpl2.getSynchronizationObject(outBriefObject, this.getSession());
            synchronized (object) {
                String transformRole;
                if (replacingObject && ((transformRole = (transform = (Transformation)InformationMapImpl2.readCompositeObjectFromOmr((Root)transform, repos, READ_TEMPLATE_LATE_BINDING)).getTransformRole()) == null || !transformRole.equals(this.getOMRTransformRole()))) {
                    InformationMapImpl2.staticPersistenceError(IQModelImplUtilities.getMessageFormatter("OMRInformationMapPersistor.PersistingToNonInfoMapTransObj.txt", new Object[0]));
                }
                transform.setName(this.getLabel());
                transform.setDesc(this.getDescription());
                transform.setUsageVersion(usageVersionToWrite.encode());
                transform.setPublicType(this.getPublicTypeToWrite());
                transform.setIsUserDefined(1);
                TextStore omrTextStore = null;
                Text omrObject = transform.getSourceCode();
                omrTextStore = omrObject instanceof TextStore ? (TextStore)omrObject : (TextStore)InformationMapImpl2.newOmrObject("TextStore", repos, this.getLabel());
                omrTextStore.setStoredText(mapXML);
                outBriefObject.setPrompts(privatePromptsCreated);
                transform.setSourceCode((Text)omrTextStore);
                this.writeLocalizedTextStore(transform, writeResults, repos);
                transformationSourcesToLinkTo = this.filterNonWriteAccessibleObjs(transformationSourcesToLinkTo, repos);
                AssociationList tSources = transform.getTransformationSources();
                tSources.clear();
                tSources.addAll((Collection)transformationSourcesToLinkTo);
                if (!replacingObject) {
                    folderToSaveInto.addItem((MetadataInterface)outBriefObject);
                }
                outBriefObject.update();
                cleanupInfo = null;
                InformationMapImpl2.removeJomaObjectFromItsStores((Root)omrTextStore);
            }
            InformationMapImpl2.deletePromptsQuietly(promptsFromReplacedMap, repos);
        }
        catch (RemoteException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        catch (ServiceException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        catch (MdException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        finally {
            if (cleanupInfo != null) {
                cleanupInfo.cleanupFromFailedWrite();
            }
        }
        this.briefMap = outBriefObject;
        try {
            String folderPath = null;
            folderPath = folderToSaveInto.getPath();
            folderPath = folderPath != null ? SQ + (folderPath.indexOf("/") == 0 ? folderPath : "/" + folderPath) + SQ : NA;
            ThreadContext.put((String)"sessionID", (String)this.getSession().getEntityKey());
            ThreadContext.put((String)"user", (String)this.getSession().getUserContext().getResolvedUserId());
            ThreadContext.put((String)"map", (String)(SQ + this.briefMap.getName() + SQ));
            ThreadContext.put((String)"transID", (String)this.briefMap.getReposId());
            ThreadContext.put((String)"folder", (String)folderPath);
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        ThreadContext.put((String)"actionID", (String)String.valueOf(3));
        ThreadContext.put((String)"action", (String)"Save");
        _auditLogger.info("");
        return saveOperationResultsForUser;
    }

    private void moveNotes(MetadataInterface readFromSmartObject, Transformation newTransform) throws RemoteException, MdException {
        Root omrObject;
        if (readFromSmartObject != null && newTransform != null && readFromSmartObject instanceof OMRBriefInformationMap && !readFromSmartObject.isDeleted() && !readFromSmartObject.isDestroyed() && (omrObject = (Root)((OMRBriefInformationMap)readFromSmartObject).getRepositoryEntity()) instanceof Transformation) {
            Transformation transformation = (Transformation)omrObject;
            AssociationList oldNotes = transformation.getNotes(true);
            AssociationList copyOfNotes = AssociationListUtil.copy((CMetadata)newTransform, oldNotes);
            newTransform.setNotes(copyOfNotes, 16);
        }
    }

    private void writeLocalizedTextStore(Transformation transform, AbstractModel.ModelWritingResults modelWritingResults, OMIRepositoryInterface repos) throws RemoteException, MdException, ServiceException {
        HashMap<Locale, PropertyList> propMap = modelWritingResults.getPropertyMap();
        if (propMap.isEmpty()) {
            return;
        }
        String textRole = "LocaleProperties";
        AssociationList notes = transform.getNotes(true);
        int size = notes.size();
        if (size == 0) {
            for (Map.Entry<Locale, PropertyList> entry : propMap.entrySet()) {
                Locale loc = entry.getKey();
                PropertyList propList = entry.getValue();
                if (propList.isEmpty()) continue;
                String txt = this.writerPropertyList(propList);
                TextStore textStore = (TextStore)InformationMapImpl2.newOmrObject("TextStore", repos, loc.toString());
                textStore.setTextRole("LocaleProperties");
                textStore.setStoredText(txt);
                notes.add((Object)textStore);
            }
        } else {
            for (Map.Entry<Locale, PropertyList> entry : propMap.entrySet()) {
                Locale loc = entry.getKey();
                PropertyList propList = entry.getValue();
                if (propList.isEmpty()) continue;
                boolean found = false;
                String txt = this.writerPropertyList(propList);
                String locStr = loc.toString();
                for (int i = 0; i < size; ++i) {
                    TextStore textStore = (TextStore)notes.get(i);
                    if (!locStr.equalsIgnoreCase(textStore.getName())) continue;
                    textStore.setStoredText(txt);
                    found = true;
                }
                if (found) continue;
                TextStore textStore = (TextStore)InformationMapImpl2.newOmrObject("TextStore", repos, loc.toString());
                textStore.setTextRole("LocaleProperties");
                textStore.setStoredText(txt);
                notes.add((Object)textStore);
            }
        }
    }

    private String writerPropertyList(PropertyList propList) {
        StringWriter writer = new StringWriter(32);
        writer.append(CDATA_OPEN);
        try {
            propList.save((Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        writer.append(CDATA_CLOSE);
        StringBuffer txt = writer.getBuffer();
        txt.trimToSize();
        String propString = txt.toString();
        propString = propString.replaceAll("\r", "");
        return propString;
    }

    private void checkAuthorizationToWrite(MetadataInterface briefObjectToReplace, FolderInterface folderToSaveInto, OMIRepositoryInterface repos) throws MetadataException, ServiceException, RemoteException {
        boolean newMap;
        boolean bl = newMap = briefObjectToReplace == null;
        if (newMap) {
            if (!folderToSaveInto.isAuthorized("WriteMemberMetadata")) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("InformationMapImpl.NotAuthorizedToCreate.txt", new Object[0]));
            }
        } else if (!briefObjectToReplace.isAuthorized("WriteMetadata")) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("InformationMapImpl.NotAuthorizedToUpdate.txt", new Object[0]));
        }
        if (this.willCreateOMRObjectsWhenWriting(newMap) && !repos.isUserAuthorizedInRepository("WriteMetadata")) {
            MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.CannotCreateNewObjectsInRepository.fmt.txt", this.getLabel(), repos.getDefaultRepositoryName());
            throw new MetadataException(messageFormatter);
        }
    }

    private boolean willCreateOMRObjectsWhenWriting(boolean newMapIsBeingCreated) {
        return newMapIsBeingCreated || this.getObjects(false, Prompt.class).size() > 0;
    }

    private List filterNonWriteAccessibleObjs(List jomaObjects, OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        ArrayList out = new ArrayList(jomaObjects.size());
        for (Object jomaObject : jomaObjects) {
            MetadataInterface mi;
            if (!(jomaObject instanceof Root) || (mi = repos.factoryProcess(jomaObject)) == null) continue;
            if (!mi.isObjectAlive()) {
                this.warnNoLongerExists(mi);
                continue;
            }
            out.add(jomaObject);
        }
        return out;
    }

    private void warnNoLongerExists(MetadataInterface mi) {
        String name;
        String type;
        try {
            type = mi.getType();
        }
        catch (RemoteException e) {
            type = IQModelImplUtilities.getMessage("Unknown.txt", new Object[0]);
        }
        try {
            name = mi.getName();
        }
        catch (RemoteException e) {
            name = IQModelImplUtilities.getMessage("Unknown.txt", new Object[0]);
        }
        if (_logger.isEnabled(Level.WARN)) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ObjectNoLongerExists.fmt.txt", type, name);
            _logger.warn(formatter.toString());
        }
    }

    private void writetimeVersionIncreaseCheck(UsageVersion usageVersionToWrite, UsageVersion previousVersion, Map<String, String> saveOptions, Map<String, String> saveOperationResultsForUser) throws MetadataException {
        if (previousVersion.compareTo((Object)IQUsageVersions.VERSION_92) >= 0) {
            int previousMajorVersion;
            int majorVersionToWrite = usageVersionToWrite.getMajorVersion();
            if (majorVersionToWrite > (previousMajorVersion = previousVersion.getMajorVersion())) {
                boolean allowMajorVersionIncrease = this.shouldWeAllowMajorVersionIncrease(saveOptions);
                if (!allowMajorVersionIncrease) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("SAVE of information map failed because it would upgrade the major version number from " + previousVersion.toString() + " to " + usageVersionToWrite.toString() + " and save option allowing this was not set.");
                    }
                    Object[] args = new Object[]{this};
                    MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.WriteOverNotAllowedBecauseItWouldUpgradeMajorVersion.fmt.txt", args);
                    Reason reason = new Reason((Object)this, 1, 234, formatter);
                    MetadataException e = new MetadataException(formatter, Arrays.asList(reason));
                    throw e;
                }
            } else if (majorVersionToWrite == previousMajorVersion) {
                int minorVersionToWrite = usageVersionToWrite.getMinorVersion();
                int previousMinorVersion = previousVersion.getMinorVersion();
                boolean allowMinorVersionIncrease = this.shouldWeAllowMinorVersionIncrease(saveOptions);
                if (minorVersionToWrite > previousMinorVersion && !allowMinorVersionIncrease) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("SAVE of information map failed because it would upgrade the minor version number from " + previousVersion.toString() + " to " + usageVersionToWrite.toString() + " and save option allowing this was not set.");
                    }
                    Object[] args = new Object[]{this};
                    MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.WriteOverNotAllowedBecauseItWouldUpgradeMinorVersion.fmt.txt", args);
                    Reason reason = new Reason((Object)this, 1, 235, formatter);
                    MetadataException e = new MetadataException(formatter, Arrays.asList(reason));
                    throw e;
                }
            }
            if (previousVersion.compareTo((Object)usageVersionToWrite) < 0) {
                saveOperationResultsForUser.put("SaveResultedInVersionIncrease", "true");
            }
        }
    }

    @Override
    protected String getLocationWhenNotUnresolved() throws MetadataException {
        String out = null;
        if (this.briefMap != null) {
            try {
                PathUrl path = this.briefMap.getPathUrl();
                if (path != null) {
                    out = path.getAbsolutePath();
                }
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
            catch (ServiceException e) {
                throw new MetadataException(e);
            }
        }
        return out;
    }

    @Override
    protected MetadataInterface getSmartObject() {
        return this.briefMap;
    }

    @Override
    protected boolean hasPersistedStorageLocation() {
        return super.hasPersistedStorageLocation() || this.briefMap != null;
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        InformationMapImpl2.writeForeignObjectUnderNewSubelement(this.extendedAttributes, thisElement, writingContext, "ExtendedAttributes");
        if (this._attributes != null && this._attributes.count() > 0) {
            InformationMapImpl2.writeRelatedObject(this._attributes, thisElement, writingContext, "KeyValueAttributes");
        }
        InformationMapImpl2.writeRelatedObject(this._generalFilterSet, thisElement, writingContext, "GeneralFilterSet");
        String jarVersion = this.getJarVersionToWrite();
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "iqSvcsJarVersion", jarVersion);
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        attrsProvider.consumeAttrEmptyDefault("iqSvcsJarVersion");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder rih) throws SAXException {
        super.consumeRelatedObjects(rih);
        this.extendedAttributes = (EntityInterface)rih.consumeForeignObject("ExtendedAttributes");
        StringOnlyKeyValuesMapping attributes = (StringOnlyKeyValuesMapping)rih.consumeObject("KeyValueAttributes");
        if (attributes != null) {
            this._attributes = attributes;
        }
        this._generalFilterSet = (FilterSet)((Object)rih.consumeObject("GeneralFilterSet"));
    }

    @Override
    protected void adjustTopSubelementsOrder(ArrayList<String> priorityElementNames) {
        priorityElementNames.add("ContainedItems");
        priorityElementNames.add("RootFolder");
        priorityElementNames.add("DataLocale");
        priorityElementNames.add("KeyValueAttributes");
        priorityElementNames.add("ChangeHistory");
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this.extendedAttributes = this.v1_readExtendedAttributes(thisElement);
        this.readGeneralFilterSetV1(thisElement, readingContext);
        List<Element> subelements = IQModelImplUtilities.getSubelements(thisElement);
        int size = subelements.size();
        for (int i = 0; i < size; ++i) {
            Element subelement = subelements.get(i);
            String elementName = subelement.getTagName();
            if (elementName.equals("InformationMapAttributeList")) {
                this.readInformationMapAttributesV1(subelement);
                continue;
            }
            if (!elementName.equals("DataLocale")) continue;
            this.readLocaleV1(subelement);
        }
    }

    @Override
    protected void resolveExternalDependenciesV1(ReadingContext resolutionContext) throws MetadataException {
        InformationMapExternalResourceResolver handler = new InformationMapExternalResourceResolver(resolutionContext);
        handler.setDoResolve(resolutionContext.isDoResolveExternalResources());
        handler.bindExternalResources();
    }

    @Override
    public void read(Element elMapModel, Map availableResources) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    public static FactoryResultsImpl readInNewMap(BriefInformationMap briefMap, IntelligentQueryMetadataServiceInterface service, SessionContextInterface session) throws MetadataException {
        return InformationMapImpl2.readInNewMap(briefMap, service, session, false, true);
    }

    public static FactoryResultsImpl readInNewMap(BriefInformationMap briefMap, IntelligentQueryMetadataServiceInterface service, SessionContextInterface session, boolean externalOnly, boolean doResolveExternalResources) throws MetadataException {
        long start = 0L;
        if (_persistRFSLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowSummary(">> InformationMapImpl2.readNewMap(BriefInformationMap)");
            start = System.currentTimeMillis();
        }
        if (_perfMRLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogMapReadingPerformance("> Reading (fetching and parsing) infomap from briefMap: " + briefMap.toString());
            start = System.currentTimeMillis();
        }
        FactoryResultsImpl results = InformationMapImpl2.fetchMap(briefMap, service, session, externalOnly, doResolveExternalResources);
        try {
            String folderPath = null;
            FolderInterface folder = briefMap.getParent();
            folderPath = folder != null ? ((folderPath = folder.getPath()) != null ? SQ + (folderPath.indexOf("/") == 0 ? folderPath : "/" + folderPath) + SQ : NA) : NA;
            ThreadContext.put((String)"sessionID", (String)session.getEntityKey());
            ThreadContext.put((String)"user", (String)session.getUserContext().getResolvedUserId());
            ThreadContext.put((String)"map", (String)(SQ + briefMap.getName() + SQ));
            ThreadContext.put((String)"transID", (String)briefMap.getReposId());
            ThreadContext.put((String)"folder", (String)folderPath);
        }
        catch (RemoteException folderPath) {
        }
        catch (ServiceException folderPath) {
            // empty catch block
        }
        ThreadContext.put((String)"actionID", (String)String.valueOf(4));
        ThreadContext.put((String)"action", (String)"Open");
        ThreadContext.put((String)"actionType", (String)"Persisted");
        _auditLogger.info("");
        if (_persistRFSLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogReadFlowSummary("<< InformationMapImpl2.readNewMap(BriefInformationMap): " + (end - start) + "ms");
        }
        if (_perfMRLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogMapReadingPerformance("< done reading (" + (end - start) + "ms)");
        }
        return results;
    }

    public static InformationMapImpl2 readInNewMap(Element mapElement, Map linkedResources, IntelligentQueryMetadataServiceInterface iqService, SessionContextInterface session) throws MetadataException {
        Object readingContext;
        long timestamp = 0L;
        if (_persistRFSLogger.isDebugEnabled()) {
            timestamp = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogReadFlowSummary(">> InformationMapImpl2.readNewMap(Element)");
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("start instantiatioInformationMapImplImpl2");
        InformationMapImpl2 outMap = new InformationMapImpl2(iqService, session);
        ExtraLoggingContexts.debugLogReadFlowDetails("end   instantiation of InformationMapImpl2");
        ModelVersion version = IQModelImplUtilities.getModelVersionAttr(mapElement, "ver");
        boolean v2XML = outMap.checkModelVersion(version);
        if (v2XML) {
            ExtraLoggingContexts.debugLogReadFlowSummary("  V2 XML recognized.  Using DOM V2 parsing flow -- DOM because API was given DOM.");
            readingContext = new ReadingContextV2(outMap);
            outMap.readDOMV2(mapElement, (ReadingContextV2)readingContext);
        } else {
            ExtraLoggingContexts.debugLogReadFlowSummary("  V1 XML recognized.  Using old V1 parsing flow.");
            readingContext = new InformationMapReadingContext(outMap);
            outMap.readV1(mapElement, (ReadingContext)readingContext);
        }
        if (_persistRFSLogger.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - timestamp;
            ExtraLoggingContexts.debugLogReadFlowSummary("<< InformationMapImpl2.readNewMap(Element): " + elapsedTime + "ms (does not include DOM parse time)");
        }
        return outMap;
    }

    public static FactoryResultsImpl readInNewMap(String mapText, IntelligentQueryMetadataServiceInterface iqService, SessionContextInterface session, boolean doResolveExternalResources, boolean doProcessExternalResourcesOnly, List privatePromptSmartObjectsAttachedToModelInMetadataServer, boolean versionAlreadyChecked, MetadataServerInterface metadataServer) throws MetadataException {
        List<DataSourceTableImpl2.ReadModification> dstModifications;
        boolean v2XML;
        long timestamp = 0L;
        if (_persistRFSLogger.isDebugEnabled()) {
            timestamp = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogReadFlowSummary(">> InformationMapImpl2.readNewMap(String)    String size = " + mapText.length());
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("start instantiation of InformationMapImpl2");
        InformationMapImpl2 outMap = new InformationMapImpl2(iqService, session);
        ExtraLoggingContexts.debugLogReadFlowDetails("end   instantiation of InformationMapImpl2");
        ExtraLoggingContexts.debugLogReadFlowDetails("start quick determination of model version");
        ModelVersion modelVersion = null;
        if (versionAlreadyChecked) {
            v2XML = true;
        } else {
            modelVersion = InformationMapImpl2.quickGetModelVersion(mapText);
            v2XML = outMap.checkModelVersion(modelVersion);
        }
        ExtraLoggingContexts.debugLogReadFlowDetails("end   quick determination of model version");
        if (v2XML) {
            ExtraLoggingContexts.debugLogReadFlowSummary("  V2 XML recognized.  Using new V2 parsing flow.");
            ReadingContextV2 readingContext = new ReadingContextV2((AbstractModel)outMap, metadataServer);
            readingContext.setDoResolveExternalResources(doResolveExternalResources);
            String xmlToParse = mapText;
            if (doProcessExternalResourcesOnly) {
                xmlToParse = InformationMapImpl2.getMapExternalResourcesString(v2XML, mapText);
            }
            readingContext.setAssociatedPromptSmartObjects(privatePromptSmartObjectsAttachedToModelInMetadataServer);
            outMap.readV2(xmlToParse, readingContext);
            dstModifications = readingContext.getDSTReadMods();
        } else {
            ExtraLoggingContexts.debugLogReadFlowSummary("  V1 XML recognized.  Using old V1 parsing flow.");
            String externalString = mapText;
            if (doProcessExternalResourcesOnly) {
                externalString = InformationMapImpl2.getMapExternalResourcesString(v2XML, mapText);
            }
            Document doc = IQModelImplUtilities.newDocument(externalString);
            Element mapElement = doc.getDocumentElement();
            InformationMapReadingContext readingContext = new InformationMapReadingContext(outMap, metadataServer);
            readingContext.setDoResolveExternalResources(doResolveExternalResources);
            outMap.readV1(mapElement, readingContext);
            dstModifications = Collections.emptyList();
        }
        if (_persistRFSLogger.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - timestamp;
            ExtraLoggingContexts.debugLogReadFlowSummary("<< InformationMapImpl2.readNewMap(String): " + elapsedTime + "ms");
        }
        return new FactoryResultsImpl(outMap, dstModifications);
    }

    private static String getMapExternalResourcesString(boolean v2XML, String mapText) throws MetadataException {
        int endOfInfoMapTag = -1;
        int startOfExternalResourcesTag = -1;
        int endOfExternalResourcesTag = -1;
        int startOfEndInfoMapTag = -1;
        int endOfInfoMap = -1;
        String infoMapElement = null;
        String externalResourcesElement = null;
        if (v2XML) {
            infoMapElement = INFORMATION_MAP_TRANSFORM_ROLE;
            externalResourcesElement = "ExternalResources";
        } else {
            infoMapElement = INFORMATION_MAP_TRANSFORM_ROLE;
            externalResourcesElement = "ExternalResourceList";
        }
        String startInfoMapElement = "<" + infoMapElement;
        String startExternalResources = "<" + externalResourcesElement;
        String endExternalResources = "</" + externalResourcesElement + ">";
        String endInfoMapElement = "</" + infoMapElement + ">";
        int startIndex = mapText.indexOf(startInfoMapElement);
        endOfInfoMapTag = mapText.indexOf(62, startIndex + startInfoMapElement.length()) + 1;
        startOfExternalResourcesTag = mapText.indexOf(startExternalResources, endOfInfoMapTag);
        int endExternResIndex = mapText.indexOf(endExternalResources, startOfExternalResourcesTag);
        if (endExternResIndex <= 0) {
            return mapText;
        }
        endOfExternalResourcesTag = endExternResIndex + endExternalResources.length();
        startOfEndInfoMapTag = mapText.indexOf(endInfoMapElement, endOfExternalResourcesTag);
        endOfInfoMap = mapText.length();
        StringBuffer pS = new StringBuffer(mapText.length());
        pS.append(mapText.substring(0, endOfInfoMapTag));
        pS.append(mapText.substring(startOfExternalResourcesTag, endOfExternalResourcesTag));
        pS.append(mapText.substring(startOfEndInfoMapTag, endOfInfoMap));
        String externalString = pS.toString();
        return externalString;
    }

    private void readV2(String mapText, ReadingContextV2 readingContext) throws MetadataException {
        try {
            ExtraLoggingContexts.debugLogReadFlowDetails("Begin creating InputSource to parse");
            InputSource inputSource = new InputSource(new StringReader(mapText));
            ExtraLoggingContexts.debugLogReadFlowDetails("end   creating InputSource to parse");
            if (InformationMapImpl2.useDOMWhenReadingMap()) {
                ExtraLoggingContexts.debugLogReadFlowSummary("  USER OVERRIDE to use DOM instead of SAX for parsing V2 XML.");
                ExtraLoggingContexts.debugLogReadFlowDetails("begin getting DOM parser");
                DocumentBuilder domParser = IQModelImplUtilities.getDOMParser();
                ExtraLoggingContexts.debugLogReadFlowDetails("end   getting DOM parser");
                ExtraLoggingContexts.debugLogReadFlowDetails("before calling DOM parser");
                Document doc = domParser.parse(inputSource);
                ExtraLoggingContexts.debugLogReadFlowSummary("  Done creating DOM tree from XML string.");
                ExtraLoggingContexts.debugLogReadFlowDetails("after  calling DOM parser");
                ExtraLoggingContexts.debugLogReadFlowDetails("before dispensing DOM");
                this.readDOMV2(doc.getDocumentElement(), readingContext);
                ExtraLoggingContexts.debugLogReadFlowDetails("after  dispensing DOM");
            } else {
                ExtraLoggingContexts.debugLogReadFlowSummary("  Parsing model V2 XML using SAX.");
                this.readSAXV2(inputSource, readingContext);
            }
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException(e);
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
        catch (SAXException e) {
            throw new MetadataException(e);
        }
    }

    private void readDOMV2(Element mapElement, ReadingContextV2 readingContext) throws MetadataException {
        XMLV2ModelHandler xmlHandler = new XMLV2ModelHandler(readingContext);
        this.pushXMLAndPostProcess(mapElement, xmlHandler, readingContext);
    }

    private void readSAXV2(InputSource inputSource, ReadingContextV2 readingContext) throws MetadataException {
        ExtraLoggingContexts.debugLogReadFlowDetails("begin creating handler");
        XMLV2ModelHandler xmlHandler = new XMLV2ModelHandler(readingContext);
        long time = 0L;
        if (_persistRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails("end   creating handler");
            ExtraLoggingContexts.debugLogReadFlowDetails("begin SAX parsing & model creation");
            time = System.currentTimeMillis();
        }
        this.pushXMLAndPostProcess(inputSource, xmlHandler, readingContext);
        if (_persistRFDLogger.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - time;
            ExtraLoggingContexts.debugLogReadFlowDetails("end   SAX parsing & model creation: " + elapsedTime + "ms");
        }
    }

    private static ModelVersion quickGetModelVersion(String mapText) throws MetadataException {
        ModelVersion out = null;
        XMLV2VersionHandler handler = new XMLV2VersionHandler();
        InputSource inputSource = new InputSource(new StringReader(mapText));
        try {
            SAXParser parser = IQModelImplUtilities.getSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException(e);
        }
        catch (SAXException e) {
            out = handler.getModelVersion();
            if (out == null) {
                throw new MetadataException(e);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
        return out;
    }

    private static boolean useDOMWhenReadingMap() {
        String prop = System.getProperty("SASQueryServices.ReadMapsUsingDom", null);
        if (prop == null) {
            prop = System.getProperty("SAS.IQ.READ.MAPS.USING.DOM");
        }
        boolean forceToUseDOM = prop != null && !prop.equals("0");
        return forceToUseDOM;
    }

    private void readLocaleV1(Element dataLocaleElement) {
        Locale v1DataLocale = null;
        if (dataLocaleElement != null) {
            String language = IQModelImplUtilities.getAttr(dataLocaleElement, "language");
            String country = IQModelImplUtilities.getAttr(dataLocaleElement, "country");
            String variant = IQModelImplUtilities.getAttr(dataLocaleElement, "variant");
            v1DataLocale = new Locale(language, country != null ? country : "", variant != null ? variant : "");
        } else {
            v1DataLocale = LocaleUtilities.getDefaultPersistenceLocale();
        }
        this.setComputationalLocale(v1DataLocale);
    }

    private void readInformationMapAttributesV1(Element elAttributesList) throws MetadataException {
        LinkedHashMap<String, String> attributesRead = new LinkedHashMap<String, String>();
        List<Element> subelements = IQModelImplUtilities.getSubelements(elAttributesList);
        for (Element sub : subelements) {
            String elementName = sub.getTagName();
            if (!"AttributeItem".equals(elementName)) continue;
            String key = IQModelImplUtilities.getAttr(sub, "key");
            String value = IQModelImplUtilities.getAttr(sub, "value");
            attributesRead.put(key, value);
        }
        this._attributes.set(attributesRead);
    }

    @Override
    public boolean isPersistable() {
        _logger.debug(">> InformationMap isPersistable");
        boolean persistable = super.isPersistable();
        if (!persistable) {
            return false;
        }
        Iterator<String> it = this.keywords.iterator();
        while (persistable && it.hasNext()) {
            String obj = it.next();
            if (obj instanceof String) continue;
            persistable = false;
        }
        _logger.debug("<< InformationMap ");
        return persistable;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Override
    public String toDebugString() {
        MapFolder rootFolder;
        try {
            rootFolder = this.getRootMapFolder();
        }
        catch (MetadataException e) {
            rootFolder = null;
        }
        return linesep + "InformationMap name: " + this.getLabel() + ", desc: " + this.getDescription() + linesep + "InformationMap contents: " + String.valueOf(rootFolder);
    }

    @Override
    protected String getDefinitionElementName() {
        return INFORMATION_MAP_TRANSFORM_ROLE;
    }

    @Override
    public RepositoryInterface getRepository() throws MetadataException {
        RepositoryInterface repository;
        block9: {
            repository = null;
            try {
                UserContextInterface user;
                SessionContextInterface session;
                BriefInformationMap briefMap = this.getBriefMap();
                if (briefMap != null) {
                    repository = briefMap.getRepository();
                } else {
                    List<DataSource> allTables = this.getObjects(2, DataSource.class);
                    for (DataSource ds : allTables) {
                        RepositoryInterface repos = this.getRepositoryForDataSource(ds);
                        if (!(repos instanceof OMIRepositoryInterface)) continue;
                        repository = repos;
                    }
                }
                if (repository != null || (session = this.getSession()) == null || (user = session.getUserContext()) == null) break block9;
                try {
                    repository = user.getAuthRepository();
                }
                catch (ServiceException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    throw new MetadataException(e);
                }
            }
            catch (RemoteException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                throw new MetadataException(e);
            }
        }
        return repository;
    }

    private RepositoryInterface getRepositoryForDataSource(DataSource dataSource) throws MetadataException, RemoteException {
        DataSourceCube dsc;
        Cube cube;
        RepositoryInterface repository = null;
        CMetadata cMeta = null;
        if (dataSource instanceof DataSourceTable) {
            DataSourceTable dst = (DataSourceTable)dataSource;
            Table table = dst.getTable();
            if (table != null && table instanceof OMAWrapper) {
                OMAWrapper wrapper = (OMAWrapper)((Object)table);
                cMeta = wrapper.getOMAObject();
            }
        } else if (dataSource instanceof DataSourceCube && (cube = (dsc = (DataSourceCube)dataSource).getCube()) != null && cube instanceof OMAWrapper) {
            OMAWrapper wrapper = (OMAWrapper)((Object)cube);
            cMeta = wrapper.getOMAObject();
        }
        if (cMeta != null) {
            SessionContextInterface session = this.getSession();
            repository = IQModelImplUtilities.getRepositoryFromObject(cMeta, session);
        }
        return repository;
    }

    private List<UniqueKey> createBusinessUniqueKeys(DataSourceTable dataSourceTable) throws MetadataException {
        Table table = dataSourceTable.getTable();
        List<com.sas.iquery.metadata.physical.UniqueKey> physicalUniqueKeys = table.getKeys(com.sas.iquery.metadata.physical.UniqueKey.class);
        ArrayList<UniqueKey> businessUniqueKeys = new ArrayList<UniqueKey>(physicalUniqueKeys.size());
        for (com.sas.iquery.metadata.physical.UniqueKey uniqueKey : physicalUniqueKeys) {
            UniqueKey businessUniqueKey = this.createBusinessUniqueKey(dataSourceTable, uniqueKey);
            if (businessUniqueKey == null) continue;
            businessUniqueKeys.add(businessUniqueKey);
        }
        return businessUniqueKeys;
    }

    private UniqueKey createBusinessUniqueKey(DataSourceTable dataSourceTable, com.sas.iquery.metadata.physical.UniqueKey physicalUniqueKey) throws MetadataException {
        InformationMapImpl2 informationMap = this;
        List<DataSourceTable> dataSourceTables = informationMap.getObjects(true, DataSourceTable.class);
        ArrayList<ForeignKeyImpl> busForeignKeys = new ArrayList<ForeignKeyImpl>();
        List<QualifiedColumn> qualifiedColumnsForUniqueKey = this.getQualifiedColumnsForKey(dataSourceTable.getQualifiedColumns(), physicalUniqueKey);
        UniqueKeyImpl businessUniqueKey = null;
        if (!qualifiedColumnsForUniqueKey.isEmpty()) {
            List<com.sas.iquery.metadata.physical.ForeignKey> physForeignKeys = physicalUniqueKey.getForeignKeys();
            for (com.sas.iquery.metadata.physical.ForeignKey physFK : physForeignKeys) {
                List<DataSourceTable> list = this.getKeyTables(dataSourceTables, physFK);
                for (DataSourceTable foreignKeyTable : list) {
                    List<QualifiedColumn[]> columnPairs;
                    List<QualifiedColumn> qualifiedColumnsForForeignKey = this.getQualifiedColumnsForKey(foreignKeyTable.getQualifiedColumns(), physFK);
                    if (qualifiedColumnsForForeignKey.isEmpty() || (columnPairs = this.getQualifiedColumnsForColumnPairs(physFK, qualifiedColumnsForUniqueKey, qualifiedColumnsForForeignKey)).isEmpty()) continue;
                    ForeignKeyImpl businessForeignKey = new ForeignKeyImpl(physFK, foreignKeyTable, qualifiedColumnsForForeignKey, columnPairs);
                    busForeignKeys.add(businessForeignKey);
                }
            }
            boolean isPrimary = physicalUniqueKey instanceof OMAPrimaryKey;
            businessUniqueKey = new UniqueKeyImpl(physicalUniqueKey, dataSourceTable, qualifiedColumnsForUniqueKey, busForeignKeys, isPrimary);
            for (ForeignKey foreignKey : busForeignKeys) {
                foreignKey.setUniqueKey(businessUniqueKey);
            }
        }
        return businessUniqueKey;
    }

    private List<DataSourceTable> getKeyTables(List<? extends DataSourceTable> dataSourceTables, Key key) throws MetadataException {
        ArrayList<DataSourceTable> returnTables = new ArrayList<DataSourceTable>(1);
        Class keyType = key instanceof com.sas.iquery.metadata.physical.ForeignKey ? com.sas.iquery.metadata.physical.ForeignKey.class : com.sas.iquery.metadata.physical.UniqueKey.class;
        for (DataSourceTable dataSourceTable : dataSourceTables) {
            Table table = dataSourceTable.getTable();
            List<com.sas.iquery.metadata.physical.ForeignKey> keysFromTable = table.getKeys(keyType);
            if (!keysFromTable.contains(key)) continue;
            returnTables.add(dataSourceTable);
        }
        return returnTables;
    }

    private List<QualifiedColumn[]> getQualifiedColumnsForColumnPairs(com.sas.iquery.metadata.physical.ForeignKey foreignKey, List<QualifiedColumn> qualifiedColumnsForUniqueKey, List<QualifiedColumn> qualifiedColumnsForForeignKey) throws MetadataException {
        ArrayList<QualifiedColumn[]> columnPairs = new ArrayList<QualifiedColumn[]>();
        ArrayList<Column> uniqueColumns = new ArrayList<Column>();
        ArrayList<Column> foreignColumns = new ArrayList<Column>();
        for (QualifiedColumn qc : qualifiedColumnsForUniqueKey) {
            uniqueColumns.add(qc.getColumn());
        }
        for (QualifiedColumn qc : qualifiedColumnsForForeignKey) {
            foreignColumns.add(qc.getColumn());
        }
        List<Column[]> physicalPairs = foreignKey.getColumnPairs();
        for (Column[] columns : physicalPairs) {
            Column uniqueColumn = columns[0];
            Column foreignColumn = columns[1];
            if (uniqueColumn == null || foreignColumn == null) continue;
            int uniquePosition = uniqueColumns.indexOf(uniqueColumn);
            int foreignPostion = foreignColumns.indexOf(foreignColumn);
            QualifiedColumn[] qualifiedColumns = new QualifiedColumn[]{qualifiedColumnsForUniqueKey.get(uniquePosition), qualifiedColumnsForForeignKey.get(foreignPostion)};
            columnPairs.add(qualifiedColumns);
        }
        return columnPairs;
    }

    private List<QualifiedColumn> getQualifiedColumnsForKey(List<QualifiedColumn> qualifiedColumnsFromTable, Key physicalKey) throws MetadataException {
        List<Column> physKeyColumns = physicalKey.getColumns();
        ArrayList<QualifiedColumn> qualifiedColumnsForKey = new ArrayList<QualifiedColumn>();
        block0: for (Column physKeyColumn : physKeyColumns) {
            for (QualifiedColumn qc : qualifiedColumnsFromTable) {
                QualifiedColumnImpl qcImpl = (QualifiedColumnImpl)qc;
                if (qcImpl.getColumn() != physKeyColumn) continue;
                qualifiedColumnsForKey.add(qc);
                continue block0;
            }
        }
        return qualifiedColumnsForKey;
    }

    private List<ForeignKey> createBusinessForeignKeys(DataSourceTable dataSourceTable) throws MetadataException {
        InformationMapImpl2 informationMap = this;
        Table table = dataSourceTable.getTable();
        List<DataSourceTable> dataSourceTables = informationMap.getObjects(true, DataSourceTable.class);
        List<com.sas.iquery.metadata.physical.ForeignKey> physForeignKeys = table.getKeys(com.sas.iquery.metadata.physical.ForeignKey.class);
        ArrayList<ForeignKey> busForeignKeys = new ArrayList<ForeignKey>(physForeignKeys.size());
        for (com.sas.iquery.metadata.physical.ForeignKey physForeignKey : physForeignKeys) {
            com.sas.iquery.metadata.physical.UniqueKey physicalUniqueKey = physForeignKey.getUniqueKey();
            if (physicalUniqueKey == null) continue;
            List<DataSourceTable> uniqueKeyTables = this.getKeyTables(dataSourceTables, physicalUniqueKey);
            for (DataSourceTable uniqueKeyTable : uniqueKeyTables) {
                List<QualifiedColumn[]> qualifiedColumnPairs;
                UniqueKey businessUniqueKey = null;
                businessUniqueKey = this.createBusinessUniqueKey(uniqueKeyTable, physicalUniqueKey);
                List<QualifiedColumn> qualifiedColumnsForUniqueKey = this.getQualifiedColumnsForKey(uniqueKeyTable.getQualifiedColumns(), physicalUniqueKey);
                List<QualifiedColumn> qualifiedColumnsForForeignKey = this.getQualifiedColumnsForKey(dataSourceTable.getQualifiedColumns(), physForeignKey);
                if (qualifiedColumnsForUniqueKey.isEmpty() || qualifiedColumnsForForeignKey.isEmpty() || (qualifiedColumnPairs = this.getQualifiedColumnsForColumnPairs(physForeignKey, qualifiedColumnsForUniqueKey, qualifiedColumnsForForeignKey)).isEmpty()) continue;
                ForeignKeyImpl businessForeignKey = new ForeignKeyImpl(physForeignKey, dataSourceTable, qualifiedColumnsForForeignKey, qualifiedColumnPairs);
                businessForeignKey.setUniqueKey(businessUniqueKey);
                busForeignKeys.add(businessForeignKey);
            }
        }
        return busForeignKeys;
    }

    protected String getOMRTransformRole() {
        return INFORMATION_MAP_TRANSFORM_ROLE;
    }

    protected String getStoredTextPrefix() {
        return XML_PERSISTENCE_SYNTAX_VERSION_LATER_THAN_912;
    }

    @Override
    public FilterSet getGeneralFilterSet() throws MetadataException {
        return this._generalFilterSet;
    }

    @Override
    public void setGeneralFilterSet(FilterSet filterSet) throws MetadataException {
        this.changeableCheck();
        this._generalFilterSet = filterSet;
        this.fireChangeEvent("general filterset changed");
    }

    @Override
    public FilterSet newFilterSet() throws MetadataException {
        this.changeableCheck();
        return new FilterSetImpl(this);
    }

    @Override
    public FilterSetRuleItems newFilterSetRuleItems(List items, boolean isUnion) throws MetadataException {
        this.changeableCheck();
        return new FilterSetRuleItemsImpl(items, isUnion);
    }

    private void readGeneralFilterSetV1(Element parentElement, ReadingContext readingContext) throws MetadataException {
        this._generalFilterSet = (FilterSet)((Object)InformationMapImpl2.v1_readItemUnderSubelement(parentElement, readingContext, "GeneralFilterSet", new Class[]{FilterSet.class}));
    }

    @Override
    public FilterSetRuleItems getSessionFilterSetRuleList(FilterSetMember filterSetMember) throws MetadataException {
        List pcValues = new ArrayList();
        pcValues = this.getOmrPermissionConditions(pcValues);
        return this.getSessionFilterSetRuleList(filterSetMember, pcValues);
    }

    public List getOmrPermissionConditions(List permConds) throws MetadataException {
        SessionContextInterface session = this.getSession();
        boolean allowedQueryReadAccess = this._getOmrPermission(permConds);
        if (!allowedQueryReadAccess) {
            Object[] logMsgArgs;
            UserContextInterface user = null;
            String userName = "";
            try {
                user = session.getUserContext();
                if (user != null) {
                    userName = user.getName();
                }
            }
            catch (RemoteException e) {
                MessageFormatter logMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ErrorGettingUserContext.fmt.txt", new Object[0]);
                if (_logger.isDebugEnabled()) {
                    if (_sessionLogger.isDebugEnabled()) {
                        _sessionLogger.debug(logMsg.toString());
                    } else {
                        _logger.debug(logMsg.toString());
                    }
                }
                throw new MetadataException(logMsg, (Throwable)e);
            }
            try {
                logMsgArgs = new Object[]{userName, this.getLabel(), this.getBriefMap().getPathUrl().getAbsolutePath()};
            }
            catch (Exception ex) {
                logMsgArgs = new Object[]{userName, this.getLabel(), ""};
            }
            MessageFormatter logMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ErrorMissingReadFlag.fmt.txt", logMsgArgs);
            if (_logger.isEnabled(Level.WARN)) {
                if (_sessionLogger.isEnabled(Level.WARN)) {
                    _sessionLogger.warn(logMsg.toString());
                } else {
                    _logger.warn(logMsg.toString());
                }
            }
            throw new MetadataException(logMsg);
        }
        return permConds;
    }

    @Override
    public FilterSetRuleItems getSessionFilterSetRuleList(FilterSetMember filterSetMember, List pcValues) throws MetadataException {
        if (pcValues == null || pcValues.size() == 0) {
            return null;
        }
        UserContextInterface user = null;
        String userName = "";
        try {
            user = this.getSession().getUserContext();
            if (user != null) {
                userName = user.getName();
            }
        }
        catch (RemoteException e) {
            MessageFormatter logMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ErrorGettingUserContext.fmt.txt", new Object[0]);
            if (_logger.isDebugEnabled()) {
                if (_sessionLogger.isDebugEnabled()) {
                    _sessionLogger.debug(logMsg.toString());
                } else {
                    _logger.debug(logMsg.toString());
                }
            }
            throw new MetadataException(logMsg, (Throwable)e);
        }
        ArrayList<FilterSetRuleItems> ruleItemsToCombine = new ArrayList<FilterSetRuleItems>();
        for (int i = 0; i < pcValues.size(); ++i) {
            FilterSetRuleItems pcRuleItems;
            String pcValue = (String)pcValues.get(i);
            if (pcValue == null || pcValue.length() <= 0 || (pcRuleItems = this.getRuleItems(userName, pcValue, filterSetMember)) == null || pcRuleItems.size() <= 0) continue;
            ruleItemsToCombine.add(pcRuleItems);
        }
        FilterSetRuleItems combinedFilters = null;
        if (ruleItemsToCombine.size() == 1) {
            combinedFilters = (FilterSetRuleItems)ruleItemsToCombine.get(0);
        } else if (ruleItemsToCombine.size() > 1) {
            combinedFilters = new FilterSetRuleItemsImpl(ruleItemsToCombine, true);
        }
        return combinedFilters;
    }

    /*
     * Enabled aggressive block sorting
     */
    private FilterSetRuleItems getRuleItems(String userName, String lookupID, FilterSetMember filterSetMember) throws MetadataException {
        FilterSetRuleItems filters;
        block6: {
            block7: {
                BusinessRule rule = this.getBusinessRuleByID(lookupID);
                if (rule == null) break block7;
                if (rule instanceof FilterSet) {
                    ArrayList<FilterSetRuleItems> list = this._getEffectiveListOfRuleItems((FilterSet)rule, filterSetMember);
                    if (list.size() == 1) {
                        filters = (FilterSetRuleItems)list.get(0);
                        break block6;
                    } else {
                        FilterSetRuleItemsImpl f1 = new FilterSetRuleItemsImpl(list, false);
                        filters = FilterSetRuleItemsImpl.flattenFilterSetRuleItems(f1);
                    }
                    break block6;
                } else {
                    Object[] logMsgArgs = new Object[]{userName, lookupID, rule.getIdentityString()};
                    MessageFormatter logMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ErrorWrongTypeInPermissionCondition.fmt.txt", logMsgArgs);
                    if (!_logger.isDebugEnabled()) throw new MetadataException(logMsg);
                    if (_sessionLogger.isDebugEnabled()) {
                        _sessionLogger.debug(logMsg.toString());
                        throw new MetadataException(logMsg);
                    }
                    _logger.debug(logMsg.toString());
                    throw new MetadataException(logMsg);
                }
            }
            MessageFormatter logMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ErrorInvalidValueInPermissionCondition.fmt.txt", userName, lookupID);
            if (!_logger.isDebugEnabled()) throw new MetadataException(logMsg);
            if (_sessionLogger.isDebugEnabled()) {
                _sessionLogger.debug(logMsg.toString());
                throw new MetadataException(logMsg);
            }
            _logger.debug(logMsg.toString());
            throw new MetadataException(logMsg);
        }
        if (filters == null) return null;
        if (filters.size() != 0) return filters;
        return null;
    }

    private ArrayList<FilterSetRuleItems> _getEffectiveListOfRuleItems(FilterSet filterSet, FilterSetMember filterSetMember) throws MetadataException {
        FilterSetRuleItems ruleItems;
        ArrayList<FilterSetRuleItems> list = new ArrayList<FilterSetRuleItems>();
        if (filterSet != null && (ruleItems = filterSet.getFilterSetRuleItems(filterSetMember)) != null && ruleItems.size() > 0) {
            list.add(ruleItems);
        }
        return list;
    }

    @Override
    public FilterSetRuleItems getCombinedFilterSetRuleList(FilterSetMember filterSetMember) throws MetadataException {
        List pcValues = new ArrayList();
        pcValues = this.getOmrPermissionConditions(pcValues);
        return this.getCombinedFilterSetRuleList(filterSetMember, pcValues);
    }

    @Override
    public FilterSetRuleItems getCombinedFilterSetRuleList(FilterSetMember filterSetMember, List pcValues) throws MetadataException {
        ArrayList<FilterSetRuleItems> list = this._getEffectiveListOfRuleItems(this._generalFilterSet, filterSetMember);
        FilterSetRuleItems sessionFilterRuleItems = this.getSessionFilterSetRuleList(filterSetMember, pcValues);
        if (sessionFilterRuleItems != null) {
            list.add(sessionFilterRuleItems);
        }
        FilterSetRuleItems filters = null;
        if (list.size() == 1) {
            filters = (FilterSetRuleItems)list.get(0);
        } else {
            filters = new FilterSetRuleItemsImpl(list, false);
            filters = FilterSetRuleItemsImpl.flattenFilterSetRuleItems(filters);
        }
        return filters;
    }

    public boolean getOmrPermissionForUser(SessionContextInterface session, UserContextInterface user, List permConds) throws MetadataException {
        return this._getOmrPermission(permConds);
    }

    private boolean _getOmrPermission(List permConds) throws MetadataException {
        SessionContextInterface session = this.getSession();
        BriefInformationMap briefMap = this.getBriefMap();
        if (briefMap == null) {
            return true;
        }
        boolean isAllowed = false;
        try {
            String reposId = briefMap.getReposId();
            String READ_PERMISSION = "Read";
            String OMR_URI_TRANSFORMATION_PREFIX = "OMSOBJ:Transformation/";
            if (_logger.isDebugEnabled()) {
                Object[] startingMsgArgs = new Object[]{this.getLabel(), reposId};
                String startingMsg = IQModelImplUtilities.getMessage("InformationMapImpl.ReadPerm.fmt.txt", startingMsgArgs);
                if (_sessionLogger.isDebugEnabled()) {
                    _sessionLogger.debug(startingMsg);
                } else {
                    _logger.debug(startingMsg);
                }
            }
            OMIRepositoryInterface omrServer = (OMIRepositoryInterface)briefMap.getRepository();
            String resourceURI = "OMSOBJ:Transformation/" + reposId;
            AuthResult answer = omrServer.isAuthorizedWithConditions("", resourceURI, "Read");
            isAllowed = answer.isAuthorized();
            String permCond = answer.getConditions();
            if (isAllowed) {
                if (permCond != null && permCond.length() > 0) {
                    if (_logger.isInfoEnabled()) {
                        Object[] logMsgArgs = new Object[]{this.getLabel(), permCond};
                        String logMsg = IQModelImplUtilities.getMessage("InformationMapImpl.PermCond.fmt.txt", logMsgArgs);
                        if (_sessionLogger.isDebugEnabled()) {
                            _sessionLogger.info(logMsg);
                        } else {
                            _logger.info(logMsg);
                        }
                    }
                    String MARKER = "<!--CONDITION-->";
                    String remainingConds = permCond;
                    boolean done = false;
                    while (!done) {
                        String oneCond;
                        int markerPos = remainingConds.indexOf("<!--CONDITION-->");
                        if (markerPos == -1) {
                            oneCond = remainingConds;
                            done = true;
                        } else {
                            oneCond = remainingConds.substring(0, markerPos);
                            remainingConds = remainingConds.substring(markerPos + "<!--CONDITION-->".length());
                        }
                        if ((oneCond = oneCond.trim()).length() <= 0) continue;
                        permConds.add(oneCond);
                    }
                    if (_logger.isDebugEnabled()) {
                        String msg = IQModelImplUtilities.getMessage("InformationMapImpl.PermCondSize.fmt.txt", this.getLabel(), Integer.toString(permConds.size()));
                        if (_sessionLogger.isDebugEnabled()) {
                            _sessionLogger.debug(msg);
                        } else {
                            _logger.debug(msg);
                        }
                    }
                } else if (_logger.isInfoEnabled()) {
                    String msg = IQModelImplUtilities.getMessage("InformationMapImpl.AuthPermit.fmt.txt", this.getLabel());
                    if (_sessionLogger.isInfoEnabled()) {
                        _sessionLogger.info(msg);
                    } else {
                        _logger.info(msg);
                    }
                }
            } else if (_logger.isDebugEnabled()) {
                String msg = IQModelImplUtilities.getMessage("InformationMapImpl.AuthDeny.fmt.txt", this.getLabel(), reposId);
                if (_sessionLogger.isDebugEnabled()) {
                    _sessionLogger.debug(msg);
                } else {
                    _logger.debug(msg);
                }
            }
        }
        catch (RemoteException ex) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.RMIFailAuthCheck.fmt.txt", this.getLabel());
            if (_logger.isEnabled(Level.WARN)) {
                if (_sessionLogger.isEnabled(Level.WARN)) {
                    _sessionLogger.warn(msg.toString(), (Throwable)ex);
                } else {
                    _logger.warn(msg.toString(), (Throwable)ex);
                }
            }
            throw new MetadataException(msg, (Throwable)ex);
        }
        catch (ServiceException ex) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ServiceFailAuthCheck.fmt.txt", this.getLabel());
            if (_logger.isEnabled(Level.WARN)) {
                if (_sessionLogger.isEnabled(Level.WARN)) {
                    _sessionLogger.warn(msg.toString(), (Throwable)ex);
                } else {
                    _logger.warn(msg.toString(), (Throwable)ex);
                }
            }
            throw new MetadataException(msg, (Throwable)ex);
        }
        return isAllowed;
    }

    @Override
    public List<Prompt> getIdentityDrivenPropertyPrompts() throws MetadataException {
        ArrayList<Prompt> identityPrompts = new ArrayList<Prompt>();
        List<Prompt> allPrompts = this.getObjects(2, Prompt.class);
        for (Prompt p : allPrompts) {
            PromptDefinitionInterface pd = p.getPromptDefinition();
            if (pd == null || !pd.getUserInfo().contains("IDENTITYDRIVEN")) continue;
            identityPrompts.add(p);
        }
        return identityPrompts;
    }

    protected String getPublicTypeToWrite() {
        String out = "InformationMap.Relational";
        StructureOfData struct = this.getStructure();
        if (struct.isOLAP()) {
            out = "InformationMap.OLAP";
        }
        return out;
    }

    private UsageVersion getUsageVersionToWrite(AbstractModel.ModelWritingResults modelWritingResults) {
        ModelVersion modelVersion = modelWritingResults.getModelVersion();
        UsageVersion versionOfModelCapturedAsXML = modelVersion.getEquivalentUsageVersion();
        UsageVersion metadataFormatVersion = this.getMetadataFormatVersion();
        UsageVersion wholeInfoMapVersion = IQUsageVersions.max(versionOfModelCapturedAsXML, metadataFormatVersion);
        return wholeInfoMapVersion;
    }

    private UsageVersion getMetadataFormatVersion() {
        return IQUsageVersions.VERSION_92;
    }

    private static List computeTransformationSources(List flattenedOMAResources) throws RemoteException, MdException {
        ArrayList<Object> jomaObjectsToSetInTransformationSources = new ArrayList<Object>();
        int count = flattenedOMAResources.size();
        for (int i = 0; i < count; ++i) {
            Object underlyingObject;
            MetadataInterface smartObject;
            Object resource = flattenedOMAResources.get(i);
            if (resource instanceof OMAWrapper && (resource instanceof Table || resource instanceof Cube)) {
                CMetadata underlyingOmrObject = ((OMAWrapper)resource).getOMAObject();
                if (underlyingOmrObject == null) continue;
                jomaObjectsToSetInTransformationSources.add(underlyingOmrObject);
                continue;
            }
            if (!(resource instanceof JFSStoredProcess) || (smartObject = ((JFSStoredProcess)resource).getMetadataInterface()) == null || !((underlyingObject = smartObject.getRepositoryEntity()) instanceof CMetadata)) continue;
            jomaObjectsToSetInTransformationSources.add(underlyingObject);
        }
        return jomaObjectsToSetInTransformationSources;
    }

    private ChangeHistoryItem newChangeHistoryItem(String changeNote) throws RemoteException {
        UserContextInterface user;
        if (changeNote == null) {
            changeNote = "";
        }
        ChangeHistoryItem historyItem = new ChangeHistoryItem(new Date());
        String userName = "";
        SessionContextInterface session = this.getSession();
        if (session != null && (user = session.getUserContext()) != null && (userName = user.getName()) == null) {
            userName = "";
        }
        historyItem.setUserName(userName);
        historyItem.setDescription(changeNote);
        return historyItem;
    }

    private String getJarVersionToWrite() {
        Attributes manifestAttrs;
        String output = null;
        Manifest iqServicesJarManifest = InformationMapImpl2.loadManifestForClass(this.getClass());
        if (iqServicesJarManifest != null && (manifestAttrs = iqServicesJarManifest.getMainAttributes()) != null) {
            output = manifestAttrs.getValue("Implementation-Version");
        }
        if (output == null) {
            output = "NotAvailable";
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FactoryResultsImpl fetchMap(BriefInformationMap briefMap, IntelligentQueryMetadataServiceInterface iqService, SessionContextInterface session, boolean externalOnly, boolean doResolveExternal) throws MetadataException {
        FactoryResultsImpl results = null;
        InformationMapImpl2 map = null;
        try {
            String fullMapDescription;
            Object syncObject;
            if (!briefMap.isCompatible() && !briefMap.isReadCompatible()) {
                String mapName = "";
                try {
                    mapName = briefMap.getName();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (_amLogger.isDebugEnabled()) {
                    UsageVersion version = null;
                    try {
                        version = briefMap.getUsageVersion();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    _amLogger.debug("Tried to read map named " + mapName + " but failed because it is version " + version + " and tried reading it with software that recognizes version " + OMRBriefInformationMap.CURRENT_VERSION);
                }
                Object[] args = new Object[]{mapName};
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OMRBriefInformationMap.SavedWithMoreRecentSoftware.fmt.txt", args));
            }
            Transformation transformation = (Transformation)briefMap.getRepositoryEntity();
            OMIRepositoryInterface repos = (OMIRepositoryInterface)briefMap.getRepository();
            String storedText = null;
            Locale locale = LocaleUtilities.getDefaultPersistenceLocale();
            Object object = syncObject = InformationMapImpl2.getSynchronizationObject(briefMap, session);
            synchronized (object) {
                storedText = InformationMapImpl2.getStoredTextFromCache(briefMap, (RepositoryInterface)repos);
                String template = storedText == null ? READ_TEMPLATE_LATE_BINDING : READ_TEMPLATE_LATE_BINDING_NO_SOURCE;
                template = MessageFormat.format(template, locale);
                transformation = (Transformation)InformationMapImpl2.readCompositeObjectFromOmr((Root)transformation, repos, template);
                if (storedText == null) {
                    _amLogger.debug("Done getting map's XML from OMR.");
                } else {
                    _amLogger.debug("Done map, XML from cache, remainder from OMR.");
                }
                if (storedText == null) {
                    storedText = InformationMapImpl2.getMapText(transformation);
                    InformationMapImpl2.setStoredTextInCache(briefMap, storedText);
                }
                String mapXML = InformationMapImpl2.getMapXML(storedText);
                List privatePrompts = briefMap.getPrompts();
                UsageVersion version = briefMap.getUsageVersion();
                boolean versionAlreadyChecked = version.getMajorVersion() > 0;
                try {
                    String xmlVersion = storedText.substring(0, 8);
                    if (Integer.valueOf(xmlVersion) < Integer.valueOf(XML_PERSISTENCE_SYNTAX_VERSION_LATER_THAN_912)) {
                        versionAlreadyChecked = false;
                    }
                }
                catch (NumberFormatException nfe) {
                    versionAlreadyChecked = false;
                }
                MetadataServerInterface metadataServer = (MetadataServerInterface)repos.getServer();
                results = InformationMapImpl2.readInNewMap(mapXML, iqService, session, doResolveExternal, externalOnly, privatePrompts, versionAlreadyChecked, metadataServer);
            }
            map = results._map;
            map.setBriefMap(briefMap);
            map.setLabel(briefMap.getName());
            String briefMapDescription = briefMap.getDescription();
            if (briefMapDescription == null) {
                briefMapDescription = "";
            }
            if ((fullMapDescription = map.getDescription()) == null) {
                fullMapDescription = "";
            }
            if (!fullMapDescription.startsWith(briefMapDescription) || briefMapDescription.length() < 200 && fullMapDescription.length() >= 200) {
                map.setDescription(briefMapDescription);
            }
            List<String> keywords = ListUtils.newList(briefMap.getKeywords());
            map.setKeywords(keywords);
            String propertyList = InformationMapImpl2.getPropertyList(transformation, locale);
            if (propertyList != null) {
                StringReader reader = new StringReader(propertyList);
                PropertyMap pmap = new PropertyMap();
                try {
                    pmap.load((Reader)reader);
                    map.setLocalizableProperties(locale, pmap);
                }
                catch (IOException iOException) {}
            }
        }
        catch (ServiceException e) {
            _amLogger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            _amLogger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        catch (MdException e) {
            _amLogger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        return results;
    }

    private static String getPropertyList(Transformation transformation, Locale locale) throws RemoteException, MdException, MetadataException, ServiceException {
        String result = null;
        List<TextStore> notes = AssociationListUtil.filteredSnapshot(transformation.getNotes(), TextStore.class);
        if (!notes.isEmpty()) {
            String locStr = locale.toString();
            for (TextStore textStore : notes) {
                if (!locStr.equalsIgnoreCase(textStore.getName())) continue;
                result = textStore.getStoredText();
                break;
            }
        }
        if (result != null) {
            result = result.substring(CDATA_OPEN.length(), result.length() - CDATA_CLOSE.length()).trim();
        }
        return result;
    }

    private static String getMapXML(String storedTextFromOMR) {
        return storedTextFromOMR.substring(8);
    }

    private static String getMapText(Transformation transform) throws RemoteException, MdException, MetadataException {
        if (transform.getIsUserDefined() <= 0) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractModel.PreRelese912VersionNotReadable.txt", new Object[0]));
        }
        TextStore omrTextStore = (TextStore)transform.getSourceCode();
        String storedText = null;
        if (omrTextStore != null) {
            storedText = omrTextStore.getStoredText();
        } else {
            InformationMapImpl2.staticPersistenceError(IQModelImplUtilities.getMessageFormatter("OMRInformationMapPersistor.NoTextStoreObj.fmt.txt", transform.getName()));
        }
        InformationMapImpl2.removeJomaObjectFromItsStores((Root)omrTextStore);
        InformationMapImpl2.sanityCheckStoredText(storedText);
        return storedText;
    }

    private static void sanityCheckStoredText(String storedText) throws MetadataException {
        if (storedText == null || storedText.length() < 9) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OMRInformationMapPersistor.InvalidInfoMapHeader.txt", new Object[0]));
        }
    }

    private static String getStoredTextFromCache(BriefInformationMap briefInfoMap, RepositoryInterface repos) throws ServiceException, RemoteException {
        TextStoreMgr cacheMgr = TextStoreMgr.instance();
        String rval = cacheMgr.getMapText(briefInfoMap, repos);
        return rval;
    }

    private static void setStoredTextInCache(BriefInformationMap briefInfoMap, String storedText) throws IllegalStateException, ServiceException, RemoteException {
        TextStoreMgr cacheMgr = TextStoreMgr.instance();
        cacheMgr.storeMapText(briefInfoMap, storedText);
    }

    private static Manifest loadManifestForClass(Class c) {
        Manifest outputManifest = null;
        if (c != null) {
            while (c.isArray()) {
                c = c.getComponentType();
            }
            if (c.isPrimitive()) {
                c = Integer.class;
            }
            String className = c.getName();
            String path = "/" + className.replace('.', '/') + ".class";
            URL url = c.getResource(path);
            if (url != null && "jar".equals(url.getProtocol())) {
                try {
                    Manifest mf;
                    URLConnection o = url.openConnection();
                    if (o instanceof JarURLConnection && (mf = ((JarURLConnection)o).getManifest()) != null) {
                        outputManifest = mf;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return outputManifest;
    }

    public List getReplaceableObjects() {
        Class[] barrierTypes = new Class[]{ColumnManagerImpl2.class, QualifiedColumn.class};
        List mapItems = this.getItemsUsedWithinThisMap(barrierTypes);
        ListIterator it = mapItems.listIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ResourceRelationshipInterface) continue;
            it.remove();
        }
        return mapItems;
    }

    private List getItemsUsedWithinThisMap(Class[] inclusiveBarrierTypes) {
        ArrayList directlyRefdItems = new ArrayList();
        this.accumulateDirectlyReferencedItems(directlyRefdItems);
        IdentityList accumulator = new IdentityList();
        for (Object obj : directlyRefdItems) {
            if (!(obj instanceof AbstractModelItem)) continue;
            AbstractModelItem itemRefdByMap = (AbstractModelItem)obj;
            accumulator.add(itemRefdByMap);
            if (InformationMapImpl2.itemIsBarrierType(itemRefdByMap, inclusiveBarrierTypes)) continue;
            List<ModelItem> items = itemRefdByMap.getRecursivelyReferencedItemsInDownwardDefinition(inclusiveBarrierTypes, this, ModelItem.class);
            accumulator.addAll(items);
        }
        accumulator.remove(null);
        return accumulator.toList();
    }

    private static boolean itemIsBarrierType(AbstractModelItem item, Class[] barriers) {
        boolean isBarrierType = false;
        if (barriers != null && item != null) {
            for (int i = 0; i < barriers.length && !isBarrierType; ++i) {
                isBarrierType = barriers[i].isInstance(item);
            }
        }
        return isBarrierType;
    }

    public void processResourceReplacementChanges(Map changes, boolean processDataSourceTableChanges, Logger logger) throws MetadataException {
        Object tResource;
        ArrayList changedResources = new ArrayList();
        for (Object oResource : changes.keySet()) {
            tResource = changes.get(oResource);
            if (oResource == null || tResource == null || oResource == tResource) continue;
            changedResources.add(oResource);
        }
        Collections.sort(changedResources, new PhysicalResourceResolutionTypeComparator());
        if (logger != null && logger.isInfoEnabled()) {
            for (Object oResource : changedResources) {
                tResource = changes.get(oResource);
                logger.info(IQModelImplUtilities.getMessage("AbstractBusinessModel.ReplaceUnresolvedResource.fmt.txt", ExternalResourceType.getType((PhysicalResource)oResource), oResource, tResource));
            }
        }
        if (!changedResources.isEmpty()) {
            IdentityHashMap proxyResources = new IdentityHashMap();
            List uniqueModelReferencedObjects = this.getObjectsForResourceReplacementWithin();
            for (AbstractBase usingObject : uniqueModelReferencedObjects) {
                for (Object oResource : changedResources) {
                    Object tResource2 = changes.get(oResource);
                    PhysicalResource proxyObject = (PhysicalResource)proxyResources.get(tResource2);
                    if (proxyObject == null) {
                        proxyObject = (PhysicalResource)ResourceReplacementProxy.createProxy(tResource2);
                        proxyResources.put(tResource2, proxyObject);
                    }
                    if (!processDataSourceTableChanges && usingObject instanceof DataSourceTable) continue;
                    usingObject.replaceDirectReferencesDuringResourceReplacement(oResource, proxyObject);
                }
            }
            for (AbstractBase usingObject : uniqueModelReferencedObjects) {
                for (Object t : proxyResources.keySet()) {
                    Object proxyObject = proxyResources.get(t);
                    if (!processDataSourceTableChanges && usingObject instanceof DataSourceTable) continue;
                    usingObject.replaceDirectReferencesDuringResourceReplacement(proxyObject, t);
                }
            }
        }
    }

    private List getObjectsForResourceReplacementWithin() {
        Class[] inclusiveBarrierTypes = new Class[]{DataSourceTableImpl2.class};
        return this.getItemsUsedWithinThisMap(inclusiveBarrierTypes);
    }

    private void verifySaveOptions(Map<String, String> saveOptions) {
        for (Map.Entry<String, String> entry : saveOptions.entrySet()) {
            if (!SAVE_OPTIONS.contains(entry.getKey())) {
                throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("InformationMapImpl.SaveOptionNotRecognized.fmt.txt", entry.getKey()));
            }
            if (entry.getValue() == null) {
                throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("InformationMapImpl.InvalidSaveOptionValue.fmt.txt", entry.getKey(), entry.getValue()));
            }
            if (SAVE_VALUES.contains(entry.getValue().toLowerCase())) continue;
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("InformationMapImpl.InvalidSaveOptionValue.fmt.txt", entry.getKey(), entry.getValue()));
        }
    }

    private boolean shouldWeAllowMajorVersionIncrease(Map<String, String> saveOptions) {
        return Boolean.parseBoolean(saveOptions.get("AllowMajorVersionIncrease"));
    }

    private boolean shouldWeAllowMinorVersionIncrease(Map<String, String> saveOptions) {
        return Boolean.parseBoolean(saveOptions.get("AllowMinorVersionIncrease"));
    }

    @Override
    public void endLocalization() throws UnexpectedLocalizationException {
        try {
            this.save("Saved with Multi Locale Properties ");
        }
        catch (MetadataException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    @Override
    public Collection<Locale> getLocales() {
        Collection<Locale> allLocales;
        if (this.briefMap == null) {
            allLocales = super.getLocales();
        } else {
            try {
                Transformation transformation = (Transformation)this.briefMap.getRepositoryEntity();
                List<TextStore> notes = AssociationListUtil.filteredSnapshot(transformation.getNotes(true), TextStore.class);
                if (!notes.isEmpty()) {
                    allLocales = new LinkedHashSet<Locale>();
                    for (TextStore textStore : notes) {
                        String sLocale = textStore.getName();
                        String[] values = sLocale.split("[_-]");
                        int args = values.length;
                        if (args <= 0) continue;
                        Locale locale = null;
                        switch (args) {
                            case 1: {
                                locale = new Locale(values[0]);
                                break;
                            }
                            case 2: {
                                locale = new Locale(values[0], values[1]);
                                break;
                            }
                            case 3: {
                                locale = new Locale(values[0], values[1], values[2]);
                            }
                        }
                        allLocales.add(locale);
                    }
                } else {
                    allLocales = super.getLocales();
                }
            }
            catch (RemoteException e) {
                _logger.debug("Exception getting all supported locales ", (Throwable)e);
                allLocales = super.getLocales();
            }
            catch (MdException e) {
                _logger.debug("Exception getting all supported locales ", (Throwable)e);
                allLocales = super.getLocales();
            }
        }
        return allLocales;
    }

    @Override
    public String toXML(int spacesPerIndentation) throws MetadataException {
        this.loadAllLocalizableProperties();
        return super.toXML(spacesPerIndentation);
    }

    public void loadAllLocalizableProperties() throws MetadataException {
        if (this.briefMap != null && !this._loadedLocalizableProperties) {
            this._loadedLocalizableProperties = true;
            Collection<Locale> locales = this.getLocales();
            try {
                Transformation transformation = (Transformation)this.briefMap.getRepositoryEntity();
                for (Locale locale : locales) {
                    String propertyList = InformationMapImpl2.getPropertyList(transformation, locale);
                    if (propertyList == null) continue;
                    StringReader reader = new StringReader(propertyList);
                    PropertyMap pmap = new PropertyMap();
                    try {
                        pmap.load((Reader)reader);
                        this.setLocalizableProperties(locale, pmap);
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (ServiceException e) {
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
            catch (MdException e) {
                throw new MetadataException(e);
            }
        }
    }

    private static class FactoryResultsImpl
    implements InformationMapFactory.Results {
        private final InformationMapImpl2 _map;
        private final List<? extends DataSourceTable.ReadModification> _dstMods;

        private FactoryResultsImpl(InformationMapImpl2 map, List<? extends DataSourceTable.ReadModification> dstModificationsDuringRead) {
            this._map = map;
            this._dstMods = dstModificationsDuringRead;
        }

        @Override
        public Collection<DataSourceTable.ReadModification> getDataSourceTableMods() {
            return ListUtils.newList(this._dstMods);
        }

        @Override
        public InformationMap getMap() {
            return this._map;
        }
    }
}

