/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class IdentityList {
    private Object[] _elementData;
    private int _size;

    public IdentityList(int initialCapacity) {
        if (initialCapacity < 0) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("IdentityList.IllegalCapacity.fmt.txt", Integer.toString(initialCapacity));
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this._elementData = new Object[initialCapacity];
    }

    public IdentityList() {
        this(10);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this._size; ++i) {
            sb.append(i == 0 ? "" : ",").append(this._elementData[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public IdentityList(Collection c) {
        this._size = c.size();
        this._elementData = new Object[(int)Math.min((long)this._size * 110L / 100L, Integer.MAX_VALUE)];
        c.toArray(this._elementData);
    }

    private int indexOf(Object obj) {
        int size = this._size;
        for (int i = 0; i < size; ++i) {
            if (this._elementData[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    public Object get(int index) {
        this.RangeCheck(index);
        return this._elementData[index];
    }

    private void RangeCheck(int index) {
        if (index >= this._size || index < 0) {
            String msg = IQMetadataResourceBundle.getMessageString("IdentityList.IndexAndSize.fmt.txt", Integer.toString(index), Integer.toString(this._size));
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public boolean add(Object obj) {
        boolean added = false;
        if (!this.contains(obj)) {
            this.ensureCapacity(this._size + 1);
            this._elementData[this._size++] = obj;
            added = true;
        }
        return added;
    }

    public void addAll(Collection c) {
        for (Object obj : c) {
            this.add(obj);
        }
    }

    public void remove(Object obj) {
        int index = this.indexOf(obj);
        if (index >= 0) {
            int numMoved = this._size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this._elementData, index + 1, this._elementData, index, numMoved);
            }
            this._elementData[--this._size] = null;
        }
    }

    public List toList() {
        ArrayList<Object> out = new ArrayList<Object>(this._size);
        for (int i = 0; i < this._size; ++i) {
            out.add(this._elementData[i]);
        }
        return out;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this._elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this._elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this._elementData, 0, this._size);
        }
    }

    public int size() {
        return this._size;
    }
}

