/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GoverningImpl
extends AbstractBusinessModelObject
implements Governing {
    private int _outputObservations;
    private int _inputObservations;
    private int _seconds;
    private static final Logger _logger = LogManager.getLogger(GoverningImpl.class);

    public GoverningImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
        this._outputObservations = -1;
        this._inputObservations = -1;
        this._seconds = -1;
    }

    public GoverningImpl() {
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "GOV_";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GoverningImpl newGoverning;
        block2: {
            newGoverning = (GoverningImpl)super.clone();
            try {
                newGoverning.copy(this);
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(IQMetadataResourceBundle.getStringResource("GoverningImplNoClone.txt") + me.getLocalizedMessage());
            }
        }
        return newGoverning;
    }

    @Override
    public void copy(BusinessModelObject input) throws MetadataException {
        if (!(input instanceof Governing)) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("GoverningImplInvalidArgument.txt", new Object[0]));
        }
        Governing governing = (Governing)input;
        this._outputObservations = governing.getOutputObservations();
        this._inputObservations = governing.getInputObservations();
    }

    @Override
    public int getOutputObservations() {
        return this._outputObservations;
    }

    @Override
    public void setOutputObservations(int maxObservations) throws MetadataException {
        BusinessModel busModel = this.getBusinessModel();
        StructureOfData structure = busModel.getStructure();
        if (!structure.isOLAP() && !structure.isRelational()) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("GoverningImplNoDataSource.txt", new Object[0]));
        }
        if (structure.isOLAP()) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("GoverningImplOLAPNotSupported.txt", new Object[0]));
        }
        this._outputObservations = maxObservations;
        this.fireChangeEvent("The governing's limit on output observations changed.");
    }

    @Override
    public int getInputObservations() {
        return this._inputObservations;
    }

    @Override
    public void setInputObservations(int maxObservations) throws MetadataException {
        BusinessModel busModel = this.getBusinessModel();
        StructureOfData structure = busModel.getStructure();
        if (!structure.isOLAP() && !structure.isRelational()) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("GoverningImplNoDataSource.txt", new Object[0]));
        }
        if (structure.isOLAP()) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("GoverningImplOLAPNotSupported.txt", new Object[0]));
        }
        this._inputObservations = maxObservations;
        this.fireChangeEvent("The governing's limit on input observations changed.");
    }

    public int getExecutionTimeLimit() {
        return this._seconds;
    }

    public void setExecutionTimeLimit(int maxSeconds) throws MetadataException {
        BusinessModel busModel = this.getBusinessModel();
        StructureOfData structure = busModel.getStructure();
        if (!structure.isOLAP() && !structure.isRelational()) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("GoverningImplNoDataSource.txt", new Object[0]));
        }
        if (structure.isOLAP()) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("GoverningImplOLAPNotSupported.txt", new Object[0]));
        }
        this._seconds = maxSeconds;
        this.fireChangeEvent("The governing's limit on execution seconds changed.");
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setIntAttr(thisElement, "outObs", this._outputObservations, -1);
        IQModelImplUtilities.setIntAttr(thisElement, "inObs", this._inputObservations, -1);
        IQModelImplUtilities.setIntAttr(thisElement, "executionSeconds", this._seconds, -1);
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._outputObservations = attrsProvider.consumeIntAttr("outObs", -1);
        this._inputObservations = attrsProvider.consumeIntAttr("inObs", -1);
        this._seconds = attrsProvider.consumeIntAttr("executionSeconds", -1);
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._outputObservations = IQModelImplUtilities.getIntAttr(thisElement, "OutObs", -1);
        this._inputObservations = -1;
        this._seconds = -1;
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
    }

    @Override
    protected String getDefinitionElementName() {
        return "Governing";
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }
}

