/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.PropertyChangeListenee;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.FilterSetRuleItems;
import com.sas.iquery.metadata.business.FilterSetRules;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.FilterSetRuleItemsImpl;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FilterSetRulesImpl
extends AbstractModelItem
implements FilterSetRules {
    protected LinkedHashMap _map = new LinkedHashMap();

    @Override
    public Object put(FilterSetMember key, FilterSetRuleItems value) {
        FilterSetRuleItems old = this._map.put(key, value);
        if (key instanceof PropertyChangeListenee) {
            this.listenTo((PropertyChangeListenee)((Object)key));
        }
        if (old instanceof ModelItem) {
            this.removeListeningTo((ModelItem)((Object)old));
        }
        this.listenTo(value);
        IQModelImplUtilities.fireChangeEvent(this.getListeners(), key, "filterset member rule changed", value, old);
        return old;
    }

    @Override
    public FilterSetRuleItems get(FilterSetMember key) {
        return (FilterSetRuleItems)this._map.get(key);
    }

    @Override
    public boolean containsMember(FilterSetMember key) {
        return this._map.containsKey(key);
    }

    @Override
    public FilterSetMember[] getMembers() {
        return this._map.keySet().toArray(new FilterSetMember[this._map.size()]);
    }

    @Override
    public FilterSetRuleItems remove(FilterSetMember key) {
        Object old = this._map.get(key);
        if (key instanceof ModelItem) {
            this.removeListeningTo((ModelItem)((Object)key));
        }
        if (old instanceof ModelItem) {
            this.removeListeningTo((ModelItem)old);
        }
        this._map.remove(key);
        IQModelImplUtilities.fireChangeEvent(this.getListeners(), key, "filterset member rule changed", null, old);
        return (FilterSetRuleItems)old;
    }

    @Override
    public void clear() {
        Set keys = this._map.keySet();
        for (Object key : keys) {
            this.remove((FilterSetMember)key);
        }
        this._map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FilterSetRulesImpl clone = (FilterSetRulesImpl)super.clone();
        clone._map = new LinkedHashMap();
        for (Object key : this._map.keySet()) {
            Object obj = this._map.get(key);
            if (obj instanceof FilterSetRuleItems) {
                obj = ((FilterSetRuleItems)obj).clone();
            }
            clone._map.put(key, obj);
        }
        return clone;
    }

    public boolean equals(Object o) {
        return o instanceof FilterSetRulesImpl ? this._map.equals(((FilterSetRulesImpl)o)._map) : false;
    }

    public int hashCode() {
        return (this._map == null ? 0 : this._map.hashCode()) + this.getClass().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Set keys = this._map.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (key == null || !(key instanceof FilterSetMember)) continue;
            String text = null;
            if (key instanceof BusinessModelObject) {
                text = ((BusinessModelObject)key).getIntraModelID();
            }
            if (text == null) continue;
            if (text.indexOf(91) > -1 || text.indexOf(93) > -1 || text.indexOf(123) > -1 || text.indexOf(125) > -1 || text.indexOf(58) > -1 || text.indexOf(44) > -1) {
                text = "\"" + text.replaceAll("\"", "\\\"") + "\"";
            }
            buffer.append(text);
            buffer.append(":");
            FilterSetMember member = (FilterSetMember)key;
            FilterSetRuleItems list = this.get(member);
            if (list instanceof FilterSetRuleItemsImpl) {
                text = ((FilterSetRuleItemsImpl)list).toString();
            }
            buffer.append(text);
            if (!iter.hasNext() || buffer.length() <= 0) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this._map != null) {
            for (Object key : this._map.keySet()) {
                Object obj;
                if (key instanceof AbstractModelItem) {
                    Utils.accumulate(intoList, key);
                }
                if (!((obj = this._map.get(key)) instanceof AbstractModelItem)) continue;
                AbstractModelItem bmi = (AbstractModelItem)obj;
                Utils.accumulate(intoList, bmi.getDirectlyReferencedItemsInDownwardDefinition());
            }
        }
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        FilterSetRulesImpl.replaceInJavaMap(this._map, oldObject, newObject);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        if (this._map != null) {
            for (Object key : this._map.keySet()) {
                Object newKey = Utils.replaceResource(key, oldResource, newResource, model, recursive);
                Object value = this._map.get(key);
                Object newValue = Utils.replaceResource(value, oldResource, newResource, model, recursive);
                boolean keySame = IQModelImplUtilities.same(key, newKey);
                boolean valueSame = IQModelImplUtilities.same(value, newValue);
                if (keySame && valueSame) continue;
                if (!keySame) {
                    if (key instanceof ModelItem && newKey instanceof ModelItem) {
                        this.moveListeningTo((ModelItem)key, (ModelItem)newKey);
                    }
                    this._map.remove(key);
                    IQModelImplUtilities.fireChangeEvent(this.getListeners(), key, "filterset member rule changed", null, value);
                }
                if (!valueSame && value instanceof ModelItem && newValue instanceof ModelItem) {
                    this.moveListeningTo((ModelItem)value, (ModelItem)newValue);
                }
                if (!keySame && this._map.containsKey(newKey)) {
                    FilterSetRuleItems currentValue = (FilterSetRuleItems)this._map.get(newKey);
                    ArrayList<Object> newRuleItems = new ArrayList<Object>();
                    newRuleItems.add(currentValue);
                    newRuleItems.add(newValue);
                    boolean isUnion = false;
                    FilterSetRuleItemsImpl newValuePreFlatten = new FilterSetRuleItemsImpl(newRuleItems, isUnion);
                    newValue = FilterSetRuleItemsImpl.flattenFilterSetRuleItems(newValuePreFlatten);
                }
                this._map.put(newKey, newValue);
                IQModelImplUtilities.fireChangeEvent(this.getListeners(), newKey, "filterset member rule changed", newValue, null);
            }
        }
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        FilterSetRulesImpl.writeForeignObjectUnderNewSubelement(this._map, thisElement, writingContext, "RulesMap");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._map = (LinkedHashMap)riHolder.consumeForeignObject("RulesMap");
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._map = FilterSetRulesImpl.readLinkedHashMapUnderSubelementV1(thisElement, readingContext, "RulesMap", new Class[]{FilterSetMember.class}, new Class[]{FilterSetRuleItems.class});
    }

    private static final LinkedHashMap readLinkedHashMapUnderSubelementV1(Node parentNode, ReadingContext readingContext, String subelementName, Class[] allowedKeyTypes, Class[] allowedValueTypes) throws MetadataException {
        Element entryListElement;
        Element hashMapElement;
        LinkedHashMap<AbstractModelItem, AbstractModelItem> out = new LinkedHashMap<AbstractModelItem, AbstractModelItem>();
        Element subelement = IQModelImplUtilities.getFirstSubelementNamed(parentNode, subelementName);
        if (subelement != null && (hashMapElement = IQModelImplUtilities.getFirstSubelementNamed(subelement, "LinkedHashMap")) != null && (entryListElement = IQModelImplUtilities.getFirstSubelementNamed(hashMapElement, "EntryList")) != null) {
            List<Element> entryElements = IQModelImplUtilities.getSubelementsNamed(entryListElement, "Entry");
            int entryCount = entryElements.size();
            for (int i = 0; i < entryCount; ++i) {
                Element entryElement = entryElements.get(i);
                AbstractModelItem key = FilterSetRulesImpl.v1_readItemUnderSubelement(entryElement, readingContext, "Key", allowedKeyTypes);
                AbstractModelItem value = FilterSetRulesImpl.v1_readItemUnderSubelement(entryElement, readingContext, "Value", allowedValueTypes);
                out.put(key, value);
            }
        }
        return out;
    }

    @Override
    protected String getDefinitionElementName() {
        return "FilterSetRules";
    }
}

