/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CopyFromInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FilterCascadeContainer;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.FolderItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractLocalizableBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.relational.AbstractComparisonWithQueryResultsExpression;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FilterItemImpl
extends AbstractLocalizableBusinessModelObject
implements FilterItem,
FolderItem,
CopyFromInterface {
    private ExpressionInterface condExpr;
    private static final Class<?>[] VALID_EXPRESSION_TYPES = new Class[]{ExpressionInterface.class};

    FilterItemImpl(AbstractBusinessModel businessModel) throws MetadataException {
        super(businessModel);
    }

    public FilterItemImpl() {
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "FII_";
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        ExpressionInterface prevExpr = this.condExpr;
        this.condExpr = (ExpressionInterface)Utils.replaceResource(prevExpr, oldResource, newResource, model, recursive);
        if (prevExpr != this.condExpr) {
            prevExpr.removeListener(this);
            this.condExpr.addListener(this);
            this.fireChangeEvent("The filters's expression changed.");
        }
    }

    @Override
    public ExpressionInterface getExpression() {
        return this.condExpr;
    }

    @Override
    public void setExpression(ExpressionInterface inputExpr) throws MetadataException {
        this.changeableCheck();
        ExpressionInterface previousExpr = this.condExpr;
        this.condExpr = inputExpr;
        if (previousExpr != null) {
            previousExpr.removeListener(this);
        }
        if (inputExpr != null) {
            inputExpr.addListener(this);
        }
        this.fireChangeEvent("The filters's expression changed.");
    }

    @Override
    public List<Prompt> getPrompts(int searchCriteria) {
        ExpressionInterface expr = this.getExpression();
        List<Prompt> prompts = expr != null ? expr.getResources(Prompt.class, searchCriteria) : Collections.emptyList();
        return prompts;
    }

    @Override
    @Nonnull
    public List<DataItem> getDataItems(int searchCriteria) {
        ExpressionInterface expr = this.getExpression();
        List<DataItem> dataItems = expr != null ? expr.getResources(DataItem.class, searchCriteria) : Collections.emptyList();
        return dataItems;
    }

    @Override
    protected String getDefinitionElementName() {
        return "Filter";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        FilterItemImpl.writeRelatedObject(this.condExpr, thisElement, writingContext, "Expr");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this.condExpr = (ExpressionInterface)((Object)riHolder.consumeObject("Expr"));
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this.condExpr = (ExpressionInterface)((Object)FilterItemImpl.v1_readItemUnderSubelement(thisElement, readingContext, "Expr", VALID_EXPRESSION_TYPES));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FilterItemImpl clone = (FilterItemImpl)super.clone();
        if (this.condExpr != null && !(this.condExpr instanceof BusinessModelResource)) {
            ExpressionInterface cloneExpr = (ExpressionInterface)this.condExpr.clone();
            try {
                clone.setExpression(cloneExpr);
            }
            catch (MetadataException e) {
                String msg = e.getCause() == null ? (e.getMessage() == null ? e.toString() : e.getMessage()) : (e.getCause().getMessage() == null ? e.getCause().toString() : e.getCause().getMessage());
                CloneNotSupportedException c = new CloneNotSupportedException(msg);
                c.initCause(e);
                throw c;
            }
        }
        return clone;
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this.condExpr == null) {
            reasons.add(new Reason((Object)this, 2, 16, "FilterItemNoExpression.fmt.txt", this.getIdentityString()));
        }
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this.condExpr);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this.condExpr = (ExpressionInterface)FilterItemImpl.replace(this.condExpr, oldObject, newObject);
    }

    public List getImmediateSubqueries() {
        return FilterItemImpl.getImmediateSubqueries(this.condExpr, this.getModel());
    }

    private static List getImmediateSubqueries(ExpressionInterface inExpr, AbstractModel model) {
        IdentityList out = new IdentityList(1);
        AbstractModelItem exprItem = (AbstractModelItem)((Object)inExpr);
        if (exprItem != null) {
            List<AbstractComparisonWithQueryResultsExpression> subqueryCompareExprs = exprItem.getRecursivelyReferencedItemsInDownwardDefinition(new Class[]{AbstractComparisonWithQueryResultsExpression.class}, model, AbstractComparisonWithQueryResultsExpression.class);
            if (exprItem instanceof AbstractComparisonWithQueryResultsExpression) {
                subqueryCompareExprs.add((AbstractComparisonWithQueryResultsExpression)exprItem);
            }
            int count = subqueryCompareExprs.size();
            for (int i = 0; i < count; ++i) {
                BusinessQuery query;
                AbstractComparisonWithQueryResultsExpression expr = subqueryCompareExprs.get(i);
                if (expr == null || (query = expr.getQuery()) == null) continue;
                out.add(query);
            }
        }
        return out.toList();
    }

    @Override
    boolean isBasedOn(BusinessQuery query) {
        boolean found = false;
        List subqueries = FilterItemImpl.getImmediateSubqueries(this.condExpr, this.getModel());
        int count = subqueries.size();
        for (int i = 0; i < count && !found; ++i) {
            found = subqueries.get(i) == query;
        }
        return found;
    }

    public List getCascades(boolean recursive) {
        ArrayList cascades = new ArrayList();
        if (this.condExpr != null && this.condExpr instanceof FilterCascadeContainer) {
            Utils.addButNoDuplicates(cascades, ((FilterCascadeContainer)((Object)this.condExpr)).getCascades(recursive));
        }
        return cascades;
    }

    @Override
    public void copyFrom(Object obj) throws MetadataException {
        this._copyFrom(obj);
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws MetadataException {
        return super.newLocalizableProperties(locale, this);
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws MetadataException {
        super.setLocalizableProperties(locale, this, map);
    }

    @Override
    public String getLocalizationPrependKey() {
        return "FilterItems";
    }
}

