/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportProperties;
import com.sas.iquery.metadata.business.ExportSelectionMetadata;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.ExportAbstract;
import com.sas.iquery.metadata.business.impl.ExportMetadataFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Set;

public class ExportRelationalImpl
extends ExportAbstract
implements Export {
    ExportRelationalImpl(BusinessModel businessModel, ExportType usage, ExportProperties ... properties) throws MetadataException {
        super(businessModel, usage, properties);
    }

    @Override
    protected DataSelection newExportDataSelection(BusinessModel origBusinessModel) throws MetadataException {
        boolean isOlap = origBusinessModel.getStructure().isOLAP();
        if (isOlap) {
            throw new MetadataException(ExportRelationalImpl.getMsgInvalidUseOfExportRelationalForOlapDS());
        }
        DataSelection exportDS = DataSelectionFactory.newDataSelection(origBusinessModel);
        exportDS.setID("ExportRelDS");
        exportDS.setLabel("Export Relational DS");
        return exportDS;
    }

    @Override
    protected void addRefToSelectedItems(DataSelection dataSelection, DataItem itemRef, Role role, Set<String> alreadyAdded) throws MetadataException {
        super.addRefToSelectedItems(dataSelection, itemRef, Role.COLUMN, alreadyAdded);
    }

    @Override
    protected void buildUploadDataSelection() throws MetadataException {
        DataSelection uploadDS = this.getExportDataSelection();
        boolean usePreSummarized = false;
        this.setPreSummarized(usePreSummarized);
        this.setUploadDataSelection(uploadDS);
    }

    @Override
    protected void buildExportMetadata() throws MetadataException {
        DataSelection exportDS = this.getExportDataSelection();
        ExportSelectionMetadata exportMD = ExportMetadataFactory.newExportMetadataRelational(exportDS);
        this.setExportMetadata(exportMD);
    }

    private static MessageFormatter getMsgInvalidUseOfExportRelationalForOlapDS() {
        return IQMetadataResourceBundle.getMessageFormatter("ExportRelational.InvalidUseOfExportRelationalForOlapDS.fmt.txt", new Object[0]);
    }
}

