/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.ExportColumn;
import com.sas.iquery.metadata.business.ExportDataSource;
import com.sas.iquery.metadata.business.ExportDimension;
import com.sas.iquery.metadata.business.ExportFilter;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportHierarchy;
import com.sas.iquery.metadata.business.ExportLevel;
import com.sas.iquery.metadata.business.ExportMember;
import com.sas.iquery.metadata.business.ExportObject;
import com.sas.iquery.metadata.business.ExportObjectFactoryInterface;
import com.sas.iquery.metadata.business.ExportOlapMetadata;
import com.sas.iquery.metadata.business.impl.ExportDimensionFactory;
import com.sas.iquery.metadata.business.impl.ExportHierarchyFactory;
import com.sas.iquery.metadata.business.impl.ExportLevelFactory;
import com.sas.iquery.metadata.business.impl.ExportMemberFactory;
import com.sas.iquery.metadata.business.impl.ExportMetadataSelectedAbstract;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Member;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

class ExportMetadataSelOlapImpl
extends ExportMetadataSelectedAbstract
implements ExportOlapMetadata {
    private final ExportDimensionFactory exportDimensions = ExportDimensionFactory.getSingleton();
    private final ExportHierarchyFactory exportHierarchies = ExportHierarchyFactory.getSingleton();
    private final ExportLevelFactory exportLevels = ExportLevelFactory.getSingleton();
    private final ExportMemberFactory exportMembers = ExportMemberFactory.getSingleton();

    ExportMetadataSelOlapImpl(DataSelection dataSelection) throws MetadataException {
        super(dataSelection);
    }

    @Override
    public List<ExportDimension> getExportDimensionsAvailable() throws MetadataException {
        List<ExportDimension> collection = this.getCollection("AvailableDimensions", this.exportDimensions, ExportDimensionFactory.DiscoverDimensions.AvailableDimensions, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportHierarchy> getExportHierarchiesAvailable() throws MetadataException {
        List<ExportHierarchy> collection = this.getCollection("AvailableHierarchies", this.exportHierarchies, ExportHierarchyFactory.DiscoverHierarchies.AvailableHierarchies, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportLevel> getExportLevelsAvailable() throws MetadataException {
        List<ExportLevel> collection = this.getCollection("AvailableLevels", this.exportLevels, ExportLevelFactory.DiscoverLevels.AvailableLevels, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportMember> getExportMembersAvailable() throws MetadataException {
        List<ExportMember> collection = this.getCollection("AvailableMembers", this.exportMembers, ExportMemberFactory.DiscoverMembers.AvailableMembers, this, new Object[0]);
        return collection;
    }

    @Override
    public ExportDimension getExportDimension(Dimension dimension, Object ... createOptions) throws MetadataException {
        ExportDimension exportObject;
        String uniqueExportName = this.exportDimensions.makeUniqueExportName(dimension, (ExportGeneralMetadata)this, createOptions);
        ExportObject<?, ?> alreadyCached = this.getUniqueExportObject(uniqueExportName);
        if (alreadyCached != null) {
            Object underlyingObject = alreadyCached.getUnderlyingObject();
            if (underlyingObject != dimension) {
                throw new MetadataException(this.getDuplicateUniqueExportNameMessage(uniqueExportName, dimension, underlyingObject));
            }
            exportObject = (ExportDimension)alreadyCached;
        } else {
            exportObject = this.exportDimensions.createObject(uniqueExportName, dimension, (ExportGeneralMetadata)this, createOptions);
            this.putUniqueExportObject(uniqueExportName, exportObject);
        }
        return exportObject;
    }

    @Override
    public List<ExportHierarchy> getExportHierarchies(List<Hierarchy> hierarchies, Object ... createOptions) throws MetadataException {
        return this.exportOlapItems(hierarchies, this.exportHierarchies, createOptions);
    }

    @Override
    public List<ExportLevel> getExportLevels(List<Level> levels, Object ... createOptions) throws MetadataException {
        return this.exportOlapItems(levels, this.exportLevels, createOptions);
    }

    @Override
    public List<ExportMember> getExportMembers(List<Member> members, Object ... createOptions) throws MetadataException {
        return this.exportOlapItems(members, this.exportMembers, createOptions);
    }

    protected <U, X extends ExportObject<U, X>> List<X> exportOlapItems(List<U> underlyingObjects, ExportObjectFactoryInterface<U, X> exportObjectFactory, Object ... createOptions) throws MetadataException {
        for (U underlyingObject : underlyingObjects) {
            Object underlyingObject2;
            String uniqueExportName = exportObjectFactory.makeUniqueExportName(underlyingObject, this, createOptions);
            ExportObject<?, ?> alreadyCached = this.getUniqueExportObject(uniqueExportName);
            if (alreadyCached == null || (underlyingObject2 = alreadyCached.getUnderlyingObject()) == underlyingObject) continue;
            throw new MetadataException(this.getDuplicateUniqueExportNameMessage(uniqueExportName, underlyingObject, underlyingObject2));
        }
        ArrayList exportObjects = new ArrayList();
        for (U underlyingObject : underlyingObjects) {
            ExportObject<?, ?> exportObject;
            String uniqueExportName = exportObjectFactory.makeUniqueExportName(underlyingObject, this, createOptions);
            if (this.containsUniqueExportObject(uniqueExportName)) {
                ExportObject<?, ?> uniqueExportObjectRaw = this.getUniqueExportObject(uniqueExportName);
                try {
                    ExportObject<?, ?> uniqueExportObjectBound;
                    exportObject = uniqueExportObjectBound = uniqueExportObjectRaw;
                }
                catch (ClassCastException e) {
                    throw new MetadataException(e);
                }
            } else {
                exportObject = (ExportObject<?, ?>)exportObjectFactory.createObject(uniqueExportName, underlyingObject, this, createOptions);
                this.putUniqueExportObject(uniqueExportName, exportObject);
            }
            exportObjects.add(exportObject);
        }
        return exportObjects;
    }

    @Override
    public List<Dimension> getAvailableDimensions(List<String> list, Object ... qualifiers) throws MetadataException {
        boolean filter = list != null && list.size() > 0;
        LinkedHashSet<Dimension> found = new LinkedHashSet<Dimension>();
        List<ExportDataSource> exportDataSources = this.getExportDataSourcesUsed();
        for (ExportDataSource exportDataSource : exportDataSources) {
            DataSource underlyingObject = (DataSource)exportDataSource.getUnderlyingObject();
            if (!(underlyingObject instanceof DataSourceCube)) continue;
            DataSourceCube dataSourceCube = this.getDataSouceCube(underlyingObject);
            List<Dimension> dimensions = dataSourceCube.getDimensions();
            if (filter) {
                for (Dimension dimension : dimensions) {
                    String checkName = this.exportDimensions.makeUniqueExportName(dimension, (ExportGeneralMetadata)this, qualifiers);
                    if (list == null || !list.contains(checkName)) continue;
                    found.add(dimension);
                }
                continue;
            }
            found.addAll(dimensions);
        }
        return new ArrayList<Dimension>(found);
    }

    @Override
    public List<Hierarchy> getAvailableHierarchies(List<String> list, Object ... qualifiers) throws MetadataException {
        boolean filter = list != null && list.size() > 0;
        LinkedHashSet<Hierarchy> found = new LinkedHashSet<Hierarchy>();
        List<ExportDataSource> exportDataSources = this.getExportDataSourcesUsed();
        for (ExportDataSource exportDataSource : exportDataSources) {
            DataSource underlyingObject = (DataSource)exportDataSource.getUnderlyingObject();
            if (!(underlyingObject instanceof DataSourceCube)) continue;
            DataSourceCube dataSourceCube = this.getDataSouceCube(underlyingObject);
            List<Dimension> dimensions = dataSourceCube.getDimensions();
            for (Dimension dimension : dimensions) {
                List<Hierarchy> hierarchies = dimension.getHierarchies();
                if (filter) {
                    for (Hierarchy hierarchy : hierarchies) {
                        String checkName = this.exportHierarchies.makeUniqueExportName(hierarchy, (ExportGeneralMetadata)this, qualifiers);
                        if (list == null || !list.contains(checkName)) continue;
                        found.add(hierarchy);
                    }
                    continue;
                }
                found.addAll(hierarchies);
            }
        }
        return new ArrayList<Hierarchy>(found);
    }

    @Override
    public List<Level> getAvailableLevels(List<String> list, Object ... qualifiers) throws MetadataException {
        boolean filter = list != null && list.size() > 0;
        LinkedHashSet<Level> found = new LinkedHashSet<Level>();
        List<ExportDataSource> exportDataSources = this.getExportDataSourcesUsed();
        for (ExportDataSource exportDataSource : exportDataSources) {
            DataSource underlyingObject = (DataSource)exportDataSource.getUnderlyingObject();
            if (!(underlyingObject instanceof DataSourceCube)) continue;
            DataSourceCube dataSourceCube = this.getDataSouceCube(underlyingObject);
            List<Dimension> dimensions = dataSourceCube.getDimensions();
            for (Dimension dimension : dimensions) {
                List<Hierarchy> hierarchies = dimension.getHierarchies();
                for (Hierarchy hierarchy : hierarchies) {
                    List<Level> levels = hierarchy.getLevels();
                    if (filter) {
                        for (Level level : levels) {
                            String checkName = this.exportLevels.makeUniqueExportName(level, (ExportGeneralMetadata)this, qualifiers);
                            if (list == null || !list.contains(checkName)) continue;
                            found.add(level);
                        }
                        continue;
                    }
                    found.addAll(levels);
                }
            }
        }
        return new ArrayList<Level>(found);
    }

    @Override
    public List<Member> getAvailableMembers(List<String> list, Object ... qualifiers) throws MetadataException {
        boolean filter = list != null && list.size() > 0;
        LinkedHashSet<Member> found = new LinkedHashSet<Member>();
        List<ExportDataSource> exportDataSources = this.getExportDataSourcesUsed();
        for (ExportDataSource exportDataSource : exportDataSources) {
            DataSource underlyingObject = (DataSource)exportDataSource.getUnderlyingObject();
            if (!(underlyingObject instanceof DataSourceCube)) continue;
            DataSourceCube dataSourceCube = this.getDataSouceCube(underlyingObject);
            List<Dimension> dimensions = dataSourceCube.getDimensions();
            for (Dimension dimension : dimensions) {
                List<Hierarchy> hierarchies = dimension.getHierarchies();
                for (Hierarchy hierarchy : hierarchies) {
                    List<Level> levels = hierarchy.getLevels();
                    for (Level level : levels) {
                        List<Member> members = level.getMembers();
                        if (filter) {
                            for (Member member : members) {
                                String checkName = this.exportMembers.makeUniqueExportName(member, (ExportGeneralMetadata)this, qualifiers);
                                if (list == null || !list.contains(checkName)) continue;
                                found.add(member);
                            }
                            continue;
                        }
                        found.addAll(members);
                    }
                }
            }
        }
        return new ArrayList<Member>(found);
    }

    @Override
    public void setExportItemsToUse(List<ExportDataSource> exportDataSources, List<ExportColumn> exportColumns, List<ExportFilter> exportFilters) throws MetadataException {
    }
}

