/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportJoin;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.impl.ExportJoinImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class ExportJoinFactory
extends ExportObjectFactoryAbstract<Join, ExportJoin> {
    private static final ExportJoinFactory SINGLETON_FACTORY = new ExportJoinFactory();

    private ExportJoinFactory() {
    }

    public static ExportJoinFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    private ExportJoin createExportObject(Join objectToExport, String uniqueExportName, ExportGeneralMetadata exportMetadata, Object ... options) throws MetadataException {
        return new ExportJoinImpl(objectToExport, uniqueExportName, this, exportMetadata);
    }

    @Override
    public String makeUniqueExportName(@Nonnull Join objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String objectToExportUniqueID = objectToExport.getID();
        return ExportJoinFactory.qualifyName(new StringBuffer(objectToExportUniqueID), qualifiers).toString();
    }

    @Override
    public ExportJoin createObject(String useUniqueExportName, Join objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueExportName = useUniqueExportName != null && useUniqueExportName.length() > 0 ? useUniqueExportName : this.makeUniqueExportName(objectToExport, exportMetadata, qualifiers);
        ExportJoin exportJoin = this.createExportObject(objectToExport, uniqueExportName, exportMetadata, new Object[0]);
        return exportJoin;
    }

    @Override
    public List<ExportJoin> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        DataSelection dataSelection = exportMetadata.getDataSelection();
        List<Join> objectsToCheck = dataSelection.getObjects(true, Join.class);
        ArrayList<Join> objectsToExport = new ArrayList<Join>();
        for (Join objectToCheck : objectsToCheck) {
            String checkName = this.makeUniqueExportName(objectToCheck, exportMetadata, qualifiers);
            if (list != null && !list.contains(checkName)) continue;
            objectsToExport.add(objectToCheck);
        }
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<Join> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List<Join> objectsToExport;
        DataSelection dataSelection = exportMetadata.getDataSelection();
        if (discoveryType == DiscoverJoins.AllJoinsUsed) {
            objectsToExport = dataSelection.getEffectiveJoinPath();
        } else if (discoveryType == DiscoverJoins.SelectedJoins) {
            objectsToExport = dataSelection instanceof ExplicitJoinPathSupport ? ((ExplicitJoinPathSupport)((Object)dataSelection)).getExplicitJoinPath() : new ArrayList<Join>();
        } else {
            throw new MetadataException(this.getInvalidDiscoveryTypeMessage(discoveryType));
        }
        return objectsToExport;
    }

    public static enum DiscoverJoins implements ExportDiscoveryType
    {
        AllJoinsUsed,
        SelectedJoins,
        AvailableJoins;

    }
}

