/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.EntityInterface;
import com.sas.entities.persist.EntityFactory;
import com.sas.iquery.metadata.Cardinality;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ExportCubeMlsLanguage;
import com.sas.iquery.metadata.business.ExportHierarchyColumnDef;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.JoinTypeList;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.ExportCubeMlsLanguageFactory;
import com.sas.iquery.metadata.business.impl.ExportCubeProcessor;
import com.sas.iquery.metadata.business.impl.ExportOutputColumnDef;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifierList;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Key;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExportCubeDataDsBuilder {
    static final Logger _logger = LogManager.getLogger(ExportCubeDataDsBuilder.class);
    public static final String DATA_ITEM_ATTRIBUTE_FORMATTED_HIER_COL = "FORMATTED_HIER_COL";
    public static final String DATA_ITEM_ATTRIBUTE_UNFORMATTED_HIER_COL = "UNFORMATTED_HIER_COL";
    private final SessionContextInterface _session;
    private final IntelligentQueryMetadataServiceInterface _iqService;
    private final DataSourceCube _dataSourceCube;
    private ExportCubeProcessor _cubeProcessor = null;
    private boolean _ownsCubeProcessor = false;

    public ExportCubeDataDsBuilder(@Nonnull SessionContextInterface session, @Nonnull IntelligentQueryMetadataServiceInterface iqService, @Nonnull DataSourceCube dataSourceCube) {
        this._session = session;
        this._iqService = iqService;
        this._dataSourceCube = dataSourceCube;
    }

    public void close() {
        if (this._cubeProcessor != null && this._ownsCubeProcessor) {
            this._ownsCubeProcessor = false;
            this._cubeProcessor.close();
            this._cubeProcessor = null;
        }
    }

    public ExportCubeProcessor getExportCubeProcessor() throws MetadataException {
        if (this._cubeProcessor == null) {
            if (this._dataSourceCube == null) {
                throw new MetadataException(this.getMsgCannotBuildDataSelectionForExport(this._dataSourceCube));
            }
            this._cubeProcessor = this.newCubeProcessor(this._dataSourceCube);
            this._ownsCubeProcessor = true;
        }
        return this._cubeProcessor;
    }

    public void setExportCubeProcessor(ExportCubeProcessor newCubeProcessor) throws MetadataException {
        if (this._ownsCubeProcessor && this._cubeProcessor != null) {
            this._cubeProcessor.close();
        }
        this._cubeProcessor = newCubeProcessor;
        this._ownsCubeProcessor = false;
    }

    private ExportCubeProcessor newCubeProcessor(DataSourceCube dataSourceCube) {
        return new ExportCubeProcessor(dataSourceCube);
    }

    public boolean canHandle() throws MetadataException {
        return this._dataSourceCube != null;
    }

    public DataSelection newDataSelection(Locale computationLocale, boolean ignoreReachThruTable, boolean includeAllColumns) throws MetadataException {
        return this.newDataSelection(computationLocale, true, true, false, false, 1, null, ignoreReachThruTable, includeAllColumns);
    }

    public DataSelection newDataSelection(Locale computationLocale, ExportCubeMlsLanguage exportMlsLanguage, boolean ignoreReachThruTable, boolean includeAllColumns) throws MetadataException {
        return this.newDataSelection(computationLocale, true, true, false, false, 1, ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY, ignoreReachThruTable, includeAllColumns);
    }

    public DataSelection newDataSelection(Locale computationLocale, boolean useRaseJoinConditions, boolean addRegularDataItems, boolean addForcedFormatDataItems, boolean queryUnformattedValues, int siFormatType, ExportCubeMlsLanguage exportMlsLanguage, boolean ignoreReachThruTable, boolean includeAllColumns) throws MetadataException {
        DataSelection ds;
        if (!this.canHandle()) {
            throw new MetadataException(this.getMsgCannotBuildDataSelectionForExport(this._dataSourceCube));
        }
        ExportCubeMlsLanguage language = exportMlsLanguage;
        ExportCubeProcessor cubeProcessor = this.getExportCubeProcessor();
        com.sas.metadata.remote.Cube omrCube = cubeProcessor.getOmrCube();
        try {
            ds = this.newDataSelection(this._session, this._iqService, this._dataSourceCube, omrCube, computationLocale, cubeProcessor, useRaseJoinConditions, addRegularDataItems, addForcedFormatDataItems, queryUnformattedValues, siFormatType, language, ignoreReachThruTable, includeAllColumns);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        return ds;
    }

    private DataSelection newDataSelection(SessionContextInterface session, IntelligentQueryMetadataServiceInterface iqService, DataSourceCube dataSourceCube, com.sas.metadata.remote.Cube omrCube, Locale computationLocale, ExportCubeProcessor cubeProcessor, boolean useRaseJoinConditions, boolean addRegularDataItems, boolean addForcedFormatDataItems, boolean queryUnformattedValues, int siFormatType, ExportCubeMlsLanguage language, boolean ignoreReachThruTable, boolean includeAllColumns) throws RemoteException, MdException, MetadataException, ServiceException {
        String factTableDataSetOptions;
        DataTable factTable;
        boolean useReachThru;
        boolean bl = useReachThru = !ignoreReachThruTable && cubeProcessor.useReachThruTable(language);
        if (useReachThru) {
            factTable = cubeProcessor.getReachThruTable(language);
            factTableDataSetOptions = cubeProcessor.getReachThruTableDataSetOptions();
        } else {
            factTable = cubeProcessor.getDetailTable(language);
            factTableDataSetOptions = cubeProcessor.getDetailTableDataSetOptions();
        }
        SASLibrary factSchema = ExportCubeProcessor.getLibrary(factTable);
        ServerContext defaultServerContext = ExportCubeProcessor.getServerContext((RelationalSchema)factSchema);
        if (defaultServerContext == null) {
            throw new MetadataException(this.getMsgSchemaNotAssociatedWithServer(factSchema));
        }
        DataSelection ds = DataSelectionFactory.newDataSelection(session, iqService, computationLocale);
        ds.setID("ExportCubeDS");
        LinkedHashMap<Object, String> names = new LinkedHashMap<Object, String>();
        DataSourceTable detailDST = this.newDataSource(ds, factTable, useReachThru ? "RT" : "FACT", names, dataSourceCube, defaultServerContext, factTableDataSetOptions);
        ds.addDataSource(detailDST);
        LinkedHashMap<DataTable, DataSourceTable> sources = new LinkedHashMap<DataTable, DataSourceTable>();
        sources.put(factTable, detailDST);
        LinkedHashMap<Object, List<ExportOutputColumnDef>> referencedColumns = new LinkedHashMap<Object, List<ExportOutputColumnDef>>();
        referencedColumns.putAll(cubeProcessor.getOutputColumnReferences(language));
        if (!useReachThru) {
            this.joinDimensions(cubeProcessor, defaultServerContext, ds, dataSourceCube, omrCube, names, sources, language, factTableDataSetOptions, useRaseJoinConditions, referencedColumns);
        }
        Set<String> used = null;
        if (!includeAllColumns) {
            used = this.getUsedTableColumnNames(referencedColumns, useReachThru, factTable);
        }
        LinkedHashMap<DataItem, QualifiedColumn> items = new LinkedHashMap<DataItem, QualifiedColumn>();
        for (Map.Entry entry : sources.entrySet()) {
            DataSourceTable dst = (DataSourceTable)entry.getValue();
            DataTable dt = (DataTable)entry.getKey();
            String sasTableName = dt.getTableName();
            List<QualifiedColumn> qualifiedColumns = dst.getQualifiedColumns();
            for (QualifiedColumn qualifiedColumn : qualifiedColumns) {
                String sasColumnName = qualifiedColumn.getSasName();
                boolean includeColumn = includeAllColumns || used.contains(sasTableName.toLowerCase() + "." + sasColumnName.toLowerCase());
                if (!includeColumn) continue;
                DataItem item = this.newDataItem(qualifiedColumn, ds, names);
                if (addRegularDataItems) {
                    DataItem newDir = this.newDir(qualifiedColumn, ds, names, item, sasColumnName, false);
                    items.put(newDir, qualifiedColumn);
                    ds.addResultItem(newDir, Role.COLUMN);
                }
                if (!addForcedFormatDataItems) continue;
                DataItem newDirFF = this.newDir(qualifiedColumn, ds, names, item, "ff" + sasColumnName, true);
                items.put(newDirFF, qualifiedColumn);
                ds.addResultItem(newDirFF, Role.COLUMN);
            }
        }
        List<Dimension> dimensions = cubeProcessor.getDimensions();
        if (dimensions.size() > 0) {
            EntityFactory entityFactory = new EntityFactory();
            Set keySet = referencedColumns.keySet();
            block2: for (Object object : keySet) {
                if (!(object instanceof ExportHierarchyColumnDef)) continue;
                ExportHierarchyColumnDef memberColumnDef = (ExportHierarchyColumnDef)object;
                for (Map.Entry entry : items.entrySet()) {
                    com.sas.metadata.remote.Column memberPhyColumn;
                    DataItem item = (DataItem)entry.getKey();
                    QualifiedColumn itemQcColumn = (QualifiedColumn)entry.getValue();
                    boolean match = ExportCubeDataDsBuilder.isMatch(itemQcColumn, memberPhyColumn = memberColumnDef.getCol(), useReachThru);
                    if (!match) continue;
                    DataItem newResultItem = this.hierarchyColumn(ds, item, itemQcColumn, addForcedFormatDataItems, names, entityFactory, memberColumnDef, memberColumnDef.getHier());
                    if (newResultItem == null) continue block2;
                    ds.addResultItem(newResultItem, Role.COLUMN);
                    continue block2;
                }
            }
        }
        if (queryUnformattedValues) {
            ds.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, queryUnformattedValues);
        }
        if (siFormatType != 0) {
            for (SelectedItem selectedItem : ds.getSelectedItems()) {
                selectedItem.setFormatType(siFormatType);
            }
        }
        return ds;
    }

    public static boolean isMatch(QualifiedColumn qualifiedColumn, com.sas.metadata.remote.Column dataTableColumn, boolean useReachThru) throws MetadataException, RemoteException, MdException {
        Column itemPhyColumn = qualifiedColumn.getColumn();
        boolean match = false;
        if (useReachThru || !(itemPhyColumn instanceof OMAColumn)) {
            String colName = itemPhyColumn.getSasName();
            if (colName.equalsIgnoreCase(dataTableColumn.getSASColumnName())) {
                if (useReachThru) {
                    match = true;
                } else {
                    String tabName = itemPhyColumn.getOwningTable().getSasName();
                    if (tabName.equals(dataTableColumn.getTable().getTableName())) {
                        match = true;
                    }
                }
            }
        } else {
            CMetadata omaObject = ((OMAColumn)itemPhyColumn).getOMAObject();
            if (dataTableColumn.equals((Object)omaObject)) {
                match = true;
            }
        }
        return match;
    }

    private Set<String> getUsedTableColumnNames(Map<Object, List<ExportOutputColumnDef>> referencedColumns, boolean useReachThru, DataTable reachThruTable) throws RemoteException {
        LinkedHashSet<String> used = new LinkedHashSet<String>();
        for (List<ExportOutputColumnDef> outputColumnDefs : referencedColumns.values()) {
            for (ExportOutputColumnDef outputColumnDef : outputColumnDefs) {
                String refsSasColumnName = outputColumnDef.getSasColumnName();
                String refsSasTableName = useReachThru ? reachThruTable.getTableName() : outputColumnDef.getSasTableName();
                used.add(refsSasTableName.toLowerCase() + "." + refsSasColumnName.toLowerCase());
            }
        }
        return used;
    }

    private void joinDimensions(ExportCubeProcessor cubeProcessor, ServerContext defaultServerContext, DataSelection ds, DataSourceCube dataSourceCube, com.sas.metadata.remote.Cube omrCube, Map<Object, String> names, Map<DataTable, DataSourceTable> sources, ExportCubeMlsLanguage language, String factTableDataSetOptions, boolean useRaseJoinConditions, Map<Object, List<ExportOutputColumnDef>> referencedColumns) throws RemoteException, MdException, MetadataException, ServiceException {
        LinkedHashMap<Dimension, ExportOutputColumnDef> dimKeyColumns = new LinkedHashMap<Dimension, ExportOutputColumnDef>();
        dimKeyColumns.putAll(cubeProcessor.getDimKeyColumnReferences(language));
        LinkedHashMap<Dimension, ExportOutputColumnDef> factKeyColumns = new LinkedHashMap<Dimension, ExportOutputColumnDef>();
        factKeyColumns.putAll(cubeProcessor.getFactKeyColumnReferences(language));
        LinkedHashSet joinedDimensions = new LinkedHashSet(dimKeyColumns.keySet());
        joinedDimensions.addAll(factKeyColumns.keySet());
        for (Dimension dimension : joinedDimensions) {
            ExportOutputColumnDef dimKeyColumnDef;
            List<ExportOutputColumnDef> list = referencedColumns.get(dimension);
            if (list == null) {
                list = new ArrayList<ExportOutputColumnDef>();
                referencedColumns.put(dimension, list);
            }
            if ((dimKeyColumnDef = (ExportOutputColumnDef)dimKeyColumns.get(dimension)) == null) {
                throw new MetadataException(this.getMsgCouldNotFindDimTableKeyColumn(omrCube, dimension));
            }
            if (!list.contains(dimKeyColumnDef)) {
                list.add(dimKeyColumnDef);
            }
            com.sas.metadata.remote.Column dimKeyColumn = dimKeyColumnDef.getColumn();
            ExportOutputColumnDef factKeyColumnDef = (ExportOutputColumnDef)factKeyColumns.get(dimension);
            if (factKeyColumnDef == null) {
                throw new MetadataException(this.getMsgCouldNotFindFactTableKeyColumn(omrCube, dimension));
            }
            if (!list.contains(factKeyColumnDef)) {
                list.add(factKeyColumnDef);
            }
            com.sas.metadata.remote.Column factKeyColumn = factKeyColumnDef.getColumn();
            DataTable factKeyTable = factKeyColumn.getTable();
            this.ensureTableAdded(ds, dataSourceCube, sources, factKeyTable, "FACT", names, defaultServerContext, factTableDataSetOptions);
            DataSourceTable factDST = sources.get(factKeyTable);
            QualifiedColumn factQC = this.findQualifiedColumn(factDST, factKeyColumn);
            DataTable dimKeyTable = dimKeyColumn.getTable();
            String dimTableDataSetOptions = cubeProcessor.getDimensionTableDataSetOptions(dimension);
            this.ensureTableAdded(ds, dataSourceCube, sources, dimKeyTable, "DIM", names, defaultServerContext, dimTableDataSetOptions);
            DataSourceTable dimDST = sources.get(dimKeyTable);
            QualifiedColumn dimQC = this.findQualifiedColumn(dimDST, dimKeyColumn);
            Join join = this.newJoin(ds, factDST, factQC, dimDST, dimQC, JoinType.INNER, useRaseJoinConditions);
            ds.addBusinessRule(join);
        }
    }

    private DataItem hierarchyColumn(DataSelection ds, DataItem baseItem, QualifiedColumn itemQcColumn, boolean addForcedFormatDataItems, Map<Object, String> names, EntityFactory entityFactory, ExportHierarchyColumnDef memberColumnDef, Hierarchy hierarchy) throws RemoteException, MetadataException, InvalidIDException {
        DataItem newResultItem;
        int ord = memberColumnDef.getPosition();
        com.sas.metadata.remote.Column memberPhyColumn = memberColumnDef.getCol();
        Level lev = memberColumnDef.getLev();
        String format = this.getFormatToUse(lev, memberPhyColumn, itemQcColumn);
        boolean baseIsChar = baseItem.getExpressionType() == 3;
        boolean setFFvalue = false;
        if (format == null || !baseIsChar || !format.equals("") && !format.equals("$.")) {
            setFFvalue = true;
        }
        boolean reuseOrig = this.reuseOriginalDataItem(baseItem, format, baseIsChar, setFFvalue);
        String uniqueHierarchyName = hierarchy.getUniqueName();
        this.addToAttrValue(entityFactory, baseItem, DATA_ITEM_ATTRIBUTE_UNFORMATTED_HIER_COL, uniqueHierarchyName, ord, format);
        if (reuseOrig) {
            this.addToAttrValue(entityFactory, baseItem, DATA_ITEM_ATTRIBUTE_FORMATTED_HIER_COL, uniqueHierarchyName, ord, format);
            newResultItem = null;
        } else {
            newResultItem = this.formattedItem(ds, baseItem, itemQcColumn, addForcedFormatDataItems, names, entityFactory, memberColumnDef, ord, format, setFFvalue, uniqueHierarchyName);
        }
        return newResultItem;
    }

    private boolean reuseOriginalDataItem(DataItem baseItem, String format, boolean baseIsChar, boolean setFFvalue) {
        boolean reuse = false;
        DataItemActionType oldUsage = baseItem.getUsage();
        if (oldUsage.equals(DataItemActionType.USAGE_DETAIL)) {
            boolean formatsMatch;
            boolean oldFF = baseItem.isFormattingForced();
            String oldFormat = baseItem.getFormat();
            boolean oldFormatEmpty = oldFormat == null || oldFormat.trim().isEmpty() || baseIsChar && oldFormat.trim().equals("$.");
            boolean newFormatEmpty = format == null || format.trim().isEmpty() || baseIsChar && format.trim().equals("$.");
            boolean bl = formatsMatch = oldFormatEmpty && newFormatEmpty || oldFormat.equals(format);
            if (oldFF == setFFvalue && formatsMatch) {
                reuse = true;
            }
        }
        return reuse;
    }

    private DataItem formattedItem(DataSelection ds, DataItem baseItem, QualifiedColumn itemQcColumn, boolean addForcedFormatDataItems, Map<Object, String> names, EntityFactory entityFactory, ExportHierarchyColumnDef memberColumnDef, int ord, String format, boolean setFFvalue, String uniqueHierarchyName) throws MetadataException, InvalidIDException, RemoteException {
        DataItem attribItem;
        DataItem newResultItem;
        DataItem item;
        boolean reusePreviousFF = false;
        StringExpressionUtil exprUtil = StringExpressionUtil.getInstance();
        boolean setFormat = true;
        if (setFFvalue && !addForcedFormatDataItems) {
            String format2;
            FunctionCall putExpr = (format2 = this.ensureValidFormat(baseItem, itemQcColumn, format)) == null ? null : this.newPutExpression(ds, itemQcColumn, format2);
            DataItem found = this.findReusableFfItem(ds, exprUtil, itemQcColumn, format2, putExpr);
            if (found != null) {
                reusePreviousFF = true;
                item = found;
            } else if (putExpr != null) {
                item = this.newPutExprDataItem(ds, itemQcColumn, names, putExpr);
                setFFvalue = false;
                setFormat = false;
                format = format2;
            } else {
                item = baseItem;
            }
        } else {
            item = baseItem;
        }
        if (reusePreviousFF) {
            newResultItem = null;
            attribItem = item;
        } else {
            attribItem = newResultItem = this.newHierColDataItem(ds, item, memberColumnDef, setFormat, format, setFFvalue, names);
        }
        this.addToAttrValue(entityFactory, attribItem, DATA_ITEM_ATTRIBUTE_FORMATTED_HIER_COL, uniqueHierarchyName, ord, format);
        return newResultItem;
    }

    private DataItem findReusableFfItem(DataSelection ds, StringExpressionUtil exprUtil, QualifiedColumn itemQcColumn, String format, ExpressionInterface putExpr) throws MetadataException {
        String putText = putExpr == null ? null : exprUtil.getText(putExpr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, ds).trim();
        String qcText = exprUtil.getText(itemQcColumn, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, ds).trim();
        List<DataItem> currentItems = ds.getResultItems(Role.COLUMN);
        DataItem found = null;
        for (DataItem dataItem : currentItems) {
            if (!dataItem.getUsage().equals(DataItemActionType.USAGE_DETAIL)) continue;
            String compText1 = null;
            String compText2 = null;
            boolean diFF = dataItem.isFormattingForced();
            int diType = dataItem.getExpressionTypeIgnoringFormattingForced();
            if (diFF) {
                ExpressionInterface diExpr = dataItem.getExpression();
                int diExType = diExpr.getExpressionType();
                int qcType = itemQcColumn.getExpressionType();
                if (qcType == diExType) {
                    String diFormat = dataItem.getFormat();
                    if (format == null && diFormat == null || format != null && diFormat != null && format.trim().equals(diFormat.trim())) {
                        compText1 = qcText;
                        compText2 = exprUtil.getText(diExpr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, ds).trim();
                    }
                }
            } else if (putText != null && diType == 3) {
                ExpressionInterface expression = dataItem.getExpression();
                compText1 = putText;
                compText2 = exprUtil.getText(expression, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, ds);
            }
            if (compText1 == null || !(compText2 != null & compText1.equals(compText2))) continue;
            found = dataItem;
            break;
        }
        return found;
    }

    private String getFormatToUse(Level level, com.sas.metadata.remote.Column memberPhyColumn, QualifiedColumn itemQcColumn) throws RemoteException, MetadataException {
        boolean usePhyFormat;
        String levFormat = level.getSASFormat();
        String phyFormat = memberPhyColumn.getSASFormat();
        String qcFormat = itemQcColumn.getSasFormat();
        boolean useLevFormat = levFormat != null && levFormat.trim().length() > 0;
        boolean bl = usePhyFormat = phyFormat != null && phyFormat.trim().length() > 0;
        String format = useLevFormat ? levFormat : (usePhyFormat ? phyFormat : qcFormat);
        return format;
    }

    private DataItem newHierColDataItem(DataSelection ds, DataItem baseItem, ExportHierarchyColumnDef memberColumnDef, boolean setFormat, String format, boolean setFFvalue, Map<Object, String> names) throws RemoteException, MetadataException, InvalidIDException {
        String levelSimpleName = memberColumnDef.getLev().getName();
        String dirName = this.getNewColumnName("lev_" + levelSimpleName, ds, names);
        String label = "Level " + levelSimpleName;
        String description = "Formatted values of Level " + levelSimpleName + (setFormat ? " with format " + format : "");
        DataItemReference ffHierCol = ds.newDataItemReference(baseItem);
        ds.addBusinessItem(ffHierCol);
        ffHierCol.setLabel(label);
        ffHierCol.setDescription(description);
        ffHierCol.setUsage(DataItemActionType.USAGE_DETAIL);
        ffHierCol.setIntraModelID(dirName);
        ffHierCol.setResultSetID(dirName);
        names.put(ffHierCol, dirName);
        if (setFormat) {
            ffHierCol.setFormat(format);
        }
        if (setFFvalue) {
            ffHierCol.setFormattingForced(setFFvalue);
        }
        return ffHierCol;
    }

    private DataItem newPutExprDataItem(DataSelection ds, QualifiedColumn itemQcColumn, Map<Object, String> names, ExpressionInterface putExpr) throws MetadataException, InvalidIDException {
        String itemPrefix = names.get(itemQcColumn.getDataSource());
        String itemName = this.getNewColumnName(itemPrefix, ds, names);
        RootDataItem item = ExportCubeDataDsBuilder.newDataItem(ds, itemQcColumn);
        item.setExpression(putExpr);
        item.setIntraModelID(itemName);
        item.setResultSetID(itemName);
        item.setLabel(itemQcColumn.getLabel());
        item.setFormat("");
        names.put(item, itemName);
        ds.addBusinessItem(item);
        return item;
    }

    private FunctionCall newPutExpression(DataSelection ds, ExpressionInterface columnExpr, String putFormat) throws MetadataException {
        boolean disablePutQ = Boolean.getBoolean("SASQueryServices.sasDisablePutQ");
        FunctionNameID putId = disablePutQ ? FunctionNameID.PUT : FunctionNameID.PUT_Q;
        Function fn = ds.getServerProperties().getFunctionByNameID(putId);
        ConstantExpression formatExpr = new ConstantExpression(putFormat, 11);
        FunctionCall fc = new FunctionCall(fn, columnExpr, formatExpr);
        return fc;
    }

    private String ensureValidFormat(DataItem baseItem, QualifiedColumn itemQcColumn, String format) {
        if (format != null && !format.trim().equals("")) {
            boolean isFormatCompatible = GenerationUtil.isFormatCompatibleWithType(baseItem);
            if (!isFormatCompatible) {
                format = "";
            }
        } else {
            int type = itemQcColumn.getExpressionType();
            format = type == 2 ? "BEST." : (type == 3 ? "$." : (type == 4 ? "DATE." : (type == 5 ? "TIME." : (type == 6 ? "DATETIME." : null))));
        }
        return format;
    }

    private void addToAttrValue(EntityFactory entityFactory, DataItem item, String attrName, String uniqueHierarchyName, int ord, String format) throws MetadataException, RemoteException {
        String attribute;
        EntityInterface extendedAttributes = this.getItemEntity(entityFactory, item, attrName);
        try {
            attribute = (String)extendedAttributes.getAttribute(attrName);
            attribute = attribute != null && attribute.trim().length() > 0 ? attribute + "," : "";
        }
        catch (NoSuchElementException e) {
            attribute = "";
        }
        attribute = attribute + uniqueHierarchyName + "#" + ord + "#" + format;
        try {
            extendedAttributes.setAttribute(attrName, (Object)attribute);
        }
        catch (AttributeSetException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getUsedByFormattedHierarchies(DataItem underlyingObject) throws MetadataException {
        List<String> usedByUniqueLevelNames;
        EntityInterface extendedAttributes = underlyingObject.getExtendedAttributes();
        if (extendedAttributes != null) {
            Object attribute;
            try {
                attribute = extendedAttributes.getAttribute(DATA_ITEM_ATTRIBUTE_FORMATTED_HIER_COL);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                throw new MetadataException(e);
            }
            catch (NoSuchElementException e) {
                attribute = null;
            }
            usedByUniqueLevelNames = attribute != null && attribute instanceof String ? Arrays.asList(((String)attribute).split(",")) : Collections.emptyList();
        } else {
            usedByUniqueLevelNames = Collections.emptyList();
        }
        return usedByUniqueLevelNames;
    }

    private EntityInterface getItemEntity(EntityFactory entityFactory, DataItem item, String attrname) throws MetadataException, RemoteException {
        EntityInterface extendedAttributes;
        if (item instanceof DataItemReference) {
            DataItemReference dir = (DataItemReference)item;
            if (!dir.isExtendedAttributesModified()) {
                extendedAttributes = entityFactory.createEntity();
                item.setExtendedAttributes(extendedAttributes);
            } else {
                extendedAttributes = item.getExtendedAttributes();
            }
        } else {
            extendedAttributes = item.getExtendedAttributes();
        }
        AttributeGroupInterface attributeGroup = extendedAttributes.getAttributeGroup();
        if (!attributeGroup.containsAttributeDescriptorNamed(attrname, false)) {
            AttributeDescriptor attribute = new AttributeDescriptor(attrname);
            attributeGroup.addAttributeDescriptor((AttributeDescriptorInterface)attribute, -1);
        }
        return extendedAttributes;
    }

    private DataItem newDataItem(QualifiedColumn qualifiedColumn, DataSelection dataSelection, Map<Object, String> names) throws MetadataException, InvalidIDException {
        RootDataItem item = ExportCubeDataDsBuilder.newDataItem(dataSelection, qualifiedColumn);
        boolean formatValid = GenerationUtil.isFormatCompatibleWithType(item);
        if (!formatValid) {
            item.setFormat(GenerationUtil.generateFormat(item, true));
        }
        dataSelection.addBusinessItem(item);
        String itemPrefix = names.get(qualifiedColumn.getDataSource());
        String itemName = this.getNewColumnName(itemPrefix, dataSelection, names);
        item.setResultSetID(itemName);
        item.setIntraModelID(itemName);
        item.setLabel(qualifiedColumn.getLabel());
        names.put(item, itemName);
        return item;
    }

    private DataItem newDir(QualifiedColumn qualifiedColumn, DataSelection dataSelection, Map<Object, String> names, DataItem item, String sasName, boolean isFF) throws MetadataException, InvalidIDException {
        boolean formatValid;
        DataItemReference dir = dataSelection.newDataItemReference(item);
        dataSelection.addBusinessItem(dir);
        if (!dir.getUsage().equals(DataItemActionType.USAGE_DETAIL)) {
            dir.setUsage(DataItemActionType.USAGE_DETAIL);
        }
        if (dir.isFormattingForced() != isFF) {
            dir.setFormattingForced(isFF);
        }
        if (!(formatValid = GenerationUtil.isFormatCompatibleWithType(dir))) {
            dir.setFormat(GenerationUtil.generateFormat(dir, true));
        }
        String dirName = this.getNewColumnName(sasName, dataSelection, names);
        dir.setIntraModelID(dirName);
        dir.setResultSetID(dirName);
        names.put(dir, dirName);
        return dir;
    }

    private String getNewColumnName(String itemPrefix, DataSelection dataSelection, Map<Object, String> names) {
        int j = 1;
        String testItemName = dataSelection.generateIntraModelID(itemPrefix);
        while (names.containsValue(testItemName)) {
            testItemName = dataSelection.generateIntraModelID(itemPrefix + "_" + ++j);
        }
        return testItemName;
    }

    private void ensureTableAdded(BusinessModel model, DataSourceCube cube, Map<DataTable, DataSourceTable> sources, DataTable remoteTable, String prefix, Map<Object, String> names, ServerContext defaultServerContext, String overrideDataSetOptions) throws RemoteException, MdException, MetadataException, ServiceException {
        if (!sources.keySet().contains(remoteTable)) {
            DataSourceTable dimensionTable = this.newDataSource(model, remoteTable, prefix, names, cube, defaultServerContext, overrideDataSetOptions);
            model.addDataSource(dimensionTable);
            sources.put(remoteTable, dimensionTable);
        }
    }

    private Join newJoin(BusinessModel model, DataSourceTable detailTable, QualifiedColumn qualifiedColumnOfDetail, DataSourceTable dimensionTable, QualifiedColumn qualifiedColumnOfDimension, JoinType joinType, boolean useRaseJoinCondition) throws MetadataException {
        ConditionalExpression jc = null;
        if (useRaseJoinCondition) {
            ExpressionIdentifier exprIdentifier;
            ExpressionIdentifierList exprIdentifierList = new ExpressionIdentifierList();
            if (joinType == JoinType.INNER) {
                exprIdentifier = ExpressionIdentifier.getStringIdentifier("\n\t   ");
                exprIdentifierList.add(exprIdentifier);
            } else {
                exprIdentifier = ExpressionIdentifier.getStringIdentifier("\n\t   (");
                exprIdentifierList.add(exprIdentifier);
            }
            exprIdentifier = ExpressionIdentifier.getResourceIdentifier(qualifiedColumnOfDimension);
            exprIdentifierList.add(exprIdentifier);
            exprIdentifier = ExpressionIdentifier.getStringIdentifier("=");
            exprIdentifierList.add(exprIdentifier);
            exprIdentifier = ExpressionIdentifier.getResourceIdentifier(qualifiedColumnOfDetail);
            exprIdentifierList.add(exprIdentifier);
            if (joinType == JoinType.INNER) {
                exprIdentifier = ExpressionIdentifier.getStringIdentifier("\n");
                exprIdentifierList.add(exprIdentifier);
            } else {
                exprIdentifier = ExpressionIdentifier.getStringIdentifier(") or (");
                exprIdentifierList.add(exprIdentifier);
                exprIdentifier = ExpressionIdentifier.getResourceIdentifier(qualifiedColumnOfDetail);
                exprIdentifierList.add(exprIdentifier);
                exprIdentifier = ExpressionIdentifier.getStringIdentifier(" IS NULL)\n");
                exprIdentifierList.add(exprIdentifier);
            }
            ResourceAwareStringExpression rase = new ResourceAwareStringExpression(model, exprIdentifierList, 9, ResourceScope.PHYSICAL_SCOPE);
            ConditionalExpressionAdapter jce = new ConditionalExpressionAdapter();
            jce.setExpression(rase);
            jc = jce;
        } else if (joinType == JoinType.INNER) {
            SimpleConditionalExpression_Comparison sce = new SimpleConditionalExpression_Comparison();
            sce.setLeftExpression(qualifiedColumnOfDetail);
            sce.setRightExpression(qualifiedColumnOfDimension);
            sce.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            jc = sce;
        } else {
            CompoundConditionalExpression cce = new CompoundConditionalExpression();
            cce.setRelationType(ConditionalRelationType.OR);
            SimpleConditionalExpression_Comparison condExpr = new SimpleConditionalExpression_Comparison();
            condExpr.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            condExpr.setLeftExpression(qualifiedColumnOfDetail);
            condExpr.setRightExpression(qualifiedColumnOfDimension);
            cce.setLeftExpression(condExpr);
            SimpleConditionalExpression_TestForNull isNull = new SimpleConditionalExpression_TestForNull();
            isNull.setWhatToCompare(qualifiedColumnOfDetail);
            cce.setRightExpression(isNull);
            jc = cce;
        }
        Join join = model.newJoin();
        JoinTypeList joinTypeList = new JoinTypeList();
        joinTypeList.addAll((Collection)JoinTypeList.ALL_JOIN_TYPES);
        join.setAllowedTypes(joinTypeList);
        if (joinType == JoinType.RIGHT || joinType == JoinType.INNER) {
            join.setLeftDataSource(detailTable);
            join.setRightDataSource(dimensionTable);
            join.setCardinality(Cardinality.MANY_TO_ONE);
        } else {
            join.setLeftDataSource(dimensionTable);
            join.setRightDataSource(detailTable);
            join.setCardinality(Cardinality.ONE_TO_MANY);
            join.setLabel(jc.toString());
            join.setDescription(jc.toString());
        }
        join.setType(joinType);
        join.setJoinCondition(jc);
        join.setLabel(detailTable + ".\"" + qualifiedColumnOfDetail + "\" " + joinType + " " + dimensionTable + ".\"" + qualifiedColumnOfDimension + "\"");
        join.setDescription((join.getLeftDataSource() + " " + join.getType().getPersistentForm() + " " + join.getRightDataSource() + " on " + StringExpressionUtil.getInstance().getReadableText(jc)).replaceAll("[\\n\\s]+", " "));
        return join;
    }

    private QualifiedColumn findQualifiedColumn(DataSourceTable dataSourceTable, com.sas.metadata.remote.Column physicalColumn) throws MetadataException {
        QualifiedColumn qualifiedColumnOfDimension = null;
        for (QualifiedColumn qc : dataSourceTable.getQualifiedColumns()) {
            Column column = qc.getColumn();
            String dataSourceTableSasName = column.getSasName();
            String physicalColumnSasName = "";
            try {
                physicalColumnSasName = physicalColumn.getSASColumnName();
            }
            catch (RemoteException e) {
                throw new MetadataException(this.getMsgCouldNotRetrieveTheColumnName(physicalColumn), (Throwable)e);
            }
            if (!dataSourceTableSasName.equalsIgnoreCase(physicalColumnSasName)) continue;
            qualifiedColumnOfDimension = qc;
            break;
        }
        return qualifiedColumnOfDimension;
    }

    private DataSourceTable newDataSource(BusinessModel model, DataTable dataTable, String prefix, Map<Object, String> names, Cube cube, ServerContext defaultServerContext, String overrideDataSetOptions) throws RemoteException, MdException, MetadataException, ServiceException {
        SessionContextInterface session = model.getSession();
        MetadataServerInterface metadataServer = IQModelImplUtilities.getMetadataServerAuthenticatedWith(session);
        String tableName = dataTable.getTableName();
        AccessPathToRelationalData accessPath = this.newAccessPath(dataTable, session, metadataServer, defaultServerContext);
        Table table = this.newTable(dataTable, session, metadataServer, overrideDataSetOptions);
        DataSourceTable dsTable = model.newDataSourceTable(accessPath, table);
        dsTable.setLabel(tableName);
        int inc = 1;
        while (names.containsValue(prefix + inc)) {
            ++inc;
        }
        names.put(dsTable, prefix + inc);
        dsTable.setIntraModelID(prefix + inc);
        return dsTable;
    }

    private AccessPathToRelationalData newAccessPath(DataTable dataTable, SessionContextInterface session, MetadataServerInterface metadataServer, ServerContext defaultServerContext) throws RemoteException, MdException, MetadataException {
        SASLibrary schema = ExportCubeProcessor.getLibrary(dataTable);
        ServerContext serverContext = ExportCubeProcessor.getServerContext((RelationalSchema)schema);
        if (serverContext == null) {
            serverContext = defaultServerContext;
        }
        OMASoftwareServer serverObject = OMAResourceFactory.getOMAServerObject(serverContext, session, metadataServer, true);
        Schema schemaObject = (Schema)((Object)OMAResourceFactory.getReposObject((CMetadata)schema, session, metadataServer));
        AccessPathToRelationalData accessPath = new AccessPathToRelationalData(serverObject, schemaObject);
        return accessPath;
    }

    private Table newTable(DataTable dataTable, SessionContextInterface session, MetadataServerInterface metadataServer, final String overrideDataSetOptions) throws MetadataException {
        boolean isOverridden;
        Table tableObject;
        Table useTable = tableObject = (Table)((Object)OMAResourceFactory.getReposObject((CMetadata)dataTable, session, metadataServer));
        boolean bl = isOverridden = overrideDataSetOptions != null && !overrideDataSetOptions.trim().isEmpty();
        if (isOverridden) {
            useTable = new Table(){
                Table _table;
                {
                    this._table = tableObject;
                }

                public String toString() {
                    return this._table.toString();
                }

                @Override
                public String getDataSetOptionsAsString() throws MetadataException {
                    return overrideDataSetOptions;
                }

                @Override
                public List<AccessPath> getAccessPaths() throws MetadataException {
                    return this._table.getAccessPaths();
                }

                @Override
                public String getLabel() {
                    return this._table.getLabel();
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this._table.propertyChange(evt);
                }

                @Override
                public boolean isUsableInQuery() {
                    return this._table.isUsableInQuery();
                }

                @Override
                public String getDescription() {
                    return this._table.getDescription();
                }

                @Override
                public com.sas.iquery.metadata.physical.RelationalSchema getRelationalSchema() throws MetadataException {
                    return this._table.getRelationalSchema();
                }

                @Override
                public void addListener(PropertyChangeListener listener) {
                    this._table.addListener(listener);
                }

                @Override
                public boolean isUnresolved() {
                    return this._table.isUnresolved();
                }

                @Override
                public List<Reason> getReasonsUnusable() {
                    return this._table.getReasonsUnusable();
                }

                @Override
                public void removeListener(PropertyChangeListener listener) {
                    this._table.removeListener(listener);
                }

                @Override
                public String getIdentityString() {
                    return this._table.getIdentityString();
                }

                @Override
                public List<Column> getColumns() throws MetadataException {
                    return this._table.getColumns();
                }

                @Override
                public List<PropertyChangeListener> getListeners() {
                    return this._table.getListeners();
                }

                @Override
                public String getSasName() throws MetadataException {
                    return this._table.getSasName();
                }

                @Override
                public String getDbmsName() throws MetadataException {
                    return this._table.getDbmsName();
                }

                @Override
                public List<Key> getKeys() throws MetadataException {
                    return this._table.getKeys();
                }

                @Override
                public <T extends Key> List<T> getKeys(Class<T> type) throws MetadataException {
                    return this._table.getKeys(type);
                }
            };
        }
        return useTable;
    }

    public boolean usePreSummarized() throws MetadataException {
        boolean usePreSummarized;
        ExportCubeProcessor cubeProcessor = this.getExportCubeProcessor();
        try {
            boolean incrementalUpdate;
            ExportCubeProcessor.OLAPDataType olapDataType = cubeProcessor.getOlapDataType();
            usePreSummarized = olapDataType == ExportCubeProcessor.OLAPDataType.NWAY ? true : (incrementalUpdate = cubeProcessor.getIsIncrementalUpdated());
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
        return usePreSummarized;
    }

    private MessageFormatter getMsgCannotBuildDataSelectionForExport(DataSourceCube dataSourceCube) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.CannotBuildDataSelectionForExport.fmt.txt", dataSourceCube);
    }

    private MessageFormatter getMsgSchemaNotAssociatedWithServer(SASLibrary defaultDetailSchema) throws RemoteException {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.SchemaNotAssociatedWithServer.fmt.txt", defaultDetailSchema);
    }

    private MessageFormatter getMsgCouldNotFindFactTableKeyColumn(com.sas.metadata.remote.Cube omrCube, Dimension dimension) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.CouldNotFindFactTableKeyColumn.fmt.txt", dimension, omrCube);
    }

    private MessageFormatter getMsgCouldNotFindDimTableKeyColumn(com.sas.metadata.remote.Cube omrCube, Dimension dimension) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.CouldNotFindDimTableKeyColumn.fmt.txt", dimension, omrCube);
    }

    private MessageFormatter getMsgCouldNotRetrieveTheColumnName(com.sas.metadata.remote.Column dimKeyColumn) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.CouldNotRetrieveTheColumnName.fmt.txt", dimKeyColumn);
    }

    public static List<DataItem> newDataItems(BusinessModel businessModel, DataSource dataSource) throws MetadataException {
        Properties dataItemProperties = new Properties();
        dataItemProperties.setProperty("USE_LABELS", "1");
        dataItemProperties.setProperty("INIT_CAP", "0");
        return businessModel.newDataItems(dataSource, dataItemProperties);
    }

    public static RootDataItem newDataItem(BusinessModel businessModel, PhysicalResource resource) throws MetadataException {
        Properties dataItemProperties = new Properties();
        dataItemProperties.setProperty("USE_LABELS", "1");
        dataItemProperties.setProperty("INIT_CAP", "0");
        return businessModel.newDataItem(resource, dataItemProperties);
    }
}

