/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExportColumnGroup;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.ExportColumnGroupImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.physical.OlapItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExportColumnGroupFactory
extends ExportObjectFactoryAbstract<Object, ExportColumnGroup> {
    private static final ExportColumnGroupFactory SINGLETON_FACTORY = new ExportColumnGroupFactory();

    private ExportColumnGroupFactory() {
    }

    public static ExportColumnGroupFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    @Override
    public String makeUniqueExportName(Object objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueName = null;
        if (objectToExport instanceof Object[]) {
            Object[] def = (Object[])objectToExport;
            Object underlyingObject = def[0];
            List items = (List)def[1];
            StringBuffer buffer = new StringBuffer("Group.");
            buffer.append(this.makeUniqueExportName(underlyingObject, exportMetadata, qualifiers));
            for (Object object : items) {
                buffer.append(",");
                buffer.append(this.makeUniqueExportName(object, exportMetadata, qualifiers));
            }
            uniqueName = buffer.toString();
        } else {
            uniqueName = "Group." + String.valueOf(objectToExport);
        }
        return uniqueName;
    }

    @Override
    public ExportColumnGroup createObject(String useUniqueExportName, Object objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        ExportColumnGroupImpl out = null;
        if (objectToExport instanceof Object[] && ((Object[])objectToExport).length == 2) {
            Object[] def = (Object[])objectToExport;
            Object underlyingObject = def[0];
            List items = (List)def[1];
            String uniqueExportName = underlyingObject.toString();
            out = new ExportColumnGroupImpl(underlyingObject, uniqueExportName, this, exportMetadata, items);
        }
        return out;
    }

    @Override
    public List<ExportColumnGroup> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        return new ArrayList<ExportColumnGroup>();
    }

    @Override
    public List<Object> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        DataSelection dataSelection = exportMetadata.getDataSelection();
        ArrayList<Object> objectsToExport = new ArrayList<Object>();
        List<DataItem> allItems = dataSelection.getEffectiveResultItems();
        Map<Role, List<DataItem>> itemsOnRoles = this.addRoleColumnGroupsDefs(objectsToExport, dataSelection, allItems);
        this.addUsageColumnGroupsDefs(objectsToExport, itemsOnRoles);
        if (dataSelection.getStructure().isOLAP()) {
            this.addOlapSpecificGroups(objectsToExport, allItems);
        } else if (itemsOnRoles.get(Role.ROW) == null || itemsOnRoles.get(Role.ROW).size() > 0) {
            // empty if block
        }
        return objectsToExport;
    }

    private void addOlapSpecificGroups(List<Object> objectsToExport, List<DataItem> allItems) {
        for (DataItem dataItem : allItems) {
            ExpressionInterface expr;
            StructureOfDataItem structure = dataItem.getStructure();
            if (!structure.equals(StructureOfDataItem.STRUCTURE_HIERARCHY) && !structure.equals(StructureOfDataItem.STRUCTURE_DIMENSION) && !structure.equals(StructureOfDataItem.STRUCTURE_LEVEL) && !structure.equals(StructureOfDataItem.STRUCTURE_NAMED_SET) && !structure.equals(StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER) || !((expr = dataItem.getExpression()) instanceof OlapItem)) continue;
            objectsToExport.add(new Object[]{expr, Collections.singletonList(dataItem)});
        }
    }

    private void addUsageColumnGroupsDefs(List<Object> objectsToExport, Map<Role, List<DataItem>> itemsOnRoles) {
        ArrayList<DataItem> categories = new ArrayList<DataItem>();
        ArrayList<DataItem> details = new ArrayList<DataItem>();
        ArrayList<DataItem> measures = new ArrayList<DataItem>();
        for (Map.Entry<Role, List<DataItem>> itemsOnRolesEntry : itemsOnRoles.entrySet()) {
            List<DataItem> itemsOnRole = itemsOnRolesEntry.getValue();
            for (DataItem dataItem : itemsOnRole) {
                DataItemActionType usage = dataItem.getUsage();
                if (usage.equals(DataItemActionType.USAGE_CATEGORY)) {
                    categories.add(dataItem);
                    continue;
                }
                if (usage.equals(DataItemActionType.USAGE_AGGREGATE)) {
                    measures.add(dataItem);
                    continue;
                }
                details.add(dataItem);
            }
        }
        if (!categories.isEmpty()) {
            objectsToExport.add(new Object[]{DataItemActionType.USAGE_CATEGORY, categories});
        }
        if (!measures.isEmpty()) {
            objectsToExport.add(new Object[]{DataItemActionType.USAGE_AGGREGATE, measures});
        }
        if (!details.isEmpty()) {
            objectsToExport.add(new Object[]{DataItemActionType.USAGE_DETAIL, details});
        }
    }

    private Map<Role, List<DataItem>> addRoleColumnGroupsDefs(List<Object> objectsToExport, DataSelection dataSelection, List<DataItem> allItems) throws MetadataException {
        List itemsOnRole;
        Role role;
        LinkedHashMap<Role, List<DataItem>> itemsOnRoles = new LinkedHashMap<Role, List<DataItem>>();
        itemsOnRoles.put(Role.COLUMN, new ArrayList());
        itemsOnRoles.put(Role.ROW, new ArrayList());
        for (DataItem dataItem : allItems) {
            role = dataSelection.getResultItemRole(dataItem);
            itemsOnRole = (ArrayList<DataItem>)itemsOnRoles.get(role);
            if (itemsOnRole == null) {
                itemsOnRole = new ArrayList<DataItem>();
                itemsOnRoles.put(role, itemsOnRole);
            }
            itemsOnRole.add(dataItem);
        }
        for (Map.Entry entry : itemsOnRoles.entrySet()) {
            role = (Role)entry.getKey();
            itemsOnRole = (List)entry.getValue();
            if (itemsOnRole == null || itemsOnRole.size() <= 0) continue;
            objectsToExport.add(new Object[]{role, itemsOnRole});
        }
        return itemsOnRoles;
    }

    public static enum DiscoverColumnGroups implements ExportDiscoveryType
    {
        AllColumnGroups;

    }
}

