/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExportColumn;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.ExportColumnImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ExportColumnFactory
extends ExportObjectFactoryAbstract<DataItem, ExportColumn> {
    private static final ExportColumnFactory SINGLETON_FACTORY = new ExportColumnFactory();

    private ExportColumnFactory() {
    }

    public static ExportColumnFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    private ExportColumn createExportObject(DataItem objectToExport, String uniqueExportName, ExportGeneralMetadata exportMetadata, Role role, Object ... options) throws MetadataException {
        return new ExportColumnImpl(objectToExport, uniqueExportName, this, exportMetadata, role);
    }

    @Override
    public String makeUniqueExportName(DataItem objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String objectToExportUniqueID = objectToExport.getID();
        return ExportColumnFactory.qualifyName(new StringBuffer(objectToExportUniqueID), qualifiers).toString();
    }

    @Override
    public ExportColumn createObject(String useUniqueExportName, DataItem objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueExportName = useUniqueExportName != null && useUniqueExportName.length() > 0 ? useUniqueExportName : this.makeUniqueExportName(objectToExport, exportMetadata, qualifiers);
        DataSelection dataSelection = exportMetadata.getDataSelection();
        Role resultItemRole = dataSelection.getResultItemRole(objectToExport);
        ExportColumn exportColumn = this.createExportObject(objectToExport, uniqueExportName, exportMetadata, resultItemRole, new Object[0]);
        return exportColumn;
    }

    @Override
    public List<ExportColumn> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List objectsToExport = this.find((List)list, DataItem.class, exportMetadata, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<ExportColumn> discover(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List<DataItem> objectsToExport = this.discoverUnderlyingObjects(discoveryType, exportMetadata, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<DataItem> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List<DataItem> objectsToExport;
        DataSelection dataSelection = exportMetadata.getDataSelection();
        if (discoveryType == DiscoverResultItems.AllResultItemsUsed) {
            objectsToExport = dataSelection.getEffectiveResultItems();
        } else if (discoveryType == DiscoverResultItems.SelectedResultItems) {
            objectsToExport = dataSelection.getResultItems();
        } else if (discoveryType == DiscoverResultItems.AvailableResultItemsIncludeHidden || discoveryType == DiscoverResultItems.AvailableResultItemsIncludeHiddenFromAllModels) {
            boolean allModels = discoveryType == DiscoverResultItems.AvailableResultItemsIncludeHiddenFromAllModels;
            objectsToExport = dataSelection.getObjects(allModels, DataItem.class);
        } else if (discoveryType == DiscoverResultItems.AvailableResultItems || discoveryType == DiscoverResultItems.AvailableResultItemsFromAllModels) {
            boolean allModels = discoveryType == DiscoverResultItems.AvailableResultItemsFromAllModels;
            objectsToExport = new ArrayList<DataItem>(dataSelection.getObjects(allModels, DataItem.class));
            Iterator<DataItem> iter = objectsToExport.iterator();
            while (iter.hasNext()) {
                DataItem item = iter.next();
                if (!item.isHidden()) continue;
                iter.remove();
            }
        } else {
            throw new MetadataException(this.getInvalidDiscoveryTypeMessage(discoveryType));
        }
        return objectsToExport;
    }

    public static enum DiscoverResultItems implements ExportDiscoveryType
    {
        AllResultItemsUsed,
        SelectedResultItems,
        AvailableResultItems,
        AvailableResultItemsIncludeHidden,
        AvailableResultItemsFromAllModels,
        AvailableResultItemsIncludeHiddenFromAllModels;

    }
}

