/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportProperties;
import com.sas.iquery.metadata.business.ExportSelectionMetadata;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.ExportUploadMetadata;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.ExportCubeDataDsBuilder;
import com.sas.iquery.metadata.business.impl.ExportMetadataFactory;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryFactory;
import com.sas.iquery.metadata.physical.inmemory.InMemoryQueryTable;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.physical.oma.OMASASLibrary;
import com.sas.iquery.strategies.sas.oma.AbstractStrategy;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.SASFormat;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExportAbstract
implements Export {
    private static final Logger _logger = LogManager.getLogger((String)"ExportAbstract.class");
    private final BusinessModel _origBusinessModel;
    private final ExportType _usage;
    private final LinkedHashSet<ExportProperties> _exportProperties = new LinkedHashSet();
    private int _columnLimit = 1000;
    private int _tableLimit = 10;
    private SASLibrary _SASLibrary = null;
    private String _libref = null;
    private String _path = null;
    private String _engine = null;
    private String _options = null;
    private String _tableName = null;
    private String _lasrData = null;
    private DataSourceTable _lasrDataSourceTable = null;
    private String _lasrCreateFile = null;
    private boolean _lasrCreate = false;
    private boolean _lasrAdd = false;
    private String _lasrPath = null;
    private int _lasrPort = 0;
    private String _lasrSigner = null;
    private String _lasrHost = null;
    private String _lasrInstall = null;
    private int _lasrNodes = 0;
    private int _lasrNthreads = 0;
    private String _outfile = null;
    private String _resultSetTableName = "";
    private String _JSONout = null;
    private String[] _JSONExportOptions = new String[]{"", ""};
    private StringBuffer _JSONOptions = null;
    private boolean _JSONMultipleOptions = false;
    private String _metaUser = null;
    private String _metaPswd = null;
    private String _metaServer = null;
    private String _metaRepname = null;
    private String _metaPort = null;
    private String _metaLibref = null;
    private SASWorkspaceServer _server = null;
    private DataSelection _exportDataSelection = null;
    private ExportSelectionMetadata _exportMetadata = null;
    private DataSelection _uploadDataSelection = null;
    private Boolean _preSummarized = false;
    private ExportUploadMetadata _uploadMetadata = null;
    private String _lasrFormatLibref = null;
    private String _lasrFormatLibnameStmt = null;
    private String _udfTableName = null;
    private String _udfTableLibref = null;
    private boolean _onlyReferencedUdfs = true;
    private boolean _ignoreReachThruTable = false;
    private boolean _includeAllColumns = false;

    protected abstract void buildUploadDataSelection() throws MetadataException;

    protected abstract void buildExportMetadata() throws MetadataException;

    protected abstract DataSelection newExportDataSelection(BusinessModel var1) throws MetadataException;

    ExportAbstract(BusinessModel businessModel, ExportType usage, ExportProperties ... properties) throws MetadataException {
        this._origBusinessModel = businessModel;
        this._usage = usage;
        if (usage == ExportType.JSON) {
            this._JSONOptions = new StringBuffer();
        }
        this._exportProperties.addAll(Arrays.asList(properties));
        if (!(this._exportProperties.contains((Object)ExportProperties.AGGREGATE) || this._exportProperties.contains((Object)ExportProperties.ALL_DETAIL) || this._exportProperties.contains((Object)ExportProperties.DETAIL_WITH_FILTERS))) {
            if (usage == ExportType.CSV || usage == ExportType.JSON) {
                this._exportProperties.add(ExportProperties.AGGREGATE);
            } else {
                this._exportProperties.add(ExportProperties.ALL_DETAIL);
            }
        }
        if (!(this._exportProperties.contains((Object)ExportProperties.VIEW_ONLY) || this._exportProperties.contains((Object)ExportProperties.TABLE_ONLY) || this._exportProperties.contains((Object)ExportProperties.FULL_EXPORT))) {
            this._exportProperties.add(ExportProperties.FULL_EXPORT);
        }
    }

    protected void buildExportDataSelection() throws MetadataException {
        boolean addAllItems;
        DataSelection exportDS;
        BusinessModel origBusinessModel = this.getOrigBusinessModel();
        HashSet<String> dimsAddedAlready = new HashSet<String>();
        List<DataItem> dataItems = this.findExistingDataItemsToAdd(origBusinessModel);
        boolean noDataItems = dataItems.isEmpty();
        if (noDataItems) {
            DataSelection defaultItemsModel = DataSelectionFactory.newDataSelection(origBusinessModel);
            defaultItemsModel.setLabel("Default items");
            defaultItemsModel.setID("DefaultItems");
            this.createDefaultDataItemsToAdd((BusinessModel)defaultItemsModel, dataItems);
            exportDS = this.newExportDataSelection(defaultItemsModel);
            addAllItems = true;
        } else {
            exportDS = this.newExportDataSelection(origBusinessModel);
            if (origBusinessModel instanceof DataSelection) {
                DataSelection parentDs = (DataSelection)origBusinessModel;
                List<SelectedItem> selectedItems = parentDs.getSelectedItems();
                addAllItems = selectedItems.isEmpty();
                for (SelectedItem selectedItem : selectedItems) {
                    DataItem item = selectedItem.getItem();
                    DataItemReference itemRef = this.newRef(exportDS, item);
                    this.addRefToSelectedItems(exportDS, itemRef, selectedItem.getRole(), dimsAddedAlready);
                }
            } else {
                addAllItems = true;
            }
        }
        if (addAllItems) {
            this.addDataItems(exportDS, dimsAddedAlready, dataItems);
        }
        this.setExportDataSelection(exportDS);
    }

    protected void addDataItems(DataSelection exportDS, Set<String> dimsAddedAlready, List<DataItem> dataItems) throws MetadataException {
        for (DataItem item : dataItems) {
            DataItemReference itemRef = this.newRef(exportDS, item);
            this.addRefToSelectedItems(exportDS, itemRef, Role.COLUMN, dimsAddedAlready);
        }
    }

    protected DataItemReference newRef(DataSelection selection, DataItem item) throws MetadataException {
        DataItemReference itemRef = selection.newDataItemReference(item);
        itemRef.setResultSetID(item.getResultSetID());
        selection.addBusinessItem(itemRef);
        itemRef.setUsage(item.getUsage());
        if (itemRef.isActionSupported(DataItemActionType.OTHER_FORMAT)) {
            itemRef.setFormat(item.getFormat());
        }
        return itemRef;
    }

    protected List<DataItem> findExistingDataItemsToAdd(BusinessModel origBusinessModel) {
        List<DataItem> dataItems = origBusinessModel.getObjects(false, DataItem.class);
        if (dataItems.isEmpty()) {
            for (BusinessModel search = origBusinessModel.getParentBusinessModel(); search != null && (dataItems = search.getObjects(false, DataItem.class)).isEmpty(); search = search.getParentBusinessModel()) {
            }
        }
        return dataItems;
    }

    protected void createDefaultDataItemsToAdd(BusinessModel model, List<DataItem> dataItems) throws MetadataException {
        List<DataSource> dataSources = model.getObjects(true, DataSource.class);
        for (DataSource dataSource : dataSources) {
            List<DataItem> newItems = this.createDefaultDataItemsToAdd(model, dataSource);
            if (newItems == null || newItems.size() <= 0) continue;
            dataItems.addAll(newItems);
        }
    }

    protected List<DataItem> createDefaultDataItemsToAdd(BusinessModel model, DataSource dataSource) throws MetadataException {
        List<DataItem> dataItems = ExportCubeDataDsBuilder.newDataItems(model, dataSource);
        for (DataItem dataItem : dataItems) {
            String rsid = GenerationUtil.generateResourceBasedRSID(model, dataItem);
            dataItem.setResultSetID(rsid);
            if (dataItem.getValidActions().contains(DataItemActionType.USAGE_DETAIL)) {
                if (!dataItem.isActionSupported(DataItemActionType.USAGE_DETAIL)) {
                    dataItem.setActionSupported(DataItemActionType.USAGE_DETAIL, true);
                }
                dataItem.setUsage(DataItemActionType.USAGE_DETAIL);
            }
            model.addBusinessItem(dataItem);
        }
        return dataItems;
    }

    protected void addRefToSelectedItems(DataSelection dataSelection, DataItem itemRef, Role role, Set<String> alreadyAdded) throws MetadataException {
        dataSelection.addResultItem(itemRef, role);
    }

    protected void buildUploadMetadata() throws MetadataException {
        ExportSelectionMetadata exportMD = this.getExportMetadata();
        DataSelection uploadDS = this.getUploadDataSelection();
        boolean uploadDataPresummarized = this.isPreSummarized();
        ExportUploadMetadata uploadMD = ExportMetadataFactory.newExportMetadataUploaded(uploadDS, uploadDataPresummarized, exportMD);
        this.setUploadMetadata(uploadMD);
    }

    public BusinessModel getOrigBusinessModel() {
        return this._origBusinessModel;
    }

    public DataSelection getExportDataSelection() throws MetadataException {
        if (this._exportDataSelection == null) {
            this.buildExportDataSelection();
        }
        return this._exportDataSelection;
    }

    protected void setExportDataSelection(DataSelection exportDataSelection) throws MetadataException {
        this._exportDataSelection = exportDataSelection;
    }

    public DataSelection getUploadDataSelection() throws MetadataException {
        if (this._uploadDataSelection == null) {
            this.buildUploadDataSelection();
        }
        return this._uploadDataSelection;
    }

    protected void setUploadDataSelection(DataSelection uploadDataSelection) throws MetadataException {
        this._uploadDataSelection = uploadDataSelection;
    }

    public boolean isPreSummarized() throws MetadataException {
        if (this._preSummarized == null) {
            this.buildUploadDataSelection();
        }
        return this._preSummarized == null ? false : this._preSummarized;
    }

    protected void setPreSummarized(boolean preSummarized) throws MetadataException {
        this._preSummarized = preSummarized;
    }

    @Override
    public ExportSelectionMetadata getExportMetadata() throws MetadataException {
        if (this._exportMetadata == null) {
            this.buildExportMetadata();
        }
        return this._exportMetadata;
    }

    protected void setExportMetadata(ExportSelectionMetadata exportMetadata) throws MetadataException {
        this._exportMetadata = exportMetadata;
    }

    @Override
    public ExportUploadMetadata getUploadMetadata() throws MetadataException {
        if (this._uploadMetadata == null) {
            this.buildUploadMetadata();
        }
        return this._uploadMetadata;
    }

    protected void setUploadMetadata(ExportUploadMetadata uploadMetadata) throws MetadataException {
        this._uploadMetadata = uploadMetadata;
    }

    @Override
    public Export SASLibrary(SASLibrary library) {
        this._SASLibrary = library;
        return this;
    }

    @Override
    public Export libref(String libref) {
        this._libref = libref;
        return this;
    }

    @Override
    public Export path(String path) {
        this._path = path;
        return this;
    }

    @Override
    public Export engine(String engine) {
        this._engine = engine;
        return this;
    }

    @Override
    public Export options(String options) {
        this._options = options;
        return this;
    }

    @Override
    public Export tableName(String tableName) {
        this._tableName = tableName;
        return this;
    }

    @Override
    public Export outfile(String outfile) {
        this._outfile = outfile;
        return this;
    }

    @Override
    public Export JSONout(String JSONout) {
        this._JSONout = JSONout;
        return this;
    }

    @Override
    public Export JSONExportOptions(String JSONExportOptions, String JSONExportTablename) {
        this._JSONExportOptions[0] = JSONExportOptions;
        this._JSONExportOptions[1] = JSONExportTablename;
        return this;
    }

    @Override
    public Export JSONOptions(String JSONOptions) {
        if (this._JSONMultipleOptions) {
            this._JSONOptions.append("\n");
        }
        this._JSONOptions.append(JSONOptions).append(";");
        this._JSONMultipleOptions = true;
        return this;
    }

    @Override
    public Export lasrData(String data) throws GenerationException, DataRetrievalException {
        if (this._usage != ExportType.LASR_RESULT_SET) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
        }
        this._lasrData = data;
        return this;
    }

    @Override
    public Export lasrData(Table table) throws GenerationException, DataRetrievalException {
        if (this._usage != ExportType.LASR_OMA_TABLE) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
        }
        try {
            this.createLasrDataSourceTable(table);
        }
        catch (Exception e) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
        }
        return this;
    }

    @Override
    public Export lasrCreate(String createFile) {
        this._lasrCreateFile = createFile;
        this._lasrCreate = true;
        return this;
    }

    @Override
    public Export lasrCreate() {
        this._lasrCreate = true;
        return this;
    }

    @Override
    public Export lasrAdd() {
        this._lasrAdd = true;
        return this;
    }

    @Override
    public Export lasrPath(String path) {
        this._lasrPath = path;
        return this;
    }

    @Override
    public Export lasrHost(String host) {
        this._lasrHost = host;
        return this;
    }

    @Override
    public Export lasrPort(int port) {
        this._lasrPort = port;
        return this;
    }

    @Override
    public Export lasrSigner(String signer) {
        this._lasrSigner = signer;
        return this;
    }

    @Override
    public Export lasrInstall(String install) {
        this._lasrInstall = install;
        return this;
    }

    @Override
    public Export lasrNodes(int nodes) {
        this._lasrNodes = nodes;
        return this;
    }

    @Override
    public Export lasrNthreads(int nthreads) {
        this._lasrNthreads = nthreads;
        return this;
    }

    @Override
    public Export metaUser(String metaUser) {
        this._metaUser = metaUser;
        return this;
    }

    @Override
    public Export metaPswd(String metaPswd) {
        this._metaPswd = metaPswd;
        return this;
    }

    @Override
    public Export metaServer(String metaServer) {
        this._metaServer = metaServer;
        return this;
    }

    @Override
    public Export metaRepname(String metaRepname) {
        this._metaRepname = metaRepname;
        return this;
    }

    @Override
    public Export metaPort(String metaPort) {
        this._metaPort = metaPort;
        return this;
    }

    @Override
    public Export metaLibref(String metaLibref) {
        this._metaLibref = metaLibref;
        return this;
    }

    @Override
    public Export server(SASWorkspaceServer server) {
        this._server = server;
        return this;
    }

    @Override
    public ExportProperties[] getExportProperties() {
        return this._exportProperties.toArray(new ExportProperties[this._exportProperties.size()]);
    }

    protected Set<ExportProperties> _getExportProperties() {
        return this._exportProperties;
    }

    @Override
    public boolean isAllDetail() {
        return this._exportProperties.contains((Object)ExportProperties.ALL_DETAIL);
    }

    @Override
    public boolean isDetailWithFilters() {
        return this._exportProperties.contains((Object)ExportProperties.DETAIL_WITH_FILTERS);
    }

    @Override
    public boolean isViewOnly() {
        return this._exportProperties.contains((Object)ExportProperties.VIEW_ONLY);
    }

    @Override
    public boolean isTableOnly() {
        return this._exportProperties.contains((Object)ExportProperties.TABLE_ONLY);
    }

    @Override
    public boolean isCreateTableRequiredForExport() {
        return this.getUsage() == ExportType.EXPORT_AND_LASR_SAS_LIBNAME || this.getUsage() == ExportType.EXPORT_AND_LASR_SAS_OMALIB || this.getUsage() == ExportType.EXPORT_TO_SAS_LIBNAME || this.getUsage() == ExportType.EXPORT_TO_SAS_OMA_LIBRARY;
    }

    @Override
    public boolean isMetalibInEffect() {
        return this._metaUser != null;
    }

    @Override
    public String getResultSetTableName() {
        return this._resultSetTableName;
    }

    @Override
    public void setResultSetTableName(String resultSetTableName) {
        this._resultSetTableName = resultSetTableName;
    }

    private void createLasrDataSourceTable(Table table) throws Exception {
        SASWorkspaceServer server = null;
        DataSourceTable dataSourceTable = null;
        SASLibrary lib = null;
        String tablename = null;
        String libname = null;
        if (((ResourceRelationshipInterface)((Object)table)).getParentResource() instanceof SASLibrary) {
            lib = (SASLibrary)((ResourceRelationshipInterface)((Object)table)).getParentResource();
            if (!(lib instanceof OMASASLibrary)) {
                throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
            }
            List<SoftwareServer> servers = lib.getSoftwareServers();
            for (SoftwareServer sws : servers) {
                LogicalServerInterface logicalServer = sws.getLogicalServerInterface();
                if (logicalServer == null || !logicalServer.getClassIdentifier().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") && !logicalServer.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) continue;
                server = (SASWorkspaceServer)sws;
                break;
            }
        }
        DataSelection uploadDS = this.getUploadDataSelection();
        AccessPathToRelationalData ap = new AccessPathToRelationalData(server, lib);
        dataSourceTable = uploadDS.newDataSourceTable(ap, table);
        uploadDS.addDataSource(dataSourceTable);
        this._lasrDataSourceTable = dataSourceTable;
        try {
            libname = lib.getLibref();
        }
        catch (MetadataException e) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
        }
        try {
            tablename = table.getSasName();
        }
        catch (MetadataException e) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
        }
        this._lasrData = libname + "." + tablename;
    }

    @Override
    public CreateTableDataSelection createTableDataSelection(DataSelection selection, AbstractStrategy strategy) throws MetadataException {
        CreateTableDataSelection createTableDataSelection = DataSelectionFactory.getInstance().newCreateTableDataSelection(selection);
        strategy.addAuxDataSelection(createTableDataSelection);
        if (this._SASLibrary == null) {
            SASWorkspaceServer server;
            IntelligentQueryMetadataServiceInterface service = selection.getMetadataService();
            SessionContextInterface session = selection.getSession();
            if (this._server == null) {
                server = this._server;
            } else {
                List<DataSource> dsList = selection.getObjects(true, DataSource.class);
                assert (!dsList.isEmpty());
                DataSource dataSource = dsList.get(0);
                Server dataSourceServer = dataSource.getServer();
                assert (dataSourceServer instanceof SASWorkspaceServer);
                server = (SASWorkspaceServer)dataSourceServer;
            }
            InMemorySASLibrary inMemorySASLibrary = InMemoryFactory.getInstance().newUserDefinedSASLibrary(this._libref, this._path, this._engine, this._options, session, service, server);
            this._SASLibrary = inMemorySASLibrary;
        } else {
            this._libref = this._SASLibrary.getLibref();
        }
        createTableDataSelection.setSchemaForCreation(this._SASLibrary);
        createTableDataSelection.setName(this._tableName);
        return createTableDataSelection;
    }

    @Override
    public StringBuffer generateExportStatementForCSV(String inputTable) throws DataRetrievalException {
        if (this._outfile == null) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
        }
        StringBuffer exportToCSVStatement = new StringBuffer();
        exportToCSVStatement.append("proc export data=").append(" ").append(inputTable).append("\n").append("outfile=").append("'").append(this._outfile).append("'").append("\n").append("dbms=csv replace");
        exportToCSVStatement.append(";run;");
        return exportToCSVStatement;
    }

    @Override
    public StringBuffer generateJSONStatement(String inputTable) throws DataRetrievalException {
        if (this._JSONout == null) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
        }
        StringBuffer JSONStatement = new StringBuffer();
        JSONStatement.append("proc JSON out=").append("'").append(this._JSONout).append("'").append(";").append("\n");
        JSONStatement.append(this._JSONOptions).append("\n");
        JSONStatement.append("export ").append(inputTable);
        if (this._JSONExportOptions != null && this._JSONExportOptions.length != 0) {
            if (this._JSONExportOptions.length > 0 && !this._JSONExportOptions[0].isEmpty()) {
                JSONStatement.append("(");
                JSONStatement.append(this._JSONExportOptions[0]);
                JSONStatement.append(")");
            }
            if (this._JSONExportOptions.length > 1 && !this._JSONExportOptions[1].isEmpty()) {
                JSONStatement.append(" ").append("/");
                JSONStatement.append("tablename='").append(this._JSONExportOptions[1]).append("'");
            }
        }
        JSONStatement.append(";").append("\n");
        JSONStatement.append("run;");
        return JSONStatement;
    }

    @Override
    public StringBuffer generateLasrStatement() throws DataRetrievalException {
        if (this._lasrData == null) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionInvalidParms.Message.txt", new Object[0]));
        }
        return this.generateLasrStatement(this._lasrData);
    }

    @Override
    public StringBuffer generateLasrStatement(String inputTable) throws DataRetrievalException {
        StringBuffer lasrStatement = new StringBuffer();
        String procfmtCode = this.generateUdfStatement();
        if (procfmtCode.length() > 0) {
            lasrStatement.append(procfmtCode);
        }
        if (!this.isViewOnly() && !this.isTableOnly() && this._lasrHost != null) {
            String addOrCreate = " add ";
            if (this._lasrCreate || this._lasrCreateFile != null) {
                addOrCreate = this._lasrCreateFile == null ? " create " : " create='" + this._lasrCreateFile + "'";
            }
            String lasrFormatLibref = this.getLasrFormatLibref();
            this.buildLasrStatement(lasrStatement, addOrCreate, inputTable, procfmtCode, lasrFormatLibref);
        }
        return lasrStatement;
    }

    protected StringBuffer buildLasrStatement(StringBuffer lasrStatement, String addOrCreate, String inputTable, String procfmtCode, String lasrFormatLibref) {
        lasrStatement.append("proc lasr ").append("data=").append(inputTable).append(addOrCreate).append("\n");
        if (this._lasrPort != 0) {
            if (this._lasrSigner == null) {
                lasrStatement.append(" port=").append(this._lasrPort).append("\n");
            } else {
                lasrStatement.append(" port=").append(this._lasrPort).append("\n");
                lasrStatement.append(" signer='").append(this._lasrSigner).append("'\n");
            }
        }
        if (this._lasrPath != null) {
            lasrStatement.append(" path=").append("'").append(this._lasrPath).append("'");
        }
        if (procfmtCode.length() > 0) {
            lasrStatement.append("\n fmtlibxml=").append(lasrFormatLibref);
        }
        lasrStatement.append(";\n");
        lasrStatement.append(" performance").append(" host='").append(this._lasrHost).append("'\n");
        if (this._lasrInstall != null) {
            lasrStatement.append(" install=").append("'").append(this._lasrInstall).append("'\n");
        }
        if (this._lasrNodes > 0) {
            lasrStatement.append(" nodes=").append(this._lasrNodes).append("\n");
        }
        if (this._lasrNthreads > 0) {
            lasrStatement.append(" nthreads=").append(this._lasrNthreads).append("\n");
        }
        lasrStatement.append(";\nrun;");
        return lasrStatement;
    }

    @Override
    public boolean isTooManyTablesOrColumns() throws MetadataException {
        DataSelection exportDS = this.getExportDataSelection();
        return this.isTooManyTablesOrColumns(exportDS);
    }

    public boolean isTooManyTablesOrColumns(DataSelection dataSelection) throws MetadataException {
        int QCCount = 0;
        HashSet<QualifiedColumn> QCColumns = new HashSet<QualifiedColumn>();
        for (SelectedItem selectedItem : dataSelection.getSelectedItems()) {
            DataItem dataItem = selectedItem.getItem();
            List<QualifiedColumn> QCList = dataItem.getResources(QualifiedColumn.class, 65535);
            if (QCList.isEmpty()) {
                ++QCCount;
                continue;
            }
            QCColumns.addAll(QCList);
        }
        QCCount += QCColumns.size();
        int tableCount = 0;
        try {
            List<DataSource> effectiveDataSources = dataSelection.getEffectiveDataSources();
            tableCount = effectiveDataSources.size();
        }
        catch (MetadataException e) {
            tableCount = 0;
        }
        return QCCount > this.getColumnLimit() || tableCount > this.getTableLimit();
    }

    @Override
    public int getColumnLimit() {
        return this._columnLimit;
    }

    @Override
    public void setColumnLimit(int columnLimit) {
        this._columnLimit = columnLimit;
    }

    @Override
    public int getTableLimit() {
        return this._tableLimit;
    }

    @Override
    public void setTableLimit(int tableLimit) {
        this._tableLimit = tableLimit;
    }

    @Override
    public StringBuffer generateProcMetalib(String inputTable) throws DataRetrievalException {
        if (this._metaUser == null || this._metaPswd == null || this._metaServer == null || this._metaRepname == null || this._metaPort == null || this._metaLibref == null) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionWrongMetalibUsage.Message.txt", new Object[0]));
        }
        StringBuffer metalibStatement = new StringBuffer();
        metalibStatement.append("\n");
        metalibStatement.append("proc metalib; OMR=(LIBRARY='").append(this._metaLibref).append("'").append("\n");
        metalibStatement.append(" USER='").append(this._metaUser).append("'").append("\n");
        metalibStatement.append(" PASSWORD='").append(this._metaPswd).append("'").append("\n");
        metalibStatement.append(" SERVER='").append(this._metaServer).append("'").append("\n");
        metalibStatement.append(" REPNAME='").append(this._metaRepname).append("'").append("\n");
        metalibStatement.append(" PORT='").append(this._metaPort).append("'").append(");").append("\n");
        metalibStatement.append(" select(").append(inputTable).append(");").append("\n");
        metalibStatement.append("run;");
        return metalibStatement;
    }

    @Override
    public String generate(String tableName) throws ExecutionException, IntelligentQueryException, MetadataException {
        this.setResultSetTableName(tableName);
        return this.generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generate() throws ExecutionException, IntelligentQueryException, MetadataException {
        if (this.isMetalibInEffect() && (this.getUsage() == ExportType.JSON || this.getUsage() == ExportType.CSV || this.getUsage() == ExportType.LASR_OMA_TABLE)) {
            throw new DataRetrievalException(this.getMsgExportDataSelectionWrongMetaLibraryUsage());
        }
        DataSelection exportDS = this.getExportDataSelection();
        if (this.isTooManyTablesOrColumns(exportDS)) {
            throw new DataRetrievalException(this.getMsgExportDataSelectionTooLarge());
        }
        DataSelection uploadDS = this.getUploadDataSelection();
        SessionContextInterface session = uploadDS.getSession();
        List<FilterItem> filters = uploadDS.getFilters();
        try {
            String string;
            block11: {
                if (this.isAllDetail() && !filters.isEmpty()) {
                    ArrayList filterItems = new ArrayList();
                    uploadDS.setFilters(filterItems);
                }
                QueryConnector qc = (QueryConnector)IQDataServices.newQueryConnector(session, 1, 1);
                try {
                    string = qc.getPhysicalQuery(uploadDS);
                    if (qc == null) break block11;
                }
                catch (Throwable throwable) {
                    if (qc != null) {
                        IQDataServices.closeQueryConnector(qc, session, null);
                    }
                    throw throwable;
                }
                IQDataServices.closeQueryConnector(qc, session, null);
            }
            return string;
        }
        finally {
            if (this.isAllDetail() && !filters.isEmpty()) {
                uploadDS.setFilters(filters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws DataRetrievalException, ExecutionException, MetadataException {
        DataSelection exportDS = this.getExportDataSelection();
        if (this.isTooManyTablesOrColumns(exportDS)) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionTooLarge.Message.txt", new Object[0]));
        }
        DataSelection uploadDS = this.getUploadDataSelection();
        SessionContextInterface session = uploadDS.getSession();
        QueryConnector qc = (QueryConnector)IQDataServices.newQueryConnector(session, 1, 1);
        ResultSetInterface resultSetInterface = null;
        try {
            resultSetInterface = this.run(qc);
        }
        finally {
            if (resultSetInterface != null) {
                resultSetInterface.close();
            }
            if (qc != null) {
                IQDataServices.closeQueryConnector(qc, session, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetInterface run(QueryConnector queryConnector) throws DataRetrievalException, MetadataException {
        if (this.isMetalibInEffect() && (this.getUsage() == ExportType.JSON || this.getUsage() == ExportType.CSV || this.getUsage() == ExportType.LASR_OMA_TABLE)) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionWrongMetalibUsage.Message.txt", new Object[0]));
        }
        DataSelection exportDS = this.getExportDataSelection();
        if (this.isTooManyTablesOrColumns(exportDS)) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionTooLarge.Message.txt", new Object[0]));
        }
        DataSelection uploadDS = this.getUploadDataSelection();
        List<FilterItem> filters = uploadDS.getFilters();
        if (this.isAllDetail() && !filters.isEmpty()) {
            ArrayList filterItems = new ArrayList();
            uploadDS.setFilters(filterItems);
        }
        try {
            ResultSetInterface resultSetInterface;
            Map<String, ResultSetInterface> results = queryConnector.retrieveQueryResultMap(Collections.singletonList(uploadDS));
            ResultSetInterface resultSetInterface2 = resultSetInterface = results.get(uploadDS.getID());
            return resultSetInterface2;
        }
        finally {
            if (this.isAllDetail() && !filters.isEmpty()) {
                uploadDS.setFilters(filters);
            }
        }
    }

    @Override
    public DataSourceTable getlasrDataSourceTable() {
        return this._lasrDataSourceTable;
    }

    @Override
    public ExportType getUsage() {
        return this._usage;
    }

    @Override
    public SASLibrary getSASLibrary() {
        return this._SASLibrary;
    }

    private MessageFormatter getMsgExportDataSelectionWrongMetaLibraryUsage() {
        return IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionWrongMetalibUsage.Message.txt", new Object[0]);
    }

    private MessageFormatter getMsgExportDataSelectionTooLarge() {
        return IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExportDataSelectionTooLarge.Message.txt", new Object[0]);
    }

    @Override
    public Export lasrFormatLibref(String lasrFormatLib) {
        this._lasrFormatLibref = lasrFormatLib;
        return this;
    }

    @Override
    public boolean getOnlyReferencedUDFs() {
        return this._onlyReferencedUdfs;
    }

    @Override
    public Export onlyReferencedUDFs(boolean onlyReferencedUDFs) {
        this._onlyReferencedUdfs = onlyReferencedUDFs;
        return this;
    }

    @Override
    public String getLasrFormatLibref() {
        String lasrFormatLibref = this._lasrFormatLibref == null ? "lsrfmts" : this._lasrFormatLibref;
        return lasrFormatLibref;
    }

    @Override
    public Export lasrFormatLibnameStmt(String lasrFormatLibnameStmt) {
        this._lasrFormatLibnameStmt = lasrFormatLibnameStmt;
        return this;
    }

    @Override
    public String getLasrFormatLibnameStmt() {
        String lasrFormatLibnameStmt = this._lasrFormatLibnameStmt == null ? "libname " + this.getLasrFormatLibref() + " XML92 xmltype=sasfmt tagset=tagsets.XMLsuv;" : this._lasrFormatLibnameStmt;
        return lasrFormatLibnameStmt;
    }

    @Override
    public Export udfOutputTableName(String udfTableName) {
        this._udfTableName = udfTableName;
        return this;
    }

    @Override
    public String getUdfOutputTableName() {
        String udfTableName = this._udfTableName == null ? "iqfmts" : this._udfTableName;
        return udfTableName;
    }

    @Override
    public Export udfOutputTableLibref(String udfTableLibref) {
        this._udfTableLibref = udfTableLibref;
        return this;
    }

    @Override
    public String getUdfOutputTableLibref() {
        String udfTableLibref = this._udfTableLibref == null ? "work" : this._udfTableLibref;
        return udfTableLibref;
    }

    @Override
    public String generateUdfStatement() throws DataRetrievalException {
        String procfmtCode;
        try {
            procfmtCode = this.buildUdfFormatCode(this.getOnlyReferencedUDFs());
        }
        catch (MetadataException e) {
            throw new DataRetrievalException(e);
        }
        return procfmtCode;
    }

    protected String buildUdfFormatCode(boolean onlyReferencedResultItems) throws MetadataException, DataRetrievalException {
        String procfmtCode = "";
        String udfTableLibref = this.getUdfOutputTableLibref();
        String udfTableName = this.getUdfOutputTableName();
        String udfTableFullName = GenerationUtil.generateFullyQualifiedIdentifier(udfTableLibref, udfTableName);
        String lasrFormatLibnameStmt = this.getLasrFormatLibnameStmt();
        String lasrFormatLibref = this.getLasrFormatLibref();
        String lasrFormatTableName = this.getUdfOutputTableName();
        String lasrFormatFullName = GenerationUtil.generateFullyQualifiedIdentifier(lasrFormatLibref, lasrFormatTableName);
        DataSelection uploadDS = this.getUploadDataSelection();
        Set<String> baseFmtNames = this.getBaseFormatNames(onlyReferencedResultItems, uploadDS);
        procfmtCode = this.getUserDefinedFormats(uploadDS, udfTableLibref, udfTableName, udfTableFullName, lasrFormatLibnameStmt, lasrFormatLibref, lasrFormatTableName, lasrFormatFullName, baseFmtNames);
        if (_logger.isDebugEnabled()) {
            if (procfmtCode.length() > 0) {
                _logger.debug("Map has user-defined formats.  Code for the XML was generated. Code = \n" + procfmtCode);
            } else {
                _logger.debug("Map does not have user-defined formats.  No code for the XML was generated.");
            }
        }
        return procfmtCode;
    }

    protected Set<String> getBaseFormatNames(boolean onlyReferencedResultItems, DataSelection uploadDS) throws MetadataException, DataRetrievalException {
        List<DataItem> dataItems = null;
        dataItems = onlyReferencedResultItems ? uploadDS.getEffectiveResultItems() : uploadDS.getObjects(true, DataItem.class);
        Set<String> baseFmtNames = this.getBaseFormatNames(dataItems);
        return baseFmtNames;
    }

    protected String getUserDefinedFormats(DataSelection uploadDs, String udfTableLibref, String udfTableName, String udfTableFullName, String lasrFormatLibnameStmt, String lasrFormatLibref, String lasrFormatTableName, String lasrFormatFullName, Set<String> baseFmtNames) throws DataRetrievalException {
        String[][] udfs = this.queryForUDFs(uploadDs, baseFmtNames, udfTableLibref, udfTableName, udfTableFullName);
        String procfmtCode = "";
        if (udfs.length > 0) {
            procfmtCode = this.generateUDFXML(udfs, udfTableLibref, udfTableName, udfTableFullName, lasrFormatLibnameStmt, lasrFormatLibref, lasrFormatTableName, lasrFormatFullName);
        }
        return procfmtCode;
    }

    /*
     * Unable to fully structure code
     */
    protected String[][] queryForUDFs(DataSelection uploadDs, Set<String> baseFmtNames, String udfOutputTableLibref, String udfOutputTableName, String udfOutputTableFullName) throws DataRetrievalException {
        fmtInfo = new String[][]{};
        session = uploadDs.getSession();
        service = uploadDs.getMetadataService();
        qc = null;
        results = null;
        try {
            fmtNames = new StringBuilder();
            if (baseFmtNames.isEmpty()) {
                var12_17 = fmtInfo;
                return var12_17;
            }
            sorted = new ArrayList<String>(baseFmtNames);
            Collections.sort(sorted);
            it = sorted.iterator();
            while (it.hasNext()) {
                fmtName = (String)it.next();
                if (it.hasNext()) {
                    fmtNames.append("  fmtname=\"").append(fmtName).append("\" OR\n");
                    continue;
                }
                fmtNames.append("  fmtname=\"").append(fmtName).append("\"");
            }
            sasCode = new StringBuilder();
            sasCode.append("proc sql;\n");
            sasCode.append(" create table ").append(udfOutputTableFullName).append(" as\n");
            sasCode.append("  select libname, memname, fmtname\n");
            sasCode.append("    from dictionary.formats\n");
            sasCode.append("   where (").append(fmtNames.toString()).append(")\n");
            sasCode.append("     AND (fmttype='F' AND source='C');\n");
            sasCode.append("quit;\n");
            if (ExportAbstract._logger.isDebugEnabled()) {
                ExportAbstract._logger.debug("Query for user-defined formats =\n" + sasCode);
            }
            qt = this.getInMemQueryTable(uploadDs, sasCode, session, service, udfOutputTableName);
            qt.setOutputSchemaName(udfOutputTableLibref);
            qt.setComplexQuery(true);
            qc = (QueryConnector)IQDataServices.newQueryConnector(session, 0, 0);
            qt.setQueryConnector(qc);
            qt.prepare();
            ap = qt.getAccessPaths().get(0);
            if (!ExportAbstract.$assertionsDisabled && ap == null) {
                throw new AssertionError();
            }
            ds = DataSelectionFactory.newDataSelection(session, service);
            dst = ds.newDataSourceTable(ap, qt);
            ds.addDataSource(dst);
            for (DataItem di : ds.newDataItems(dst, null)) {
                ds.addBusinessItem(di);
                di.setUsage(DataItemActionType.USAGE_DETAIL);
                ds.addResultItem(di, Role.COLUMN);
            }
            results = qc.retrieveQueryResultMap(Collections.singletonList(ds));
            rsi = results.get(ds.getID());
            rs = (ResultSet)rsi.getResultSet();
            fmtInfo = this.getFormatInfoFromResult(rs);
            ** try [egrp 3[TRYBLOCK] [1 : 557->569)] { 
        }
        catch (MetadataException e) {
            throw new DataRetrievalException(e);
        }
        catch (ExecutionException e) {
            throw new DataRetrievalException(e);
        }
        catch (GenerationException e) {
            throw new DataRetrievalException(e);
        }
        catch (SQLException e) {
            throw new DataRetrievalException(e);
        }
        finally {
            try {
                IQDataServices.closeQueryConnector(qc, session, results);
            }
            catch (ExecutionException e) {
                ExportAbstract._logger.warn((Object)e);
            }
        }
lbl-1000:
        // 1 sources

        {
            IQDataServices.closeQueryConnector(qc, session, results);
        }
lbl64:
        // 1 sources

        catch (ExecutionException e) {
            ExportAbstract._logger.warn((Object)e);
        }
        {
        }
        return fmtInfo;
    }

    protected Set<String> getBaseFormatNames(List<DataItem> dataItems) throws MetadataException {
        LinkedHashSet<String> formats = new LinkedHashSet<String>();
        for (DataItem di : dataItems) {
            QualifiedColumn qc;
            ExpressionInterface expression;
            String format = di.getFormat();
            if (format != null && format.trim().length() > 0) {
                formats.add(format.trim());
            }
            if (!((expression = di.getExpression()) instanceof QualifiedColumn) || (format = (qc = (QualifiedColumn)expression).getSasFormat()) == null || format.trim().length() <= 0) continue;
            formats.add(format.trim());
        }
        return this.getBaseFormatNames(formats);
    }

    protected Set<String> getBaseFormatNames(Set<String> formats) {
        LinkedHashSet<String> baseFormats = new LinkedHashSet<String>();
        for (String format : formats) {
            String[] result = SASFormat.parseFormat((String)format);
            String base = result[0];
            if (base.trim().length() == 0) continue;
            baseFormats.add(base.trim());
        }
        return baseFormats;
    }

    private InMemoryQueryTable getInMemQueryTable(BusinessModel businessModel, StringBuilder sasCode, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, String udfOutputTableName) throws MetadataException {
        List servers = service.getSoftwareServers(session, Collections.singletonList(SASWorkspaceServer.class));
        DataSource dataSource = businessModel.getObjects(true, DataSource.class).get(0);
        assert (dataSource != null);
        String serverName = dataSource.getServer().getLabel();
        SASWorkspaceServer server = null;
        for (SASWorkspaceServer serv : servers) {
            String serverLabel = serv.getLabel();
            if (!serverName.equalsIgnoreCase(serverLabel)) continue;
            server = serv;
            break;
        }
        assert (server != null);
        String queryText = sasCode.toString();
        InMemoryQueryTable qt = InMemoryFactory.getInstance().newSimpleQueryTable(udfOutputTableName, businessModel, queryText, Collections.emptyList(), server);
        return qt;
    }

    protected String[][] getFormatInfoFromResult(ResultSet rs) throws SQLException {
        String[][] formats = new String[][]{};
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        assert (columnCount == 3);
        rs.last();
        int rows = rs.getRow();
        formats = new String[rows][];
        rs.beforeFirst();
        int i = 0;
        while (rs.next()) {
            String libname = rs.getString(1) == null ? "" : rs.getString(1).trim();
            String memname = rs.getString(2) == null ? "" : rs.getString(2).trim();
            String fmtname = rs.getString(3) == null ? "" : rs.getString(3).trim();
            String catalog = memname.equals("") ? libname : libname + "." + memname;
            formats[i] = new String[columnCount - 1];
            formats[i][0] = catalog;
            formats[i][1] = fmtname;
            ++i;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Catalogs and UDFs =\n" + Arrays.deepToString((Object[])formats));
        }
        return formats;
    }

    protected String generateUDFXML(String[][] udfs, String udfOutputTableLibref, String udfOutputTableName, String udfOutputFullName, String lasrFormatLibnameStmt, String lasrFormatLibref, String lasrFormatTableName, String lasrFormatFullName) {
        LinkedHashMap catalogsWithFmts = new LinkedHashMap();
        for (String[] formatRow : udfs) {
            List<String> fmts = (List)catalogsWithFmts.get(formatRow[0]);
            if (fmts == null) {
                fmts = new ArrayList<String>();
                fmts.add(formatRow[1]);
                catalogsWithFmts.put(formatRow[0], fmts);
                continue;
            }
            fmts.add(formatRow[1]);
        }
        StringBuilder procCat = new StringBuilder();
        String pc = "\nproc catalog catalog=";
        String pad = " ";
        String pad2 = "\n         ";
        for (String catalog : catalogsWithFmts.keySet()) {
            procCat.append(pc).append(catalog).append(";\n");
            procCat.append(" copy out=").append(udfOutputFullName).append(";\n");
            procCat.append("  select");
            List fmts = (List)catalogsWithFmts.get(catalog);
            int fnum = 0;
            for (String fmt : fmts) {
                ++fnum;
                String fmtType = ".FORMAT";
                if (fmt.startsWith("$")) {
                    fmt = fmt.substring(1);
                    fmtType = ".FORMATC";
                }
                if (fnum > 1) {
                    procCat.append(pad2);
                } else {
                    procCat.append(pad);
                }
                procCat.append(fmt).append(fmtType);
            }
            procCat.append(";\nrun;\n");
        }
        procCat.append("quit;\n\n");
        StringBuilder procfmtCode = new StringBuilder("");
        procfmtCode.append((CharSequence)procCat);
        procfmtCode.append("\n/* \"bridge\" user-defined formats to LASR */\n");
        procfmtCode.append("/* setup XML libref */\n");
        procfmtCode.append("filename ").append(lasrFormatLibref).append(" TEMP;\n");
        procfmtCode.append(lasrFormatLibnameStmt).append("\n");
        procfmtCode.append("%let xmlpath=%sysfunc(pathname(").append(lasrFormatLibref).append(", F));\n");
        procfmtCode.append("%put &xmlpath;\n\n");
        procfmtCode.append("/* copy formats to one catalog in work to xml file */").append("/* Generate temporary XML file used in LASR */\n");
        procfmtCode.append("proc format library=").append(udfOutputFullName).append(" cntlout=").append(lasrFormatFullName).append(";\n");
        procfmtCode.append("run;\n");
        procfmtCode.append("quit;\n\n");
        if (_logger.isDebugEnabled()) {
            _logger.debug("Code to create XML:\n" + procfmtCode.toString());
        }
        return procfmtCode.toString();
    }

    @Override
    public boolean getIncludeAllColumns() {
        return this._includeAllColumns;
    }

    @Override
    public Export includeAllColumns(boolean includeAllColumns) {
        this._includeAllColumns = includeAllColumns;
        return this;
    }

    @Override
    public boolean getIgnoreReachThruTable() {
        return this._ignoreReachThruTable;
    }

    @Override
    public Export ignoreReachThruTable(boolean ignoreReachThruTable) {
        this._ignoreReachThruTable = ignoreReachThruTable;
        return this;
    }
}

