/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.ColumnManager;
import com.sas.iquery.metadata.business.CopyFromInterface;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ColumnManagerImpl2;
import com.sas.iquery.metadata.business.impl.DataSecurityInterface;
import com.sas.iquery.metadata.business.impl.DataSourceImpl;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.QualifiedColumnImpl;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.business.impl.SecuredObjectInterface;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.impl.security.DataSecurityFactory;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Key;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.StructuredData;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DataSourceTableImpl2
extends DataSourceImpl
implements DataSourceTable,
SecuredObjectInterface,
ResourceRelationshipInterface,
FilterSetMember,
CopyFromInterface {
    private AccessPath _accessPath;
    private Table _table;
    private List<QualifiedColumn> _columns = new ArrayList<QualifiedColumn>();
    private static final boolean DEFAULTVALUE_COLUMNS_ARE_MANAGED = false;
    private boolean _columnsAreManaged = false;
    private ColumnManagerImpl2 _columnManager = new ColumnManagerImpl2(this);
    private static final DataSourceTable.IMLETableAggregation DEFAULTVALUE_AGGREGATE_IMLE_DATA = DataSourceTable.IMLETableAggregation.USE_METADATA_SETTING;
    private DataSourceTable.IMLETableAggregation _aggregateIMLEData = DEFAULTVALUE_AGGREGATE_IMLE_DATA;
    private static final Logger _logger = LogManager.getLogger(DataSourceTableImpl2.class);

    DataSourceTableImpl2(AbstractBusinessModel businessModel, AccessPath inputAccessPath, Table inputTable) throws MetadataException {
        super(businessModel);
        if (inputAccessPath == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.AccessPathArgument.txt", new Object[0]));
        }
        if (inputTable == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImplTableArgument.txt", new Object[0]));
        }
        this.setAccessPath(inputAccessPath);
        this._table = inputTable;
        this.setLabel(this._table.getLabel());
        this.setDescription(this._table.getDescription());
        this.loadColumns();
        if (!this._table.isUnresolved() && this.isIMLETable()) {
            this.setColumnsAreManaged(true);
            this._columnManager.setAutoKeepNewColumns(false);
        }
    }

    public DataSourceTableImpl2() {
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "DST_";
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        super.replaceResource(oldResource, newResource, model, recursive);
        this._accessPath = (AccessPath)Utils.replaceResource(this._accessPath, oldResource, newResource, model, recursive);
        this._table = (Table)Utils.replaceResource(this._table, oldResource, newResource, model, recursive);
        for (int i = this._columns.size() - 1; i >= 0; --i) {
            Column col = this._columns.get(i);
            col.replaceResource(oldResource, newResource, model, recursive);
            if (col != oldResource || !(newResource instanceof QualifiedColumn) || ((QualifiedColumn)newResource).getOwningTable() != this) continue;
            if (this._columns.contains(newResource)) {
                this._columns.remove(i);
                continue;
            }
            this._columns.set(i, (QualifiedColumn)newResource);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataSourceTableImpl2 dst = (DataSourceTableImpl2)super.clone();
        if (!dst.isUnresolved()) {
            dst._columns = new ArrayList<QualifiedColumn>(this._columns.size());
            if (this._columns != null) {
                for (QualifiedColumn qc : this._columns) {
                    QualifiedColumnImpl newQCol = new QualifiedColumnImpl(dst, qc.getColumn());
                    dst._columns.add(newQCol);
                }
            }
            if (this._columnManager != null) {
                dst._columnManager = (ColumnManagerImpl2)this._columnManager.clone();
                dst._columnManager.setOwningTable(dst);
            }
        }
        return dst;
    }

    @Override
    public void setAccessPath(AccessPath path) throws MetadataException {
        if (path == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.AccessPathArgument.txt", new Object[0]));
        }
        this._accessPath = path.copy();
    }

    @Override
    @Nullable
    public AccessPath getAccessPath() {
        return this._accessPath.copy();
    }

    @Override
    @Nonnull
    public List<AccessPath> getAccessPaths() {
        AccessPath path = this.getAccessPath();
        assert (path != null);
        return Collections.singletonList(path);
    }

    @Override
    public AccessPath getAbstractAccessPath() {
        return this.getAccessPath();
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public List<Column> getColumns() throws MetadataException {
        return new ArrayList<Column>(this._columns);
    }

    @Override
    public List<QualifiedColumn> getQualifiedColumns() throws MetadataException {
        return new ArrayList<QualifiedColumn>(this._columns);
    }

    @Override
    public List<Key> getKeys() throws MetadataException {
        String errorMsg = IQMetadataResourceBundle.getStringResource("BusinessModelImplUnsupportedMethod.txt");
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public <T extends Key> List<T> getKeys(@Nonnull Class<T> type) throws MetadataException {
        String errorMsg = IQMetadataResourceBundle.getStringResource("BusinessModelImplUnsupportedMethod.txt");
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public String getSasName() throws MetadataException {
        String name = null;
        if (this._table.isUnresolved()) {
            MessageFormatter error = IQMetadataResourceBundle.getMessageFormatter("RepositoryObject.IsUnresolved.fmt.txt", this._table.getIdentityString());
            throw new MetadataException(error);
        }
        name = this._table.getSasName();
        return name;
    }

    @Override
    public String getDbmsName() throws MetadataException {
        String name = null;
        if (this._table.isUnresolved()) {
            MessageFormatter error = IQMetadataResourceBundle.getMessageFormatter("RepositoryObject.IsUnresolved.fmt.txt", this._table.getIdentityString());
            throw new MetadataException(error);
        }
        name = this._table.getDbmsName();
        return name;
    }

    @Override
    public RelationalSchema getRelationalSchema() throws MetadataException {
        return this._table.getRelationalSchema();
    }

    public QualifiedColumnImpl getQualifiedColumn(Column column) {
        QualifiedColumnImpl qColumn = null;
        for (QualifiedColumn qc : this._columns) {
            Column qciColumn = qc.getColumn();
            if (!qciColumn.equals(column)) continue;
            qColumn = (QualifiedColumnImpl)qc;
            break;
        }
        return qColumn;
    }

    void addQualifiedColumn(QualifiedColumnImpl col) {
        this._columns.add(col);
    }

    @Override
    public StructureOfData getStructure() {
        StructureOfData sod = this._table instanceof StructuredData ? ((StructuredData)((Object)this._table)).getStructure() : StructureOfData.RELATIONAL;
        return sod;
    }

    @Override
    protected String getDefinitionElementName() {
        return "DataSourceTable";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setBooleanAttr(thisElement, "columnsAreManaged", this._columnsAreManaged, false);
        if (this._accessPath instanceof AccessPathToRelationalData) {
            Server server = this._accessPath.getServer();
            Schema schema = this._accessPath.getSchema();
            DataSourceTableImpl2.writeRelatedObject(server, thisElement, writingContext, "Server");
            DataSourceTableImpl2.writeRelatedObject(schema, thisElement, writingContext, "SASLibrary");
        } else {
            DataSourceTableImpl2.writeRelatedObject(this._accessPath, thisElement, writingContext, "AccessPath");
        }
        DataSourceTableImpl2.writeRelatedObject(this._table, thisElement, writingContext, "Table");
        writingContext.queueToWriteRelatedItemsOnlyIfUsedWithinModel(this._columns, thisElement, "Columns");
        if (this._columnsAreManaged) {
            DataSourceTableImpl2.writeRelatedObject(this._columnManager, thisElement, writingContext, "ColumnManagementInfo");
        }
        IQModelImplUtilities.setEnumAttr(thisElement, "aggrIMLEData", this._aggregateIMLEData, DEFAULTVALUE_AGGREGATE_IMLE_DATA);
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._columnsAreManaged = attrsProvider.consumeBooleanAttr("columnsAreManaged", false);
        String columnMappingsAttr = attrsProvider.consumeAttr("dataSourceColumnMappings");
        if (columnMappingsAttr != null) {
            ReadingContextV2 readingContext = attrsProvider.getReadingContext();
            this._columns = this.processColumnMappingsAttr(columnMappingsAttr, readingContext);
            this.setOwningTable();
        }
        this._aggregateIMLEData = DataSourceTable.IMLETableAggregation.consumeValue(attrsProvider, "aggrIMLEData", DEFAULTVALUE_AGGREGATE_IMLE_DATA);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        Server server = (Server)((Object)riHolder.consumeObject("Server", null));
        Schema schema = (Schema)((Object)riHolder.consumeObject("SASLibrary", null));
        AccessPath accessPath = (AccessPath)riHolder.consumeObject("AccessPath", null);
        this._accessPath = server != null && schema != null ? new AccessPathToRelationalData(server, schema) : accessPath;
        this._table = (Table)((Object)riHolder.consumeObject("Table"));
        List<QualifiedColumn> cols = riHolder.consumeObjects("Columns", QualifiedColumn.class);
        this._columns.addAll(cols);
        this._columnManager = (ColumnManagerImpl2)riHolder.consumeObject("ColumnManagementInfo", this._columnManager);
        this.setOwningTable();
    }

    private List processColumnMappingsAttr(String attr, ReadingContextV2 readingContext) throws SAXException {
        ArrayList<QualifiedColumnImpl> cols = new ArrayList<QualifiedColumnImpl>();
        StringTokenizer st = new StringTokenizer(attr, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int iComma = token.indexOf(44);
            if (iComma < 0) continue;
            String dsColumnPersistenceID = token.substring(0, iComma);
            String physColPersistenceID = token.substring(iComma + 1);
            QualifiedColumnImpl newColumn = (QualifiedColumnImpl)readingContext.getObjectForNewObjectElement(dsColumnPersistenceID, "DSColumn");
            Column omaColumn = (Column)((Object)readingContext.getObjectForUsedObjectElement("ReposColumn", physColPersistenceID, false));
            newColumn.setPhysicalColumn(omaColumn);
            cols.add(newColumn);
        }
        return cols;
    }

    private void setOwningTable() {
        int size = this._columns.size();
        for (int i = 0; i < size; ++i) {
            QualifiedColumnImpl qci = (QualifiedColumnImpl)this._columns.get(i);
            qci.setOwningTable(this);
        }
        this._columnManager.setOwningTable(this);
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        Server server = (Server)((Object)DataSourceTableImpl2.v1_readItemUnderSubelement(thisElement, readingContext, "Server", new Class[]{Server.class}));
        Schema schema = (Schema)((Object)DataSourceTableImpl2.v1_readItemUnderSubelement(thisElement, readingContext, "Schema", new Class[]{Schema.class}));
        this._table = (Table)((Object)DataSourceTableImpl2.v1_readItemUnderSubelement(thisElement, readingContext, "Table", new Class[]{Table.class}));
        this._accessPath = new AccessPathToRelationalData(server, schema);
    }

    @Override
    public String getDataSetOptionsAsString() throws MetadataException {
        String options = null;
        if (this._table != null && !this._table.isUnresolved()) {
            options = this._table.getDataSetOptionsAsString();
            String filter = null;
            try {
                SessionContextInterface session = this.getBusinessModel().getSession();
                DataSecurityInterface broker = DataSecurityFactory.getInstance().newBroker(session);
                filter = broker.getDataFilter(this);
            }
            catch (MetadataException e) {
                MessageFormatter error = IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.ErrorGettingRowLevelSecurity.fmt.txt", this._table.getIdentityString(), e);
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(error.toString(), (Throwable)e);
                }
                throw new MetadataException(error, (Throwable)e);
            }
            if (filter == null) {
                if (_logger.isEnabled(Level.WARN)) {
                    String warn = IQMetadataResourceBundle.getMessageString("DataSourceTableImpl2.WarnGettingRowLevelSecurity.fmt.txt", this._table.getIdentityString());
                    _logger.warn(warn);
                }
                filter = "1=0";
            }
            if (filter.trim().length() > 0) {
                if (options == null || options.trim().length() == 0) {
                    options = "WHERE=(" + filter + ")";
                } else {
                    int valueLoc;
                    int filterLoc = options.toUpperCase().indexOf("WHERE=");
                    int parensOpen = 0;
                    boolean inQuote = false;
                    char quoteChar = ' ';
                    int valueEnd = valueLoc = filterLoc + 7;
                    for (int i = valueLoc; i < options.length(); ++i) {
                        char ch = options.charAt(i);
                        if (ch == '(') {
                            if (inQuote) continue;
                            ++parensOpen;
                            continue;
                        }
                        if (ch == ')') {
                            if (inQuote) continue;
                            --parensOpen;
                            continue;
                        }
                        if (ch == '\'' || ch == '\"') {
                            if (!inQuote || ch != quoteChar) continue;
                            inQuote = false;
                            continue;
                        }
                        if (ch != ' ' || parensOpen != 0 || inQuote) continue;
                        valueEnd = i;
                        break;
                    }
                    String left = options.substring(0, valueLoc);
                    String value = options.substring(valueLoc, valueEnd).trim();
                    String right = options.substring(valueEnd, options.length());
                    if (value.length() != 0) {
                        filter = filter + " AND (" + value + ")";
                    }
                    options = left + "(" + filter + ")" + right;
                }
            }
        }
        return options;
    }

    public boolean isCaseEnabled() throws MetadataException {
        boolean caseEnabled = false;
        if (this._table instanceof OMATable) {
            caseEnabled = ((OMATable)this._table).isCaseEnabled();
        }
        return caseEnabled;
    }

    public boolean isSpecialCharEnabled() throws MetadataException {
        boolean specialCharEnabled = false;
        if (this._table instanceof OMATable) {
            specialCharEnabled = ((OMATable)this._table).isSpecialCharEnabled();
        }
        return specialCharEnabled;
    }

    private void loadColumns() throws MetadataException {
        this._columns.clear();
        for (Column col : DataSourceTableImpl2.getColumnsUsingJomaCache(this._table)) {
            QualifiedColumnImpl qCol = new QualifiedColumnImpl(this, col);
            this._columns.add(qCol);
        }
    }

    public ReadModification addUnusedColumns() throws MetadataException {
        List ensureColumns;
        ReadModification readMod = new ReadModification(this);
        if (this._columnsAreManaged) {
            List physCols = this._columnManager.autoAddNewPhysicalColumns();
            if (this._columnManager.getAutoKeepNewColumns()) {
                readMod._keptPhysColsAutoAdded = physCols;
            } else {
                readMod._omittedPhysColsAutoAdded = physCols;
            }
            ensureColumns = this._columnManager.getKeptColumns();
        } else {
            ensureColumns = DataSourceTableImpl2.getColumnsUsingJomaCache(this._table);
        }
        if (!ensureColumns.isEmpty()) {
            boolean changed = false;
            IdentityList qcPhysicalColumns = this.getPhysicalColumnsForQualifiedColumns();
            for (Column col : ensureColumns) {
                boolean qcDoesNotExist = qcPhysicalColumns.add(col);
                if (!qcDoesNotExist) continue;
                QualifiedColumnImpl qCol = new QualifiedColumnImpl(this, col);
                this._columns.add(qCol);
                readMod.qualifiedColumnAdded(qCol);
                changed = true;
            }
            if (changed) {
                // empty if block
            }
        }
        return readMod;
    }

    public void removedUnusedUnresolvedColumns() throws MetadataException {
        boolean changed = false;
        List<Column> usedColumns = this.getUsedPhysicalColumns();
        Iterator<QualifiedColumn> iterator = this._columns.iterator();
        while (iterator.hasNext()) {
            QualifiedColumn qc = iterator.next();
            boolean unresolved = qc.isUnresolved();
            Column phyColumn = qc.getColumn();
            if (!unresolved && phyColumn != null) {
                unresolved = phyColumn.isUnresolved();
            }
            if (!unresolved || phyColumn != null && usedColumns.contains(phyColumn)) continue;
            iterator.remove();
            changed = true;
        }
        if (changed) {
            // empty if block
        }
    }

    void resolveColumnManagerOmittedColumns() throws MetadataException {
        this._columnManager.resolveOmittedColumns(this._table);
    }

    IdentityList getPhysicalColumnsForQualifiedColumns() {
        int usedSize = this._columns.size();
        IdentityList physicalColumnsUsed = new IdentityList(usedSize * 5);
        for (int i = 0; i < usedSize; ++i) {
            QualifiedColumn qc = this._columns.get(i);
            physicalColumnsUsed.add(qc.getColumn());
        }
        return physicalColumnsUsed;
    }

    static List<Column> getColumnsUsingJomaCache(Table table) throws MetadataException {
        List<Column> out = table instanceof OMATable ? ((OMATable)table).getColumns(false) : (table instanceof InMemoryTable ? ((InMemoryTable)table).getColumns(false) : table.getColumns());
        return out;
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._table == null) {
            reasons.add(new Reason((Object)this, 2, 41, "DataSourceTableImpl2.NoTableDefinedForDataSource.fmt.txt", this.getIdentityString()));
        }
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._accessPath instanceof AccessPathToRelationalData) {
            intoList.add(this._accessPath.getServer());
            intoList.add(this._accessPath.getSchema());
        } else {
            intoList.add(this._accessPath);
        }
        intoList.add(this._table);
        intoList.add(this._columnManager);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        if (this._accessPath instanceof AccessPathToRelationalData) {
            Schema newSchema;
            Schema oldSchema;
            Server newServer;
            Server oldServer = this._accessPath.getServer();
            if (oldServer != (newServer = (Server)DataSourceTableImpl2.replace(oldServer, oldObject, newObject))) {
                this._accessPath.setServer(newServer);
            }
            if ((oldSchema = this._accessPath.getSchema()) != (newSchema = (Schema)DataSourceTableImpl2.replace(oldSchema, oldObject, newObject))) {
                this._accessPath.setSchema(newSchema);
            }
        } else {
            this._accessPath = (AccessPath)DataSourceTableImpl2.replace(this._accessPath, oldObject, newObject);
        }
        this._table = (Table)DataSourceTableImpl2.replace(this._table, oldObject, newObject);
        this._columnManager = (ColumnManagerImpl2)DataSourceTableImpl2.replace(this._columnManager, oldObject, newObject);
    }

    @Override
    protected void checksForCopyingFromObject(Object obj) throws MetadataException {
        super.checksForCopyingFromObject(obj);
        DataSourceTableImpl2 fromTable = (DataSourceTableImpl2)obj;
        AccessPath fromAccessPath = fromTable.getAccessPath();
        if (!this._accessPath.equals(fromAccessPath) || this._table != fromTable._table) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.CannotCopyBetweenDataSourceTableHavingDifferentServerLibOrTable.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
        List<Column> fromColumns = DataSourceTableImpl2.getColumnsUsingJomaCache(fromTable);
        if (this._columns != null && fromColumns == null || this._columns == null && fromColumns != null || this._columns != null && fromColumns != null && this._columns.size() != fromColumns.size()) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.CannotCopyBetweenDataSourceTableHavingDifferentColumnsDefined.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
        Iterator<Column> fromIterator = fromColumns.iterator();
        Iterator<QualifiedColumn> thisIterator = this._columns.iterator();
        while (fromIterator.hasNext()) {
            Column fromObj = fromIterator.next();
            QualifiedColumn thisObj = thisIterator.next();
            if (!(fromObj instanceof QualifiedColumn) || !(thisObj instanceof QualifiedColumn)) continue;
            QualifiedColumn fromQC = (QualifiedColumn)fromObj;
            QualifiedColumn thisQC = thisObj;
            if (fromQC.getColumn() == thisQC.getColumn()) continue;
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.CannotCopyBetweenDataSourceTableHavingDifferentColumnsDefined.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
    }

    @Override
    protected boolean shouldCopyFieldValue(Object fromObjectFieldValue) {
        boolean rc = super.shouldCopyFieldValue(fromObjectFieldValue);
        if (rc && (this._columns == fromObjectFieldValue || this._columnManager == fromObjectFieldValue)) {
            rc = false;
        }
        return rc;
    }

    @Override
    public void copyFrom(Object obj) throws MetadataException {
        this._copyFrom(obj);
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._columns = rilsHolder.consumeObjects("Columns", QualifiedColumn.class);
        this.setOwningTable();
    }

    @Override
    public ColumnManager getColumnMgr() throws MetadataException {
        this.unresolvedCheck();
        this.inModelCheck();
        this.snapshotPhysicalTable();
        return DataSourceTableImpl2.copy(this._columnManager);
    }

    private void snapshotPhysicalTable() {
        PhysicalTable omrTable;
        OMATable omaTable;
        if (this._table instanceof OMATable && (omaTable = (OMATable)this._table).isLive() && (omrTable = (PhysicalTable)omaTable.getOMAObject()) != null) {
            try {
                omrTable.getColumns(true);
            }
            catch (RemoteException e) {
                _logger.debug("Failure during snapshotting table metadata", (Throwable)e);
            }
            catch (MdException e) {
                _logger.debug("Failure during snapshotting table metadata", (Throwable)e);
            }
        }
    }

    private static ColumnManagerImpl2 copy(ColumnManagerImpl2 mgmt) throws MetadataException {
        ColumnManagerImpl2 out = null;
        try {
            out = (ColumnManagerImpl2)mgmt.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(e);
        }
        return out;
    }

    @Override
    public synchronized ColumnManager.ColumnManagerResults setColumnMgr(ColumnManager mgr) throws MetadataException {
        this.changeableCheck();
        this.inModelCheck();
        if (!(mgr instanceof ColumnManagerImpl2)) {
            MessageFormatter error = IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.UnsupportedColumnMgmtType.fmt.txt", mgr == null ? "null" : mgr.getClass().toString());
            throw new IQueryServicesIllegalArgumentException(error);
        }
        DataSourceTable mgmtDataSource = mgr.getDataSource();
        if (mgmtDataSource != this) {
            MessageFormatter error = IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.ColumnManagementNotForDataSource.fmt.txt", mgmtDataSource == null ? "null" : mgmtDataSource.getIdentityString(), this.getIdentityString());
            throw new MetadataException(error);
        }
        this.columnsNotManagedCheck();
        ColumnManagerImpl2 colMgr = DataSourceTableImpl2.copy((ColumnManagerImpl2)mgr);
        colMgr.validateToSetOnDST();
        ColumnManager.ColumnManagerResults results = this.performColumnManagement(colMgr);
        this._columnManager = colMgr;
        return results;
    }

    void columnsNotManagedCheck() throws MetadataException {
        if (!this._columnsAreManaged) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("ColumnManagerImpl2.ColumnsAreNotManagedForDataSource.fmt.txt", this);
            throw new MetadataException(formatter);
        }
    }

    private ColumnManager.ColumnManagerResults performColumnManagement(ColumnManager mgmt) throws MetadataException {
        ArrayList<QualifiedColumnImpl> physColsAdded = new ArrayList<QualifiedColumnImpl>();
        ArrayList<Column> physColsRemoved = new ArrayList<Column>();
        if (this._columnsAreManaged) {
            List omittedCols = mgmt.getOmittedColumns();
            ListIterator<QualifiedColumn> it = this._columns.listIterator();
            while (it.hasNext()) {
                QualifiedColumn qc = it.next();
                Column physCol = qc.getColumn();
                if (!omittedCols.contains(physCol)) continue;
                it.remove();
                physColsRemoved.add(physCol);
            }
            List keptCols = mgmt.getKeptColumns();
            for (Column keptPhysColumn : keptCols) {
                boolean found = false;
                ListIterator<QualifiedColumn> qcIter = this._columns.listIterator();
                while (!found && qcIter.hasNext()) {
                    QualifiedColumn qc = qcIter.next();
                    found = keptPhysColumn == qc.getColumn();
                }
                if (found) continue;
                QualifiedColumnImpl qCol = new QualifiedColumnImpl(this, keptPhysColumn);
                this._columns.add(qCol);
                physColsAdded.add(qCol);
            }
        }
        return new ColumnManagerResultsImpl(physColsAdded, physColsRemoved);
    }

    @Override
    public List<Column> getUsedPhysicalColumns() throws MetadataException {
        this.unresolvedCheck();
        IdentityList physicalColumnsUsed = new IdentityList();
        AbstractModel model = this.getModel();
        List<BusinessModelObject> contents = model.getAllContainedObjects();
        for (BusinessModelObject bmo : contents) {
            if (!(bmo instanceof BusinessModelResourceReferencer)) continue;
            BusinessModelObject bmrr = bmo;
            List<QualifiedColumn> qualCols = bmrr.getResources(QualifiedColumn.class, 65535);
            for (QualifiedColumn qc : qualCols) {
                Column physColumn;
                if (qc == null || qc.getDataSource() != this || !this._columns.contains(qc) || (physColumn = qc.getColumn()) == null) continue;
                physicalColumnsUsed.add(physColumn);
            }
        }
        return physicalColumnsUsed.toList();
    }

    @Override
    public List<Column> getUnusedPhysicalColumns() throws MetadataException {
        this.unresolvedCheck();
        this.liveTableCheck();
        List<Column> physColumns = DataSourceTableImpl2.getColumnsUsingJomaCache(this._table);
        for (QualifiedColumn qc : this._columns) {
            Column physColumn = qc.getColumn();
            if (physColumn == null || !physColumn.isUnresolved()) continue;
            physColumns.add(physColumn);
        }
        List<Column> usedColumns = this.getUsedPhysicalColumns();
        physColumns.removeAll(usedColumns);
        return physColumns;
    }

    @Override
    public boolean isIMLETable() throws MetadataException {
        SASLibrary lib;
        this.unresolvedCheck();
        boolean out = false;
        Schema schema = this._accessPath.getSchema();
        if (schema instanceof SASLibrary && !(lib = (SASLibrary)schema).isUnresolved()) {
            String engine = lib.getEngine();
            out = "SASIOIME".equalsIgnoreCase(engine);
        }
        return out;
    }

    @Override
    public void setAggregateIMLEData(DataSourceTable.IMLETableAggregation aggregate) throws MetadataException {
        this.changeableCheck();
        if (this._aggregateIMLEData != aggregate) {
            this._aggregateIMLEData = aggregate;
            this.fireChangeEvent("Return aggregated data when table is IMLE data");
        }
    }

    @Override
    public DataSourceTable.IMLETableAggregation getAggregateIMLEData() {
        this.unresolvedCheck();
        return this._aggregateIMLEData;
    }

    void liveTableCheck() throws MetadataException {
        if (this._table == null || this._table.isUnresolved()) {
            MessageFormatter error = IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.ColumnManagementNotAvailableWhenUnderlyingTableIsUnresolved.fmt.txt", this._table == null ? "null" : this._table.getIdentityString());
            throw new MetadataException(error);
        }
    }

    private void inModelCheck() throws MetadataException {
        AbstractModel model = this.getModel();
        if (!model.contains(this)) {
            MessageFormatter error = IQMetadataResourceBundle.getMessageFormatter("DataSourceTableImpl2.DataSourceNotContainedInItsModel.fmt.txt", this.getIdentityString());
            throw new MetadataException(error);
        }
    }

    @Override
    public boolean getColumnsAreManaged() {
        return this._columnsAreManaged;
    }

    @Override
    public void setColumnsAreManaged(boolean managed) throws MetadataException {
        this.changeableCheck();
        this.liveTableCheck();
        if (this._columnsAreManaged != managed) {
            this._columnManager.init();
            if (!managed) {
                this.addUnusedColumns();
            }
            this._columnsAreManaged = managed;
            this.fireChangeEvent("The switch that controls whether columns are managed or not has changed.");
        }
    }

    public void resyncColumnManagerColumnsWithPhysColumns(Logger logger) throws MetadataException {
        if (this._columnsAreManaged) {
            List availCols = this.getAvailableReplacementColumns();
            List refdCols = this._columnManager.getKeptColumns();
            refdCols.addAll(this._columnManager.getOmittedColumns());
            for (Object obj : refdCols) {
                OMAColumn col;
                if (!(obj instanceof OMAColumn)) continue;
                this.resynchColumnMgrColumn(this._columnManager, col, availCols, logger, (col = (OMAColumn)obj).getOwningTable() != this._table);
            }
        }
    }

    private List getAvailableReplacementColumns() throws MetadataException {
        ArrayList<Column> out = new ArrayList<Column>();
        ArrayList<Column> unresolvedCols = new ArrayList<Column>();
        if (this._table != null) {
            IdentityList availablePhysCols = new IdentityList();
            availablePhysCols.addAll(this._table.getColumns());
            IdentityList qcPhysCols = this.getPhysicalColumnsForQualifiedColumns();
            availablePhysCols.addAll(qcPhysCols.toList());
            int size = availablePhysCols.size();
            for (int i = 0; i < size; ++i) {
                Column availColumn = (Column)availablePhysCols.get(i);
                if (this._table != availColumn.getOwningTable()) continue;
                if (availColumn.isUnresolved()) {
                    unresolvedCols.add(availColumn);
                    continue;
                }
                out.add(availColumn);
            }
        }
        out.addAll(unresolvedCols);
        return out;
    }

    private void resynchColumnMgrColumn(ColumnManagerImpl2 colMgr, OMAColumn col, List availablePhysCols, Logger logger, boolean differentTable) throws MetadataException {
        Column replacementColumn = null;
        int size = availablePhysCols.size();
        for (int i = 0; i < size && replacementColumn == null; ++i) {
            Column availColumn = (Column)availablePhysCols.get(i);
            if (col == availColumn || !col.isPhysicallyEquivalent(availColumn)) continue;
            replacementColumn = availColumn;
        }
        if (differentTable && replacementColumn == null) {
            SessionContextInterface session = this.getBusinessModel().getSession();
            OMAColumn unresolvedCol = new OMAColumn(null, session, null);
            unresolvedCol.setUnresolved();
            unresolvedCol.setOwningTable((OMATable)this._table);
            String sasName = col.getSasName();
            String sasType = col.getSasType();
            unresolvedCol.setExternalReferenceInfo(sasName, "N".equalsIgnoreCase(sasType));
            replacementColumn = unresolvedCol;
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("An unresolved column is used in column management: \"" + sasName + "\" in table \"" + this._table.getLabel() + "\"");
            }
        }
        if (replacementColumn != null) {
            colMgr.replaceDirectReferences(col, replacementColumn);
        }
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public List<PhysicalResource> getChildResources(ExternalResourceType type) throws MetadataException {
        return new ArrayList<PhysicalResource>(this.getColumns());
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this._accessPath.getSchema();
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Table;
    }

    @Override
    public String getSearchString() throws MetadataException {
        return "";
    }

    @Override
    public String getUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        return "";
    }

    @Override
    public boolean hasChildResources() {
        return true;
    }

    @Override
    public boolean hasParentResource() {
        return true;
    }

    @Override
    public boolean isPhysicallyEquivalent(PhysicalResource res) throws MetadataException {
        String label;
        boolean returnValue = false;
        if (this == res) {
            returnValue = true;
        } else if (this._table == res) {
            returnValue = true;
        } else if (res instanceof OMATable) {
            String label2;
            String string = label2 = this._table != null ? this._table.getLabel() : this.getLabel();
            if (label2.equalsIgnoreCase(((OMATable)res).getLabel())) {
                returnValue = true;
            }
        } else if (res instanceof Table && (label = this.getLabel()).equals(res.getLabel())) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
    }

    static class ReadModification
    implements DataSourceTable.ReadModification {
        List _keptPhysColsAutoAdded;
        List _omittedPhysColsAutoAdded;
        ArrayList<QualifiedColumn> _qualifiedColumnsCreated;
        DataSourceTableImpl2 _dst;

        ReadModification(DataSourceTableImpl2 dsti) {
            this._dst = dsti;
        }

        @Override
        public DataSourceTable getDataSource() {
            return this._dst;
        }

        boolean hasModsToTellAPIUser() {
            return this._keptPhysColsAutoAdded != null && this._keptPhysColsAutoAdded.size() > 0;
        }

        public List getKeptColumnsAutoAddedToColumnManager() {
            return ListUtils.newList(this._keptPhysColsAutoAdded);
        }

        void qualifiedColumnAdded(QualifiedColumnImpl qci) {
            if (this._qualifiedColumnsCreated == null) {
                this._qualifiedColumnsCreated = new ArrayList();
            }
            this._qualifiedColumnsCreated.add(qci);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this._keptPhysColsAutoAdded != null) {
                buf.append("Kept columns auto added: ");
                this.colsIntoBuffer(this._keptPhysColsAutoAdded, buf);
                buf.append('\n');
            }
            if (this._omittedPhysColsAutoAdded != null) {
                buf.append("Omitted columns auto added: ");
                this.colsIntoBuffer(this._omittedPhysColsAutoAdded, buf);
                buf.append('\n');
            }
            if (this._qualifiedColumnsCreated != null) {
                buf.append("Qualfied columns auto added: ");
                this.colsIntoBuffer(this._qualifiedColumnsCreated, buf);
                buf.append('\n');
            }
            return buf.toString();
        }

        private void colsIntoBuffer(List<? extends Column> cols, StringBuffer buf) {
            Iterator<? extends Column> it = cols.iterator();
            while (it.hasNext()) {
                Column col = it.next();
                String sasName = "";
                try {
                    sasName = col.getSasName();
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
                buf.append(sasName);
                if (!it.hasNext()) continue;
                buf.append(',');
            }
        }
    }

    static class ColumnManagerResultsImpl
    implements ColumnManager.ColumnManagerResults {
        private List _physColsAdded;
        private List _physColsOmitted;

        ColumnManagerResultsImpl(List physColsAdded, List physColsOmitted) {
            this._physColsAdded = physColsAdded;
            this._physColsOmitted = physColsOmitted;
        }

        @Override
        public Collection getRemovedColumns() {
            return ListUtils.newList(this._physColsOmitted);
        }

        @Override
        public Collection getAddedColumns() {
            return ListUtils.newList(this._physColsAdded);
        }
    }
}

