/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.ColumnManager;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.DataSourceImpl;
import com.sas.iquery.metadata.business.impl.QualifiedColumnImpl;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Key;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.physical.inmemory.InMemoryFactory;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.util.DataSelectionUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public class DataSourceRelationalQueryImpl
extends DataSourceImpl
implements DataSourceRelationalQuery {
    public static final String EVENT_BUSINESS_QUERY_CHANGED = "business query changed";
    public static final String EVENT_ACCESS_PATH_CHANGED = "access path changed";
    public static final String EVENT_REFERENCED_OBJECT_CHANGED = "referenced object changed";
    private BusinessQuery _businessQuery;
    private InMemoryTable _physicalTable;
    private List<QualifiedColumn> _columns;
    private AccessPath _accessPath;
    private static final Logger _logger = LogManager.getLogger(DataSourceRelationalQueryImpl.class);
    private volatile boolean nested = false;

    DataSourceRelationalQueryImpl(AbstractBusinessModel businessModel, BusinessQuery businessQuery) throws MetadataException {
        super(businessModel);
        this._businessQuery = businessQuery;
        this._businessQuery.addListener(this);
        this._validateBusinessQuery();
        this._accessPath = this._createAccessPath();
        this._physicalTable = this._createPhysicalTable();
    }

    DataSourceRelationalQueryImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    @Override
    public void setBusinessQuery(BusinessQuery inBusinessQuery) {
        Preconditions.ensureNonNull(inBusinessQuery, "inBusinessQuery");
        if (this._businessQuery != null) {
            _logger.error("Changing the business query of a data source is not supported.");
            this._businessQuery.removeListener(this);
        }
        this._businessQuery = inBusinessQuery;
        this._businessQuery.addListener(this);
        this.fireChangeEvent(EVENT_BUSINESS_QUERY_CHANGED);
    }

    @Override
    public BusinessQuery getBusinessQuery() {
        return this._businessQuery;
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "DSRQ_";
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="identity comparison OK")
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        super.replaceResource(oldResource, newResource, model, recursive);
        this._accessPath.replaceResource(oldResource, newResource, model, recursive);
        this._physicalTable = (InMemoryTable)Utils.replaceResource(this._physicalTable, oldResource, newResource, model, recursive);
        for (int i = 0; i < this._columns.size(); ++i) {
            QualifiedColumn qc = this._columns.get(i);
            qc.replaceResource(oldResource, newResource, model, recursive);
            if (qc != oldResource) continue;
            this._columns.set(i, (QualifiedColumn)newResource);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataSourceRelationalQueryImpl dst = (DataSourceRelationalQueryImpl)super.clone();
        return dst;
    }

    @Override
    public void setAccessPath(AccessPath path) throws MetadataException {
        this._accessPath = path != null ? path.copy() : null;
        this.fireChangeEvent(EVENT_ACCESS_PATH_CHANGED);
    }

    @Override
    public AccessPath getAccessPath() {
        AccessPath returnValue = null;
        if (this._accessPath != null) {
            returnValue = this._accessPath.copy();
        }
        return returnValue;
    }

    @Override
    @Nonnull
    public List<AccessPath> getAccessPaths() {
        if (this._accessPath != null) {
            return Collections.singletonList(this._accessPath);
        }
        return Collections.emptyList();
    }

    @Override
    public AccessPath getAbstractAccessPath() {
        return this.getAccessPath();
    }

    @Override
    public Table getTable() {
        return this._physicalTable;
    }

    @Override
    public List<Column> getColumns() throws MetadataException {
        return new ArrayList<Column>(this._columns);
    }

    @Override
    public List<QualifiedColumn> getQualifiedColumns() throws MetadataException {
        return new ArrayList<QualifiedColumn>(this._columns);
    }

    @Override
    public String getSasName() throws MetadataException {
        if (this._physicalTable.isUnresolved()) {
            MessageFormatter error = IQModelImplUtilities.getMessageFormatter("RepositoryObject.IsUnresolved.fmt.txt", this._physicalTable.getIdentityString());
            throw new MetadataException(error);
        }
        String name = this._physicalTable.getSasName();
        return name;
    }

    @Override
    public String getDbmsName() throws MetadataException {
        if (this._physicalTable.isUnresolved()) {
            MessageFormatter error = IQModelImplUtilities.getMessageFormatter("RepositoryObject.IsUnresolved.fmt.txt", this._physicalTable.getIdentityString());
            throw new MetadataException(error);
        }
        String name = this._physicalTable.getDbmsName();
        return name;
    }

    @Override
    public RelationalSchema getRelationalSchema() throws MetadataException {
        if (this._physicalTable.isUnresolved()) {
            MessageFormatter error = IQModelImplUtilities.getMessageFormatter("RepositoryObject.IsUnresolved.fmt.txt", this._physicalTable.getIdentityString());
            throw new MetadataException(error);
        }
        RelationalSchema schema = this._physicalTable.getRelationalSchema();
        return schema;
    }

    @Override
    public StructureOfData getStructure() {
        return StructureOfData.RELATIONAL;
    }

    @Override
    protected String getDefinitionElementName() {
        return "DataSourceRelationalQuery";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        _logger.error("Persistence of this class is not supported.");
    }

    @Override
    public void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        _logger.error("Persistence of this class is not supported.");
    }

    @Override
    public String getDataSetOptionsAsString() throws MetadataException {
        return this._physicalTable.getDataSetOptionsAsString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object objThatChanged = event.getSource();
        String propThatChanged = event.getPropertyName();
        if (objThatChanged != null && objThatChanged == this._businessQuery) {
            if ("The list of result items has changed".equals(propThatChanged) || "The role of a result item has changed".equals(propThatChanged) || "The query's definition has changed and may cause different resultset results since prior to the definition change.".equals(propThatChanged) || "An object referenced by the BusinessQuery has changed".equals(propThatChanged)) {
                InMemoryTable table = this._physicalTable;
                try {
                    List<InMemoryColumn> tableColumns = table.getInMemoryColumns();
                    List<QualifiedColumn> qualifiedColumns = this.getQualifiedColumns();
                    if (this.updateColumnLists(table, tableColumns, qualifiedColumns)) {
                        table.setColumns(tableColumns);
                        this._columns = qualifiedColumns;
                    }
                }
                catch (MetadataException e) {
                    _logger.error("Could not update the columns for the DataSourceRelationalQuery when the underlying BusinessQuery changed", (Throwable)e);
                }
            }
            this.fireChangeEvent(EVENT_REFERENCED_OBJECT_CHANGED);
        }
    }

    private AccessPath _createAccessPath() throws MetadataException {
        DataSourceTable originalDataSource = this._getOriginalDataSource();
        AccessPath originalAccessPath = originalDataSource.getAccessPath();
        return originalAccessPath.copy();
    }

    private InMemoryTable _createPhysicalTable() throws MetadataException {
        DataSourceTable originalDataSource = this._getOriginalDataSource();
        InMemoryTable physicalTable = this._createInMemoryTable(originalDataSource, null);
        return physicalTable;
    }

    private DataSourceTable _getOriginalDataSource() throws MetadataException {
        DataSourceTable originalDataSource = null;
        for (SelectedItem si : this._businessQuery.getSelectedItems()) {
            DataSourceTable dataSource;
            Iterator<QualifiedColumn> iterator;
            DataItem item = si.getItem();
            Role role = si.getRole();
            boolean isOutputResultItem = Role.isOutputResultRole(this._businessQuery, role);
            if (!isOutputResultItem || !(iterator = item.getResources(QualifiedColumn.class, 65535).iterator()).hasNext()) continue;
            QualifiedColumn qc = iterator.next();
            originalDataSource = dataSource = qc.getDataSource();
        }
        return originalDataSource;
    }

    private InMemoryTable _createInMemoryTable(DataSourceTable originalDataSource, AccessPathToRelationalData accessPath) throws MetadataException {
        InMemoryTable table = InMemoryFactory.getInstance().newTable();
        table.setLabel(this._businessQuery.getID());
        Schema schema = accessPath != null ? accessPath.getSchema() : null;
        table.setSchema(schema);
        table.setDataSetOptionsAsString("dbmstemp=yes");
        ArrayList<InMemoryColumn> columns = new ArrayList<InMemoryColumn>();
        ArrayList<QualifiedColumn> qualifiedColumns = new ArrayList<QualifiedColumn>();
        this.updateColumnLists(table, columns, qualifiedColumns);
        table.setColumns(columns);
        this._columns = qualifiedColumns;
        return table;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateColumnLists(Table table, List<InMemoryColumn> tableColumns, List<QualifiedColumn> qualifiedColumns) throws MetadataException {
        boolean changed = false;
        HashMap<String, InMemoryColumn> rsidToTableColumn = new HashMap<String, InMemoryColumn>(tableColumns.size());
        HashMap<String, Integer> rsidToTablePosition = new HashMap<String, Integer>();
        int i = 0;
        for (InMemoryColumn inMemoryColumn : tableColumns) {
            String rsid = inMemoryColumn.getSasName();
            rsidToTableColumn.put(rsid, inMemoryColumn);
            rsidToTablePosition.put(rsid, i);
            ++i;
        }
        HashMap<String, QualifiedColumn> rsidToQualifiedColumn = new HashMap<String, QualifiedColumn>(qualifiedColumns.size());
        for (QualifiedColumn qColumn : qualifiedColumns) {
            String rsid = qColumn.getSasName();
            rsidToQualifiedColumn.put(rsid, qColumn);
        }
        tableColumns.clear();
        qualifiedColumns.clear();
        boolean bl = false;
        for (SelectedItem si : this._businessQuery.getSelectedItems()) {
            void var9_12;
            DataItem item = si.getItem();
            Role role = si.getRole();
            boolean isOutputResultItem = Role.isOutputResultRole(this._businessQuery, role);
            if (!isOutputResultItem) continue;
            String rsid = item.getResultSetID();
            InMemoryColumn column = (InMemoryColumn)rsidToTableColumn.get(rsid);
            if (column == null) {
                column = DataSelectionUtilities.createColumn(item, table);
                changed = true;
            } else {
                rsidToTableColumn.remove(rsid);
            }
            tableColumns.add(column);
            QualifiedColumn qCol = (QualifiedColumn)rsidToQualifiedColumn.get(rsid);
            if (qCol == null) {
                qCol = new QualifiedColumnImpl(this, column);
                changed = true;
            } else {
                Integer position = (Integer)rsidToTablePosition.get(rsid);
                if (!(changed || position != null && position.intValue() == var9_12)) {
                    changed = true;
                }
                rsidToQualifiedColumn.remove(rsid);
            }
            qualifiedColumns.add(qCol);
            ++var9_12;
        }
        for (InMemoryColumn ic : rsidToTableColumn.values()) {
            ic.setUnresolved();
            changed = true;
        }
        rsidToTableColumn.clear();
        for (QualifiedColumn qCol : rsidToQualifiedColumn.values()) {
            qualifiedColumns.add(qCol);
            changed = true;
        }
        rsidToQualifiedColumn.clear();
        return changed;
    }

    private void _validateBusinessQuery() throws MetadataException {
        Preconditions.ensureNonNull(this._businessQuery, "_businessQuery");
        boolean hasOutputItem = false;
        List<DataItem> items = this._businessQuery.getEffectiveResultItems();
        for (DataItem item : items) {
            Role role = this._businessQuery.getResultItemRole(item);
            boolean isOutputResultItem = Role.isOutputResultRole(this._businessQuery, role);
            if (role != null && !isOutputResultItem) continue;
            if (role != Role.COLUMN) {
                throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataSourceRelationalQueryImpl.InvalidRole.txt", new Object[0]));
            }
            hasOutputItem = true;
        }
        if (!hasOutputItem) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplNoReturnedResultItem.txt", new Object[0]));
        }
    }

    @Override
    public List<Key> getKeys() throws MetadataException {
        String errorMsg = IQModelImplUtilities.getMessage("BusinessModelImplUnsupportedMethod.txt", new Object[0]);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public <T extends Key> List<T> getKeys(@Nonnull Class<T> type) throws MetadataException {
        String errorMsg = IQModelImplUtilities.getMessage("BusinessModelImplUnsupportedMethod.txt", new Object[0]);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._physicalTable == null) {
            reasons.add(new Reason((Object)this, 2, 41, "DataSourceTableImpl.NoTableDefinedForDataSource.fmt.txt", this.getIdentityString()));
        }
        if (this._accessPath != null) {
            reasons.addAll(this._accessPath.getReasonsUnusable());
            for (int index = reasons.size() - 1; index >= 0; --index) {
                Reason reason = reasons.get(index);
                if (reason.getReason() != 2 || reason.getSubReason() != 76) continue;
                reasons.remove(reason);
            }
        }
        if (this._businessQuery != null && !this.nested) {
            this.nested = true;
            reasons.addAll(this._businessQuery.getReasonsNotValid());
        }
        this.nested = false;
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._accessPath);
        intoList.add(this._physicalTable);
    }

    @Override
    protected void accumulateDirectlyReferencedModelsInDownwardDefinition(List<? super Model> intoList) {
        super.accumulateDirectlyReferencedModelsInDownwardDefinition(intoList);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    @Override
    boolean isBasedOn(BusinessQuery query) {
        return this._businessQuery == query;
    }

    @Override
    public ColumnManager getColumnMgr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Column> getUsedPhysicalColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnManager.ColumnManagerResults setColumnMgr(ColumnManager mgmt) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Column> getUnusedPhysicalColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIMLETable() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAggregateIMLEData(DataSourceTable.IMLETableAggregation aggregate) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSourceTable.IMLETableAggregation getAggregateIMLEData() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getColumnsAreManaged() {
        return false;
    }

    @Override
    public void setColumnsAreManaged(boolean managed) throws MetadataException {
        throw new UnsupportedOperationException();
    }
}

